/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.business.domain.service.impl.staff;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.haos.business.domain.repository.staff.MuldimUseStaffRepository;
import kd.hr.haos.business.domain.repository.staff.OrgPersonStaffInfoRepository;
import kd.hr.haos.business.domain.repository.staff.OrgUseStaffDetailRepository;
import kd.hr.haos.business.domain.repository.staff.PersonChangeEventServiceRepository;
import kd.hr.haos.business.domain.repository.staff.PersonStaffInfoRepository;
import kd.hr.haos.business.domain.service.impl.staff.AbstractUseStaffService;
import kd.hr.haos.business.domain.service.staff.IOrgUseStaffDetailService;
import kd.hr.haos.business.service.staff.bean.MulDimUseStaffBo;
import kd.hr.haos.business.service.staff.bean.OrgPersonStaffInfoBo;
import kd.hr.haos.business.service.staff.bean.OrgUseStaffBo;
import kd.hr.haos.business.service.staff.bean.StaffContext;
import kd.hr.haos.common.constants.staff.OrgStaffConstants;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRArrayUtils;
import kd.hr.hbp.common.util.HRDateTimeUtils;

public class OrgUseStaffDetailServiceImpl
extends AbstractUseStaffService
implements IOrgUseStaffDetailService,
OrgStaffConstants {
    protected HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("haos_orgusestaffdetail");
    private static OrgUseStaffDetailRepository orgUseStaffDetailRepository = OrgUseStaffDetailRepository.getInstance();
    private static MuldimUseStaffRepository muldimUseStaffRepository = MuldimUseStaffRepository.getInstance();
    private static PersonChangeEventServiceRepository personChangeEventServiceRepository = PersonChangeEventServiceRepository.getInstance();
    private static PersonStaffInfoRepository personStaffInfoRepository = PersonStaffInfoRepository.getInstance();
    private static OrgPersonStaffInfoRepository orgPersonStaffInfoRepository = OrgPersonStaffInfoRepository.getInstance();

    @Override
    public void save(List<DynamicObject> dynList) {
        this.setDefaultFiled(dynList);
        this.serviceHelper.save(dynList.toArray(new DynamicObject[0]));
    }

    @Override
    public void update(List<DynamicObject> dynList) {
        dynList.stream().forEach(dyn -> {
            dyn.set("modifier", (Object)RequestContext.get().getCurrUserId());
            dyn.set("modifytime", (Object)new Date());
        });
        this.serviceHelper.update(dynList.toArray(new DynamicObject[0]));
    }

    private void delByIdList(List<Long> uidList, List<Long> orgPersonList) {
        if (uidList.isEmpty() && orgPersonList.isEmpty()) {
            return;
        }
        DynamicObject[] orgUseDetails = orgUseStaffDetailRepository.queryOrgUseStaffByUidList(uidList);
        DynamicObject[] muldimUseStaffs = muldimUseStaffRepository.queryMuldimUseStaffByUidList(uidList);
        DynamicObject[] personDimInfos = orgPersonStaffInfoRepository.queryPersonStaffInfoByDepEmpIds(orgPersonList);
        DynamicObject[] eventInfos = personChangeEventServiceRepository.queryEventByUidList(uidList);
        List<Long> orgUseIdList = this.getIdList(orgUseDetails);
        List<Long> muldimUseIdList = this.getIdList(muldimUseStaffs);
        List<Long> personDimIdList = this.getIdList(personDimInfos);
        List<Long> eventIdList = this.getIdList(eventInfos);
        orgUseStaffDetailRepository.delete(orgUseIdList);
        muldimUseStaffRepository.delete(muldimUseIdList);
        orgPersonStaffInfoRepository.delete(personDimIdList);
        personChangeEventServiceRepository.delete(eventIdList);
    }

    private List<Long> getIdList(DynamicObject[] orgUseDetails) {
        if (HRArrayUtils.isEmpty((Object[])orgUseDetails)) {
            return Lists.newArrayList();
        }
        return Stream.of(orgUseDetails).map(it -> it.getLong("id")).collect(Collectors.toList());
    }

    @Override
    public void saveByDepempIdList(List<Long> depEmpIdList) {
        if (CollectionUtils.isEmpty(depEmpIdList)) {
            return;
        }
        DynamicObject[] dys = orgPersonStaffInfoRepository.queryPersonStaffInfoByDepEmpIds(depEmpIdList);
        this.resetLeffdtByReleasingData(Arrays.asList(dys));
        this.saveByDimPersonInfo(Arrays.asList(dys));
    }

    public void saveByDimPersonInfo(List<DynamicObject> orgPersonDimensionDynList) {
        List<Long> personIdList = orgPersonDimensionDynList.stream().map(it -> it.getLong("person_id")).collect(Collectors.toList());
        List<Long> useOrgIdList = orgPersonDimensionDynList.stream().map(it -> it.getLong("orgteam_id")).collect(Collectors.toList());
        StaffContext staffContext = new StaffContext(useOrgIdList, personIdList);
        staffContext.init();
        ArrayList list = Lists.newArrayListWithExpectedSize((int)orgPersonDimensionDynList.size());
        ArrayList needToDelDimId = Lists.newArrayListWithExpectedSize((int)orgPersonDimensionDynList.size());
        ArrayList needToDelOrgUseStaffDepempId = Lists.newArrayListWithExpectedSize((int)orgPersonDimensionDynList.size());
        for (DynamicObject orgPersonDimensionDyn : orgPersonDimensionDynList) {
            OrgUseStaffBo orgUseStaffBo = new OrgUseStaffBo(orgPersonDimensionDyn, "1", staffContext);
            if (orgUseStaffBo.getId() == 0L) {
                needToDelDimId.add(orgPersonDimensionDyn.getLong("id"));
                needToDelOrgUseStaffDepempId.add(orgPersonDimensionDyn.getLong("orgperson_id"));
                continue;
            }
            list.add(orgUseStaffBo);
        }
        ArrayList orgUseStaffList = Lists.newArrayListWithExpectedSize((int)orgPersonDimensionDynList.size());
        ArrayList staffPersonList = Lists.newArrayListWithExpectedSize((int)orgPersonDimensionDynList.size());
        ArrayList mulDimUseStaffList = Lists.newArrayList();
        for (OrgUseStaffBo orgUseStaffBo : list) {
            orgUseStaffList.add(orgUseStaffBo.convertToDynamicObject());
            if (orgUseStaffBo.getStaffPersonBo().isNeedCreate()) {
                staffPersonList.add(orgUseStaffBo.getStaffPersonBo().convertToDynamicObject());
            }
            mulDimUseStaffList.addAll(orgUseStaffBo.getMulDimUseStaffBoList().stream().map(MulDimUseStaffBo::convertDynamicObject).collect(Collectors.toList()));
        }
        List<Long> staffPersonInfoIds = orgPersonDimensionDynList.stream().filter(dynamicObject -> !needToDelDimId.contains(dynamicObject.getLong("id"))).filter(dynamicObject -> this.isEmptyOfLong(dynamicObject.getLong("personstaffinfo_id"))).map(dyn -> dyn.getLong("id")).collect(Collectors.toList());
        DynamicObject[] staffPersonInfoArr = orgPersonStaffInfoRepository.queryPersonStaffInfoById(staffPersonInfoIds);
        if (staffPersonInfoArr.length > 0) {
            List<OrgPersonStaffInfoBo> personStaffInfoBoList = Arrays.stream(staffPersonInfoArr).map(it -> new OrgPersonStaffInfoBo((DynamicObject)it, staffContext)).collect(Collectors.toList());
            personStaffInfoBoList.forEach(OrgPersonStaffInfoBo::addPersonStaffId);
        }
        personStaffInfoRepository.save(staffPersonList.toArray(new DynamicObject[0]));
        orgPersonStaffInfoRepository.save(staffPersonInfoArr);
        orgUseStaffDetailRepository.save(orgUseStaffList.toArray(new DynamicObject[0]));
        muldimUseStaffRepository.save(mulDimUseStaffList.toArray(new DynamicObject[0]));
        orgPersonStaffInfoRepository.delete(needToDelDimId);
        this.delByDepEmpIdListInStaffTYPE(needToDelOrgUseStaffDepempId, Collections.singletonList("1"));
    }

    private boolean isEmptyOfLong(Long value) {
        return value == null || value == 0L;
    }

    @Override
    public void deleteByIds(List<Long> ids) {
        QFilter idsFilter = new QFilter("id", "in", ids);
        this.serviceHelper.deleteByFilter(new QFilter[]{idsFilter});
    }

    @Override
    public Map<Long, DynamicObject> getDepEmpIdToReleasingOrgUesStaffMap(List<Long> depEmpIdList) {
        DynamicObject[] orgUseStaffDetails = OrgUseStaffDetailRepository.getInstance().queryAllOrgUseStaffByPersonStaffInfoIds(depEmpIdList, new String[]{"3", "4"});
        HashMap depEmpIdToReleasingDataMap = Maps.newHashMapWithExpectedSize((int)orgUseStaffDetails.length);
        for (DynamicObject detail : orgUseStaffDetails) {
            Long depEmpId = detail.getLong("orgperson_id");
            depEmpIdToReleasingDataMap.put(depEmpId, detail);
        }
        return depEmpIdToReleasingDataMap;
    }

    private void resetLeffdtByReleasingData(List<DynamicObject> staffPersonInfos) {
        List<Long> depEmpIdList = staffPersonInfos.stream().map(dyn -> dyn.getLong("orgperson_id")).collect(Collectors.toList());
        Map<Long, DynamicObject> releasingOrgUesStaffMap = this.getDepEmpIdToReleasingOrgUesStaffMap(depEmpIdList);
        Date now = HRDateTimeUtils.getNowDate();
        for (DynamicObject staffPersonInfo : staffPersonInfos) {
            DynamicObject releasingOrgUesStaff = releasingOrgUesStaffMap.get(staffPersonInfo.getLong("orgperson_id"));
            if (!HRDateTimeUtils.dayAfter((Date)staffPersonInfo.getDate("leffdt"), (Date)now) || releasingOrgUesStaff == null) continue;
            Date releasingOrgUesStaff_effdt = releasingOrgUesStaff.getDate("effdt");
            Date staffPersonInfo_leffdt = HRDateTimeUtils.addDay((Date)releasingOrgUesStaff_effdt, (long)-1L);
            staffPersonInfo.set("leffdt", (Object)staffPersonInfo_leffdt);
            staffPersonInfo.set("status", (Object)"2");
        }
    }

    @Override
    public void delByUseOrgIdAndDateList(List<Long> useOrgIdList, Date startDate) {
        DynamicObject[] personStaffInfo = orgPersonStaffInfoRepository.queryByOrgIdListAndDate(useOrgIdList, startDate);
        if (personStaffInfo == null || personStaffInfo.length == 0) {
            return;
        }
        List<Long> depempIdList = Arrays.stream(personStaffInfo).map(dyn -> dyn.getLong("orgperson_id")).collect(Collectors.toList());
        this.delByDepEmpIdListInStaffTYPE(depempIdList, Collections.singletonList("1"));
    }

    @Override
    public void delByDepEmpIdListInStaffTYPE(List<Long> depempIdList, List<String> staffType) {
        if (CollectionUtils.isEmpty(depempIdList)) {
            return;
        }
        DynamicObject[] orgusestaff = orgUseStaffDetailRepository.queryUseStaffInfoByDepempIdInStaffType(depempIdList, staffType);
        List<Long> uidList = Arrays.stream(orgusestaff).map(dyn -> dyn.getLong("id")).collect(Collectors.toList());
        List<Long> depEmpIdList = Arrays.stream(orgusestaff).map(dyn -> dyn.getLong("orgperson_id")).collect(Collectors.toList());
        this.delByIdList(uidList, depEmpIdList);
    }

    @Override
    public void delByPersonIdAndDateList(List<Long> personIdList, Date startDate) {
        DynamicObject[] personStaffInfo = orgPersonStaffInfoRepository.queryByPersonIdListAndDate(personIdList, startDate);
        if (personStaffInfo == null || personStaffInfo.length == 0) {
            return;
        }
        List<Long> depempIdList = Arrays.stream(personStaffInfo).map(dyn -> dyn.getLong("orgperson_id")).collect(Collectors.toList());
        this.delByDepEmpIdListInStaffTYPE(depempIdList, null);
    }
}

