/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.business.domain.service.impl.staff;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.hr.haos.business.domain.repository.staff.DutyOrgDetailRepository;
import kd.hr.haos.business.domain.repository.staff.MuldimDetailRepository;
import kd.hr.haos.business.domain.repository.staff.StaffDimensionRepository;
import kd.hr.haos.business.domain.repository.staff.StaffReportRepository;
import kd.hr.haos.business.domain.repository.staff.StaffRepository;
import kd.hr.haos.business.domain.repository.staff.UseOrgDetailRepository;
import kd.hr.haos.business.domain.service.staff.IStaffReportService;
import kd.hr.haos.common.constants.staff.OrgStaffConstants;
import kd.hr.hbp.common.util.HRDateTimeUtils;

public class StaffReportService
implements IStaffReportService {
    private Date now = new Date();

    @Override
    public void saveReportData(List<Long> staffIdList) {
        this.deleteByStaffId(staffIdList);
        DynamicObject[] staffDyn = StaffRepository.getInstance().queryEnabledStaffByStaffId("id,staffcycle,year", staffIdList);
        if (staffDyn.length == 0) {
            return;
        }
        Map<Long, Long> staffIdToCycleMap = Arrays.stream(staffDyn).collect(Collectors.toMap(dyn -> dyn.getLong("id"), dyn -> dyn.getLong("staffcycle.id")));
        Map<Long, String> staffYearMap = Arrays.stream(staffDyn).collect(Collectors.toMap(dyn -> dyn.getLong("id"), dyn -> HRDateTimeUtils.format((Date)dyn.getDate("year"), (String)"yyyy")));
        QFilter staffIdFilter = new QFilter("staff", "in", staffIdList);
        DynamicObject[] dutyOrgDyn = DutyOrgDetailRepository.getInstance().loadDutyOrgDetailByFilter(staffIdFilter);
        DynamicObject[] useOrgDyn = UseOrgDetailRepository.getInstance().loadUseOrgDetailByFilter(staffIdFilter);
        DynamicObject[] mulDimDyn = MuldimDetailRepository.getInstance().loadDimensionDetailByFilter(staffIdFilter);
        Map<Long, Map<Long, DynamicObject>> staffDutyOrgIdToDynMap = Arrays.stream(dutyOrgDyn).collect(Collectors.groupingBy(dyn -> dyn.getLong("staff.id"), Collectors.toMap(dyn -> dyn.getLong("dutyorg.id"), dyn -> dyn, (v1, v2) -> v1)));
        List<DynamicObject> orgstaffReportList = this.assembleOrgstaffReport(useOrgDyn, staffYearMap, staffIdToCycleMap, staffDutyOrgIdToDynMap);
        List<DynamicObject> dimstaffReportList = this.assembleDimstaffReport(mulDimDyn, staffYearMap, staffIdToCycleMap);
        List orgstaffReportPartitionList = Lists.partition(orgstaffReportList, (int)100000);
        List dimstaffReportPartitionList = Lists.partition(dimstaffReportList, (int)100000);
        for (List list : orgstaffReportPartitionList) {
            StaffReportRepository.getInstance().saveOrgData(list.toArray(new DynamicObject[0]));
        }
        for (List list : dimstaffReportPartitionList) {
            StaffReportRepository.getInstance().saveDimData(list.toArray(new DynamicObject[0]));
        }
    }

    private void deleteByStaffId(List<Long> staffId) {
        StaffReportRepository.getInstance().deleteOrgDataByStaffId(staffId);
        StaffReportRepository.getInstance().deleteDimDataByStaffId(staffId);
    }

    private Date getYear(String year) {
        try {
            return HRDateTimeUtils.parseDate((String)year, (String)"yyyy");
        }
        catch (ParseException e) {
            return null;
        }
    }

    private Date getMonth(String year, int month) {
        String monthStr = year + "-" + month;
        try {
            return HRDateTimeUtils.parseDate((String)monthStr, (String)"yyyy-MM");
        }
        catch (ParseException e) {
            return null;
        }
    }

    private List<DynamicObject> assembleOrgstaffReport(DynamicObject[] useOrgDyn, Map<Long, String> staffYearMap, Map<Long, Long> staffIdToCycleMap, Map<Long, Map<Long, DynamicObject>> dutyOrgIdToDynMap) {
        ArrayList list = Lists.newArrayListWithExpectedSize((int)(useOrgDyn.length * 12));
        for (DynamicObject useOrg : useOrgDyn) {
            long staffId = useOrg.getLong("staff.id");
            String year = staffYearMap.get(staffId);
            long staffcycleId = staffIdToCycleMap.get(staffId);
            long adminorgId = useOrg.getLong("useorg.boid");
            long staffcountwithsub = 0L;
            DynamicObject dutyOrg = (DynamicObject)((Map)dutyOrgIdToDynMap.getOrDefault(staffId, new HashMap())).get(useOrg.getLong("useorg.id"));
            if (dutyOrg != null) {
                staffcountwithsub = dutyOrg.getLong("staffcount");
            }
            for (int i = 1; i <= 12; ++i) {
                DynamicObject orgStaffReport = StaffReportRepository.getInstance().newEmptyOrgstaffReportDyn();
                orgStaffReport.set("staffid", (Object)staffId);
                orgStaffReport.set("year", (Object)this.getYear(year));
                orgStaffReport.set("month", (Object)this.getMonth(year, i));
                orgStaffReport.set("adminorg", (Object)adminorgId);
                orgStaffReport.set("staffcountwithsub", (Object)staffcountwithsub);
                if (staffcycleId == OrgStaffConstants.STAFF_CYCLE_YEAR) {
                    orgStaffReport.set("staffcount", useOrg.get("yearstaff"));
                } else {
                    orgStaffReport.set("staffcount", useOrg.get("monthstaff" + i));
                }
                if (orgStaffReport.get("staffcount") == null) {
                    orgStaffReport.set("staffcount", (Object)0);
                }
                if (orgStaffReport.get("staffcountwithsub") == null) {
                    orgStaffReport.set("staffcountwithsub", (Object)0);
                }
                orgStaffReport.set("createtime", (Object)this.now);
                list.add(orgStaffReport);
            }
        }
        return list;
    }

    private List<DynamicObject> assembleDimstaffReport(DynamicObject[] mulDimDyn, Map<Long, String> staffYearMap, Map<Long, Long> staffIdToCycleMap) {
        if (mulDimDyn.length == 0) {
            return Lists.newArrayList();
        }
        Map<String, Long> dimensionKeyIdMap = this.initDimensionKeys();
        ArrayList list = Lists.newArrayListWithExpectedSize((int)(mulDimDyn.length * 12));
        for (DynamicObject mulDim : mulDimDyn) {
            long staffId = mulDim.getLong("staff.id");
            String year = staffYearMap.get(staffId);
            long staffcycleId = staffIdToCycleMap.get(staffId);
            long adminorgId = mulDim.getLong("useorg.boid");
            for (int i = 1; i <= 12; ++i) {
                DynamicObject dimStaffReport = StaffReportRepository.getInstance().newEmptyDimstaffReportDyn();
                dimStaffReport.set("staffid", (Object)staffId);
                dimStaffReport.set("year", (Object)this.getYear(year));
                dimStaffReport.set("month", (Object)this.getMonth(year, i));
                dimStaffReport.set("adminorg", (Object)adminorgId);
                if (staffcycleId == OrgStaffConstants.STAFF_CYCLE_YEAR) {
                    dimStaffReport.set("staffcount", mulDim.get("yearstaff"));
                } else {
                    dimStaffReport.set("staffcount", mulDim.get("monthstaff" + i));
                }
                dimensionKeyIdMap.forEach((key, id) -> {
                    dimStaffReport.set(key, mulDim.get(key));
                    if (mulDim.get(key) != null) {
                        dimStaffReport.set("staffdimension", id);
                    }
                });
                dimStaffReport.set("createtime", (Object)this.now);
                list.add(dimStaffReport);
            }
        }
        return list;
    }

    private Map<String, Long> initDimensionKeys() {
        HashMap dimensionKeyIdMap = Maps.newHashMap();
        dimensionKeyIdMap.put("dutyworkrole", 1010L);
        dimensionKeyIdMap.put("job", 1020L);
        dimensionKeyIdMap.put("laborreltype", 1050L);
        DynamicObject[] dimensions = StaffDimensionRepository.getInstance().listAllDimension();
        Map<String, Long> extendDimesionKeyIdMap = Arrays.stream(dimensions).collect(Collectors.toMap(dyn -> dyn.getString("staffdimension"), dyn -> dyn.getLong("id"), (v1, v2) -> v1));
        Map mulDetailAllFields = MetadataServiceHelper.getDataEntityType((String)"haos_muldimendetail").getAllFields();
        Map dimReportAllFields = MetadataServiceHelper.getDataEntityType((String)"haos_dimstaffreport").getAllFields();
        extendDimesionKeyIdMap.forEach((key, id) -> {
            if (mulDetailAllFields.containsKey(key) && dimReportAllFields.containsKey(key)) {
                dimensionKeyIdMap.put(key, id);
            }
        });
        return dimensionKeyIdMap;
    }
}

