/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.business.domain.service.impl.staff;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.hr.haos.business.domain.repository.staff.DutyOrgDetailRepository;
import kd.hr.haos.business.domain.repository.staff.MuldimDetailRepository;
import kd.hr.haos.business.domain.repository.staff.StaffDimensionRepository;
import kd.hr.haos.business.domain.repository.staff.StaffRepository;
import kd.hr.haos.business.domain.repository.staff.UseOrgDetailRepository;
import kd.hr.haos.business.domain.service.impl.staff.AbstractMultiSaveService;
import kd.hr.haos.business.domain.service.impl.staff.DutyOrgInfoSaveChain;
import kd.hr.haos.business.domain.service.impl.staff.FifthDimensinoSaveChain;
import kd.hr.haos.business.domain.service.impl.staff.FirstDimensionSaveChain;
import kd.hr.haos.business.domain.service.impl.staff.FourthDimensionSaveChain;
import kd.hr.haos.business.domain.service.impl.staff.JobInfoSaveChain;
import kd.hr.haos.business.domain.service.impl.staff.LaborRelTypeInfoSaveChain;
import kd.hr.haos.business.domain.service.impl.staff.PositionInfoSaveChain;
import kd.hr.haos.business.domain.service.impl.staff.SecondDimensionSaveChain;
import kd.hr.haos.business.domain.service.impl.staff.ThirdDimensionSaveChain;
import kd.hr.haos.business.domain.service.impl.staff.UseOrgInfoSaveChain;
import kd.hr.haos.business.domain.service.staff.IStaffService;
import kd.hr.haos.business.service.staff.bean.StaffHisParamBO;
import kd.hr.haos.business.service.staff.service.OrgStaffBaseService;
import kd.hr.haos.business.service.staff.service.StaffCommonService;
import kd.hr.haos.business.util.TimeLogger;
import kd.hr.haos.common.constants.staff.DynamicDimensionEnum;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;

public class StaffServiceImpl
implements IStaffService {
    public static final ThreadLocal<TimeLogger> timeLoggerThreadLocal = ThreadLocal.withInitial(() -> TimeLogger.create());
    private static final Log logger = LogFactory.getLog(StaffServiceImpl.class);
    private static final String[] copyKeys = new String[]{"creator", "number", "name", "year", "staffcycle", "staffproject", "staffdimension", "staffcontrolstrategy", "staffelasticcontrol", "staffelasticcount"};

    @Override
    public void saveBaseData(DynamicObject[] staffDyns) {
        HRBaseServiceHelper staffHelper = new HRBaseServiceHelper("haos_staff");
        Map<Long, DynamicObject> baseDataInfoMap = Arrays.stream(staffDyns).collect(Collectors.toMap(dyn -> dyn.getLong("id"), dyn -> dyn));
        QFilter idFilter = new QFilter("id", "in", baseDataInfoMap.keySet());
        DynamicObject[] staffInfos = staffHelper.loadDynamicObjectArray(new QFilter[]{idFilter});
        if (staffInfos != null && staffInfos.length > 0) {
            Map<Long, DynamicObject> dbDataInfoMap = Arrays.stream(staffInfos).collect(Collectors.toMap(dyn -> dyn.getLong("id"), dyn -> dyn));
            for (int i = 0; i < staffDyns.length; ++i) {
                long id = staffDyns[i].getLong("id");
                DynamicObject dbDataInfo = dbDataInfoMap.get(id);
                if (dbDataInfo != null) {
                    StaffCommonService.fieldCopy(staffDyns[i], dbDataInfo, copyKeys);
                    staffDyns[i] = dbDataInfo;
                }
                staffDyns[i].set("modifier", (Object)RequestContext.get().getCurrUserId());
                staffDyns[i].set("modifytime", (Object)new Date());
            }
        }
        staffHelper.save(staffDyns);
    }

    @Override
    public void saveEntryData(DynamicObject[] staffDynArr, String operationKey) {
        logger.info("save.staff.entry.data.begin!");
        ArrayList staffHisParamBOs = Lists.newArrayListWithExpectedSize((int)16);
        DutyOrgInfoSaveChain dutyOrgInfoSaveAttach = this.getStaffSaveService(staffDynArr);
        dutyOrgInfoSaveAttach.invokeStaffSave(staffDynArr, staffHisParamBOs);
        OrgStaffBaseService opService = new OrgStaffBaseService();
        String enable = staffDynArr[0].getString("enable");
        if ("save".equals(operationKey) && !CollectionUtils.isEmpty((Collection)staffHisParamBOs)) {
            if ("10".equals(enable)) {
                opService.saveTemp(staffHisParamBOs);
            } else {
                opService.change(staffHisParamBOs);
            }
        }
        logger.info("save.staff.entry.data.end!");
    }

    @Override
    public void deleteBaseData(List<Long> staffIdList) {
        StaffRepository.getInstance().deleteDynByStaffId(staffIdList);
    }

    @Override
    public void deleteEntryData(List<Long> staffIdList) {
        ArrayList paramBOs = Lists.newArrayListWithExpectedSize((int)16);
        QFilter filter = new QFilter("staff", "in", staffIdList);
        DynamicObject[] dutyInfoArr = DutyOrgDetailRepository.getInstance().queryOriginalArray("id", new QFilter[]{filter});
        DynamicObject[] useOrgInfoArr = UseOrgDetailRepository.getInstance().queryOriginalArray("id", new QFilter[]{filter});
        DynamicObject[] dimensionInfoArr = MuldimDetailRepository.getInstance().queryOriginalArray("id", new QFilter[]{filter});
        if (dutyInfoArr != null && dutyInfoArr.length > 0) {
            paramBOs.add(new StaffHisParamBO("haos_dutyorgdetail", Arrays.asList(dutyInfoArr)));
        }
        if (useOrgInfoArr != null && useOrgInfoArr.length > 0) {
            paramBOs.add(new StaffHisParamBO("haos_useorgdetail", Arrays.asList(useOrgInfoArr)));
        }
        if (dimensionInfoArr != null && dimensionInfoArr.length > 0) {
            paramBOs.add(new StaffHisParamBO("haos_muldimendetail", Arrays.asList(dimensionInfoArr)));
        }
        OrgStaffBaseService service = new OrgStaffBaseService();
        service.deleteTemp(paramBOs);
    }

    private DutyOrgInfoSaveChain getStaffSaveService(DynamicObject[] staffDynArr) {
        timeLoggerThreadLocal.get().check("StaffServiceImpl#getStaffSaveService before DutyOrgInfoSaveChain cost:");
        DutyOrgInfoSaveChain dutyOrgInfoSaveChain = new DutyOrgInfoSaveChain(staffDynArr);
        timeLoggerThreadLocal.get().check("StaffServiceImpl#getStaffSaveService after DutyOrgInfoSaveChain cost:");
        UseOrgInfoSaveChain useOrgInfoSaveChain = new UseOrgInfoSaveChain(staffDynArr);
        timeLoggerThreadLocal.get().check("StaffServiceImpl#getStaffSaveService after UseOrgInfoSaveChain cost:");
        PositionInfoSaveChain positionInfoSaveChain = new PositionInfoSaveChain(staffDynArr);
        timeLoggerThreadLocal.get().check("StaffServiceImpl#getStaffSaveService after PositionInfoSaveChain cost:");
        JobInfoSaveChain jobInfoSaveChain = new JobInfoSaveChain(staffDynArr);
        timeLoggerThreadLocal.get().check("StaffServiceImpl#getStaffSaveService after JobInfoSaveChain cost:");
        LaborRelTypeInfoSaveChain laborRelTypeInfoSaveChain = new LaborRelTypeInfoSaveChain(staffDynArr);
        timeLoggerThreadLocal.get().check("StaffServiceImpl#getStaffSaveService after laborRelTypeInfoSaveChain cost:");
        dutyOrgInfoSaveChain.setNextStaffSaveService(useOrgInfoSaveChain);
        useOrgInfoSaveChain.setPreStaffSaveService(dutyOrgInfoSaveChain);
        useOrgInfoSaveChain.setNextStaffSaveService(positionInfoSaveChain);
        positionInfoSaveChain.setNextMultiSaveService(jobInfoSaveChain);
        positionInfoSaveChain.setPreStaffSaveService(useOrgInfoSaveChain);
        jobInfoSaveChain.setNextMultiSaveService(laborRelTypeInfoSaveChain);
        jobInfoSaveChain.setPreStaffSaveService(positionInfoSaveChain);
        laborRelTypeInfoSaveChain.setPreStaffSaveService(jobInfoSaveChain);
        DynamicObject[] dynamicObjects = StaffDimensionRepository.getInstance().listAllDimension();
        ArrayList<AbstractMultiSaveService> chainList = new ArrayList<AbstractMultiSaveService>(16);
        for (DynamicObject dimension : dynamicObjects) {
            String staffdimension = dimension.getString("staffdimension");
            DynamicDimensionEnum dimensionEnum = DynamicDimensionEnum.match((String)staffdimension);
            if (dimensionEnum == null) continue;
            String entryentityName = dimensionEnum.getEntryentityName();
            boolean execEntry = MetadataServiceHelper.getDataEntityType((String)"haos_staff").getAllEntities().containsKey(entryentityName);
            if (!execEntry) continue;
            AbstractMultiSaveService dimensionSaveChain = this.getDimensionSaveChain(dimensionEnum, staffDynArr);
            chainList.add(dimensionSaveChain);
        }
        this.setSaveChainExecOrder(chainList, laborRelTypeInfoSaveChain);
        return dutyOrgInfoSaveChain;
    }

    private AbstractMultiSaveService getDimensionSaveChain(DynamicDimensionEnum dimensionEnum, DynamicObject[] staffDynArr) {
        switch (dimensionEnum) {
            case basicData1: {
                return new FirstDimensionSaveChain(staffDynArr);
            }
            case basicData2: {
                return new SecondDimensionSaveChain(staffDynArr);
            }
            case basicData3: {
                return new ThirdDimensionSaveChain(staffDynArr);
            }
            case basicData4: {
                return new FourthDimensionSaveChain(staffDynArr);
            }
            case basicData5: {
                return new FifthDimensinoSaveChain(staffDynArr);
            }
        }
        throw new KDBizException("DynamicDimension match error");
    }

    private void setSaveChainExecOrder(List<AbstractMultiSaveService> chainList, LaborRelTypeInfoSaveChain laborRelTypeInfoSaveChain) {
        int chainSize = chainList.size();
        if (chainSize == 0) {
            return;
        }
        if (chainSize == 1) {
            AbstractMultiSaveService abstractMultiSaveService = chainList.get(0);
            laborRelTypeInfoSaveChain.setNextMultiSaveService(abstractMultiSaveService);
            abstractMultiSaveService.setPreStaffSaveService(laborRelTypeInfoSaveChain);
        } else {
            for (int i = 0; i < chainSize - 1; ++i) {
                if (i == 0) {
                    laborRelTypeInfoSaveChain.setNextMultiSaveService(chainList.get(i));
                    chainList.get(i).setPreStaffSaveService(laborRelTypeInfoSaveChain);
                } else {
                    chainList.get(i).setPreStaffSaveService(chainList.get(i - 1));
                }
                chainList.get(i).setNextMultiSaveService(chainList.get(i + 1));
                if (chainSize == 1 || chainSize != i + 1) continue;
                chainList.get(i + 1).setPreStaffSaveService(chainList.get(i));
            }
        }
    }
}

