/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.business.domain.service.impl.staff.helper;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.haos.business.domain.repository.HAOSBaseRepository;
import kd.hr.haos.business.domain.repository.QFilterHelper;
import kd.hr.haos.business.domain.repository.staff.DutyOrgDetailHisRepository;
import kd.hr.haos.business.domain.repository.staff.MuldimDetailHisRepository;
import kd.hr.haos.business.domain.repository.staff.MuldimDetailRepository;
import kd.hr.haos.business.domain.repository.staff.StaffRepository;
import kd.hr.haos.business.domain.repository.staff.UseOrgDetailHisRepository;
import kd.hr.haos.business.domain.repository.staff.UseOrgDetailRepository;
import kd.hr.haos.business.domain.service.impl.staff.helper.StaffHisUpgradeEnum;
import kd.hr.haos.business.service.staff.service.StaffCommonService;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;

public class StaffHisDataUpgradeHelper {
    private static final Log logger = LogFactory.getLog(StaffHisDataUpgradeHelper.class);
    List<DynamicObject> saveDynList = Lists.newArrayListWithExpectedSize((int)16);
    List<DynamicObject> deleteDynList = Lists.newArrayListWithExpectedSize((int)16);

    public static void upgradeEntryBoId() {
        DynamicObject[] mulDimDetailHisDynArr;
        DynamicObject[] useOrgDetailHisDynArr;
        HashSet entryIdForBoIdNullSetForUseOrg = Sets.newHashSetWithExpectedSize((int)16);
        UseOrgDetailHisRepository useOrgDetailHisRepository = UseOrgDetailHisRepository.getInstance();
        for (DynamicObject useOrgDetailHisDyn : useOrgDetailHisDynArr = useOrgDetailHisRepository.queryArray("useorgdetail.id, useorgdetail.bo, bo", new QFilter[]{QFilterHelper.create1Equals1Filter()})) {
            if (!StaffHisDataUpgradeHelper.longIsEmpty(useOrgDetailHisDyn.getLong("useorgdetail.bo"))) {
                useOrgDetailHisDyn.set("bo", (Object)useOrgDetailHisDyn.getLong("useorgdetail.bo"));
                continue;
            }
            entryIdForBoIdNullSetForUseOrg.add(useOrgDetailHisDyn.getLong("useorgdetail.id"));
        }
        logger.info("StaffHisDataUpgradeHelper#upgradeEntryBoId.entryIdForBoIdNullSetForUseOrg={}", (Object)SerializationUtils.toJsonString((Object)entryIdForBoIdNullSetForUseOrg));
        useOrgDetailHisRepository.save(useOrgDetailHisDynArr);
        HashSet entryIdForBoIdNullSetForMulDim = Sets.newHashSetWithExpectedSize((int)16);
        MuldimDetailHisRepository muldimDetailHisRepository = MuldimDetailHisRepository.getInstance();
        for (DynamicObject mulDimDetailHisDyn : mulDimDetailHisDynArr = muldimDetailHisRepository.queryArray("muldimendetail.id, muldimendetail.bo, bo", new QFilter[]{QFilterHelper.create1Equals1Filter()})) {
            if (!StaffHisDataUpgradeHelper.longIsEmpty(mulDimDetailHisDyn.getLong("muldimendetail.bo"))) {
                mulDimDetailHisDyn.set("bo", (Object)mulDimDetailHisDyn.getLong("muldimendetail.bo"));
                continue;
            }
            entryIdForBoIdNullSetForMulDim.add(mulDimDetailHisDyn.getLong("muldimendetail.id"));
        }
        logger.info("StaffHisDataUpgradeHelper#upgradeEntryBoId.entryIdForBoIdNullSetForMulDim={}", (Object)SerializationUtils.toJsonString((Object)entryIdForBoIdNullSetForMulDim));
        muldimDetailHisRepository.save(mulDimDetailHisDynArr);
    }

    public static void upgradeEnableInDisableStaffData() {
        DynamicObject[] disableStaffDyn = StaffRepository.getInstance().loadDynamicObject(new QFilter("enable", "in", (Object)"0"));
        List staffIdList = Arrays.stream(disableStaffDyn).map(dyn -> dyn.getLong("id")).collect(Collectors.toList());
        QFilter staffIdFilter = new QFilter("staff", "in", staffIdList);
        DynamicObject[] enableUseOrgDyn = UseOrgDetailRepository.getInstance().loadUseOrgDetailByFilter(staffIdFilter);
        Arrays.stream(enableUseOrgDyn).forEach(dyn -> dyn.set("enable", (Object)"0"));
        UseOrgDetailRepository.getInstance().save(enableUseOrgDyn);
        List<Long> vIdListForUseOrg = Arrays.stream(enableUseOrgDyn).map(dyn -> dyn.getLong("vid.id")).collect(Collectors.toList());
        DynamicObject[] useOrgHisDynArr = UseOrgDetailHisRepository.getInstance().loadById(vIdListForUseOrg);
        Arrays.stream(useOrgHisDynArr).forEach(dyn -> dyn.set("enable", (Object)"0"));
        UseOrgDetailHisRepository.getInstance().save(useOrgHisDynArr);
        DynamicObject[] enableMulDimDyn = MuldimDetailRepository.getInstance().loadDimensionDetailByFilter(staffIdFilter);
        Arrays.stream(enableMulDimDyn).forEach(dyn -> dyn.set("enable", (Object)"0"));
        MuldimDetailRepository.getInstance().save(enableMulDimDyn);
        List<Long> vIdListForMulDim = Arrays.stream(enableMulDimDyn).map(dyn -> dyn.getLong("vid.id")).collect(Collectors.toList());
        DynamicObject[] mulDimHisDynArr = MuldimDetailHisRepository.getInstance().loadById(vIdListForMulDim);
        Arrays.stream(mulDimHisDynArr).forEach(dyn -> dyn.set("enable", (Object)"0"));
        MuldimDetailHisRepository.getInstance().save(mulDimHisDynArr);
    }

    public static void upgradeRepeatData() {
        StaffHisDataUpgradeHelper staffHisDataUpgradeHelper = new StaffHisDataUpgradeHelper();
        staffHisDataUpgradeHelper.upgradeRepeatData(StaffHisUpgradeEnum.DUTY_ORG);
        staffHisDataUpgradeHelper.upgradeRepeatData(StaffHisUpgradeEnum.USE_ORG);
        staffHisDataUpgradeHelper.upgradeRepeatData(StaffHisUpgradeEnum.MUL_DIM);
    }

    private void upgradeRepeatData(StaffHisUpgradeEnum staffHisUpgradeEnum) {
        DynamicObject[] useOrgDetailHisDynArr = this.getAllHisData(staffHisUpgradeEnum);
        Map<String, List<DynamicObject>> groupIdVsDynListMap = Arrays.stream(useOrgDetailHisDynArr).collect(Collectors.groupingBy(dyn -> staffHisUpgradeEnum.getGroupIdFunction().apply((DynamicObject)dyn)));
        ArrayList allList = Lists.newArrayListWithExpectedSize((int)16);
        Set<Map.Entry<String, List<DynamicObject>>> groupIdVsDynListMapEntries = groupIdVsDynListMap.entrySet();
        for (Map.Entry<String, List<DynamicObject>> groupIdVsDynListMapEntry : groupIdVsDynListMapEntries) {
            List<Object> sameStaffIdUseOrgBoIdDynList = groupIdVsDynListMapEntry.getValue();
            sameStaffIdUseOrgBoIdDynList = sameStaffIdUseOrgBoIdDynList.stream().sorted(Comparator.comparing(dyn -> dyn.getDate("modifytime"))).collect(Collectors.toList());
            DynamicObject preDyn = (DynamicObject)sameStaffIdUseOrgBoIdDynList.get(0);
            List<Object> list = Lists.newArrayListWithExpectedSize((int)16);
            for (int i = 1; i < sameStaffIdUseOrgBoIdDynList.size(); ++i) {
                DynamicObject sameStaffIdUseOrgBoIdDyn = (DynamicObject)sameStaffIdUseOrgBoIdDynList.get(i);
                boolean isNoChange = StaffCommonService.compareDynamicObjectByContainsProp(preDyn, sameStaffIdUseOrgBoIdDyn, staffHisUpgradeEnum.getComparePropList());
                if (isNoChange) {
                    list.add(preDyn);
                    if (this.isInvalidData(preDyn)) {
                        allList.add(list);
                        list = Lists.newArrayListWithExpectedSize((int)16);
                    } else if (i == sameStaffIdUseOrgBoIdDynList.size() - 1) {
                        list.add(sameStaffIdUseOrgBoIdDyn);
                        allList.add(list);
                    }
                } else if (!CollectionUtils.isEmpty((Collection)list)) {
                    list.add(preDyn);
                    allList.add(list);
                    list = this.newList();
                }
                preDyn = sameStaffIdUseOrgBoIdDyn;
            }
        }
        for (List list : allList) {
            List idList = list.stream().map(dyn -> dyn.getLong("id")).collect(Collectors.toList());
            List dataStatusList = list.stream().map(dyn -> dyn.getString("datastatus")).collect(Collectors.toList());
            logger.info("StaffHisDataUpgradeHelper#upgradeRepeatData.idList={},dataStatusList={}", idList, dataStatusList);
            this.treatSameDyn(list);
        }
        HRBaseServiceHelper helper = staffHisUpgradeEnum.getHelper();
        helper.save(this.saveDynList.toArray(new DynamicObject[0]));
        List toBeDeleteIdList = this.deleteDynList.stream().map(dyn -> dyn.getLong("id")).collect(Collectors.toList());
        helper.delete(toBeDeleteIdList.toArray());
        this.saveDynList.clear();
        this.deleteDynList.clear();
    }

    private List<DynamicObject> newList() {
        return Lists.newArrayListWithExpectedSize((int)16);
    }

    private DynamicObject[] getAllHisData(StaffHisUpgradeEnum staffHisUpgradeEnum) {
        DynamicObject[] useOrgDetailHisDynArr = new DynamicObject[]{};
        HAOSBaseRepository repository = staffHisUpgradeEnum.getRepository();
        if (repository instanceof DutyOrgDetailHisRepository) {
            useOrgDetailHisDynArr = ((DutyOrgDetailHisRepository)repository).loadAllDyn();
        } else if (repository instanceof UseOrgDetailHisRepository) {
            useOrgDetailHisDynArr = ((UseOrgDetailHisRepository)repository).loadAllDyn();
        } else if (repository instanceof MuldimDetailHisRepository) {
            useOrgDetailHisDynArr = ((MuldimDetailHisRepository)repository).loadAllDyn();
        }
        return useOrgDetailHisDynArr;
    }

    private void treatSameDyn(List<DynamicObject> dynList) {
        if (CollectionUtils.isEmpty(dynList)) {
            return;
        }
        List<DynamicObject> sortedDynList = dynList.stream().sorted(Comparator.comparing(dyn -> dyn.getDate("modifytime"))).collect(Collectors.toList());
        Set dataStatusSet = sortedDynList.stream().map(dyn -> dyn.getString("datastatus")).collect(Collectors.toSet());
        if (dataStatusSet.contains("1")) {
            this.existEffectExecutor(sortedDynList);
        } else if (dataStatusSet.contains("2")) {
            this.existInvalidExecutor(sortedDynList);
        } else {
            this.allDeletedExecutor(sortedDynList);
        }
    }

    private void allDeletedExecutor(List<DynamicObject> dynList) {
        for (int i = 0; i < dynList.size() - 1; ++i) {
            this.deleteDynList.add(dynList.get(i));
        }
    }

    private void existInvalidExecutor(List<DynamicObject> dynList) {
        int len = dynList.size();
        DynamicObject latestDyn = dynList.get(len - 1);
        Iterator<DynamicObject> iterator = dynList.iterator();
        while (iterator.hasNext()) {
            DynamicObject dyn = iterator.next();
            String dataStatus = dyn.getString("datastatus");
            if (!HRStringUtils.equals((String)dataStatus, (String)"-2")) continue;
            this.deleteDynList.add(dyn);
            iterator.remove();
        }
        DynamicObject firstInvalidDyn = dynList.get(0);
        Date bsed = firstInvalidDyn.getDate("effdt");
        DynamicObject lastInvalidDyn = dynList.get(dynList.size() - 1);
        lastInvalidDyn.set("effdt", (Object)bsed);
        String entityNumber = firstInvalidDyn.getDataEntityType().getName();
        if (HRStringUtils.equals((String)entityNumber, (String)"haos_dutyorgdetailhis")) {
            lastInvalidDyn.set("dutyorg", (Object)latestDyn.getDynamicObject("dutyorg"));
        } else if (HRStringUtils.equals((String)entityNumber, (String)"haos_useorgdetailhis")) {
            lastInvalidDyn.set("useorg", (Object)latestDyn.getDynamicObject("useorg"));
            lastInvalidDyn.set("dutyorg", (Object)latestDyn.getDynamicObject("dutyorg"));
        } else if (HRStringUtils.equals((String)entityNumber, (String)"haos_muldimendetailhis")) {
            lastInvalidDyn.set("orgteam", (Object)latestDyn.getDynamicObject("orgteam"));
            lastInvalidDyn.set("useorg", (Object)latestDyn.getDynamicObject("useorg"));
        }
        lastInvalidDyn.set("modifytime", (Object)latestDyn.getDate("modifytime"));
        this.saveDynList.add(lastInvalidDyn);
        for (int i = 0; i < dynList.size() - 1; ++i) {
            this.deleteDynList.add(dynList.get(i));
        }
    }

    private void existEffectExecutor(List<DynamicObject> dynList) {
        List invalidDynList = dynList.stream().filter(dyn -> HRStringUtils.equals((String)dyn.getString("datastatus"), (String)"2")).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(invalidDynList)) {
            DynamicObject firstInvalidDyn = (DynamicObject)invalidDynList.get(0);
            Date bsed = firstInvalidDyn.getDate("effdt");
            DynamicObject effectDyn = dynList.stream().filter(dyn -> HRStringUtils.equals((String)dyn.getString("datastatus"), (String)"1")).findFirst().get();
            effectDyn.set("effdt", (Object)bsed);
            logger.info("StaffHisDataUpgradeHelper#existEffectExecutor.effectDynId={},effectDynBsed={}", (Object)effectDyn.getLong("id"), (Object)effectDyn.getDate("effdt"));
            this.saveDynList.add(effectDyn);
        }
        for (DynamicObject dyn2 : dynList) {
            if (HRStringUtils.equals((String)dyn2.getString("datastatus"), (String)"1")) continue;
            this.deleteDynList.add(dyn2);
        }
    }

    private boolean isInvalidData(DynamicObject dyn) {
        Date bsledForCur = dyn.getDate("leffdt");
        Date dateWithOutHMS = HRDateTimeUtils.truncateDate((Date)bsledForCur);
        String dataStatus = dyn.getString("datastatus");
        return HRStringUtils.equals((String)dataStatus, (String)"2") && bsledForCur.getTime() == dateWithOutHMS.getTime();
    }

    protected static boolean longIsEmpty(Long naturalId) {
        return naturalId == null || naturalId == 0L;
    }
}

