/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.business.domain.service.impl.teamcoop;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.db.DBRoute;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.hr.haos.business.domain.repository.teamcoop.TeamCoopRelRepository;
import kd.hr.haos.business.domain.service.teamcoop.ITeamCoopRelService;
import kd.hr.haos.business.service.adminorg.AdminOrgHisDynamicUtils;
import kd.hr.haos.business.service.adminorg.AdminOrgHisServiceHelper;
import kd.hr.haos.business.service.adminorg.bean.TeamCoopRelBO;
import kd.hr.haos.business.util.DfsCycleCheckServiceHelper;
import kd.hr.haos.common.constants.projectgroup.ProjectGroupMDConstants;
import kd.hr.haos.common.model.CoopInfoModel;
import kd.hr.hbp.business.application.impl.newhismodel.HisModelController;
import kd.hr.hbp.business.domain.model.newhismodel.BatchVersionChangeRespData;
import kd.hr.hbp.business.domain.model.newhismodel.HisResponse;
import kd.hr.hbp.business.domain.model.newhismodel.HisVersionParamBo;
import kd.hr.hbp.business.domain.model.newhismodel.HisVersionParamListBo;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDBUtil;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;

public class TeamCoopRelServiceImpl
implements ITeamCoopRelService {
    private static final TeamCoopRelServiceImpl INSTANCE = new TeamCoopRelServiceImpl();
    private static final String HRMP_HAOS_BUSINESS = "hrmp-haos-business";
    private boolean pushUnModifiedChange;
    private boolean changeOnlyAd;

    private TeamCoopRelServiceImpl() {
    }

    public static TeamCoopRelServiceImpl getInstance() {
        return INSTANCE;
    }

    @Override
    public HisResponse<BatchVersionChangeRespData> batchAddNew(Map<Long, List<TeamCoopRelBO>> orgTeamCoopRelMap, Long eventId) {
        HisVersionParamBo hisVersionParamBo = this.buildAddNewHisParam(orgTeamCoopRelMap);
        HisVersionParamListBo hisVersionParamListBo = AdminOrgHisServiceHelper.constructBatchSaveHisVersionParamBO(Collections.singletonList(hisVersionParamBo), eventId);
        return HisModelController.getInstance().batchHisVersionChange(hisVersionParamListBo);
    }

    public void ChangeOne(TeamCoopRelBO teamCoopRelBO) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("haos_orgteamcooprel");
        QFilter qFilter = new QFilter("org", "=", (Object)teamCoopRelBO.getOrgTeamId()).and("coopreltype", "=", (Object)1010L);
        DynamicObject orgTeamCoopRelDB = serviceHelper.queryOne("boid", new QFilter[]{ProjectGroupMDConstants.FILTER_ENABLE, ProjectGroupMDConstants.FILTER_IS_CURRENT_VERSION, qFilter});
        if (orgTeamCoopRelDB == null) {
            return;
        }
        HashMap<Long, List<TeamCoopRelBO>> orgTeamCoopRelMap = new HashMap<Long, List<TeamCoopRelBO>>();
        ArrayList<TeamCoopRelBO> teamCoopRelBOList = new ArrayList<TeamCoopRelBO>();
        teamCoopRelBOList.add(teamCoopRelBO);
        teamCoopRelBO.setBoId(orgTeamCoopRelDB.getLong("boid"));
        orgTeamCoopRelMap.put(teamCoopRelBO.getOrgTeamId(), teamCoopRelBOList);
        this.pushUnModifiedChange = false;
        this.changeOnlyAd = true;
        this.doBatchChange(orgTeamCoopRelMap, teamCoopRelBO.getEffDate(), null);
    }

    @Override
    public HisResponse<BatchVersionChangeRespData> batchChange(Map<Long, List<TeamCoopRelBO>> orgTeamCoopRelMap, Date effDate, Long eventId) {
        this.pushUnModifiedChange = false;
        this.changeOnlyAd = false;
        return this.doBatchChange(orgTeamCoopRelMap, effDate, eventId);
    }

    @Override
    public HisResponse<BatchVersionChangeRespData> batchEnableOrDisable(List<Long> coopRelIdList, String enable, Date effDate, Long eventId) {
        DynamicObject[] teamCoopRelDyns = AdminOrgHisServiceHelper.batchGetTeamCoopRelByIds(coopRelIdList);
        DynamicObject[] teamCoopRelDynArrays = new DynamicObject[teamCoopRelDyns.length];
        int index = 0;
        for (DynamicObject teamCoopRelDyn : teamCoopRelDyns) {
            DynamicObject dynamicObject = AdminOrgHisServiceHelper.enableOrDisableEntity(teamCoopRelDyn, "haos_orgteamcooprel", enable, effDate);
            teamCoopRelDynArrays[index++] = dynamicObject;
        }
        HisVersionParamBo hisVersionParam = AdminOrgHisDynamicUtils.getInstance().getHisVersionParam(teamCoopRelDynArrays, "haos_orgteamcooprel", false);
        HisVersionParamListBo hisVersionParamListBo = AdminOrgHisServiceHelper.constructBatchSaveHisVersionParamBO(Collections.singletonList(hisVersionParam), eventId);
        return HisModelController.getInstance().batchHisVersionChange(hisVersionParamListBo);
    }

    public HisVersionParamBo buildAddNewHisParam(Map<Long, List<TeamCoopRelBO>> orgTeamCoopRelMap) {
        Set<Map.Entry<Long, List<TeamCoopRelBO>>> entrySet = orgTeamCoopRelMap.entrySet();
        Iterator<Map.Entry<Long, List<TeamCoopRelBO>>> iterator = entrySet.iterator();
        ArrayList<DynamicObject> orgTeamCoopRelList = new ArrayList<DynamicObject>();
        while (iterator.hasNext()) {
            Map.Entry<Long, List<TeamCoopRelBO>> orgTeamCoopRelEntry = iterator.next();
            List<TeamCoopRelBO> TeamCoopRelBOList = orgTeamCoopRelEntry.getValue();
            for (TeamCoopRelBO teamCoopRelBO : TeamCoopRelBOList) {
                this.constructAndAddNewCoopRelDyn(orgTeamCoopRelList, teamCoopRelBO);
            }
        }
        return AdminOrgHisDynamicUtils.getInstance().getHisVersionParam(orgTeamCoopRelList.toArray(new DynamicObject[0]), "haos_orgteamcooprel", false);
    }

    private void constructAndAddNewCoopRelDyn(List<DynamicObject> orgTeamCoopRelList, TeamCoopRelBO teamCoopRelBO) {
        DynamicObject dyn = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"haos_orgteamcooprel"));
        long id = ORM.create().genLongId("haos_orgteamcooprel");
        dyn.set("id", (Object)id);
        dyn.set("status", (Object)"C");
        dyn.set("bsed", (Object)teamCoopRelBO.getEffDate());
        dyn.set("enable", (Object)teamCoopRelBO.getEnable());
        dyn.set("org", (Object)teamCoopRelBO.getOrgTeamId());
        dyn.set("coopreltype", (Object)teamCoopRelBO.getCoopTypeId());
        dyn.set("cooporgteam", (Object)teamCoopRelBO.getCoopTeamId());
        dyn.set("index", (Object)teamCoopRelBO.getIndex());
        dyn.set("changedescription", (Object)teamCoopRelBO.getChangeDescription());
        dyn.set("initstatus", (Object)"2");
        orgTeamCoopRelList.add(dyn);
    }

    public HisVersionParamBo buildChangeHisParam(Map<Long, List<TeamCoopRelBO>> orgTeamCoopRelMap, Date effectDate) {
        Map<Long, List<TeamCoopRelBO>> oldOrgTeamCoopRelMap = this.changeOnlyAd ? AdminOrgHisServiceHelper.batchGetOldOrgCoopRelMapOnlyAd(orgTeamCoopRelMap.keySet()) : AdminOrgHisServiceHelper.batchGetOldOrgCoopRelMap(orgTeamCoopRelMap.keySet());
        Set<Map.Entry<Long, List<TeamCoopRelBO>>> entrySet = orgTeamCoopRelMap.entrySet();
        Iterator<Map.Entry<Long, List<TeamCoopRelBO>>> iterator = entrySet.iterator();
        ArrayList<DynamicObject> orgTeamCoopRelList = new ArrayList<DynamicObject>();
        while (iterator.hasNext()) {
            Map.Entry<Long, List<TeamCoopRelBO>> orgTeamCoopRelEntry = iterator.next();
            List<TeamCoopRelBO> newTeamCoopRelBOS = orgTeamCoopRelEntry.getValue();
            Map<Long, TeamCoopRelBO> changeIdTeamCoopRelMap = newTeamCoopRelBOS.stream().filter(teamCoopRelBO -> !teamCoopRelBO.getBoId().equals(0L)).collect(Collectors.toMap(TeamCoopRelBO::getBoId, teamCoopRelBO -> teamCoopRelBO));
            Long orgTeamId = orgTeamCoopRelEntry.getKey();
            List<TeamCoopRelBO> oldTeamCoopRelBOS = oldOrgTeamCoopRelMap.get(orgTeamId);
            Map<Long, TeamCoopRelBO> oldIdTeamCoopRelBOMap = oldTeamCoopRelBOS.stream().collect(Collectors.toMap(TeamCoopRelBO::getBoId, teamCoopRelBO -> teamCoopRelBO));
            for (TeamCoopRelBO newTeamCoopRelBO : newTeamCoopRelBOS) {
                boolean coopTypeOrCoopTeamChanged;
                Date effDate;
                Long teamCoopRelId = newTeamCoopRelBO.getBoId();
                Date date = effDate = Objects.isNull(newTeamCoopRelBO.getEffDate()) ? effectDate : newTeamCoopRelBO.getEffDate();
                if (teamCoopRelId == 0L && newTeamCoopRelBO.getCoopTypeId() != 1010L) {
                    this.constructAndAddNewCoopRelDyn(orgTeamCoopRelList, newTeamCoopRelBO);
                    continue;
                }
                if (newTeamCoopRelBO.getCoopTypeId().equals(1010L)) {
                    Optional<TeamCoopRelBO> oldOptionalTeamCoopRelBO = oldTeamCoopRelBOS.stream().filter(teamCoopRelBO -> teamCoopRelBO.getCoopTypeId().equals(1010L)).findFirst();
                    oldOptionalTeamCoopRelBO.ifPresent(oldTeamCoopRelBO -> {
                        if (!oldTeamCoopRelBO.getCoopTeamId().equals(newTeamCoopRelBO.getCoopTeamId())) {
                            DynamicObject dynamicObject = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"haos_orgteamcooprel"));
                            HRDynamicObjectUtils.copy((DynamicObject)oldTeamCoopRelBO.getOldTeamCoopRelDyn(), (DynamicObject)dynamicObject);
                            dynamicObject.set("cooporgteam", (Object)this.newDynamicOBjectWithId("haos_adminorgteam", newTeamCoopRelBO.getCoopTeamId()));
                            dynamicObject.set("bsed", (Object)effDate);
                            orgTeamCoopRelList.add(dynamicObject);
                        }
                    });
                    continue;
                }
                TeamCoopRelBO oldTeamCoopRel = oldIdTeamCoopRelBOMap.get(teamCoopRelId);
                if (oldTeamCoopRel == null) continue;
                boolean bl = coopTypeOrCoopTeamChanged = !oldTeamCoopRel.getCoopTypeId().equals(newTeamCoopRelBO.getCoopTypeId()) || !oldTeamCoopRel.getCoopTeamId().equals(newTeamCoopRelBO.getCoopTeamId());
                if (!this.pushUnModifiedChange && !coopTypeOrCoopTeamChanged) continue;
                DynamicObject dynamicObject = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"haos_orgteamcooprel"));
                HRDynamicObjectUtils.copy((DynamicObject)oldTeamCoopRel.getOldTeamCoopRelDyn(), (DynamicObject)dynamicObject);
                dynamicObject.set("cooporgteam", (Object)this.newDynamicOBjectWithId("haos_adminorgteam", newTeamCoopRelBO.getCoopTeamId()));
                dynamicObject.set("coopreltype", (Object)this.newDynamicOBjectWithId("haos_teamcoopreltype", newTeamCoopRelBO.getCoopTypeId()));
                dynamicObject.set("bsed", (Object)effDate);
                dynamicObject.set("index", (Object)newTeamCoopRelBO.getIndex());
                orgTeamCoopRelList.add(dynamicObject);
            }
            for (TeamCoopRelBO oldTeamCoopRelBO2 : oldTeamCoopRelBOS) {
                if (changeIdTeamCoopRelMap.containsKey(oldTeamCoopRelBO2.getBoId()) || oldTeamCoopRelBO2.getCoopTypeId().equals(1010L)) continue;
                DynamicObject dynamicObject = AdminOrgHisServiceHelper.enableOrDisableEntity(oldTeamCoopRelBO2.getOldTeamCoopRelDyn(), "haos_orgteamcooprel", "0", effectDate);
                orgTeamCoopRelList.add(dynamicObject);
            }
        }
        return AdminOrgHisDynamicUtils.getInstance().getHisVersionParam(orgTeamCoopRelList.toArray(new DynamicObject[0]), "haos_orgteamcooprel", false);
    }

    private DynamicObject newDynamicOBjectWithId(String entityNumber, long id) {
        DynamicObject newDynObj = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)entityNumber));
        newDynObj.set("id", (Object)id);
        return newDynObj;
    }

    @Override
    public Map<Long, String> batchCheck(Map<Long, DynamicObject[]> orgTeamCoopRelDynMap) {
        if (ObjectUtils.isEmpty(orgTeamCoopRelDynMap)) {
            return new HashMap<Long, String>(0);
        }
        Set<Map.Entry<Long, DynamicObject[]>> entries = orgTeamCoopRelDynMap.entrySet();
        Set<Long> coopOrgTeamIdSet = entries.stream().map(entry -> Arrays.stream((Object[])entry.getValue()).map(dyn -> dyn.getLong("cooporgteam.id")).collect(Collectors.toSet())).flatMap(Collection::stream).collect(Collectors.toSet());
        HashMap<Long, String> coopRelTypeMap = new HashMap<Long, String>(4);
        Map<Long, List<List<Long>>> circleCheckResult = this.coopInfoCircleCheck(orgTeamCoopRelDynMap, coopRelTypeMap);
        Map<Long, String> orgStatusMap = this.batchGetOrgBusinessStatus(coopOrgTeamIdSet);
        HashMap<Long, String> resultMap = new HashMap<Long, String>(orgTeamCoopRelDynMap.size());
        for (Map.Entry<Long, DynamicObject[]> entry2 : entries) {
            StringBuilder errorMessageBuilder = new StringBuilder();
            Long orgId = entry2.getKey();
            DynamicObject[] orgTeamCoopRels = entry2.getValue();
            HashSet<Long> cooperateSet = new HashSet<Long>(4);
            for (DynamicObject orgTeamCoopRel : orgTeamCoopRels) {
                long coopOrgTeamId;
                long coopTypeId = orgTeamCoopRel.getLong("coopreltype.id");
                if (Objects.nonNull(circleCheckResult.get(coopTypeId))) {
                    for (List<Long> circle : circleCheckResult.get(coopTypeId)) {
                        if (!circle.contains(orgId)) continue;
                        errorMessageBuilder.append(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u201c%s\u201d\u534f\u4f5c\u5173\u7cfb\u51fa\u73b0\u534f\u4f5c\u5faa\u73af\uff0c\u8bf7\u4fee\u6539\uff1b", (String)"TeamCoopRelServiceImpl_0", (String)HRMP_HAOS_BUSINESS, (Object[])new Object[0]), coopRelTypeMap.get(coopTypeId)));
                    }
                }
                if (Objects.nonNull(orgStatusMap.get(coopOrgTeamId = orgTeamCoopRel.getLong("cooporgteam.id"))) && "0".equals(orgStatusMap.get(coopOrgTeamId))) {
                    errorMessageBuilder.append(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u201c%1$s\u201d\u5bf9\u5e94\u7684\u534f\u4f5c\u7ec4\u7ec7\u201c%2$s\u201d\u5df2\u7981\u7528\uff0c\u8bf7\u4fee\u6539\uff1b", (String)"TeamCoopRelServiceImpl_1", (String)HRMP_HAOS_BUSINESS, (Object[])new Object[0]), orgTeamCoopRel.getString("coopreltype.name"), orgTeamCoopRel.getString("cooporgteam.name")));
                }
                if (cooperateSet.add(coopTypeId)) continue;
                errorMessageBuilder.append(String.format(Locale.ROOT, ResManager.loadResFormat((String)"%s\uff1a\u534f\u4f5c\u5173\u7cfb\u51fa\u73b0\u91cd\u590d\uff0c\u8bf7\u4fee\u6539\uff1b", (String)"TeamCoopRelServiceImpl_2", (String)HRMP_HAOS_BUSINESS, (Object[])new Object[0]), orgTeamCoopRel.getString("coopreltype.name")));
            }
            resultMap.put(orgId, errorMessageBuilder.toString());
        }
        return resultMap;
    }

    private Map<Long, List<List<Long>>> coopInfoCircleCheck(Map<Long, DynamicObject[]> orgTeamCoopRelDynMap, Map<Long, String> coopRelTypeMap) {
        List coopInfos = orgTeamCoopRelDynMap.entrySet().stream().map(entry -> Arrays.stream((Object[])entry.getValue()).map(dy -> {
            Long collTypeId = dy.getLong("coopreltype.id");
            Long collTeamId = dy.getLong("cooporgteam.id");
            coopRelTypeMap.put(collTypeId, dy.getString("coopreltype.name"));
            CoopInfoModel coopInfoModel = new CoopInfoModel();
            coopInfoModel.setOrg(entry.getKey());
            coopInfoModel.setCoopOrg((Object)collTypeId);
            coopInfoModel.setCooprelType(collTeamId);
            return coopInfoModel;
        }).collect(Collectors.toList())).flatMap(Collection::stream).collect(Collectors.toList());
        StringBuilder sb = new StringBuilder();
        sb.append("select forgid,fcoopreltypeid,fcooporgteamid,fenable ").append(" from t_haos_teamcooprel where fenable='1' and fiscurrentversion = '1' ").append(" and fcoopreltypeid in (");
        for (int i = 0; i < coopRelTypeMap.size(); ++i) {
            sb.append('?');
            if (i >= coopRelTypeMap.size() - 1) continue;
            sb.append(',');
        }
        sb.append(") and forgid not in (");
        orgTeamCoopRelDynMap.forEach((k, v) -> sb.append("?,"));
        sb.deleteCharAt(sb.length() - 1);
        sb.append(',');
        ArrayList<Long> params = new ArrayList<Long>(4);
        params.addAll(coopRelTypeMap.keySet());
        params.addAll(orgTeamCoopRelDynMap.keySet());
        try (DataSet rs = HRDBUtil.queryDataSet((String)"t_haos_teamcooprel", (DBRoute)new DBRoute("haos"), (String)sb.toString(), (Object[])params.toArray());){
            rs.forEach(data -> {
                CoopInfoModel coopInfoModel = new CoopInfoModel();
                coopInfoModel.setOrg((Object)data.getLong("forgid"));
                coopInfoModel.setCoopOrg((Object)data.getLong("fcooporgteamid"));
                coopInfoModel.setCooprelType(data.getLong("fcoopreltypeid"));
                coopInfos.add(coopInfoModel);
            });
        }
        HashMap<Long, List<List<Long>>> result = new HashMap<Long, List<List<Long>>>(coopRelTypeMap.size());
        coopInfos.stream().collect(Collectors.groupingBy(CoopInfoModel::getCooprelType)).forEach((k, v) -> {
            DfsCycleCheckServiceHelper circleChecker = new DfsCycleCheckServiceHelper();
            v.forEach(coopInfoModel -> circleChecker.addLine(coopInfoModel.getOrg(), coopInfoModel.getCoopOrg()));
            result.put((Long)k, circleChecker.find());
        });
        return result;
    }

    private Map<Long, String> batchGetOrgBusinessStatus(Set<Long> orgIdSet) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("haos_adminorgdetail");
        QFilter nameFilter = new QFilter("id", "in", orgIdSet);
        QFilter iscurrentversionFilter = new QFilter("iscurrentversion", "=", (Object)"1");
        DynamicObject[] dynamicObjects = serviceHelper.query("id, enable", new QFilter[]{nameFilter, iscurrentversionFilter});
        HashMap<Long, String> result = new HashMap<Long, String>(orgIdSet.size());
        for (DynamicObject dynamicObject : dynamicObjects) {
            result.put(dynamicObject.getLong("id"), dynamicObject.getString("enable"));
        }
        return result;
    }

    @Override
    public Map<Long, List<DynamicObject>> getProTeamCoopRelInfoBySourceOrgId(List<Long> sourceOrgIdLis, String selectFields, boolean isCurVersion, List<String> dataStatusList, String initStatus) {
        TeamCoopRelRepository teamCoopRelRepository = TeamCoopRelRepository.getInstance();
        Object[] proTeamCoopRelArr = teamCoopRelRepository.getProTeamCoopRelInfoBySourceOrgId(sourceOrgIdLis, selectFields, isCurVersion, dataStatusList, initStatus);
        if (ObjectUtils.isEmpty((Object[])proTeamCoopRelArr)) {
            return new HashMap<Long, List<DynamicObject>>(0);
        }
        return Arrays.stream(proTeamCoopRelArr).collect(Collectors.groupingBy(dyn -> dyn.getLong("org.id")));
    }

    @Override
    public HisResponse<BatchVersionChangeRespData> batchChangeAll(Map<Long, List<TeamCoopRelBO>> orgTeamCoopRelMap, Date effDate, Long eventId) {
        this.pushUnModifiedChange = true;
        this.changeOnlyAd = false;
        return this.doBatchChange(orgTeamCoopRelMap, effDate, eventId);
    }

    @Override
    public HisResponse<BatchVersionChangeRespData> batchChangeOnlyAd(Map<Long, List<TeamCoopRelBO>> orgTeamCoopRelMap, Date effDate, Long eventId) {
        this.pushUnModifiedChange = false;
        this.changeOnlyAd = true;
        return this.doBatchChange(orgTeamCoopRelMap, effDate, eventId);
    }

    private HisResponse<BatchVersionChangeRespData> doBatchChange(Map<Long, List<TeamCoopRelBO>> orgTeamCoopRelMap, Date effDate, Long eventId) {
        HisVersionParamBo hisVersionParamBo = this.buildChangeHisParam(orgTeamCoopRelMap, effDate);
        if (hisVersionParamBo.getHisDyns() == null || hisVersionParamBo.getHisDyns().length == 0) {
            return new HisResponse();
        }
        HisVersionParamListBo hisVersionParamListBo = AdminOrgHisServiceHelper.constructBatchSaveHisVersionParamBO(Collections.singletonList(hisVersionParamBo), eventId);
        return HisModelController.getInstance().batchHisVersionChange(hisVersionParamListBo);
    }
}

