/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.business.meta;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.devportal.util.MetaDataUtil;
import kd.bos.dlock.DLock;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.AbstractMetadata;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.hr.haos.business.domain.service.orgteam.ICustomOrgTeamService;
import kd.hr.haos.business.meta.StructTypeConstant;
import kd.hr.haos.business.meta.util.AppMenuInfo;
import kd.hr.haos.business.meta.util.GenMetaDataHelper;
import kd.hr.haos.business.meta.util.StructTypeIETempHelper;
import kd.hr.haos.business.service.adminorg.AdminOrgHisDynamicUtils;
import kd.hr.haos.business.util.IdCreator;
import kd.hr.haos.business.util.StructTypeHelper;
import kd.hr.hbp.business.domain.service.impl.newhismodel.HisEffDateCommonService;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;

public class StructClassHelper {
    private static final Log LOG = LogFactory.getLog(StructClassHelper.class);
    private static final HRBaseServiceHelper ORG_TYPE = new HRBaseServiceHelper("hbss_orgtype");
    private static final HRBaseServiceHelper TEAM_TYPE = new HRBaseServiceHelper("hbss_teamtype");
    private static final HRBaseServiceHelper OT_CLASS = new HRBaseServiceHelper("haos_otclassify");
    private static final HRBaseServiceHelper OT_CUSTOM_STRUCT = new HRBaseServiceHelper("haos_customotstruct");
    private static final HRBaseServiceHelper OT_CUSTOM_STRUCT_PROJECT = new HRBaseServiceHelper("haos_customstructproject");
    private static final HRBaseServiceHelper OT_CUSTOM = new HRBaseServiceHelper("haos_cusadminorgteam");
    private static final HRBaseServiceHelper OT_CUSTOM_SORT = new HRBaseServiceHelper("haos_customotsort");
    private static final HRBaseServiceHelper NUMBER_PREFIX = new HRBaseServiceHelper("hbss_numberprefix");
    private static final HRBaseServiceHelper STRUCT_TYPE = new HRBaseServiceHelper("haos_otherstructtype");
    private static final HRBaseServiceHelper STRUCT_PROJECT_CONFIG = new HRBaseServiceHelper("haos_structproconfig");
    private static final HRBaseServiceHelper BOS_ENTITY_OBJECT = new HRBaseServiceHelper("bos_entityobject");
    private static DynamicObject FUNC_ORG_TYPE = ORG_TYPE.loadDynamicObject(new QFilter("id", "=", (Object)1010L));

    public static HRBaseServiceHelper getStructTypeServiceHelper() {
        return STRUCT_TYPE;
    }

    public static HRBaseServiceHelper getOtCustomStructProjectServiceHelper() {
        return OT_CUSTOM_STRUCT_PROJECT;
    }

    public static void saveNew(DynamicObject dynamicObject) {
        LOG.info("begin struct type save new");
        IdCreator idCreator = new IdCreator();
        long thisId = idCreator.getId();
        boolean structTypeEnabled = dynamicObject.getBoolean("enable");
        LOG.info("structTypeEnabled : {}", (Object)structTypeEnabled);
        dynamicObject.set("id", (Object)thisId);
        String structTypeNumber = dynamicObject.getString("number");
        LOG.info("newTeamType");
        DynamicObject teamType = StructClassHelper.newTeamType(dynamicObject, thisId, structTypeNumber);
        LOG.info("newOtClass");
        DynamicObject otClass = StructClassHelper.newOtClass(dynamicObject, thisId, structTypeNumber, teamType);
        String nextNumberPrefix = StructClassHelper.getNextNumberPrefix();
        LOG.info("getNextNumberPrefix : {}", (Object)nextNumberPrefix);
        DynamicObject numberPrefix = StructClassHelper.newNumberPrefix(dynamicObject, thisId, structTypeNumber, teamType, nextNumberPrefix);
        DynamicObjectCollection entryEntity = dynamicObject.getDynamicObjectCollection("entryentity");
        ArrayList<DynamicObject> structProjectDynamicObjectList = new ArrayList<DynamicObject>(entryEntity.size());
        HashMap<Integer, Long> indexToStructId = new HashMap<Integer, Long>(entryEntity.size());
        HashMap<Long, Integer> structIdToIndex = new HashMap<Long, Integer>(entryEntity.size());
        for (int index = 0; index < entryEntity.size(); ++index) {
            long structId = idCreator.getId();
            StructClassHelper.newStructProject(entryEntity, structProjectDynamicObjectList, indexToStructId, structIdToIndex, index, structId, otClass);
        }
        Map<Long, DynamicObject> idToStructDyMap = structProjectDynamicObjectList.stream().collect(Collectors.toMap(dyn -> dyn.getLong("id"), dyn -> dyn));
        for (int index = 0; index < entryEntity.size(); ++index) {
            ((DynamicObject)entryEntity.get(index)).set("structproject", (Object)idToStructDyMap.get(indexToStructId.get(index)));
        }
        OT_CUSTOM_STRUCT_PROJECT.save(structProjectDynamicObjectList.toArray(new DynamicObject[0]));
        OT_CLASS.save(new DynamicObject[]{otClass});
        StructClassHelper.saveTeamTypeAndNumberPrefix(teamType, numberPrefix);
        StructClassHelper.createOrgTeam(dynamicObject, teamType, otClass);
        boolean createMetaResult = StructClassHelper.createMetaData(nextNumberPrefix, dynamicObject);
        if (!createMetaResult) {
            StructClassHelper.deleteDataIfNeed(thisId);
            throw new KDBizException("save meta error");
        }
        StructClassHelper.saveStructConfig(teamType, otClass, nextNumberPrefix);
        boolean publishMenuResult = StructClassHelper.publishMenu(dynamicObject, structProjectDynamicObjectList);
        if (!publishMenuResult) {
            StructClassHelper.deleteDataIfNeed(thisId);
            StructClassHelper.deleteMetaData(nextNumberPrefix);
            throw new KDBizException("publish menu error");
        }
        try (TXHandle required = TX.requiresNew();){
            try {
                StructTypeIETempHelper.addTemplate(dynamicObject);
            }
            catch (Throwable ex) {
                required.markRollback();
                LOG.error("addTemplate error", ex);
            }
        }
        LOG.info("end struct type save new");
    }

    private static void saveStructConfig(DynamicObject teamType, DynamicObject otClass, String nextNumberPrefix) {
        DynamicObject[] appObject = BusinessDataServiceHelper.load((String)"bos_devportal_bizapp", (String)"id,number", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)"homs")});
        AtomicInteger integer = new AtomicInteger(0);
        DynamicObject[] structProjectConfigs = new DynamicObject[StructTypeConstant.META_PROPER_KEY.size()];
        long[] ids = ORM.create().genLongIds("haos_structproconfig", StructTypeConstant.META_PROPER_KEY.size());
        StructTypeConstant.META_PROPER_KEY.forEach((page, propKey) -> {
            DynamicObject bosObject = BOS_ENTITY_OBJECT.queryOne(new QFilter[]{new QFilter("id", "=", (Object)(page + "_" + nextNumberPrefix.toLowerCase(Locale.ROOT)))});
            DynamicObject structProjectConfig = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"haos_structproconfig"));
            structProjectConfig.set("id", (Object)ids[integer.get()]);
            structProjectConfig.set("entitytype", (Object)bosObject);
            structProjectConfig.set("bizapp", (Object)appObject[0]);
            structProjectConfig.set("initstatus", (Object)"2");
            structProjectConfig.set("issyspreset", (Object)"1");
            DynamicObjectCollection entryentity = structProjectConfig.getDynamicObjectCollection("entryentity");
            DynamicObject entry = entryentity.addNew();
            entry.set("teamtype", (Object)teamType);
            DynamicObjectCollection entireProcessCollection = new DynamicObjectCollection();
            DynamicObject dy = new DynamicObject(entry.getDynamicObjectCollection("otclassify").getDynamicObjectType());
            dy.set("fbasedataid", (Object)otClass.getLong("id"));
            entireProcessCollection.add((Object)dy);
            entry.set("otclassify", (Object)entireProcessCollection);
            entry.set("propkey", propKey);
            entry.set("columnname", propKey);
            entry.set("entryissyspreset", (Object)"1");
            if ("haos_cusadminorgteam".equals(page)) {
                DynamicObject parentEntry = entryentity.addNew();
                parentEntry.set("teamtype", (Object)teamType);
                DynamicObjectCollection entireProcessCollection2 = new DynamicObjectCollection();
                DynamicObject dy2 = new DynamicObject(parentEntry.getDynamicObjectCollection("otclassify").getDynamicObjectType());
                dy2.set("fbasedataid", (Object)otClass.getLong("id"));
                entireProcessCollection2.add((Object)dy2);
                parentEntry.set("otclassify", (Object)entireProcessCollection2);
                parentEntry.set("propkey", (Object)"parent");
                parentEntry.set("columnname", (Object)"parent");
                parentEntry.set("entryissyspreset", (Object)"1");
            }
            structProjectConfigs[integer.getAndIncrement()] = structProjectConfig;
        });
        STRUCT_PROJECT_CONFIG.save(structProjectConfigs);
    }

    private static boolean publishMenu(DynamicObject dynamicObject, List<DynamicObject> structProjectList) {
        boolean publishMenuResult = true;
        try (TXHandle required = TX.requiresNew();){
            try {
                AppMenuInfo appMenuInfo = StructClassHelper.transferCusStructToAppMenuInfo(dynamicObject, structProjectList);
                StructClassHelper.publishMenu(appMenuInfo);
            }
            catch (Throwable ex) {
                required.markRollback();
                publishMenuResult = false;
                LOG.error("publishMenu error", ex);
            }
        }
        return publishMenuResult;
    }

    private static AppMenuInfo transferCusStructToAppMenuInfo(DynamicObject structType, List<DynamicObject> structProjectList) {
        AppMenuInfo appMenuInfo = new AppMenuInfo();
        appMenuInfo.setId(String.valueOf(structType.get("id")));
        appMenuInfo.setMenuName(structType.getLocaleString("name"));
        appMenuInfo.setParentNodeId("1802202898084539392");
        appMenuInfo.setDescription("");
        appMenuInfo.setSeq(0);
        appMenuInfo.setVectorValue("");
        appMenuInfo.setShortCutEntrance("");
        appMenuInfo.setPermissionId("");
        appMenuInfo.setCaption("");
        appMenuInfo.setParameterType("ListShowParameter");
        appMenuInfo.setOpenType("MainNewTabPage");
        boolean showSecondaryMenu = false;
        if (!CollectionUtils.isEmpty(structProjectList)) {
            ArrayList childMenus = Lists.newArrayListWithExpectedSize((int)structProjectList.size());
            for (DynamicObject item : structProjectList) {
                AppMenuInfo projectMenu = new AppMenuInfo();
                projectMenu.setId(String.valueOf(item.get("id")));
                projectMenu.setMenuName(item.getLocaleString("name"));
                projectMenu.setFormId("haos_structprojecttab");
                projectMenu.setFormNumber("haos_structprojecttab");
                projectMenu.setParentNodeId(String.valueOf(structType.get("id")));
                projectMenu.setParameterType("FormShowParameter");
                projectMenu.setOpenType("MainNewTabPage");
                HashMap<String, String> param = new HashMap<String, String>();
                param.put("structProjectId", String.valueOf(item.get("id")));
                projectMenu.setParameter(SerializationUtils.toJsonString(param));
                projectMenu.setCaption(item.getString("name"));
                if (item.getBoolean("enable")) {
                    showSecondaryMenu = true;
                } else {
                    projectMenu.setVisible("false");
                    projectMenu.setDelete(true);
                }
                childMenus.add(projectMenu);
            }
            if (!showSecondaryMenu) {
                appMenuInfo.setVisible("false");
            }
            appMenuInfo.setChildren(childMenus);
        }
        return appMenuInfo;
    }

    private static void deleteMetaData(String nextNumberPrefix) {
        try (TXHandle required = TX.requiresNew();){
            try {
                MetaDataUtil metaDataUtil = new MetaDataUtil();
                for (String pageNumber : StructTypeConstant.BASE_META_PAGE) {
                    String metaId = MetadataDao.getIdByNumber((String)(pageNumber + "_" + nextNumberPrefix), (MetaCategory)MetaCategory.Form);
                    Map map = metaDataUtil.delFormMetadata(metaId);
                    LOG.info("metaDataUtil.delFormMetadata(metaId) : {}", (Object)map);
                }
            }
            catch (Throwable ex) {
                required.markRollback();
                throw ex;
            }
        }
    }

    private static void deleteDataIfNeed(long thisId) {
        try (TXHandle required = TX.requiresNew();){
            try {
                TEAM_TYPE.deleteByFilter(new QFilter[]{new QFilter("id", "=", (Object)thisId)});
                NUMBER_PREFIX.deleteByFilter(new QFilter[]{new QFilter("id", "=", (Object)thisId)});
            }
            catch (Throwable ex) {
                required.markRollback();
                throw ex;
            }
        }
    }

    public static boolean createMetaData(String nextNumberPrefix, DynamicObject dynamicObject) {
        boolean createMetaResult = true;
        try (TXHandle required = TX.requiresNew();){
            try {
                for (String pageNumber : StructTypeConstant.BASE_META_PAGE) {
                    String namePrefix;
                    AbstractMetadata metadata = MetadataDao.readRuntimeMeta((String)MetadataDao.getIdByNumber((String)pageNumber, (MetaCategory)MetaCategory.Form), (MetaCategory)MetaCategory.Form);
                    String metaName = null;
                    if (metadata instanceof FormMetadata) {
                        metaName = ((FormMetadata)metadata).getName().getLocaleValue();
                    }
                    if ((namePrefix = StructTypeConstant.META_TO_NEW_NAME.get(pageNumber)) != null) {
                        metaName = dynamicObject.getString("name") + "-" + namePrefix;
                    }
                    GenMetaDataHelper.createMetaAndSave(pageNumber + "_" + nextNumberPrefix.toLowerCase(Locale.ROOT), metaName, metadata.getModelType(), StructTypeConstant.META_PARENT.get(pageNumber), "3NBTWBH6BBSU", "W11R1282DJK", "217WYC/L9U7E");
                }
            }
            catch (Throwable ex) {
                required.markRollback();
                createMetaResult = false;
                LOG.error("createMetaData error", ex);
            }
        }
        return createMetaResult;
    }

    public static boolean changeMetaName(String nextNumberPrefix, String structTypeName) {
        boolean createMetaResult = true;
        try (TXHandle required = TX.requiresNew();){
            try {
                for (String pageNumber : StructTypeConstant.BASE_META_PAGE) {
                    String namePrefix;
                    if ("haos_customstructproject".equals(pageNumber) || (namePrefix = StructTypeConstant.META_TO_NEW_NAME.get(pageNumber)) == null) continue;
                    String pageNum = pageNumber + "_" + nextNumberPrefix.toLowerCase(Locale.ROOT);
                    String metaName = structTypeName + "-" + namePrefix;
                    GenMetaDataHelper.editMetadata(pageNum, metaName, "217WYC/L9U7E");
                }
            }
            catch (Throwable ex) {
                required.markRollback();
                createMetaResult = false;
                LOG.error("changeMetaName error", ex);
            }
        }
        return createMetaResult;
    }

    private static void saveTeamTypeAndNumberPrefix(DynamicObject teamType, DynamicObject numberPrefix) {
        try (TXHandle required = TX.requiresNew();){
            try {
                TEAM_TYPE.saveOne(teamType);
                NUMBER_PREFIX.saveOne(numberPrefix);
            }
            catch (Throwable ex) {
                required.markRollback();
                throw ex;
            }
        }
    }

    private static void newStructProject(DynamicObjectCollection entryEntity, List<DynamicObject> structProjectDynamicObjectList, Map<Integer, Long> indexToStructId, Map<Long, Integer> structIdToIndex, int index, long structId, DynamicObject otClass) {
        DynamicObject structDynamicObject = OT_CUSTOM_STRUCT_PROJECT.generateEmptyDynamicObject();
        structDynamicObject.set("id", (Object)structId);
        structDynamicObject.set("org", ((DynamicObject)entryEntity.get(index)).get("struct_org"));
        structDynamicObject.set("number", (Object)((DynamicObject)entryEntity.get(index)).getString("struct_number"));
        structDynamicObject.set("name", ((DynamicObject)entryEntity.get(index)).get("struct_name"));
        String status = "true".equals(((DynamicObject)entryEntity.get(index)).getString("struct_enable")) ? "1" : "10";
        structDynamicObject.set("enable", (Object)status);
        structDynamicObject.set("effdt", (Object)((DynamicObject)entryEntity.get(index)).getDate("struct_effectdate"));
        structDynamicObject.set("status", (Object)"C");
        structDynamicObject.set("roottype", (Object)"1");
        structDynamicObject.set("iscustomorg", (Object)"1");
        structDynamicObject.set("otclassify", (Object)otClass);
        structDynamicObject.set("index", (Object)((DynamicObject)entryEntity.get(index)).getInt("seq"));
        structDynamicObject.set("description", ((DynamicObject)entryEntity.get(index)).get("struct_description"));
        indexToStructId.put(index, structId);
        if (((DynamicObject)entryEntity.get(index)).getBoolean("struct_enable")) {
            structIdToIndex.put(structId, index);
        }
        structProjectDynamicObjectList.add(structDynamicObject);
        ((DynamicObject)entryEntity.get(index)).set("structproject", (Object)structDynamicObject);
    }

    private static DynamicObject newNumberPrefix(DynamicObject dynamicObject, long thisId, String structTypeNumber, DynamicObject teamType, String nextNumberPrefix) {
        DynamicObject numberPrefix = NUMBER_PREFIX.generateEmptyDynamicObject();
        numberPrefix.set("id", (Object)thisId);
        numberPrefix.set("number", (Object)structTypeNumber);
        numberPrefix.set("name", dynamicObject.get("name"));
        numberPrefix.set("type", (Object)"ORGTEAM");
        numberPrefix.set("teamtype", (Object)teamType);
        numberPrefix.set("orgtype", (Object)FUNC_ORG_TYPE);
        numberPrefix.set("enable", (Object)"1");
        numberPrefix.set("numberprefix", (Object)nextNumberPrefix);
        return numberPrefix;
    }

    private static DynamicObject newOtClass(DynamicObject dynamicObject, long thisId, String structTypeNumber, DynamicObject teamType) {
        DynamicObject otClass = OT_CLASS.generateEmptyDynamicObject();
        otClass.set("id", (Object)thisId);
        otClass.set("number", (Object)structTypeNumber);
        otClass.set("name", dynamicObject.get("name"));
        otClass.set("status", (Object)"C");
        otClass.set("teamtype", (Object)teamType);
        otClass.set("orgtype", (Object)FUNC_ORG_TYPE);
        otClass.set("enable", (Object)"1");
        return otClass;
    }

    private static DynamicObject newTeamType(DynamicObject dynamicObject, long thisId, String structTypeNumber) {
        DynamicObject teamType = TEAM_TYPE.generateEmptyDynamicObject();
        teamType.set("id", (Object)thisId);
        teamType.set("number", (Object)structTypeNumber);
        teamType.set("name", dynamicObject.get("name"));
        teamType.set("enable", (Object)"1");
        teamType.set("status", (Object)"C");
        teamType.set("iscustom", (Object)"1");
        return teamType;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void publishMenu(AppMenuInfo appMenuInfo) {
        QFilter isvFilter;
        String appId = "217WYC/L9U7E";
        String currentIsv = GenMetaDataHelper.getCurrentIsv();
        if (StringUtils.isBlank((CharSequence)currentIsv)) {
            throw new KDBizException("current isv is blank");
        }
        String selProp = "id,isv,number,inheritpath";
        QFilter inheritPathFilter = new QFilter("inheritpath", "like", (Object)("%" + appId + "%"));
        DynamicObject[] appObjs = BusinessDataServiceHelper.load((String)"bos_devportal_bizapp", (String)selProp, (QFilter[])new QFilter[]{inheritPathFilter, isvFilter = new QFilter("isv", "=", (Object)currentIsv)});
        if (appObjs != null && appObjs.length > 0) {
            DynamicObject appExdDy = StructClassHelper.getAppExdDy(appObjs);
            if (appExdDy == null) throw new KDBizException("get ext app fail");
            String extendAppId = appExdDy.getString("id");
            appMenuInfo.setBizAppId(extendAppId);
            GenMetaDataHelper.createAppMenuAndSave(appMenuInfo, true);
            return;
        } else {
            String extendAppId;
            appObjs = BusinessDataServiceHelper.load((String)"bos_devportal_bizapp", (String)selProp, (QFilter[])new QFilter[]{inheritPathFilter});
            DynamicObject appExdDy = StructClassHelper.getAppExdDy(appObjs);
            String toExdAppId = appId;
            if (appExdDy != null && StringUtils.isNotBlank((CharSequence)appExdDy.getString("id"))) {
                toExdAppId = appExdDy.getString("id");
            }
            if ((extendAppId = GenMetaDataHelper.createExtendApp("0MUWQ6HSY5JA", toExdAppId)) == null) throw new KDBizException("create ext app fail");
            appMenuInfo.setBizAppId(extendAppId);
            GenMetaDataHelper.createAppMenuAndSave(appMenuInfo, true);
        }
    }

    private static DynamicObject getAppExdDy(DynamicObject[] appObjs) {
        if (appObjs != null && appObjs.length > 0) {
            DynamicObject appObjExd = null;
            for (DynamicObject appObjDy : appObjs) {
                if (appObjExd == null) {
                    appObjExd = appObjDy;
                    continue;
                }
                String inheritPathExd = appObjExd.getString("inheritpath");
                String inheritPath = appObjDy.getString("inheritpath");
                if (!StringUtils.isNotBlank((CharSequence)inheritPathExd) || !StringUtils.isNotBlank((CharSequence)inheritPath) || inheritPath.length() <= inheritPathExd.length()) continue;
                appObjExd = appObjDy;
            }
            return appObjExd;
        }
        return null;
    }

    private static boolean isAllLetter(String str) {
        char[] chars = str.toCharArray();
        for (int index = 0; index < chars.length; ++index) {
            if (Character.isLetter(chars[index])) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getNextNumberPrefix() {
        DLock dLock = DLock.create((String)"create_number_prefix");
        dLock.lock();
        try {
            LOG.info("getNextNumberPrefix locking");
            HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbss_numberprefix");
            DynamicObject[] dynamicObject = serviceHelper.query("numberprefix,type,teamtype,orgtype,number", null);
            List allNumberPrefixSet = Arrays.stream(dynamicObject).map(dyn -> dyn.getString("numberprefix")).collect(Collectors.toList());
            List allNoDigitalNumberPrefix = allNumberPrefixSet.stream().filter(StructClassHelper::isAllLetter).sorted().collect(Collectors.toList());
            if (!allNoDigitalNumberPrefix.contains("AAA")) {
                String string = "AAA";
                return string;
            }
            String nextNumberPrefix = null;
            String lastNumberPrefix = (String)allNoDigitalNumberPrefix.get(0);
            do {
                lastNumberPrefix = nextNumberPrefix = StructClassHelper.getNextNumberPrefix(lastNumberPrefix);
            } while (allNoDigitalNumberPrefix.contains(nextNumberPrefix));
            if ("ZZZ".equals(lastNumberPrefix)) {
                throw new KDBizException("number prefix over_size");
            }
            String string = nextNumberPrefix;
            return string;
        }
        finally {
            dLock.unlock();
            LOG.info("getNextNumberPrefix unlocked");
        }
    }

    private static String getNextNumberPrefix(String prefix) {
        char[] chars = prefix.toCharArray();
        for (int i = chars.length - 1; i >= 0; --i) {
            if (i - 1 >= 0 && chars[i] == 'Z') {
                chars[i] = 65;
                if (chars[i - 1] != 'Z') {
                    int n = i - 1;
                    chars[n] = (char)(chars[n] + '\u0001');
                } else {
                    chars[i - 1] = 65;
                }
                if (i - 2 >= 0 && chars[i - 2] == 'Z') {
                    chars[i] = 65;
                    chars[i - 2] = 65;
                }
                if (i - 2 < 0 || chars[i - 2] == 'Z') break;
                chars[i] = 65;
                int n = i - 2;
                chars[n] = (char)(chars[n] + '\u0001');
                break;
            }
            if (chars[i] >= 'Z') continue;
            int n = i;
            chars[n] = (char)(chars[n] + '\u0001');
            break;
        }
        return String.valueOf(chars);
    }

    public static String getPrefixNumberByStructTypeId(Long structTypeId) {
        DynamicObject dynamicObject = NUMBER_PREFIX.queryOne((Object)structTypeId);
        return dynamicObject.getString("numberprefix").toLowerCase(Locale.ROOT);
    }

    public static void saveUpdate(DynamicObject dynamicObject) {
        DynamicObjectCollection dynamicObjects;
        DynamicObject dbDy = STRUCT_TYPE.queryOne(dynamicObject.getPkValue());
        if (HRObjectUtils.isEmpty((Object)dbDy)) {
            LOG.error("saveUpdate error\uff0c data has been deleted :[{}]", dynamicObject.getPkValue());
            return;
        }
        DynamicObject teamType = null;
        DynamicObject classDy = null;
        String structTypeNumber = dynamicObject.getString("number");
        if (structTypeNumber != null && !structTypeNumber.equals(dbDy.getString("number"))) {
            Long pkId = (Long)dynamicObject.getPkValue();
            teamType = TEAM_TYPE.queryOne(dynamicObject.getPkValue());
            if (teamType == null) {
                LOG.error("teamType is null");
                throw new KDBizException("data exception(teamType is nul)");
            }
            teamType.set("number", (Object)structTypeNumber);
            TEAM_TYPE.updateOne(dynamicObject);
            classDy = OT_CLASS.queryOne(dynamicObject.getPkValue());
            if (classDy == null) {
                LOG.error("classDy is null");
                throw new KDBizException("data exception(classDy is nul)");
            }
            classDy.set("number", (Object)structTypeNumber);
            OT_CLASS.updateOne(dynamicObject);
            DynamicObject numberPrexDy = NUMBER_PREFIX.queryOne("number", (Object)pkId);
            if (numberPrexDy == null) {
                LOG.error("numberPrexDy is null");
                throw new KDBizException("data exception(numberPrexDy is nul)");
            }
            numberPrexDy.set("number", (Object)structTypeNumber);
            NUMBER_PREFIX.updateOne(dynamicObject);
        }
        if ((dynamicObjects = dynamicObject.getDynamicObjectCollection("entryentity")) != null && dynamicObjects.size() > 0) {
            ArrayList<Object> list = new ArrayList<Object>(dynamicObjects.size());
            ArrayList<Object> addList = new ArrayList<Object>(dynamicObjects.size());
            ArrayList<Object> statusChangeList = new ArrayList<Object>(dynamicObjects.size());
            IdCreator idCreator = new IdCreator();
            for (int index = 0; index < dynamicObjects.size(); ++index) {
                boolean bl;
                DynamicObject rowDy = (DynamicObject)dynamicObjects.get(index);
                Object structProDy = rowDy.getDynamicObject("structproject");
                if (structProDy == null) {
                    structProDy = OT_CUSTOM_STRUCT_PROJECT.generateEmptyDynamicObject();
                    structProDy.set("id", (Object)idCreator.getId());
                    structProDy.set("number", (Object)rowDy.getString("struct_number"));
                    structProDy.set("name", (Object)rowDy.getString("struct_name"));
                    String string = "true".equals(rowDy.getString("struct_enable")) ? "1" : "10";
                    structProDy.set("enable", (Object)string);
                    structProDy.set("org", rowDy.get("struct_org"));
                    structProDy.set("effdt", (Object)rowDy.getDate("struct_effectdate"));
                    structProDy.set("status", (Object)"C");
                    structProDy.set("roottype", (Object)"1");
                    structProDy.set("iscustomorg", (Object)"1");
                    structProDy.set("otclassify_id", (Object)dynamicObject.getLong("id"));
                    structProDy.set("index", (Object)index);
                    structProDy.set("description", (Object)rowDy.getDate("struct_description"));
                    rowDy.set("structproject", structProDy);
                    addList.add(structProDy);
                    continue;
                }
                boolean bl2 = false;
                if (!HRStringUtils.equals((String)rowDy.getString("struct_number"), (String)structProDy.getString("number"))) {
                    structProDy.set("number", (Object)rowDy.getString("struct_number"));
                    boolean bl3 = true;
                }
                if (!HRStringUtils.equals((String)rowDy.getString("struct_name"), (String)structProDy.getString("name"))) {
                    structProDy.set("name", (Object)rowDy.getString("struct_name"));
                    boolean bl4 = true;
                }
                Date effDate = structProDy.getDate("effdt");
                Date effDate2 = rowDy.getDate("struct_effectdate");
                if (effDate != null && effDate.compareTo(effDate2) != 0) {
                    structProDy.set("effdt", (Object)effDate2);
                    boolean bl5 = true;
                }
                if (structProDy.getLong("org.id") != rowDy.getLong("struct_org.id")) {
                    structProDy.set("org", rowDy.get("struct_org"));
                    boolean bl6 = true;
                }
                if (!HRStringUtils.equals((String)rowDy.getString("struct_description"), (String)structProDy.getString("description"))) {
                    structProDy.set("description", (Object)rowDy.getString("struct_description"));
                    boolean bl7 = true;
                }
                String enableValue = StructClassHelper.getEnableValue(rowDy);
                String oldEnableValue = structProDy.getString("enable");
                if ("10".equals(oldEnableValue)) {
                    oldEnableValue = "0";
                }
                if (!HRStringUtils.equals((String)enableValue, (String)oldEnableValue)) {
                    structProDy.set("enable", (Object)enableValue);
                    bl = true;
                    statusChangeList.add(structProDy);
                }
                if (!bl) continue;
                list.add(structProDy);
            }
            ArrayList<Long> disableOrgTeamBoIds = new ArrayList<Long>(statusChangeList.size() + 8);
            if (list.size() > 0 || addList.size() > 0) {
                if (list.size() > 0) {
                    OT_CUSTOM_STRUCT_PROJECT.update(list.toArray(new DynamicObject[0]));
                }
                if (addList.size() > 0) {
                    OT_CUSTOM_STRUCT_PROJECT.save(addList.toArray(new DynamicObject[0]));
                    list.addAll(addList);
                }
                ArrayList<Long> enableOrgTeamBoIds = new ArrayList<Long>(statusChangeList.size());
                for (DynamicObject dynamicObject2 : statusChangeList) {
                    DynamicObject rootOrgTeamStruct;
                    String status = dynamicObject2.getString("enable");
                    if ("10".equals(status) || (rootOrgTeamStruct = StructTypeHelper.getRootOrgTeamStruct(dynamicObject2.getLong("id"))) == null) continue;
                    DynamicObject orgTeamDy = rootOrgTeamStruct.getDynamicObject("orgteam");
                    if ("1".equals(status)) {
                        enableOrgTeamBoIds.add(orgTeamDy.getLong("id"));
                        continue;
                    }
                    if (!"0".equals(status)) continue;
                    disableOrgTeamBoIds.add(orgTeamDy.getLong("id"));
                }
                StructClassHelper.createOrgTeam(dynamicObject, teamType, classDy);
                if (enableOrgTeamBoIds.size() > 0) {
                    ICustomOrgTeamService.getInstance().enable(enableOrgTeamBoIds);
                }
            }
            List<DynamicObject> structProjectDynamicObjectList = dynamicObjects.stream().map(val -> val.getDynamicObject("structproject")).collect(Collectors.toList());
            DynamicObjectCollection dys = dbDy.getDynamicObjectCollection("entryentity");
            if (dys != null) {
                Set set = structProjectDynamicObjectList.stream().map(val -> val.getLong("id")).collect(Collectors.toSet());
                ArrayList<DynamicObject> delToDisable = new ArrayList<DynamicObject>(dys.size());
                for (DynamicObject dyn : dys) {
                    DynamicObject orgTeamDy;
                    DynamicObject structProDy = dyn.getDynamicObject("structproject");
                    if (structProDy == null || set.contains(structProDy.getLong("id"))) continue;
                    structProDy.set("enable", (Object)"0");
                    structProjectDynamicObjectList.add(structProDy);
                    DynamicObject rootOrgTeamStruct = StructTypeHelper.getRootOrgTeamStruct(structProDy.getLong("id"));
                    if (rootOrgTeamStruct == null || (orgTeamDy = rootOrgTeamStruct.getDynamicObject("orgteam")) == null) continue;
                    disableOrgTeamBoIds.add(orgTeamDy.getLong("id"));
                    structProDy.set("enable", (Object)"0");
                    String number = structProDy.getString("number");
                    String date = HRDateTimeUtils.format((Date)new Date(), (String)"yyyyMMddHHmmss");
                    structProDy.set("number", (Object)(number + "_" + date));
                    delToDisable.add(structProDy);
                }
                if (delToDisable.size() > 0) {
                    OT_CUSTOM_STRUCT_PROJECT.update(delToDisable.toArray(new DynamicObject[0]));
                }
            }
            if (disableOrgTeamBoIds.size() > 0) {
                ICustomOrgTeamService.getInstance().disable(disableOrgTeamBoIds);
            }
            boolean bl = StructClassHelper.publishMenu(dynamicObject, structProjectDynamicObjectList);
            LOG.info("publishMenuResult:{}", (Object)bl);
        }
    }

    private static String getEnableValue(DynamicObject dynamicObject) {
        String enableValue = dynamicObject.getString("struct_enable");
        if ("true".equals(enableValue)) {
            return "1";
        }
        if (enableValue == null || !"1".equals(enableValue) && !"0".equals(enableValue)) {
            return "0";
        }
        return enableValue;
    }

    private static DynamicObject getDynamicObject(HRBaseServiceHelper helper, Object pkValue) {
        DynamicObject dynamicObject = helper.queryOne(pkValue);
        if (dynamicObject == null) {
            throw new KDBizException("data exception:" + helper.getEntityName());
        }
        return dynamicObject;
    }

    private static DynamicObject createOrgTeam(DynamicObject structProjectDy, DynamicObject teamType, DynamicObject otClass, long otBoId, long otHisId) {
        DynamicObject otCustom = OT_CUSTOM.generateEmptyDynamicObject();
        otCustom.set("id", (Object)otBoId);
        otCustom.set("number", (Object)structProjectDy.getString("number"));
        otCustom.set("structproject", (Object)structProjectDy);
        otCustom.set("isroot", (Object)"1");
        otCustom.set("name", structProjectDy.get("name"));
        otCustom.set("parent", null);
        otCustom.set("bsed", (Object)structProjectDy.getDate("effdt"));
        otCustom.set("bsled", (Object)HisEffDateCommonService.getInstance().getDate2999(null));
        otCustom.set("enable", (Object)"1");
        otCustom.set("teamtype", (Object)teamType);
        otCustom.set("initstatus", (Object)"2");
        otCustom.set("status", (Object)"C");
        String structNumber = ORM.create().genStringId("haos_cusadminorgteam");
        otCustom.set("structnumber", (Object)structNumber);
        otCustom.set("structlongnumber", (Object)structNumber);
        otCustom.set("orgtype", (Object)FUNC_ORG_TYPE);
        otCustom.set("otclassify", (Object)otClass);
        otCustom.set("index", (Object)1);
        otCustom.set("sortcode", (Object)"1");
        long[] firstVersionId = new long[]{otHisId};
        AdminOrgHisDynamicUtils.FIRST_VERSION_IDS.set(firstVersionId);
        return otCustom;
    }

    public static void createOrgTeam(DynamicObject structType, DynamicObject teamType, DynamicObject classDy) {
        DynamicObjectCollection dynamicObjects = structType.getDynamicObjectCollection("entryentity");
        IdCreator idCreator = new IdCreator();
        ArrayList<DynamicObject> newOrgs = new ArrayList<DynamicObject>(dynamicObjects.size());
        for (DynamicObject rowDy : dynamicObjects) {
            DynamicObject rootOrgTeamStruct;
            DynamicObject structPo;
            if (!"true".equals(rowDy.getString("struct_enable")) || (structPo = rowDy.getDynamicObject("structproject")) == null || (rootOrgTeamStruct = StructTypeHelper.getRootOrgTeamStruct(structPo.getLong("id"))) != null) continue;
            long otBoId = idCreator.getId();
            long otHisId = idCreator.getId();
            DynamicObject orgTeamDy = StructClassHelper.createOrgTeam(structPo, teamType, classDy, otBoId, otHisId);
            newOrgs.add(orgTeamDy);
        }
        LOG.info("newOrgs.size():{}", (Object)newOrgs.size());
        if (newOrgs.size() > 0) {
            ICustomOrgTeamService.getInstance().add(newOrgs);
        }
    }
}

