/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.business.service.adminorg;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.haos.business.service.adminorg.AdminOrgHisDynKey;
import kd.hr.haos.business.service.adminorg.AdminOrgHisDynamicUtils;
import kd.hr.haos.business.service.adminorg.AdminOrgHisServiceHelper;
import kd.hr.haos.business.service.adminorg.IOpService;
import kd.hr.haos.business.service.adminorg.sortcode.AdminOrgSortCodeService;
import kd.hr.haos.business.service.adminorg.struct.AdminOrgStructService;
import kd.hr.haos.common.constants.masterdata.AdminOrgType;
import kd.hr.hbp.business.application.impl.newhismodel.HisModelController;
import kd.hr.hbp.business.domain.model.newhismodel.BatchVersionChangeRespData;
import kd.hr.hbp.business.domain.model.newhismodel.HisResponse;
import kd.hr.hbp.business.domain.model.newhismodel.HisVersionParamBo;
import kd.hr.hbp.business.domain.model.newhismodel.HisVersionParamListBo;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;

public class AdminOrgBasicInfoService
implements IOpService {
    private static final Log logger = LogFactory.getLog(AdminOrgBasicInfoService.class);
    private static AdminOrgBasicInfoService instance = new AdminOrgBasicInfoService();

    public static AdminOrgBasicInfoService getInstance() {
        return instance;
    }

    @Override
    public HisResponse<BatchVersionChangeRespData> saveNew(DynamicObject[] dysArrays, Long eventId) {
        HisVersionParamListBo hisVersionParamListBo = new HisVersionParamListBo();
        hisVersionParamListBo.setAtomicTrans(false);
        if (eventId != null && !eventId.equals(0L)) {
            hisVersionParamListBo.setEventId(eventId);
        }
        List<HisVersionParamBo> listHisVersionParamBo = this.buildAddNewHisVersionParam(dysArrays);
        HisVersionParamBo orgStructHisParam = AdminOrgStructService.getInstance().buildAddNewHisParam(dysArrays);
        listHisVersionParamBo.add(orgStructHisParam);
        HisVersionParamBo orgSortCodeHisParam = AdminOrgSortCodeService.getInstance().buildAddNewHisParam(dysArrays);
        listHisVersionParamBo.add(orgSortCodeHisParam);
        hisVersionParamListBo.setListHisVersionParamBo(listHisVersionParamBo);
        return HisModelController.getInstance().batchHisVersionChange(hisVersionParamListBo);
    }

    public static List<HisVersionParamBo> constructOrgBasicInfoHisParam(DynamicObject[] dynArrays, List<DynamicObject> groupDynList, List<DynamicObject> companyDynList, List<DynamicObject> departmentDynList) {
        ArrayList<HisVersionParamBo> listHisVersionParamBo = new ArrayList<HisVersionParamBo>(16);
        logger.info(String.format(Locale.ROOT, "111111AdminOrgBasicInfoService.constructOrgBasicInfoHisParam() dynArrays size = %s", dynArrays.length));
        HisVersionParamBo adminOrgHisVersionParam = AdminOrgHisDynamicUtils.getInstance().getHisVersionParam(dynArrays, AdminOrgHisDynKey.ADMIN_ORG_KEY.getDynKey(), false);
        listHisVersionParamBo.add(adminOrgHisVersionParam);
        if (!CollectionUtils.isEmpty(groupDynList)) {
            HisVersionParamBo groupHisVersionParam = AdminOrgHisDynamicUtils.getInstance().getHisVersionParam(groupDynList.toArray(new DynamicObject[0]), AdminOrgHisDynKey.ADMIN_GROUP_KEY.getDynKey(), false);
            listHisVersionParamBo.add(groupHisVersionParam);
        }
        if (!CollectionUtils.isEmpty(companyDynList)) {
            HisVersionParamBo companyHisVersionParam = AdminOrgHisDynamicUtils.getInstance().getHisVersionParam(companyDynList.toArray(new DynamicObject[0]), AdminOrgHisDynKey.ADMIN_COMPANY_KEY.getDynKey(), false);
            listHisVersionParamBo.add(companyHisVersionParam);
        }
        if (!CollectionUtils.isEmpty(departmentDynList)) {
            HisVersionParamBo departmentHisVersionParam = AdminOrgHisDynamicUtils.getInstance().getHisVersionParam(departmentDynList.toArray(new DynamicObject[0]), AdminOrgHisDynKey.ADMIN_DEPARTMENT_KET.getDynKey(), false);
            listHisVersionParamBo.add(departmentHisVersionParam);
        }
        return listHisVersionParamBo;
    }

    @Override
    public HisResponse<BatchVersionChangeRespData> enable(Map<Long, Date> orgIdEnableDateMap, Long eventId) {
        return null;
    }

    @Override
    public HisResponse<BatchVersionChangeRespData> disable(Map<Long, Date> orgIdDisableDateMap, Long eventId) {
        return null;
    }

    public List<HisVersionParamBo> buildTempNewHisParam(DynamicObject[] dysArrays, Map<String, Map<Long, DynamicObject>> adminOrgInfoMap) {
        ArrayList newOrgDynList = Lists.newArrayListWithExpectedSize((int)16);
        ArrayList<DynamicObject> groupDynList = new ArrayList<DynamicObject>();
        ArrayList<DynamicObject> companyDynList = new ArrayList<DynamicObject>();
        ArrayList<DynamicObject> departmentDynList = new ArrayList<DynamicObject>();
        long[] ids = ORM.create().genLongIds("haos_adminorgdetail", dysArrays.length);
        String[] structNumbers = ORM.create().genStringIds("haos_adminorgdetail", dysArrays.length);
        for (int i = 0; i < dysArrays.length; ++i) {
            DynamicObject newDyn;
            String structNumber;
            DynamicObject dynamicObject = dysArrays[i];
            dynamicObject.set("enable", (Object)"1");
            String billEnable = dynamicObject.getString("billenable");
            if (billEnable != null) {
                dynamicObject.set("enable", (Object)billEnable);
            }
            dynamicObject.set("status", (Object)"C");
            dynamicObject.set("initstatus", (Object)"2");
            dynamicObject.set("bsled", (Object)AdminOrgHisDynamicUtils.getDefaultBsled());
            DynamicObject oldHisInfo = null;
            long adminOrgId = dynamicObject.getLong("id");
            if (adminOrgId == 0L) {
                adminOrgId = ids[i];
                dynamicObject.set("id", (Object)adminOrgId);
            }
            if (adminOrgInfoMap != null) {
                Map<Long, DynamicObject> hisInfoMap = adminOrgInfoMap.get("haos_adminorgdetail");
                oldHisInfo = hisInfoMap.get(adminOrgId);
            }
            if (oldHisInfo != null) {
                long boId = oldHisInfo.getLong("boid");
                structNumber = oldHisInfo.getString("structnumber");
                HRDynamicObjectUtils.copy((DynamicObject)dynamicObject, (DynamicObject)oldHisInfo);
                oldHisInfo.set("id", (Object)adminOrgId);
                oldHisInfo.set("boid", (Object)boId);
                dynamicObject.set("structnumber", (Object)structNumber);
                newDyn = oldHisInfo;
            } else {
                newDyn = dynamicObject;
                structNumber = structNumbers[i];
                String index = newDyn.getString("index");
                if (HRStringUtils.isEmpty((String)index)) {
                    index = AdminOrgHisServiceHelper.getCurOrgIndex(newDyn);
                    newDyn.set("index", (Object)index);
                }
            }
            newDyn.set("structnumber", (Object)structNumber);
            this.addGroupCompDepDynByOrgType(newDyn, groupDynList, companyDynList, departmentDynList, adminOrgInfoMap);
            newOrgDynList.add(newDyn);
        }
        return AdminOrgBasicInfoService.constructOrgBasicInfoHisParam(newOrgDynList.toArray(new DynamicObject[0]), groupDynList, companyDynList, departmentDynList);
    }

    public List<HisVersionParamBo> buildAddNewHisVersionParam(DynamicObject[] dysArrays) {
        ArrayList<DynamicObject> groupDynList = new ArrayList<DynamicObject>();
        ArrayList<DynamicObject> companyDynList = new ArrayList<DynamicObject>();
        ArrayList<DynamicObject> departmentDynList = new ArrayList<DynamicObject>();
        long[] ids = ORM.create().genLongIds("haos_adminorgdetail", dysArrays.length);
        String[] structNumbers = ORM.create().genStringIds("haos_adminorgdetail", dysArrays.length);
        for (int i = 0; i < dysArrays.length; ++i) {
            DynamicObject dynamicObject = dysArrays[i];
            long id = dynamicObject.getLong("id");
            if (id == 0L) {
                id = ids[i];
            }
            dynamicObject.set("id", (Object)id);
            dynamicObject.set("enable", (Object)"1");
            dynamicObject.set("status", (Object)"C");
            dynamicObject.set("bsled", (Object)AdminOrgHisDynamicUtils.getDefaultBsled());
            String structNumber = structNumbers[i];
            dynamicObject.set("structnumber", (Object)structNumber);
            String index = dynamicObject.getString("index");
            if (HRStringUtils.isEmpty((String)index)) {
                index = AdminOrgHisServiceHelper.getCurOrgIndex(dynamicObject);
                dynamicObject.set("index", (Object)index);
            }
            this.addGroupCompDepDynByOrgType(dynamicObject, groupDynList, companyDynList, departmentDynList, null);
        }
        logger.info(String.format(Locale.ROOT, "111111AdminOrgBasicInfoService.buildAddNewHisVersionParam() groupDynList size = %s", groupDynList.size()));
        logger.info(String.format(Locale.ROOT, "111111AdminOrgBasicInfoService.buildAddNewHisVersionParam() companyDynList size = %s", companyDynList.size()));
        logger.info(String.format(Locale.ROOT, "111111AdminOrgBasicInfoService.buildAddNewHisVersionParam() departmentDynList size = %s", departmentDynList.size()));
        return AdminOrgBasicInfoService.constructOrgBasicInfoHisParam(dysArrays, groupDynList, companyDynList, departmentDynList);
    }

    private void addGroupCompDepDynByOrgType(DynamicObject dynamicObject, List<DynamicObject> groupDynList, List<DynamicObject> companyDynList, List<DynamicObject> departmentDynList, Map<String, Map<Long, DynamicObject>> adminOrgInfoMap) {
        long adminOrgTypeId = dynamicObject.getLong("adminorgtype.adminorgtypestd.id");
        long byId = dynamicObject.getLong("id");
        logger.info(String.format("==addGroupCompDepDynByOrgType==dynamicObject:id:%s,name:%s,number:%s:type:%s", byId, dynamicObject.getString("name"), dynamicObject.getString("number"), adminOrgTypeId));
        switch (Objects.requireNonNull(AdminOrgType.getById((long)adminOrgTypeId))) {
            case GROUP: {
                DynamicObject groupDyn = AdminOrgHisServiceHelper.buildNewHisDynamicObject(dynamicObject, AdminOrgHisDynKey.ADMIN_GROUP_KEY.getDynKey(), adminOrgInfoMap);
                groupDynList.add(groupDyn);
                DynamicObject companyDyn = AdminOrgHisServiceHelper.buildNewHisDynamicObject(dynamicObject, AdminOrgHisDynKey.ADMIN_COMPANY_KEY.getDynKey(), adminOrgInfoMap);
                companyDynList.add(companyDyn);
                dynamicObject.set("belongcompany", (Object)dynamicObject.getLong("id"));
                dynamicObject.set("belongcompany_id", (Object)dynamicObject.getLong("id"));
                logger.info(String.format("==addGroupCompDepDynByOrgType==dynamicObject:id:%s,type:%s,belongcompany:%s", byId, adminOrgTypeId, dynamicObject.getLong("id")));
                break;
            }
            case COMPANY: {
                DynamicObject company = AdminOrgHisServiceHelper.buildNewHisDynamicObject(dynamicObject, AdminOrgHisDynKey.ADMIN_COMPANY_KEY.getDynKey(), adminOrgInfoMap);
                companyDynList.add(company);
                dynamicObject.set("belongcompany", (Object)dynamicObject.getLong("id"));
                dynamicObject.set("belongcompany_id", (Object)dynamicObject.getLong("id"));
                logger.info(String.format("==addGroupCompDepDynByOrgType==dynamicObject:id:%s,type:%s,belongcompany:%s", byId, adminOrgTypeId, dynamicObject.getLong("id")));
                break;
            }
            case DEPARTMENT: {
                DynamicObject departmentDyn = AdminOrgHisServiceHelper.buildNewHisDynamicObject(dynamicObject, AdminOrgHisDynKey.ADMIN_DEPARTMENT_KET.getDynKey(), adminOrgInfoMap);
                departmentDynList.add(departmentDyn);
                dynamicObject.set("belongdept", (Object)dynamicObject.getLong("id"));
                DynamicObject belongCompany = AdminOrgHisServiceHelper.getBelongCompany(dynamicObject);
                dynamicObject.set("belongcompany", (Object)belongCompany);
                logger.info(String.format("==addGroupCompDepDynByOrgType==dynamicObject:id:%s,type:%s,belongcompany:%s", byId, adminOrgTypeId, dynamicObject.get("belongcompany")));
                break;
            }
            case REGION: {
                DynamicObject bc = AdminOrgHisServiceHelper.getBelongCompany(dynamicObject);
                dynamicObject.set("belongcompany", (Object)bc);
                logger.info(String.format("==addGroupCompDepDynByOrgType==dynamicObject:id:%s,type:%s,belongcompany:%s", byId, adminOrgTypeId, dynamicObject.get("belongcompany")));
                break;
            }
        }
    }

    public Map<String, Map<Long, DynamicObject>> buildTempInfoMap(DynamicObject[] dysArrays) {
        Set<Long> adminOrgIds = Arrays.stream(dysArrays).map(dyn -> dyn.getLong("id")).collect(Collectors.toSet());
        HashMap tempInfoMap = Maps.newHashMapWithExpectedSize((int)16);
        tempInfoMap.put(AdminOrgHisDynKey.ADMIN_ORG_KEY.getDynKey(), this.buildAdminOrgInfoMap(adminOrgIds, AdminOrgHisDynKey.ADMIN_ORG_KEY.getDynKey(), "id", "id"));
        tempInfoMap.put(AdminOrgHisDynKey.ADMIN_GROUP_KEY.getDynKey(), this.buildAdminOrgInfoMap(adminOrgIds, AdminOrgHisDynKey.ADMIN_GROUP_KEY.getDynKey(), "adminorg", "adminorg.id"));
        tempInfoMap.put(AdminOrgHisDynKey.ADMIN_COMPANY_KEY.getDynKey(), this.buildAdminOrgInfoMap(adminOrgIds, AdminOrgHisDynKey.ADMIN_COMPANY_KEY.getDynKey(), "adminorg", "adminorg.id"));
        tempInfoMap.put(AdminOrgHisDynKey.ADMIN_DEPARTMENT_KET.getDynKey(), this.buildAdminOrgInfoMap(adminOrgIds, AdminOrgHisDynKey.ADMIN_DEPARTMENT_KET.getDynKey(), "adminorg", "adminorg.id"));
        tempInfoMap.put(AdminOrgHisDynKey.ADMIN_STRUCT_KEY.getDynKey(), this.buildAdminOrgInfoMap(adminOrgIds, AdminOrgHisDynKey.ADMIN_STRUCT_KEY.getDynKey(), "adminorg", "adminorg.id"));
        tempInfoMap.put(AdminOrgHisDynKey.ADMIN_SORT_KEY.getDynKey(), this.buildAdminOrgInfoMap(adminOrgIds, AdminOrgHisDynKey.ADMIN_SORT_KEY.getDynKey(), "adminorg", "adminorg.id"));
        return tempInfoMap;
    }

    private Map<Long, DynamicObject> buildAdminOrgInfoMap(Set<Long> adminOrgIds, String entityName, String propertyName, String keyName) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(entityName);
        QFilter idFilter = new QFilter(propertyName, "in", adminOrgIds);
        DynamicObject[] adminOrgInfoArr = serviceHelper.loadDynamicObjectArray(new QFilter[]{idFilter});
        return Arrays.stream(adminOrgInfoArr).collect(Collectors.toMap(dyn -> dyn.getLong(keyName), dyn -> dyn));
    }
}

