/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.business.service.adminorg;

import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.haos.business.service.adminorg.AdminOrgHisDynKey;
import kd.hr.haos.business.service.adminorg.IAdminOrgInitOpService;
import kd.hr.haos.business.service.adminorg.bean.OrgTeamBasicInfoBO;
import kd.hr.haos.business.service.adminorg.bean.TeamCoopRelBO;
import kd.hr.haos.business.service.orgteam.OrgTeamSynService;
import kd.hr.haos.business.service.performanceopt.impl.AdminOrgPerformanceOptimization0804DataHelper;
import kd.hr.haos.business.service.performanceopt.impl.OrgTeamPerformanceOptimization0804DataHelper;
import kd.hr.haos.business.servicehelper.AdminOrgInitServiceHelper;
import kd.hr.haos.business.servicehelper.model.upgrade.InitHisData;
import kd.hr.hbp.business.application.impl.newhismodel.HisModelController;
import kd.hr.hbp.business.domain.model.newhismodel.BatchVersionChangeRespData;
import kd.hr.hbp.business.domain.model.newhismodel.HisResponse;
import kd.hr.hbp.business.domain.model.newhismodel.HisVersionParamBo;
import kd.hr.hbp.business.domain.model.newhismodel.HisVersionParamListBo;
import kd.hr.hbp.common.util.HRStringUtils;

public class AdminOrgInitOpService
implements IAdminOrgInitOpService {
    private static final Log logger = LogFactory.getLog(AdminOrgInitOpService.class);
    private static AdminOrgInitOpService service = new AdminOrgInitOpService();

    private AdminOrgInitOpService() {
    }

    public static AdminOrgInitOpService getInstance() {
        return service;
    }

    public HisResponse<BatchVersionChangeRespData> saveNewWithInvalidHis(DynamicObject[] dysArrays, Long eventId, Long initbatch, InitHisData initHisData) {
        long startTime = System.currentTimeMillis();
        HisVersionParamListBo hisVersionParamListBo = new HisVersionParamListBo();
        HisVersionParamListBo invalidHisVersionParamListBo = new HisVersionParamListBo();
        hisVersionParamListBo.setAtomicTrans(false);
        invalidHisVersionParamListBo.setAtomicTrans(false);
        if (eventId != null && !eventId.equals(0L)) {
            hisVersionParamListBo.setEventId(eventId);
            invalidHisVersionParamListBo.setEventId(eventId);
        }
        List<HisVersionParamBo> listHisVersionParamBo = AdminOrgInitServiceHelper.buildAddNewHisVersionParamWithInvalidHis(dysArrays, initHisData);
        Map<Long, List<TeamCoopRelBO>> orgCoopRelBOMap = AdminOrgInitServiceHelper.getCurBatchOrgCoopRelBOMap(dysArrays);
        HisVersionParamBo teamCoopRelHisParam = AdminOrgInitServiceHelper.buildAddNewHisParam(orgCoopRelBOMap);
        if (!ObjectUtils.isEmpty((Object[])teamCoopRelHisParam.getHisDyns())) {
            listHisVersionParamBo.add(teamCoopRelHisParam);
        }
        hisVersionParamListBo.setListHisVersionParamBo(listHisVersionParamBo);
        listHisVersionParamBo.forEach(hisVersionParamBo -> {
            hisVersionParamBo.setNeedProcessAttachment(false);
            AdminOrgInitServiceHelper.setInitDefaultValue(hisVersionParamBo.getHisDyns(), initbatch);
        });
        List<HisVersionParamBo> invalidVersionBo = null;
        if (AdminOrgInitServiceHelper.INVALID_HIS_DATA.get() != null) {
            invalidVersionBo = AdminOrgInitServiceHelper.INVALID_HIS_DATA.get();
            invalidVersionBo.forEach(hisVersionParamBo -> {
                hisVersionParamBo.setNeedProcessAttachment(false);
                AdminOrgInitServiceHelper.setInitDefaultValue(hisVersionParamBo.getHisDyns(), initbatch);
            });
            AdminOrgInitServiceHelper.INVALID_HIS_DATA.remove();
        }
        long secondTimeMill = System.currentTimeMillis();
        logger.info(String.format(Locale.ROOT, "kd.hr.haos.business.service.adminorg.AdminOrgInitOpService.saveNew() construct hisVersionParam cost %s milliseconds", secondTimeMill - startTime));
        HisResponse versionChangeRespDataHisResponse = HisModelController.getInstance().batchHisVersionChange(hisVersionParamListBo);
        if (invalidVersionBo != null) {
            invalidHisVersionParamListBo.setListHisVersionParamBo(invalidVersionBo);
            HisModelController.getInstance().batchHisVersionChange(invalidHisVersionParamListBo);
        }
        logger.info(String.format(Locale.ROOT, "kd.hr.haos.business.service.adminorg.AdminOrgInitOpService.saveNew() call total cost  %s milliseconds", System.currentTimeMillis() - startTime));
        return versionChangeRespDataHisResponse;
    }

    @Override
    public HisResponse<BatchVersionChangeRespData> saveNew(DynamicObject[] dysArrays, Long eventId, Long initbatch) {
        long startTime = System.currentTimeMillis();
        HisVersionParamListBo hisVersionParamListBo = new HisVersionParamListBo();
        hisVersionParamListBo.setAtomicTrans(false);
        if (eventId != null && !eventId.equals(0L)) {
            hisVersionParamListBo.setEventId(eventId);
        }
        List<HisVersionParamBo> listHisVersionParamBo = AdminOrgInitServiceHelper.buildAddNewHisVersionParam(dysArrays);
        HisVersionParamBo orgStructHisParam = AdminOrgInitServiceHelper.buildAddNewHisParam(dysArrays);
        listHisVersionParamBo.add(orgStructHisParam);
        HisVersionParamBo orgSortCodeHisParam = AdminOrgInitServiceHelper.buildSortCodeAddNewHisParam(dysArrays);
        listHisVersionParamBo.add(orgSortCodeHisParam);
        Map<Long, List<TeamCoopRelBO>> orgCoopRelBOMap = AdminOrgInitServiceHelper.getCurBatchOrgCoopRelBOMap(dysArrays);
        HisVersionParamBo teamCoopRelHisParam = AdminOrgInitServiceHelper.buildAddNewHisParam(orgCoopRelBOMap);
        if (!ObjectUtils.isEmpty((Object[])teamCoopRelHisParam.getHisDyns())) {
            listHisVersionParamBo.add(teamCoopRelHisParam);
        }
        hisVersionParamListBo.setListHisVersionParamBo(listHisVersionParamBo);
        listHisVersionParamBo.forEach(hisVersionParamBo -> {
            hisVersionParamBo.setNeedProcessAttachment(false);
            AdminOrgInitServiceHelper.setInitDefaultValue(hisVersionParamBo.getHisDyns(), initbatch);
        });
        long secondTimeMill = System.currentTimeMillis();
        logger.info(String.format(Locale.ROOT, "kd.hr.haos.business.service.adminorg.AdminOrgInitOpService.saveNew() construct hisVersionParam cost %s milliseconds", secondTimeMill - startTime));
        HisResponse versionChangeRespDataHisResponse = HisModelController.getInstance().batchHisVersionChange(hisVersionParamListBo);
        logger.info(String.format(Locale.ROOT, "kd.hr.haos.business.service.adminorg.AdminOrgInitOpService.saveNew() call his change interface cost %s milliseconds", System.currentTimeMillis() - secondTimeMill));
        Optional<DynamicObject[]> orgStructDyn = listHisVersionParamBo.stream().filter(hisVersionParamBo -> HRStringUtils.equals((String)hisVersionParamBo.getEntityNumber(), (String)AdminOrgHisDynKey.ADMIN_STRUCT_KEY.getDynKey())).map(HisVersionParamBo::getHisDyns).findAny();
        OrgTeamBasicInfoBO orgTeamBasicInfoBO = new OrgTeamBasicInfoBO(1010L, 1010L, 1010L, 1010L, "adminorg.id", "parentorg");
        orgTeamBasicInfoBO.setPrefixId(1010L);
        listHisVersionParamBo.addAll(OrgTeamSynService.getInstance().addNewSync(dysArrays, orgStructDyn.get(), ((BatchVersionChangeRespData)versionChangeRespDataHisResponse.getData()).getEventId(), orgTeamBasicInfoBO));
        logger.info(String.format(Locale.ROOT, "kd.hr.haos.business.service.adminorg.AdminOrgInitOpService.saveNew() call total cost  %s milliseconds", System.currentTimeMillis() - startTime));
        this.performanceOptProcess(listHisVersionParamBo);
        return versionChangeRespDataHisResponse;
    }

    private Set<Long> filterSortCodeAdminOrgId(List<HisVersionParamBo> effectingVersionList) {
        return this.getAdminOrgIdSet(effectingVersionList, AdminOrgHisDynKey.ADMIN_SORT_KEY.getDynKey());
    }

    private Set<Long> filterStructAdminOrgId(List<HisVersionParamBo> effectingVersionList) {
        return this.getAdminOrgIdSet(effectingVersionList, AdminOrgHisDynKey.ADMIN_STRUCT_KEY.getDynKey());
    }

    private Set<Long> getAdminOrgIdSet(List<HisVersionParamBo> effectingVersionList, String entityNumber) {
        Optional<HisVersionParamBo> matchedHisVersionParamBoOpt = effectingVersionList.stream().filter(hisVersionParamBo -> entityNumber.equals(hisVersionParamBo.getEntityNumber())).findAny();
        return matchedHisVersionParamBoOpt.map(hisVersionParamBo -> Arrays.stream(hisVersionParamBo.getHisDyns()).map(struct -> struct.getLong("adminorg.id")).collect(Collectors.toSet())).orElse(null);
    }

    private void performanceOptProcess(List<HisVersionParamBo> effectingVersionList) {
        Set<Long> updateStructAdminOrgIdSet = this.filterStructAdminOrgId(effectingVersionList);
        Set<Long> updateSortCodeAdminOrgIdSet = this.filterSortCodeAdminOrgId(effectingVersionList);
        AdminOrgPerformanceOptimization0804DataHelper adminOrgPerformanceOptimization0804DataHelper = new AdminOrgPerformanceOptimization0804DataHelper();
        adminOrgPerformanceOptimization0804DataHelper.setUpdateStructAdminOrgIdSet(updateStructAdminOrgIdSet);
        adminOrgPerformanceOptimization0804DataHelper.setUpdateSortCodeAdminOrgIdSet(updateSortCodeAdminOrgIdSet);
        adminOrgPerformanceOptimization0804DataHelper.update();
        OrgTeamPerformanceOptimization0804DataHelper orgTeamPerformanceOptimization0804DataHelper = new OrgTeamPerformanceOptimization0804DataHelper();
        orgTeamPerformanceOptimization0804DataHelper.setUpdateStructAdminOrgIdSet(updateStructAdminOrgIdSet);
        orgTeamPerformanceOptimization0804DataHelper.setUpdateSortCodeAdminOrgIdSet(updateSortCodeAdminOrgIdSet);
        orgTeamPerformanceOptimization0804DataHelper.update();
    }
}

