/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.business.service.adminorg;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.extplugin.PluginProxy;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.org.model.OrgParam;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.hr.haos.business.domain.repository.adorg.BaseOrgRepository;
import kd.hr.haos.business.domain.repository.database.AdminOrgTypeRepository;
import kd.hr.haos.business.service.adminorg.AdminOrgHisDynKey;
import kd.hr.haos.common.constants.structproject.StructProjectConstants;
import kd.hr.haos.common.util.PlatformRootUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.sdk.hr.hrmp.haos.extpoint.AdminOrgUnitSynServiceExtModel;
import kd.sdk.hr.hrmp.haos.extpoint.IAdminOrgUnitSyncServiceExt;

public class AdminOrgUnitSyncService {
    private static final Log logger = LogFactory.getLog(AdminOrgUnitSyncService.class);
    private static final int ONE_BATCH_COUNT = 10;
    private static final int BATCH_ORG_SYNC_COUNT = 1000;
    protected static ThreadPool executorService = ThreadPools.newCachedThreadPool((String)"AdminOrgUnitSyncService-addOrg-Thread", (int)0, (int)10);
    private static final String ENABLE_NEW = "enable_new";
    private static final String ORG_DUTY = "01";
    private static final String ENABLE_UPDATE = "enable_update";
    private static final String ADD = "1";
    private static final String UPDATE = "2";
    private static final String FREEZE = "3";
    private static final String UNFREEZE = "4";
    private static volatile AdminOrgUnitSyncService orgUnitSyncService = null;

    private AdminOrgUnitSyncService() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static AdminOrgUnitSyncService getInstance() {
        if (orgUnitSyncService != null) return orgUnitSyncService;
        Class<AdminOrgUnitSyncService> clazz = AdminOrgUnitSyncService.class;
        synchronized (AdminOrgUnitSyncService.class) {
            if (orgUnitSyncService != null) return orgUnitSyncService;
            orgUnitSyncService = new AdminOrgUnitSyncService();
            // ** MonitorExit[var0] (shouldn't be in output)
            return orgUnitSyncService;
        }
    }

    private List<OrgParam> assembleOrgParamDisable(List<DynamicObject> orgDyList) {
        ArrayList<Long> syncOrgIdList = new ArrayList<Long>(orgDyList.size());
        orgDyList.forEach(dynamicObject -> syncOrgIdList.add(dynamicObject.getLong("id")));
        Map<Long, Long> orgIds = this.getBaseOrgIdMaps(syncOrgIdList, "disable");
        ArrayList<OrgParam> paramList = new ArrayList<OrgParam>(4);
        for (DynamicObject adminOrgDynObj : orgDyList) {
            long id = adminOrgDynObj.getLong("id");
            if (orgIds.get(id) != null) continue;
            if (logger.isInfoEnabled()) {
                logger.info("ID" + id);
            }
            if (id == PlatformRootUtils.getLongRootIdOfPlatform()) continue;
            paramList.add(AdminOrgUnitSyncService.assembleOrgParamByAdminOrg(adminOrgDynObj));
        }
        return paramList;
    }

    private List<OrgParam> assembleOrgParamNew(List<DynamicObject> orgDyList) {
        List<Long> orgIdList = orgDyList.stream().map(dynamicObject -> dynamicObject.getLong("id")).collect(Collectors.toList());
        Map<Long, Long> orgIds = this.getBaseOrgIdMaps(orgIdList, ENABLE_NEW);
        Map<Long, DynamicObject> orgDyMap = orgDyList.stream().collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy));
        DynamicObjectCollection levelArray = this.getLevelArray(orgIdList);
        ArrayList<OrgParam> paramList = new ArrayList<OrgParam>(orgDyList.size());
        Map<Long, Long> orgPatternMap = this.getOrgPatternMap(orgDyList);
        for (DynamicObject level : levelArray) {
            Long id = level.getLong("adminorg.id");
            DynamicObject dy2 = orgDyMap.get(id);
            if (dy2 == null) {
                logger.error("not find admin_struct, adminorgid" + id);
                continue;
            }
            if (orgIds.get(id) != null || id == PlatformRootUtils.getLongRootIdOfPlatform()) continue;
            OrgParam orgParam = AdminOrgUnitSyncService.assembleOrgAddParamByAdminOrg(dy2);
            this.setOrgPatternId(orgParam, orgPatternMap);
            paramList.add(orgParam);
        }
        return paramList;
    }

    private DynamicObjectCollection getLevelArray(List<Long> orgIdList) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(AdminOrgHisDynKey.ADMIN_STRUCT_KEY.getDynKey());
        QFilter filter = new QFilter("adminorg", "in", orgIdList).and("iscurrentversion", "=", (Object)ADD);
        return serviceHelper.queryOriginalCollection("adminorg.id", new QFilter[]{filter, (QFilter)StructProjectConstants.ORG_STRUCT_FILTER.get()}, "level asc");
    }

    private static OrgParam assembleOrgParamByAdminOrg(DynamicObject adminOrgDynObj) {
        DynamicObject parentOrgDynObj = (DynamicObject)adminOrgDynObj.get("parentorg");
        long parentId = parentOrgDynObj == null ? 0L : parentOrgDynObj.getLong("id");
        OrgParam orgParam = new OrgParam();
        long id = adminOrgDynObj.getLong("boid");
        orgParam.setId(id);
        orgParam.setCustomOrgId(id);
        orgParam.setName(adminOrgDynObj.getString("name"));
        orgParam.setNumber(adminOrgDynObj.getString("number"));
        orgParam.setParentId(parentId);
        orgParam.setDuty(ORG_DUTY);
        orgParam.setYzjSync(true);
        orgParam.setDescription(adminOrgDynObj.getString("description"));
        return orgParam;
    }

    private static OrgParam assembleOrgAddParamByAdminOrg(DynamicObject adminOrgDynObj) {
        DynamicObject parentOrgDynObj = (DynamicObject)adminOrgDynObj.get("parentorg");
        long parentId = parentOrgDynObj == null ? 0L : parentOrgDynObj.getLong("id");
        OrgParam orgParam = new OrgParam();
        long id = adminOrgDynObj.getLong("boid");
        orgParam.setCustomOrgId(id);
        orgParam.setName(adminOrgDynObj.getString("name"));
        orgParam.setNumber(adminOrgDynObj.getString("number"));
        orgParam.setParentId(parentId);
        orgParam.setDuty(ORG_DUTY);
        orgParam.setYzjSync(true);
        orgParam.setDescription(adminOrgDynObj.getString("description"));
        return orgParam;
    }

    private Map<Long, Long> getBaseOrgIdMaps(List<Long> adminOrgIds, String type) {
        QFilter[] filters;
        QFilter freezsFilters;
        HashMap<Long, Long> orgIds = new HashMap<Long, Long>();
        QFilter viewFilters = new QFilter("view.number", "=", (Object)ORG_DUTY);
        QFilter idFilters = new QFilter("org.id", "in", adminOrgIds);
        if (HRStringUtils.equals((String)type, (String)ENABLE_UPDATE)) {
            freezsFilters = new QFilter("isfreeze", "=", (Object)Boolean.FALSE);
            filters = new QFilter[]{idFilters, viewFilters, freezsFilters};
        } else if (HRStringUtils.equals((String)type, (String)"disable")) {
            freezsFilters = new QFilter("isfreeze", "=", (Object)Boolean.TRUE);
            filters = new QFilter[]{idFilters, viewFilters, freezsFilters};
        } else {
            filters = new QFilter[]{idFilters, viewFilters};
        }
        DynamicObjectCollection allBaseOrgColl = BaseOrgRepository.getInstance().getBaseOrgStructColl(filters);
        if (allBaseOrgColl != null && allBaseOrgColl.size() > 0) {
            for (DynamicObject baseOrg : allBaseOrgColl) {
                Long id = baseOrg.getLong("org.id");
                orgIds.put(id, id);
            }
        }
        return orgIds;
    }

    public void syncOrgUnit(DynamicObject[] adminOrgArrays) {
        if (ObjectUtils.isEmpty((Object[])adminOrgArrays)) {
            return;
        }
        logger.info("kd.hr.haos.business.service.adminorg.AdminOrgUnitSyncService.syncOrgUnit is start....");
        this.syncDisableBaseOrg(adminOrgArrays);
        this.syncAddBaseOrg(adminOrgArrays);
    }

    public void syncOrgAddDisableUnit(DynamicObject[] adminOrgArrays) {
        if (ObjectUtils.isEmpty((Object[])adminOrgArrays)) {
            return;
        }
        for (DynamicObject dynamicObject : adminOrgArrays) {
            dynamicObject.set("enable", (Object)ADD);
        }
        this.syncAddBaseOrg(adminOrgArrays);
        for (DynamicObject dynamicObject : adminOrgArrays) {
            dynamicObject.set("enable", (Object)"0");
        }
        this.syncDisableBaseOrg(adminOrgArrays);
    }

    public void syncOrgChangeDisableUnit(DynamicObject[] adminOrgArrays) {
        if (ObjectUtils.isEmpty((Object[])adminOrgArrays)) {
            return;
        }
        for (DynamicObject dynamicObject : adminOrgArrays) {
            dynamicObject.set("enable", (Object)ADD);
        }
        this.syncOrgChgUnit(adminOrgArrays);
        for (DynamicObject dynamicObject : adminOrgArrays) {
            dynamicObject.set("enable", (Object)"0");
        }
        this.syncDisableBaseOrg(adminOrgArrays);
    }

    public void syncOrgChangeEnableUnit(DynamicObject[] adminOrgArrays) {
        if (ObjectUtils.isEmpty((Object[])adminOrgArrays)) {
            return;
        }
        for (DynamicObject dynamicObject : adminOrgArrays) {
            dynamicObject.set("enable", (Object)ADD);
        }
        this.syncOrgChgUnit(adminOrgArrays);
        this.syncEnableBaseOrg(adminOrgArrays);
    }

    public void syncOrgChgUnit(DynamicObject[] adminOrgArrays) {
        if (ObjectUtils.isEmpty((Object[])adminOrgArrays)) {
            return;
        }
        Map<Long, Long> orgPatternMap = this.getOrgPatternMap(Lists.newArrayList((Object[])adminOrgArrays));
        ArrayList<OrgParam> paramList = new ArrayList<OrgParam>(adminOrgArrays.length);
        for (DynamicObject adminOrgDynObj : adminOrgArrays) {
            OrgParam orgParam = AdminOrgUnitSyncService.assembleOrgParamByAdminOrg(adminOrgDynObj);
            this.setOrgPatternId(orgParam, orgPatternMap);
            paramList.add(orgParam);
        }
        this.afterCreateOrgParamExtend(paramList, Arrays.asList(adminOrgArrays));
        Long userId = RequestContext.get().getCurrUserId();
        this.recordSyncOrgInfo(paramList, UPDATE, userId);
        this.orgUnitUpdate(paramList);
        this.handleFailSynOrgParamList(paramList, UPDATE, userId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void orgUnitUpdate(List<OrgParam> paramList) {
        TXHandle txHandle = TX.requiresNew();
        long start = System.currentTimeMillis();
        try {
            OrgUnitServiceHelper.update(paramList);
        }
        catch (Exception e) {
            logger.error("OrgUnitServiceHelper.update Exception ", (Throwable)e);
            txHandle.markRollback();
        }
        finally {
            txHandle.close();
            long end = System.currentTimeMillis();
            String logInfo = "OrgUnitServiceHelper.update is end. cast=" + (end - start) + "ms; paramList size:" + paramList.size();
            logger.info(logInfo);
        }
    }

    private void syncDisableBaseOrg(DynamicObject[] adminOrgArrays) {
        List<DynamicObject> disableDyList = Stream.of(adminOrgArrays).filter(dynamicObject -> "0".equals(dynamicObject.getString("enable"))).collect(Collectors.toList());
        if (ObjectUtils.isEmpty(disableDyList)) {
            return;
        }
        List<OrgParam> duplicateOrgParamList = this.assembleOrgParamDisable(disableDyList);
        Long userId = RequestContext.get().getCurrUserId();
        this.recordSyncOrgInfo(duplicateOrgParamList, FREEZE, userId);
        this.orgUnitFreeze(duplicateOrgParamList);
        this.handleFailSynOrgParamList(duplicateOrgParamList, FREEZE, userId);
    }

    public void syncEnableBaseOrg(DynamicObject[] adminOrgArrays) {
        if (ObjectUtils.isEmpty((Object[])adminOrgArrays)) {
            return;
        }
        List<OrgParam> paramList = Stream.of(adminOrgArrays).map(AdminOrgUnitSyncService::assembleOrgParamByAdminOrg).collect(Collectors.toList());
        Long userId = RequestContext.get().getCurrUserId();
        this.recordSyncOrgInfo(paramList, UNFREEZE, userId);
        this.orgUnitUnFreeze(paramList);
        this.handleFailSynOrgParamList(paramList, UNFREEZE, userId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void orgUnitFreeze(List<OrgParam> paramList) {
        TXHandle txHandle = TX.requiresNew();
        long start = System.currentTimeMillis();
        try {
            OrgUnitServiceHelper.freeze(paramList);
        }
        catch (Exception e) {
            logger.error("OrgUnitServiceHelper.freeze Exception ", (Throwable)e);
            txHandle.markRollback();
        }
        finally {
            txHandle.close();
            long end = System.currentTimeMillis();
            String logInfo = "OrgUnitServiceHelper.freeze is end. cast=" + (end - start) + "ms; paramList size:" + paramList.size();
            logger.info(logInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void orgUnitUnFreeze(List<OrgParam> paramList) {
        TXHandle txHandle = TX.requiresNew();
        long start = System.currentTimeMillis();
        try {
            OrgUnitServiceHelper.unFreeze(paramList);
        }
        catch (Exception e) {
            logger.error("OrgUnitServiceHelper.unFreeze Exception ", (Throwable)e);
            txHandle.markRollback();
        }
        finally {
            txHandle.close();
            long end = System.currentTimeMillis();
            String logInfo = "OrgUnitServiceHelper.unFreeze is end. cast=" + (end - start) + "ms; paramList size:" + paramList.size();
            logger.info(logInfo);
        }
    }

    private void syncAddBaseOrg(DynamicObject[] adminOrgArrays) {
        List<DynamicObject> enableDynList = Stream.of(adminOrgArrays).filter(dynamicObject -> ADD.equals(dynamicObject.getString("enable"))).collect(Collectors.toList());
        if (ObjectUtils.isEmpty(enableDynList)) {
            return;
        }
        List<OrgParam> enableOrgParamList = this.assembleOrgParamNew(enableDynList);
        this.afterCreateOrgParamExtend(enableOrgParamList, Arrays.asList(adminOrgArrays));
        Long userId = RequestContext.get().getCurrUserId();
        this.recordSyncOrgInfo(enableOrgParamList, ADD, userId);
        this.orgUnitAdd(enableOrgParamList);
        this.handleFailSynOrgParamList(enableOrgParamList, ADD, userId);
    }

    public void syncAddBaseOrgMultiThread(DynamicObject[] adminOrgArrays) {
        HashMap orgIdOrgMap = new HashMap();
        List<DynamicObject> enableDynList = Stream.of(adminOrgArrays).filter(dynamicObject -> ADD.equals(dynamicObject.getString("enable"))).collect(Collectors.toList());
        if (ObjectUtils.isEmpty(enableDynList)) {
            return;
        }
        Map<Long, Long> orgPatternMap = this.getOrgPatternMap(enableDynList);
        enableDynList.forEach(dy -> orgIdOrgMap.put(dy.getLong("id"), dy));
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(AdminOrgHisDynKey.ADMIN_STRUCT_KEY.getDynKey());
        QFilter filter = new QFilter("adminorg", "in", orgIdOrgMap.keySet()).and("iscurrentversion", "=", (Object)ADD).and((QFilter)StructProjectConstants.ORG_STRUCT_FILTER.get()).and("enable", "=", (Object)ADD);
        DynamicObjectCollection dynamicObjectCollection = serviceHelper.queryOriginalCollection("adminorg.id,level", new QFilter[]{filter}, "level asc");
        TreeMap<Long, Set> levelOrgIdsMap = new TreeMap<Long, Set>();
        dynamicObjectCollection.forEach(dy -> {
            long level = dy.getLong("level");
            Set orgIds = levelOrgIdsMap.getOrDefault(level, new TreeSet());
            orgIds.add(dy.getLong("adminorg.id"));
            levelOrgIdsMap.put(level, orgIds);
        });
        levelOrgIdsMap.forEach((level, orgIds) -> this.syncOrgAndRecordSyncOrgInfo2(orgIdOrgMap, (Set<Long>)orgIds, orgPatternMap));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void syncOrgAndRecordSyncOrgInfo2(Map<Long, DynamicObject> orgIdOrgMap, Set<Long> orgIds, Map<Long, Long> orgPatternMap) {
        ArrayBlockingQueue<SynOrgsTask> queue = new ArrayBlockingQueue<SynOrgsTask>(orgIds.size());
        ArrayList<Object> orgParams = new ArrayList<OrgParam>(1000);
        for (Long orgId : orgIds) {
            DynamicObject org = orgIdOrgMap.get(orgId);
            if (org == null) continue;
            OrgParam orgParam = AdminOrgUnitSyncService.assembleOrgAddParamByAdminOrg(org);
            this.setOrgPatternId(orgParam, orgPatternMap);
            orgParams.add(orgParam);
            if (orgParams.size() != 1000) continue;
            if (!queue.offer(new SynOrgsTask(orgParams))) {
                logger.info("queue offer SynOrgsTask failed orgParams.size {}", (Object)orgParams.size());
            }
            orgParams = new ArrayList(1000);
        }
        this.afterCreateOrgParamExtend(orgParams, new ArrayList<DynamicObject>(orgIdOrgMap.values()));
        if (!orgParams.isEmpty() && !queue.offer(new SynOrgsTask(orgParams))) {
            logger.info("queue offer SynOrgsTask failed orgParams.size {}", (Object)orgParams.size());
        }
        logger.info("kd.hr.haos.business.service.adminorg.AdminOrgUnitSyncService.syncOrgAndRecordSyncOrgInfo2.queue.size{}  ", (Object)queue.size());
        ArrayList<OrgParam> result = new ArrayList<OrgParam>();
        long start = System.currentTimeMillis();
        ArrayList<Future> futures = new ArrayList<Future>();
        try {
            int count = Math.min(queue.size(), 10);
            for (int i = 0; i < count; ++i) {
                futures.add(executorService.submit((Callable)new SynOrgTasksBigTask(queue)));
            }
            for (Future future : futures) {
                result.addAll((Collection)future.get());
            }
            Long userId = RequestContext.get().getCurrUserId();
            this.recordSyncOrgInfo(result, ADD, userId);
            this.handleFailSynOrgParamList(result, ADD, userId);
        }
        catch (Exception e) {
            logger.error("OrgUnitServiceHelper.add syncAddBaseOrgMultiThread Exception ", (Throwable)e);
        }
        finally {
            long end = System.currentTimeMillis();
            String logInfo = "OrgUnitServiceHelper.add syncAddBaseOrgMultiThread is end. cast=" + (end - start) + "ms; paramList size:" + orgIds.size();
            logger.info(logInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void syncUpdateRootOrg(DynamicObject rootOrg) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("bos_adminorg");
        DynamicObject bosRootOrg = serviceHelper.queryOne((Object)PlatformRootUtils.getLongRootIdOfPlatform());
        if (bosRootOrg != null) {
            OrgParam rootOrgParam = new OrgParam();
            rootOrgParam.setId(PlatformRootUtils.getLongRootIdOfPlatform());
            rootOrgParam.setCustomOrgId(PlatformRootUtils.getLongRootIdOfPlatform());
            rootOrgParam.setName(rootOrg.getString("name"));
            rootOrgParam.setNumber(bosRootOrg.getString("number"));
            rootOrgParam.setParentId(0L);
            rootOrgParam.setDuty(ORG_DUTY);
            rootOrgParam.setYzjSync(true);
            rootOrgParam.setDescription(rootOrg.getString("description"));
            Long userId = RequestContext.get().getCurrUserId();
            ArrayList<OrgParam> rootOrgParams = new ArrayList<OrgParam>();
            rootOrgParams.add(rootOrgParam);
            this.afterCreateOrgParamExtend4RootInit(Collections.singletonList(rootOrgParam), Collections.singletonList(rootOrg));
            this.recordSyncOrgInfo(rootOrgParams, UPDATE, userId);
            TXHandle txHandle = TX.requiresNew();
            long start = System.currentTimeMillis();
            try {
                OrgUnitServiceHelper.update((OrgParam)rootOrgParam);
            }
            catch (Exception e) {
                logger.error("OrgUnitServiceHelper.syncUpdateRootOrg Exception ", (Throwable)e);
                txHandle.markRollback();
            }
            finally {
                txHandle.close();
                long end = System.currentTimeMillis();
                String logInfo = "OrgUnitServiceHelper.add is end. cast=" + (end - start) + "ms";
                logger.info(logInfo);
            }
            this.handleFailSynOrgParamList(rootOrgParams, UPDATE, userId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void orgUnitAdd(List<OrgParam> paramList) {
        TXHandle txHandle = TX.requiresNew();
        long start = System.currentTimeMillis();
        try {
            OrgUnitServiceHelper.add(paramList);
        }
        catch (Exception e) {
            logger.error("OrgUnitServiceHelper.add Exception ", (Throwable)e);
            txHandle.markRollback();
        }
        finally {
            txHandle.close();
            long end = System.currentTimeMillis();
            String logInfo = "OrgUnitServiceHelper.add is end. cast=" + (end - start) + "ms; paramList size:" + paramList.size();
            logger.info(logInfo);
        }
    }

    private void recordSyncOrgInfo(List<OrgParam> orgParamList, String syncType, Long userId) {
        HRBaseServiceHelper logHelper = new HRBaseServiceHelper("haos_syncorglog");
        ArrayList logList = Lists.newArrayListWithCapacity((int)orgParamList.size());
        Date nowDate = new Date();
        for (OrgParam orgParam : orgParamList) {
            DynamicObject dy = logHelper.generateEmptyDynamicObject();
            this.setSyncCommonField(syncType, userId, nowDate, orgParam, dy);
            logList.add(dy);
        }
        if (ObjectUtils.isEmpty((Object)logList)) {
            return;
        }
        logHelper.save(logList.toArray(new DynamicObject[0]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleFailSynOrgParamList(List<OrgParam> orgParamList, String syncType, Long userId) {
        try (TXHandle txHandle = TX.requiresNew();){
            this.recordSyncOrgFailInfo(orgParamList, syncType, userId);
        }
    }

    private void recordSyncOrgFailInfo(List<OrgParam> orgParamList, String syncType, Long userId) {
        if (ObjectUtils.isEmpty(orgParamList)) {
            return;
        }
        HRBaseServiceHelper logHelper = new HRBaseServiceHelper("haos_syncorgfaillog");
        ArrayList failDynList = Lists.newArrayListWithCapacity((int)orgParamList.size());
        Date nowDate = new Date();
        for (OrgParam orgParam : orgParamList) {
            if (orgParam.isSuccess()) continue;
            DynamicObject dy = logHelper.generateEmptyDynamicObject();
            this.setSyncCommonField(syncType, userId, nowDate, orgParam, dy);
            dy.set("syncstatus", (Object)"N");
            dy.set("retrycount", (Object)0);
            dy.set("errormsg", (Object)orgParam.getMsg());
            failDynList.add(dy);
        }
        if (ObjectUtils.isEmpty((Object)failDynList)) {
            return;
        }
        logHelper.save(failDynList.toArray(new DynamicObject[0]));
    }

    private void setSyncCommonField(String syncType, Long userId, Date nowDate, OrgParam orgParam, DynamicObject logDy) {
        logDy.set("createtime", (Object)nowDate);
        logDy.set("modifytime", (Object)nowDate);
        logDy.set("creator", (Object)userId);
        logDy.set("modifier", (Object)userId);
        logDy.set("adminorg", (Object)orgParam.getId());
        logDy.set("synctype", (Object)syncType);
        logDy.set("executebody", (Object)SerializationUtils.toJsonString((Object)orgParam));
    }

    private Map<Long, Long> getOrgPatternMap(List<DynamicObject> dyList) {
        Set<Long> orgTypeIdSet = dyList.stream().map(dy -> dy.getLong("adminorgtype.id")).collect(Collectors.toSet());
        DynamicObjectCollection orgTypeCol = AdminOrgTypeRepository.getInstance().queryColByIds("id,orgpattern", orgTypeIdSet);
        Map<Long, Long> typeMap = orgTypeCol.stream().collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy.getLong("orgpattern")));
        return dyList.stream().collect(Collectors.toMap(dy -> dy.getLong("boid"), dy -> (Long)typeMap.get(dy.getLong("adminorgtype.id"))));
    }

    private void setOrgPatternId(OrgParam orgParam, Map<Long, Long> orgPatternMap) {
        Long orgPatternId = orgPatternMap.get(orgParam.getCustomOrgId());
        if (orgPatternId != null && orgPatternId != 0L) {
            orgParam.setOrgPatternId(orgPatternId.longValue());
        }
    }

    private void afterCreateOrgParamExtend(List<OrgParam> orgParamList, List<DynamicObject> adminOrgList) {
        this.afterCreateOrgParamExtend(orgParamList, adminOrgList, false);
    }

    private void afterCreateOrgParamExtend4RootInit(List<OrgParam> orgParamList, List<DynamicObject> adminOrgList) {
        this.afterCreateOrgParamExtend(orgParamList, adminOrgList, true);
    }

    private void afterCreateOrgParamExtend(List<OrgParam> orgParamList, List<DynamicObject> adminOrgList, boolean rootInit) {
        PluginProxy iAdminOrgUnitSyncServiceExt = PluginProxy.create((Object)this.getDefaultAdminOrgUnitSyncServiceExt(), IAdminOrgUnitSyncServiceExt.class, (String)"kd.sdk.odc.haos.service.IAdminOrgUnitSyncServiceExt");
        boolean hasExtendPlugins = iAdminOrgUnitSyncServiceExt.getPlugins().size() != 0;
        AdminOrgUnitSynServiceExtModel model = new AdminOrgUnitSynServiceExtModel();
        model.setAdminOrgList(adminOrgList);
        model.setOrgParamList(orgParamList);
        model.setInitUpdateRoot(rootInit);
        if (hasExtendPlugins) {
            iAdminOrgUnitSyncServiceExt.callReplace(plugin -> {
                logger.info(String.format("proxy plugin: %s", plugin.getClass()));
                logger.info("before callReplace afterCreateOrgParam");
                plugin.afterCreateOrgParam(model);
                logger.info("after callReplace afterCreateOrgParam");
                return null;
            });
        }
    }

    private IAdminOrgUnitSyncServiceExt getDefaultAdminOrgUnitSyncServiceExt() {
        return new IAdminOrgUnitSyncServiceExt(){};
    }

    public static class SynOrgsTask
    implements Callable<List<OrgParam>> {
        private List<OrgParam> orgParams;

        public SynOrgsTask(List<OrgParam> orgParams) {
            this.orgParams = orgParams;
        }

        @Override
        public List<OrgParam> call() throws Exception {
            logger.info("OrgUnitServiceHelper.addOrUpdate(orgParams) begin");
            OrgUnitServiceHelper.addOrUpdate(this.orgParams);
            logger.info("OrgUnitServiceHelper.addOrUpdate(orgParams) end");
            return this.orgParams;
        }
    }

    public static class SynOrgTask
    implements Callable<OrgParam> {
        private OrgParam orgParam;

        public SynOrgTask(OrgParam orgParam) {
            this.orgParam = orgParam;
        }

        @Override
        public OrgParam call() throws Exception {
            OrgUnitServiceHelper.add((OrgParam)this.orgParam);
            return this.orgParam;
        }
    }

    public static class SynOrgTasksBigTask
    implements Callable<List<OrgParam>> {
        private BlockingQueue<SynOrgsTask> blockingDeque;

        public SynOrgTasksBigTask(BlockingQueue<SynOrgsTask> blockingDeque) {
            this.blockingDeque = blockingDeque;
        }

        @Override
        public List<OrgParam> call() throws Exception {
            ArrayList result = Lists.newArrayListWithExpectedSize((int)this.blockingDeque.size());
            while (!this.blockingDeque.isEmpty()) {
                logger.info("kd.hr.haos.business.service.adminorg.AdminOrgUnitSyncService.SynOrgTaskBigTask{} ", (Object)Thread.currentThread().getName());
                SynOrgsTask take = this.blockingDeque.poll(100L, TimeUnit.MILLISECONDS);
                if (take == null) continue;
                result.addAll(take.call());
            }
            logger.info("kd.hr.haos.business.service.adminorg.AdminOrgUnitSyncService.SynOrgTaskBigTask.size{}  ", (Object)result.size());
            return result;
        }
    }

    public static class SynOrgTaskBigTask
    implements Callable<List<OrgParam>> {
        private BlockingQueue<SynOrgTask> blockingDeque;

        public SynOrgTaskBigTask(BlockingQueue<SynOrgTask> blockingDeque) {
            this.blockingDeque = blockingDeque;
        }

        @Override
        public List<OrgParam> call() throws Exception {
            ArrayList result = Lists.newArrayListWithExpectedSize((int)this.blockingDeque.size());
            while (!this.blockingDeque.isEmpty()) {
                logger.info("kd.hr.haos.business.service.adminorg.AdminOrgUnitSyncService.SynOrgTaskBigTask{} ", (Object)Thread.currentThread().getName());
                SynOrgTask take = this.blockingDeque.poll(100L, TimeUnit.MILLISECONDS);
                if (take == null) continue;
                result.add(take.call());
            }
            logger.info("kd.hr.haos.business.service.adminorg.AdminOrgUnitSyncService.SynOrgTaskBigTask.size{}  ", (Object)result.size());
            return result;
        }
    }
}

