/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.business.service.adminorg.fourlayermodel;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.hr.haos.business.service.adminorg.AdminOrgHisDynKey;
import kd.hr.haos.business.service.adminorg.AdminOrgHisServiceHelper;
import kd.hr.haos.business.service.adminorg.bean.Pair;
import kd.hr.haos.business.service.adminorg.fourlayermodel.Expression;
import kd.hr.haos.business.service.adminorg.fourlayermodel.OrgInfoExpression;
import kd.hr.haos.business.service.adminorg.fourlayermodel.Rule;
import kd.hr.haos.common.constants.masterdata.AdminOrgType;
import kd.hr.haos.common.util.HRDyObjectUtils;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;

public class OrgTypeChangeOnly4BatchChang {
    private static final Log LOGGER = LogFactory.getLog(OrgTypeChangeOnly4BatchChang.class);
    private static final List<String> GROUP_PROPS = Arrays.asList("groupvision", "groupmission");
    private static final List<String> COMPANY_PROPS = Arrays.asList("companyname", "companytype", "industrytype");
    private static final List<String> DEPARTMENT_PROPS = Collections.singletonList("departmenttype");

    private static void invalidEntity(DynamicObject entity, DynamicObject curOrgDyn, String entityName, Map<String, DynamicObject> map, List<String> setNullProps) {
        DynamicObject dynamicObject = AdminOrgHisServiceHelper.enableOrDisableEntity(entity, entityName, "0", curOrgDyn.getDate("bsed"));
        setNullProps.forEach(prop -> {
            if (HRStringUtils.equals((String)"companyname", (String)prop)) {
                dynamicObject.set(prop, curOrgDyn.get("name"));
            } else {
                dynamicObject.set(prop, curOrgDyn.get(prop));
            }
        });
        map.put(entityName, dynamicObject);
    }

    private static DynamicObject genNewOrModifyDyn(DynamicObject curOrg, String entityName, DynamicObject oldEntity, List<String> fieldNames) {
        DynamicObject dynamicObject;
        if (Objects.nonNull(oldEntity)) {
            dynamicObject = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)entityName));
            HRDynamicObjectUtils.copy((DynamicObject)oldEntity, (DynamicObject)dynamicObject);
            for (String fieldName : fieldNames) {
                if (HRStringUtils.equals((String)fieldName, (String)"companyname")) {
                    dynamicObject.set("companyname", curOrg.get("name"));
                    continue;
                }
                dynamicObject.set(fieldName, curOrg.get(fieldName));
            }
            dynamicObject.set("bsed", (Object)curOrg.getDate("bsed"));
            dynamicObject.set("enable", (Object)curOrg.getString("enable"));
        } else {
            dynamicObject = AdminOrgHisServiceHelper.buildNewHisDynamicObject(curOrg, entityName);
        }
        return dynamicObject;
    }

    private static void addNewCompanyHisVersion(DynamicObject curOrg, Map<String, DynamicObject> map, DynamicObject oldCompanyDyn) {
        if (!(HRDyObjectUtils.compareDyValue((DynamicObject)curOrg, (DynamicObject)oldCompanyDyn, Arrays.asList("companytype", "industrytype")) && HRStringUtils.equals((String)curOrg.getString("name"), (String)oldCompanyDyn.getString("companyname")) && HRStringUtils.equals((String)curOrg.getString("enable"), (String)oldCompanyDyn.getString("enable")))) {
            DynamicObject newCompanyVersion = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)AdminOrgHisDynKey.ADMIN_COMPANY_KEY.getDynKey()));
            HRDynamicObjectUtils.copy((DynamicObject)oldCompanyDyn, (DynamicObject)newCompanyVersion);
            newCompanyVersion.set("companytype", (Object)curOrg.getDynamicObject("companytype"));
            newCompanyVersion.set("industrytype", (Object)curOrg.getDynamicObject("industrytype"));
            newCompanyVersion.set("companyname", (Object)curOrg.getString("name"));
            newCompanyVersion.set("bsed", (Object)curOrg.getDate("bsed"));
            newCompanyVersion.set("enable", (Object)curOrg.getString("enable"));
            map.put(AdminOrgHisDynKey.ADMIN_COMPANY_KEY.getDynKey(), newCompanyVersion);
        }
    }

    public static class RuleEngine {
        private static List<Rule<Map<String, DynamicObject>>> rules = new ArrayList<Rule<Map<String, DynamicObject>>>();

        public static Map<String, DynamicObject> process(Expression expression) {
            return (Map)rules.stream().filter(r -> r.evaluate(expression)).findFirst().orElseGet(() -> new DefaultRule()).execute(expression);
        }

        public static List<Rule<Map<String, DynamicObject>>> getRules() {
            return rules;
        }

        public static void setRules(List<Rule<Map<String, DynamicObject>>> rules) {
            RuleEngine.rules = rules;
        }

        public static void addRule(Rule<Map<String, DynamicObject>> rule) {
            rules.add(rule);
        }

        static {
            rules.add(new Group2CompRule());
            rules.add(new Group2RegionRule());
            rules.add(new Group2DepartmentRule());
            rules.add(new Company2DepartmentRule());
            rules.add(new Company2GroupRule());
            rules.add(new Company2RegionRule());
            rules.add(new Department2CompanyRule());
            rules.add(new Department2GroupRule());
            rules.add(new Department2RegionRule());
            rules.add(new OrgTypeNotChangeRule());
            rules.add(new RegionChangeToOtherRule());
        }
    }

    private static class DefaultRule
    implements Rule<Map<String, DynamicObject>> {
        private DefaultRule() {
        }

        @Override
        public boolean evaluate(Expression expression) {
            return false;
        }

        @Override
        public Map<String, DynamicObject> execute(Expression expression) {
            return new HashMap<String, DynamicObject>();
        }
    }

    private static abstract class OrgTypeChangeRule
    implements Rule<Map<String, DynamicObject>> {
        private OrgTypeChangeRule() {
        }

        @Override
        public Map<String, DynamicObject> execute(Expression expression) {
            OrgInfoExpression orgInfoExpression = (OrgInfoExpression)expression;
            Pair<AdminOrgType, AdminOrgType> typePair = orgInfoExpression.getTypePair();
            DynamicObject curOrg = orgInfoExpression.getCurOrg();
            long curOrgId = curOrg.getLong("id");
            HashMap<String, DynamicObject> map = new HashMap<String, DynamicObject>();
            this.doExecute(orgInfoExpression, typePair, curOrg, curOrgId, map);
            return map;
        }

        protected abstract void doExecute(OrgInfoExpression var1, Pair<AdminOrgType, AdminOrgType> var2, DynamicObject var3, long var4, Map<String, DynamicObject> var6);
    }

    private static class RegionChangeToOtherRule
    extends OrgTypeChangeRule {
        private RegionChangeToOtherRule() {
        }

        @Override
        public boolean evaluate(Expression expression) {
            OrgInfoExpression orgInfoExpression = (OrgInfoExpression)expression;
            Pair<AdminOrgType, AdminOrgType> typePair = orgInfoExpression.getTypePair();
            return typePair.getKey() == AdminOrgType.REGION && typePair.getKey() != typePair.getValue();
        }

        @Override
        protected void doExecute(OrgInfoExpression orgInfoExpression, Pair<AdminOrgType, AdminOrgType> typePair, DynamicObject curOrg, long curOrgId, Map<String, DynamicObject> map) {
            switch (typePair.getValue()) {
                case GROUP: {
                    DynamicObject oldOrgGroup = orgInfoExpression.getGroupInfoMap().get(curOrgId);
                    map.put(AdminOrgHisDynKey.ADMIN_GROUP_KEY.getDynKey(), OrgTypeChangeOnly4BatchChang.genNewOrModifyDyn(curOrg, AdminOrgHisDynKey.ADMIN_GROUP_KEY.getDynKey(), oldOrgGroup, GROUP_PROPS));
                    DynamicObject oldCompany = orgInfoExpression.getCompanyInfoMap().get(curOrgId);
                    map.put(AdminOrgHisDynKey.ADMIN_COMPANY_KEY.getDynKey(), OrgTypeChangeOnly4BatchChang.genNewOrModifyDyn(curOrg, AdminOrgHisDynKey.ADMIN_COMPANY_KEY.getDynKey(), oldCompany, COMPANY_PROPS));
                    break;
                }
                case COMPANY: {
                    DynamicObject oldOrgCompany = orgInfoExpression.getCompanyInfoMap().get(curOrgId);
                    map.put(AdminOrgHisDynKey.ADMIN_COMPANY_KEY.getDynKey(), OrgTypeChangeOnly4BatchChang.genNewOrModifyDyn(curOrg, AdminOrgHisDynKey.ADMIN_COMPANY_KEY.getDynKey(), oldOrgCompany, COMPANY_PROPS));
                    break;
                }
                case DEPARTMENT: {
                    DynamicObject oldOrgDepartment = orgInfoExpression.getDepartmentInfoMap().get(curOrgId);
                    map.put(AdminOrgHisDynKey.ADMIN_DEPARTMENT_KET.getDynKey(), OrgTypeChangeOnly4BatchChang.genNewOrModifyDyn(curOrg, AdminOrgHisDynKey.ADMIN_DEPARTMENT_KET.getDynKey(), oldOrgDepartment, DEPARTMENT_PROPS));
                    break;
                }
            }
        }
    }

    private static class OrgTypeNotChangeRule
    extends OrgTypeChangeRule {
        private OrgTypeNotChangeRule() {
        }

        @Override
        public boolean evaluate(Expression expression) {
            OrgInfoExpression orgInfoExpression = (OrgInfoExpression)expression;
            Pair<AdminOrgType, AdminOrgType> typePair = orgInfoExpression.getTypePair();
            return typePair.getKey() == typePair.getValue();
        }

        @Override
        protected void doExecute(OrgInfoExpression orgInfoExpression, Pair<AdminOrgType, AdminOrgType> typePair, DynamicObject curOrg, long curOrgId, Map<String, DynamicObject> map) {
            switch (typePair.getKey()) {
                case GROUP: {
                    DynamicObject oldOrgGroupInfo = orgInfoExpression.getGroupInfoMap().get(curOrgId);
                    if (!HRDyObjectUtils.compareDyValue((DynamicObject)curOrg, (DynamicObject)oldOrgGroupInfo, (Collection)GROUP_PROPS)) {
                        DynamicObject groupDyn = OrgTypeChangeOnly4BatchChang.genNewOrModifyDyn(curOrg, AdminOrgHisDynKey.ADMIN_GROUP_KEY.getDynKey(), oldOrgGroupInfo, GROUP_PROPS);
                        map.put(AdminOrgHisDynKey.ADMIN_GROUP_KEY.getDynKey(), groupDyn);
                    }
                    DynamicObject oldOrgCompany = orgInfoExpression.getCompanyInfoMap().get(curOrgId);
                    OrgTypeChangeOnly4BatchChang.addNewCompanyHisVersion(curOrg, map, oldOrgCompany);
                    break;
                }
                case COMPANY: {
                    DynamicObject oldOrgCompanyInfo = orgInfoExpression.getCompanyInfoMap().get(curOrgId);
                    OrgTypeChangeOnly4BatchChang.addNewCompanyHisVersion(curOrg, map, oldOrgCompanyInfo);
                    break;
                }
                case DEPARTMENT: {
                    DynamicObject oldOrgDepartmentInfo = orgInfoExpression.getDepartmentInfoMap().get(curOrgId);
                    LOGGER.info(String.format(Locale.ROOT, "OrgTypeNotChangeRule.doExecute() curOrg: %s, oldOrgDepartmentInfo: %s", curOrg, oldOrgDepartmentInfo));
                    if (curOrg.getLong("departmenttype.id") == oldOrgDepartmentInfo.getLong("departmenttype.id") && HRStringUtils.equals((String)curOrg.getString("enable"), (String)oldOrgDepartmentInfo.getString("enable"))) break;
                    DynamicObject departmentDyn = OrgTypeChangeOnly4BatchChang.genNewOrModifyDyn(curOrg, AdminOrgHisDynKey.ADMIN_DEPARTMENT_KET.getDynKey(), oldOrgDepartmentInfo, DEPARTMENT_PROPS);
                    map.put(AdminOrgHisDynKey.ADMIN_DEPARTMENT_KET.getDynKey(), departmentDyn);
                    break;
                }
                case REGION: {
                    break;
                }
            }
        }
    }

    private static class Department2RegionRule
    extends OrgTypeChangeRule {
        private Department2RegionRule() {
        }

        @Override
        public boolean evaluate(Expression expression) {
            OrgInfoExpression orgInfoExpression = (OrgInfoExpression)expression;
            Pair<AdminOrgType, AdminOrgType> typePair = orgInfoExpression.getTypePair();
            return typePair.getKey() == AdminOrgType.DEPARTMENT && typePair.getValue() == AdminOrgType.REGION;
        }

        @Override
        protected void doExecute(OrgInfoExpression orgInfoExpression, Pair<AdminOrgType, AdminOrgType> typePair, DynamicObject curOrg, long curOrgId, Map<String, DynamicObject> map) {
            OrgTypeChangeOnly4BatchChang.invalidEntity(orgInfoExpression.getDepartmentInfoMap().get(curOrgId), curOrg, AdminOrgHisDynKey.ADMIN_DEPARTMENT_KET.getDynKey(), map, DEPARTMENT_PROPS);
        }
    }

    private static class Department2CompanyRule
    extends OrgTypeChangeRule {
        private Department2CompanyRule() {
        }

        @Override
        public boolean evaluate(Expression expression) {
            OrgInfoExpression orgInfoExpression = (OrgInfoExpression)expression;
            Pair<AdminOrgType, AdminOrgType> typePair = orgInfoExpression.getTypePair();
            return typePair.getKey() == AdminOrgType.DEPARTMENT && typePair.getValue() == AdminOrgType.COMPANY;
        }

        @Override
        protected void doExecute(OrgInfoExpression orgInfoExpression, Pair<AdminOrgType, AdminOrgType> typePair, DynamicObject curOrg, long curOrgId, Map<String, DynamicObject> map) {
            OrgTypeChangeOnly4BatchChang.invalidEntity(orgInfoExpression.getDepartmentInfoMap().get(curOrgId), curOrg, AdminOrgHisDynKey.ADMIN_DEPARTMENT_KET.getDynKey(), map, DEPARTMENT_PROPS);
            DynamicObject oldOrgCompany = orgInfoExpression.getCompanyInfoMap().get(curOrgId);
            map.put(AdminOrgHisDynKey.ADMIN_COMPANY_KEY.getDynKey(), OrgTypeChangeOnly4BatchChang.genNewOrModifyDyn(curOrg, AdminOrgHisDynKey.ADMIN_COMPANY_KEY.getDynKey(), oldOrgCompany, COMPANY_PROPS));
        }
    }

    private static class Department2GroupRule
    extends OrgTypeChangeRule {
        private Department2GroupRule() {
        }

        @Override
        public boolean evaluate(Expression expression) {
            OrgInfoExpression orgInfoExpression = (OrgInfoExpression)expression;
            Pair<AdminOrgType, AdminOrgType> typePair = orgInfoExpression.getTypePair();
            return typePair.getKey() == AdminOrgType.DEPARTMENT && typePair.getValue() == AdminOrgType.GROUP;
        }

        @Override
        protected void doExecute(OrgInfoExpression orgInfoExpression, Pair<AdminOrgType, AdminOrgType> typePair, DynamicObject curOrg, long curOrgId, Map<String, DynamicObject> map) {
            OrgTypeChangeOnly4BatchChang.invalidEntity(orgInfoExpression.getDepartmentInfoMap().get(curOrgId), curOrg, AdminOrgHisDynKey.ADMIN_DEPARTMENT_KET.getDynKey(), map, DEPARTMENT_PROPS);
            DynamicObject oldOrgGroup = orgInfoExpression.getGroupInfoMap().get(curOrgId);
            map.put(AdminOrgHisDynKey.ADMIN_GROUP_KEY.getDynKey(), OrgTypeChangeOnly4BatchChang.genNewOrModifyDyn(curOrg, AdminOrgHisDynKey.ADMIN_GROUP_KEY.getDynKey(), oldOrgGroup, GROUP_PROPS));
            DynamicObject oldOrgCompany = orgInfoExpression.getCompanyInfoMap().get(curOrgId);
            map.put(AdminOrgHisDynKey.ADMIN_COMPANY_KEY.getDynKey(), OrgTypeChangeOnly4BatchChang.genNewOrModifyDyn(curOrg, AdminOrgHisDynKey.ADMIN_COMPANY_KEY.getDynKey(), oldOrgCompany, COMPANY_PROPS));
        }
    }

    private static class Company2DepartmentRule
    extends OrgTypeChangeRule {
        private Company2DepartmentRule() {
        }

        @Override
        public boolean evaluate(Expression expression) {
            OrgInfoExpression orgInfoExpression = (OrgInfoExpression)expression;
            Pair<AdminOrgType, AdminOrgType> typePair = orgInfoExpression.getTypePair();
            return typePair.getKey() == AdminOrgType.COMPANY && typePair.getValue() == AdminOrgType.DEPARTMENT;
        }

        @Override
        protected void doExecute(OrgInfoExpression orgInfoExpression, Pair<AdminOrgType, AdminOrgType> typePair, DynamicObject curOrg, long curOrgId, Map<String, DynamicObject> map) {
            OrgTypeChangeOnly4BatchChang.invalidEntity(orgInfoExpression.getCompanyInfoMap().get(curOrgId), curOrg, AdminOrgHisDynKey.ADMIN_COMPANY_KEY.getDynKey(), map, COMPANY_PROPS);
            DynamicObject oldOrgDepartment = orgInfoExpression.getDepartmentInfoMap().get(curOrgId);
            map.put(AdminOrgHisDynKey.ADMIN_DEPARTMENT_KET.getDynKey(), OrgTypeChangeOnly4BatchChang.genNewOrModifyDyn(curOrg, AdminOrgHisDynKey.ADMIN_DEPARTMENT_KET.getDynKey(), oldOrgDepartment, DEPARTMENT_PROPS));
        }
    }

    private static class Company2RegionRule
    extends OrgTypeChangeRule {
        private Company2RegionRule() {
        }

        @Override
        public boolean evaluate(Expression expression) {
            OrgInfoExpression orgInfoExpression = (OrgInfoExpression)expression;
            Pair<AdminOrgType, AdminOrgType> typePair = orgInfoExpression.getTypePair();
            return typePair.getKey() == AdminOrgType.COMPANY && typePair.getValue() == AdminOrgType.REGION;
        }

        @Override
        protected void doExecute(OrgInfoExpression orgInfoExpression, Pair<AdminOrgType, AdminOrgType> typePair, DynamicObject curOrg, long curOrgId, Map<String, DynamicObject> map) {
            OrgTypeChangeOnly4BatchChang.invalidEntity(orgInfoExpression.getCompanyInfoMap().get(curOrgId), curOrg, AdminOrgHisDynKey.ADMIN_COMPANY_KEY.getDynKey(), map, COMPANY_PROPS);
        }
    }

    private static class Company2GroupRule
    extends OrgTypeChangeRule {
        private Company2GroupRule() {
        }

        @Override
        public boolean evaluate(Expression expression) {
            OrgInfoExpression orgInfoExpression = (OrgInfoExpression)expression;
            Pair<AdminOrgType, AdminOrgType> typePair = orgInfoExpression.getTypePair();
            return typePair.getKey() == AdminOrgType.COMPANY && typePair.getValue() == AdminOrgType.GROUP;
        }

        @Override
        protected void doExecute(OrgInfoExpression orgInfoExpression, Pair<AdminOrgType, AdminOrgType> typePair, DynamicObject curOrg, long curOrgId, Map<String, DynamicObject> map) {
            DynamicObject oldOrgGroup = orgInfoExpression.getGroupInfoMap().get(curOrgId);
            map.put(AdminOrgHisDynKey.ADMIN_GROUP_KEY.getDynKey(), OrgTypeChangeOnly4BatchChang.genNewOrModifyDyn(curOrg, AdminOrgHisDynKey.ADMIN_GROUP_KEY.getDynKey(), oldOrgGroup, GROUP_PROPS));
            OrgTypeChangeOnly4BatchChang.addNewCompanyHisVersion(curOrg, map, orgInfoExpression.getCompanyInfoMap().get(curOrgId));
        }
    }

    private static class Group2DepartmentRule
    extends OrgTypeChangeRule {
        private Group2DepartmentRule() {
        }

        @Override
        public boolean evaluate(Expression expression) {
            OrgInfoExpression orgInfoExpression = (OrgInfoExpression)expression;
            Pair<AdminOrgType, AdminOrgType> typePair = orgInfoExpression.getTypePair();
            return typePair.getKey() == AdminOrgType.GROUP && typePair.getValue() == AdminOrgType.DEPARTMENT;
        }

        @Override
        protected void doExecute(OrgInfoExpression orgInfoExpression, Pair<AdminOrgType, AdminOrgType> typePair, DynamicObject curOrg, long curOrgId, Map<String, DynamicObject> map) {
            OrgTypeChangeOnly4BatchChang.invalidEntity(orgInfoExpression.getGroupInfoMap().get(curOrgId), curOrg, AdminOrgHisDynKey.ADMIN_GROUP_KEY.getDynKey(), map, GROUP_PROPS);
            OrgTypeChangeOnly4BatchChang.invalidEntity(orgInfoExpression.getCompanyInfoMap().get(curOrgId), curOrg, AdminOrgHisDynKey.ADMIN_COMPANY_KEY.getDynKey(), map, COMPANY_PROPS);
            DynamicObject orgOldDepartmentDyn = orgInfoExpression.getDepartmentInfoMap().get(curOrgId);
            map.put(AdminOrgHisDynKey.ADMIN_DEPARTMENT_KET.getDynKey(), OrgTypeChangeOnly4BatchChang.genNewOrModifyDyn(curOrg, AdminOrgHisDynKey.ADMIN_DEPARTMENT_KET.getDynKey(), orgOldDepartmentDyn, DEPARTMENT_PROPS));
        }
    }

    private static class Group2RegionRule
    extends OrgTypeChangeRule {
        private Group2RegionRule() {
        }

        @Override
        public boolean evaluate(Expression expression) {
            OrgInfoExpression orgInfoExpression = (OrgInfoExpression)expression;
            Pair<AdminOrgType, AdminOrgType> typePair = orgInfoExpression.getTypePair();
            return typePair.getKey() == AdminOrgType.GROUP && typePair.getValue() == AdminOrgType.REGION;
        }

        @Override
        protected void doExecute(OrgInfoExpression orgInfoExpression, Pair<AdminOrgType, AdminOrgType> typePair, DynamicObject curOrg, long curOrgId, Map<String, DynamicObject> map) {
            OrgTypeChangeOnly4BatchChang.invalidEntity(orgInfoExpression.getGroupInfoMap().get(curOrgId), curOrg, AdminOrgHisDynKey.ADMIN_GROUP_KEY.getDynKey(), map, GROUP_PROPS);
            OrgTypeChangeOnly4BatchChang.invalidEntity(orgInfoExpression.getCompanyInfoMap().get(curOrgId), curOrg, AdminOrgHisDynKey.ADMIN_COMPANY_KEY.getDynKey(), map, COMPANY_PROPS);
        }
    }

    private static class Group2CompRule
    extends OrgTypeChangeRule {
        private Group2CompRule() {
        }

        @Override
        public boolean evaluate(Expression expression) {
            OrgInfoExpression orgInfoExpression = (OrgInfoExpression)expression;
            Pair<AdminOrgType, AdminOrgType> typePair = orgInfoExpression.getTypePair();
            return typePair.getKey() == AdminOrgType.GROUP && typePair.getValue() == AdminOrgType.COMPANY;
        }

        @Override
        protected void doExecute(OrgInfoExpression orgInfoExpression, Pair<AdminOrgType, AdminOrgType> typePair, DynamicObject curOrg, long curOrgId, Map<String, DynamicObject> map) {
            DynamicObject groupDyn = orgInfoExpression.getGroupInfoMap().get(curOrgId);
            OrgTypeChangeOnly4BatchChang.invalidEntity(groupDyn, curOrg, AdminOrgHisDynKey.ADMIN_GROUP_KEY.getDynKey(), map, GROUP_PROPS);
            DynamicObject oldCompanyDyn = orgInfoExpression.getCompanyInfoMap().get(curOrgId);
            OrgTypeChangeOnly4BatchChang.addNewCompanyHisVersion(curOrg, map, oldCompanyDyn);
        }
    }
}

