/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.business.service.adminorg.sortcode;

import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.org.utils.DynamicObjectUtils;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.hr.haos.business.service.adminorg.AdminOrgHisDynKey;
import kd.hr.haos.business.service.adminorg.AdminOrgHisDynamicUtils;
import kd.hr.haos.business.service.adminorg.AdminOrgHisServiceHelper;
import kd.hr.hbp.business.domain.model.newhismodel.HisVersionParamBo;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;

public class AdminOrgSortCodeService {
    private static final Log logger = LogFactory.getLog(AdminOrgSortCodeService.class);
    private static final AdminOrgSortCodeService orgSortCodeService = new AdminOrgSortCodeService();

    public static AdminOrgSortCodeService getInstance() {
        return orgSortCodeService;
    }

    public HisVersionParamBo buildTempNewHisParam(DynamicObject[] dynamicObjects, Map<String, Map<Long, DynamicObject>> adminOrgInfoMap) {
        if (dynamicObjects == null || dynamicObjects.length == 0) {
            return null;
        }
        Map<Long, Long> orgIdMapParentId = Stream.of(dynamicObjects).filter(dyn -> dyn.getDynamicObject("parentorg") != null).collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy.getDynamicObject("parentorg").getLong("id")));
        Map<Long, String> idMapSortCode = this.batchGetOrgParentSortCode(orgIdMapParentId);
        DynamicObject[] orgSortCodeDynArr = new DynamicObject[dynamicObjects.length];
        long[] ids = ORM.create().genLongIds(AdminOrgHisDynKey.ADMIN_SORT_KEY.getDynKey(), dynamicObjects.length);
        int index = 0;
        for (DynamicObject dynamicObject : dynamicObjects) {
            long id;
            long adminOrgId = dynamicObject.getLong("id");
            DynamicObject sortCodeInfo = null;
            if (adminOrgInfoMap != null) {
                Map<Long, DynamicObject> entityInfoMap = adminOrgInfoMap.get(AdminOrgHisDynKey.ADMIN_SORT_KEY.getDynKey());
                sortCodeInfo = entityInfoMap.get(adminOrgId);
            }
            Long boId = null;
            if (sortCodeInfo != null) {
                id = sortCodeInfo.getLong("id");
                boId = sortCodeInfo.getLong("boid");
            } else {
                id = ids[index];
                sortCodeInfo = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)AdminOrgHisDynKey.ADMIN_SORT_KEY.getDynKey()));
            }
            DynamicObjectUtils.copy((DynamicObject)dynamicObject, (DynamicObject)sortCodeInfo, AdminOrgHisDynamicUtils.getInstance().getMultiLanguageIgnoreKey());
            sortCodeInfo.set("id", (Object)id);
            sortCodeInfo.set("boid", (Object)boId);
            sortCodeInfo.set("adminorg", (Object)dynamicObject);
            DynamicObject parentOrg = dynamicObject.getDynamicObject("parentorg");
            String parentSortCode = null;
            if (Objects.nonNull(parentOrg)) {
                parentSortCode = idMapSortCode.get(parentOrg.getLong("id"));
            }
            String curOrgSortCode = AdminOrgHisServiceHelper.fillIndexWithZero(dynamicObject.getString("index"));
            if (HRStringUtils.isNotEmpty(parentSortCode)) {
                curOrgSortCode = parentSortCode + "!" + curOrgSortCode;
            }
            sortCodeInfo.set("sortcode", (Object)curOrgSortCode);
            orgSortCodeDynArr[index] = sortCodeInfo;
            ++index;
        }
        logger.info(String.format(Locale.ROOT, "111111AdminOrgSortCodeService.buildAddNewHisParam() orgSortCodeDynArr size = %s", orgSortCodeDynArr.length));
        return AdminOrgHisDynamicUtils.getInstance().getHisVersionParam(orgSortCodeDynArr, AdminOrgHisDynKey.ADMIN_SORT_KEY.getDynKey(), false);
    }

    public HisVersionParamBo buildAddNewHisParam(DynamicObject[] dynamicObjects) {
        if (dynamicObjects == null || dynamicObjects.length == 0) {
            return null;
        }
        Map<Long, Long> orgIdMapParentId = Stream.of(dynamicObjects).filter(dyn -> dyn.getDynamicObject("parentorg") != null).collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy.getDynamicObject("parentorg").getLong("id")));
        Map<Long, String> idMapSortCode = this.batchGetOrgParentSortCode(orgIdMapParentId);
        DynamicObject[] orgSortCodeDynArr = new DynamicObject[dynamicObjects.length];
        long[] ids = ORM.create().genLongIds(AdminOrgHisDynKey.ADMIN_SORT_KEY.getDynKey(), dynamicObjects.length);
        int index = 0;
        for (DynamicObject dynamicObject : dynamicObjects) {
            DynamicObject dyn2 = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)AdminOrgHisDynKey.ADMIN_SORT_KEY.getDynKey()));
            DynamicObjectUtils.copy((DynamicObject)dynamicObject, (DynamicObject)dyn2, AdminOrgHisDynamicUtils.getInstance().getMultiLanguageIgnoreKey());
            long id = ids[index];
            dyn2.set("id", (Object)id);
            dyn2.set("boid", null);
            dyn2.set("adminorg", (Object)dynamicObject);
            DynamicObject parentOrg = dynamicObject.getDynamicObject("parentorg");
            String parentSortCode = null;
            if (Objects.nonNull(parentOrg)) {
                parentSortCode = idMapSortCode.get(parentOrg.getLong("id"));
            }
            String curOrgSortCode = AdminOrgHisServiceHelper.fillIndexWithZero(dynamicObject.getString("index"));
            if (HRStringUtils.isNotEmpty(parentSortCode)) {
                curOrgSortCode = parentSortCode + "!" + curOrgSortCode;
            }
            dyn2.set("sortcode", (Object)curOrgSortCode);
            orgSortCodeDynArr[index] = dyn2;
            ++index;
        }
        logger.info(String.format(Locale.ROOT, "111111AdminOrgSortCodeService.buildAddNewHisParam() orgSortCodeDynArr size = %s", orgSortCodeDynArr.length));
        return AdminOrgHisDynamicUtils.getInstance().getHisVersionParam(orgSortCodeDynArr, AdminOrgHisDynKey.ADMIN_SORT_KEY.getDynKey(), false);
    }

    public HisVersionParamBo buildBatchSaveTempHisParam(DynamicObject[] dynamicObjects) {
        if (dynamicObjects == null || dynamicObjects.length == 0) {
            return null;
        }
        Map<Long, String> idMapSortCode = this.buildAllOrgSortCode(dynamicObjects);
        DynamicObject[] orgSortCodeDynArr = new DynamicObject[dynamicObjects.length];
        long[] ids = ORM.create().genLongIds(AdminOrgHisDynKey.ADMIN_SORT_KEY.getDynKey(), dynamicObjects.length);
        int index = 0;
        for (DynamicObject dynamicObject : dynamicObjects) {
            DynamicObject dyn = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)AdminOrgHisDynKey.ADMIN_SORT_KEY.getDynKey()));
            DynamicObjectUtils.copy((DynamicObject)dynamicObject, (DynamicObject)dyn, AdminOrgHisDynamicUtils.getInstance().getMultiLanguageIgnoreKey());
            long id = ids[index];
            dyn.set("id", (Object)id);
            dyn.set("boid", null);
            dyn.set("adminorg", (Object)dynamicObject);
            dyn.set("sortcode", (Object)idMapSortCode.get(dynamicObject.getLong("id")));
            orgSortCodeDynArr[index] = dyn;
            ++index;
        }
        logger.info(String.format(Locale.ROOT, "111111AdminOrgSortCodeService.buildAddNewHisParam() orgSortCodeDynArr size = %s", orgSortCodeDynArr.length));
        return AdminOrgHisDynamicUtils.getInstance().getHisVersionParam(orgSortCodeDynArr, AdminOrgHisDynKey.ADMIN_SORT_KEY.getDynKey(), false);
    }

    private Map<Long, String> buildAllOrgSortCode(DynamicObject[] dynamicObjects) {
        Map<Long, DynamicObject> orgIdDynMap = Arrays.stream(dynamicObjects).collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy));
        Map<Long, Long> orgIdMapParentId = Stream.of(dynamicObjects).filter(dyn -> dyn.getDynamicObject("parentorg") != null).collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy.getDynamicObject("parentorg").getLong("id")));
        Map<Long, DynamicObject> idMapSortCode = this.batchGetOrgParentSortDynCode(orgIdMapParentId);
        HashMap orgIdSortCodeMap = Maps.newHashMapWithExpectedSize((int)dynamicObjects.length);
        AdminOrgHisServiceHelper.constructOrgStructLongNumberOrSortCode(orgIdDynMap, idMapSortCode, orgIdSortCodeMap, "sortcode", "index", 0);
        return orgIdSortCodeMap;
    }

    private Map<Long, DynamicObject> batchGetOrgParentSortDynCode(Map<Long, Long> orgIdMapParentId) {
        if (CollectionUtils.isEmpty(orgIdMapParentId)) {
            return new HashMap<Long, DynamicObject>();
        }
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(AdminOrgHisDynKey.ADMIN_SORT_KEY.getDynKey());
        QFilter filter = new QFilter("adminorg", "in", orgIdMapParentId.values());
        filter.and("iscurrentversion", "=", (Object)"1");
        DynamicObject[] sortCodeDyn = serviceHelper.query("sortcode,adminorg", new QFilter[]{filter});
        HashMap idSortCodeMap = Maps.newHashMapWithExpectedSize((int)sortCodeDyn.length);
        for (DynamicObject dynamicObject : sortCodeDyn) {
            idSortCodeMap.put(dynamicObject.getLong("adminorg.id"), dynamicObject);
        }
        return idSortCodeMap;
    }

    private Map<Long, String> batchGetOrgParentSortCode(Map<Long, Long> orgIdMapParentId) {
        if (CollectionUtils.isEmpty(orgIdMapParentId)) {
            return new HashMap<Long, String>();
        }
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(AdminOrgHisDynKey.ADMIN_SORT_KEY.getDynKey());
        QFilter filter = new QFilter("adminorg", "in", orgIdMapParentId.values());
        filter.and("iscurrentversion", "=", (Object)"1");
        DynamicObject[] sortCodeDyn = serviceHelper.query("sortcode,adminorg", new QFilter[]{filter});
        HashMap<Long, String> idSortCodeMap = new HashMap<Long, String>(sortCodeDyn.length);
        for (DynamicObject dynamicObject : sortCodeDyn) {
            idSortCodeMap.put(dynamicObject.getLong("adminorg.id"), dynamicObject.getString("sortcode"));
        }
        return idSortCodeMap;
    }
}

