/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.business.service.adminorg.util;

import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.IFormView;
import kd.bos.orm.query.QFilter;
import kd.bos.util.CollectionUtils;
import kd.hr.haos.business.domain.repository.QFilterHelper;
import kd.hr.haos.business.domain.repository.adorg.AdOrgRepository;
import kd.hr.haos.business.domain.repository.structproject.StructProjectRepository;
import kd.hr.haos.business.service.projectgroup.util.OrgTeamPermissionUtil;
import kd.hr.haos.business.servicehelper.SystemParamHelper;
import kd.hr.haos.business.util.HAOSPermUtils;
import kd.hr.haos.business.util.OrgPermHelper;
import kd.hr.haos.common.constants.masterdata.AdminOrgConstants;
import kd.hr.haos.common.constants.projectgroup.model.PermissionNeedParamModel;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.model.AuthorizedOrgResultWithSub;
import kd.hr.hbp.common.model.OrgSubInfo;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;

public class AdminOrgCountSubHelper {
    private static final HRBaseServiceHelper ADMINORG_STRUCT_HELPER = new HRBaseServiceHelper("haos_adminorgstruct");
    private boolean onlyOneLevel = true;
    public static IFormView DEFAULT_AUTHOR_FORM_VIEW;

    public static AdminOrgCountSubHelper createWithOnlyOneLevel(boolean onlyOneLevel) {
        AdminOrgCountSubHelper adminOrgCountSubHelper = new AdminOrgCountSubHelper();
        adminOrgCountSubHelper.onlyOneLevel = onlyOneLevel;
        return adminOrgCountSubHelper;
    }

    private AdminOrgCountSubHelper() {
    }

    public int countSubWithAuth(long orgId, IFormView formView, Date searchDate, Long structProjectId) {
        DynamicObject structDy = StructProjectRepository.getInstance().queryOriginalOneByPk("org,creator,enable", structProjectId);
        QFilter permStructFilter = this.getPermStructFilter(formView, structProjectId, structDy, searchDate);
        QFilter hasSubOrOnlyOneLevelSubFilter = this.genSubFilter(orgId, structProjectId, this.onlyOneLevel, searchDate);
        QFilter structProjectQf = new QFilter("structproject", "=", (Object)structProjectId);
        DynamicObject[] dynamicObjects = ADMINORG_STRUCT_HELPER.queryOriginalArray("id,adminorg.id", new QFilter[]{permStructFilter, hasSubOrOnlyOneLevelSubFilter, this.genHisVersionQFilter(), structProjectQf, this.genInitQFilter(), this.getEnableQf(structProjectId, structDy), this.genDataStatusQFilter(), new QFilter("bsed", "<=", (Object)searchDate), new QFilter("bsled", ">=", (Object)searchDate)});
        List<Long> orgIds = Arrays.asList(dynamicObjects).stream().map(dynamicObject -> dynamicObject.getLong("adminorg.id")).collect(Collectors.toList());
        return this.countSubWithAuth(orgIds, searchDate);
    }

    private QFilter getEnableQf(Long structProjectId, DynamicObject structDy) {
        if (!structProjectId.equals(AdminOrgConstants.ADMINORG_STRUCT) && HRStringUtils.equals((String)structDy.getString("enable"), (String)"10")) {
            return new QFilter("enable", "=", (Object)"10");
        }
        return new QFilter("enable", "=", (Object)"1");
    }

    private int countSubWithAuth(List<Long> orgIds, Date searchDate) {
        if (CollectionUtils.isEmpty(orgIds)) {
            return 0;
        }
        QFilter orgIdQf = new QFilter("boid", "in", orgIds);
        DynamicObject[] dynamicObjects = AdOrgRepository.getInstance().queryOriginalArray("id", new QFilter[]{orgIdQf, this.genInitQFilter(), new QFilter("enable", "=", (Object)Character.valueOf('1')), this.genDataStatusQFilter(), this.genHisVersionQFilter(), new QFilter("bsed", "<=", (Object)searchDate), new QFilter("bsled", ">=", (Object)searchDate)});
        return dynamicObjects.length;
    }

    private QFilter genSubFilter(long orgId, long structProjectId, boolean onlyOneLevel, Date searchDate) {
        if (onlyOneLevel) {
            return new QFilter("parentorg.id", "=", (Object)orgId);
        }
        QFilter orgIdFilter = new QFilter("adminorg", "=", (Object)orgId);
        DynamicObject dy = !this.isPast(searchDate) ? ADMINORG_STRUCT_HELPER.queryOriginalOne("id, structlongnumber", new QFilter[]{orgIdFilter, new QFilter("structproject", "=", (Object)structProjectId), this.genCurrentVersionQFilter(), this.genInitQFilter()}) : ADMINORG_STRUCT_HELPER.queryOriginalOne("id, structlongnumber", new QFilter[]{orgIdFilter, new QFilter("structproject", "=", (Object)structProjectId), this.genInitQFilter(), QFilterHelper.createValidHisVersionFilterByOnePoint(searchDate)});
        if (dy != null) {
            return new QFilter("structlongnumber", "like", (Object)(dy.getString("structlongnumber") + "!%"));
        }
        return new QFilter("1", "!=", (Object)1);
    }

    private QFilter getPermStructFilter(IFormView formView, Long structProjectId, DynamicObject structDy, Date searchDate) {
        Long creatorId;
        Long userId;
        if (!structProjectId.equals(AdminOrgConstants.ADMINORG_STRUCT) && (userId = Long.valueOf(RequestContext.get().getCurrUserId())).equals(creatorId = Long.valueOf(structDy.getLong("creator"))) && SystemParamHelper.getCreatorHasPermission(structDy.getLong("org"))) {
            return new QFilter("1", "=", (Object)1);
        }
        PermissionNeedParamModel permissionNeedParamModel = formView == DEFAULT_AUTHOR_FORM_VIEW ? this.getDefaultPermissionNeedParamModel() : OrgTeamPermissionUtil.extraPermissionModel(formView);
        String permField = "boid";
        Map<String, Object> map = HAOSPermUtils.getStructProjectCustomInParam(permField, structProjectId);
        AuthorizedOrgResultWithSub authOrgResultWithSub = (AuthorizedOrgResultWithSub)HRMServiceHelper.invokeHRMPService((String)"hrcs", (String)"IHRCSBizDataPermissionService", (String)"getUserAdminOrgsWithSub", (Object[])new Object[]{RequestContext.get().getCurrUserId(), permissionNeedParamModel.getAppId(), permissionNeedParamModel.getPermEntityId(), permissionNeedParamModel.getPermItemId(), permField, map});
        if (this.isPast(searchDate)) {
            OrgPermHelper.resetPermOrgResultWithSubWithDate(authOrgResultWithSub, searchDate, structProjectId);
        }
        if (authOrgResultWithSub.isHasAllOrgPerm()) {
            return new QFilter("1", "=", (Object)1);
        }
        return this.getLongStructNumberFilter(authOrgResultWithSub);
    }

    private boolean isPast(Date searchDate) {
        return searchDate != null && !HRDateTimeUtils.truncateDate((Date)new Date()).equals(HRDateTimeUtils.truncateDate((Date)searchDate));
    }

    private PermissionNeedParamModel getDefaultPermissionNeedParamModel() {
        PermissionNeedParamModel permissionNeedParamModel = new PermissionNeedParamModel();
        permissionNeedParamModel.setAppId("homs");
        permissionNeedParamModel.setF7(Boolean.valueOf(false));
        permissionNeedParamModel.setPermEntityId("haos_adminorgdetail");
        permissionNeedParamModel.setPermItemId("47150e89000000ac");
        return permissionNeedParamModel;
    }

    private QFilter getLongStructNumberFilter(AuthorizedOrgResultWithSub authOrgResultWithSub) {
        List hasPermOrgsWithSub = authOrgResultWithSub.getHasPermOrgsWithSub();
        Map<Boolean, List<OrgSubInfo>> orgSubInfoPartitionByContainsSub = hasPermOrgsWithSub.stream().collect(Collectors.partitioningBy(OrgSubInfo::isContainsSub));
        List idsWithOutSub = hasPermOrgsWithSub.stream().map(OrgSubInfo::getOrgId).collect(Collectors.toList());
        Optional<QFilter> structLongNumberContainsSubFilter = orgSubInfoPartitionByContainsSub.get(true).stream().map(orgSubInfo -> new QFilter("structlongnumber", "like", (Object)(orgSubInfo.getLongStructNumber() + "!%"))).reduce((qFilter, qFilter2) -> qFilter.or(qFilter2));
        QFilter adminOrgIdFilter = new QFilter("adminorg", "in", idsWithOutSub);
        if (structLongNumberContainsSubFilter.isPresent()) {
            adminOrgIdFilter = adminOrgIdFilter.or(structLongNumberContainsSubFilter.get());
        }
        return adminOrgIdFilter;
    }

    private QFilter genCurrentVersionQFilter() {
        return new QFilter("iscurrentversion", "=", (Object)"1");
    }

    private QFilter genAdminOrgEnableQFilter() {
        return new QFilter("adminorg.enable", "=", (Object)"1");
    }

    private QFilter genInitQFilter() {
        return new QFilter("initstatus", "=", (Object)"2");
    }

    private QFilter genStatusQFilter() {
        return new QFilter("status", "=", (Object)"C");
    }

    private QFilter genHisVersionQFilter() {
        return new QFilter("iscurrentversion", "=", (Object)"0");
    }

    private QFilter genDataStatusQFilter() {
        return new QFilter("datastatus", "in", Arrays.asList("1", "2"));
    }
}

