/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.business.service.adminorg.util;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.hr.haos.business.domain.repository.adorg.AdOrgRepository;
import kd.hr.haos.business.domain.repository.adorg.AdminOrgStructRepository;
import kd.hr.haos.common.constants.masterdata.AdminOrgConstants;
import kd.hr.haos.common.model.adminorg.FindBelongCompanyModel;
import kd.hr.haos.common.util.tree.FindParentTree;

public class AdminOrgFindBelongCompanyHelper {
    public static Map<Long, Long> findBelongCompanyMap(List<FindBelongCompanyModel> addOrgList, List<FindBelongCompanyModel> changeOrgList) {
        Set<Long> parentIdSet4Add = addOrgList.stream().map(FindBelongCompanyModel::getParentId).collect(Collectors.toSet());
        DynamicObject[] parentStructs = AdminOrgStructRepository.getInstance().queryEffAndTempStructInfoByOrgId("structlongnumber, adminorg.id", parentIdSet4Add);
        List structNumberList = Arrays.stream(parentStructs).map(struct -> struct.getString("structlongnumber")).map(struct -> struct.split("!")).flatMap(Arrays::stream).distinct().collect(Collectors.toList());
        DynamicObject[] parentOrgs = AdOrgRepository.getInstance().queryOriginalEffAndTempByStructNumber("id, adminorgtype.adminorgtypestd.id, parentorg.id", new HashSet<String>(structNumberList));
        Set effectIdSet = Stream.of(addOrgList, changeOrgList).flatMap(Collection::stream).map(FindBelongCompanyModel::getId).collect(Collectors.toSet());
        List filteredQueryParentOrgList = Arrays.stream(parentOrgs).filter(parentOrg -> {
            long id = parentOrg.getLong("id");
            return !effectIdSet.contains(id);
        }).map(org -> {
            FindBelongCompanyModel findBelongCompanyModel = new FindBelongCompanyModel();
            findBelongCompanyModel.setId(org.getLong("id"));
            findBelongCompanyModel.setParentId(org.getLong("parentorg.id"));
            findBelongCompanyModel.setTypeStdId(org.getLong("adminorgtype.adminorgtypestd.id"));
            return findBelongCompanyModel;
        }).collect(Collectors.toList());
        List allOrgList = Stream.of(addOrgList, changeOrgList, filteredQueryParentOrgList).flatMap(Collection::stream).collect(Collectors.toList());
        Map<Long, FindBelongCompanyModel> idVsData = allOrgList.stream().collect(Collectors.toMap(FindBelongCompanyModel::getId, findBelongCompanyModel -> findBelongCompanyModel));
        Map<Long, Long> idVsPid = allOrgList.stream().collect(Collectors.toMap(FindBelongCompanyModel::getId, FindBelongCompanyModel::getParentId));
        FindParentTree findParentTree = new FindParentTree(idVsPid, idVsData);
        return addOrgList.stream().map(FindBelongCompanyModel::getId).collect(Collectors.toMap(id -> id, id -> AdminOrgFindBelongCompanyHelper.findCompany(findParentTree.findParentList(id.longValue(), true))));
    }

    private static long findCompany(List<FindBelongCompanyModel> orgList) {
        for (FindBelongCompanyModel findBelongCompanyModel : orgList) {
            if (!AdminOrgFindBelongCompanyHelper.isCompanyOrGroup(findBelongCompanyModel.getTypeStdId())) continue;
            return findBelongCompanyModel.getId();
        }
        return 0L;
    }

    public static boolean isCompanyOrGroup(DynamicObject adminOrg) {
        return AdminOrgConstants.ADMIN_ORG_TYPE_COMPANY_AND_GROUP.contains(adminOrg.getLong("adminorgtype.adminorgtypestd.id"));
    }

    public static boolean isCompanyOrGroup(long typeStdId) {
        return AdminOrgConstants.ADMIN_ORG_TYPE_COMPANY_AND_GROUP.contains(typeStdId);
    }
}

