/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.business.service.orgchangetransaction.service;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.haos.business.service.orgchangetransaction.bean.ChangeOperateDetail;
import kd.hr.haos.business.service.orgchangetransaction.bean.ChangeTransactionBaseModel;
import kd.hr.haos.business.service.orgchangetransaction.bean.ChangeTransactionDetail;
import kd.hr.haos.business.service.orgchangetransaction.bean.ChangeTransactionSum;
import kd.hr.haos.business.service.orgchangetransaction.bean.MergeSplitDetail;
import kd.hr.haos.business.service.orgchangetransaction.service.ChangeTransactionContext;
import kd.hr.haos.business.service.orgchangetransaction.service.TransactionModelHandler;
import kd.hr.haos.common.constants.changetransaction.ChangeTransactionConstants;

public class TransactionModelMergeHandler
implements TransactionModelHandler {
    private final Map<Long, DynamicObject> mergeSplitDetailMap;
    private final Collection<MergeSplitDetail> mergeSplitDetailList;
    private Map<Long, Long> idBoIdMap;

    public TransactionModelMergeHandler(Map<Long, DynamicObject> mergeSplitDetailMap, Collection<MergeSplitDetail> mergeSplitDetailList) {
        this.mergeSplitDetailMap = mergeSplitDetailMap;
        this.mergeSplitDetailList = mergeSplitDetailList;
    }

    private ChangeTransactionSum buildChangeTransactionSum(ChangeTransactionContext context, MergeSplitDetail detail, Long targetOrgId, Long sceneSubId) {
        ChangeTransactionSum changeTransactionSum = new ChangeTransactionSum();
        context.setChangeDate(detail.getEffectDate());
        List<Long> sceneSubIdList = this.buildSceneSubIdList(context, targetOrgId);
        ArrayList<Object> newSceneSubIdList = CollectionUtils.isEmpty(sceneSubIdList) ? new ArrayList(1) : new ArrayList<Long>(sceneSubIdList);
        newSceneSubIdList.add(sceneSubId);
        context.setModelCommonField(changeTransactionSum);
        changeTransactionSum.setChangeSceneSubIds(newSceneSubIdList);
        changeTransactionSum.setTargetOrgId(this.idBoIdMap.getOrDefault(targetOrgId, targetOrgId));
        changeTransactionSum.setOrgChangeTypeId(detail.getChangeSceneId());
        changeTransactionSum.setOrgChangeReasonId(detail.getChangeReasonId());
        return changeTransactionSum;
    }

    private ChangeTransactionDetail buildChangeTransactionDetail(ChangeTransactionContext context, MergeSplitDetail detail, Long targetOrgId, Long sceneSubId) {
        ChangeTransactionDetail changeTransactionDetail = new ChangeTransactionDetail();
        context.setChangeDate(detail.getEffectDate());
        List<Long> sceneSubIdList = this.buildSceneSubIdList(context, targetOrgId);
        ArrayList<Object> newSceneSubIdList = CollectionUtils.isEmpty(sceneSubIdList) ? new ArrayList(1) : new ArrayList<Long>(sceneSubIdList);
        newSceneSubIdList.add(sceneSubId);
        context.setModelCommonField(changeTransactionDetail);
        changeTransactionDetail.setTargetOrgId(this.idBoIdMap.getOrDefault(targetOrgId, targetOrgId));
        changeTransactionDetail.setChangeSceneSubIds(newSceneSubIdList);
        changeTransactionDetail.setOrgChangeTypeId(detail.getChangeSceneId());
        changeTransactionDetail.setOrgChangeReasonId(detail.getChangeReasonId());
        return changeTransactionDetail;
    }

    private List<Long> buildSceneSubIdList(ChangeTransactionContext context, Long targetOrgId) {
        DynamicObject dy = this.mergeSplitDetailMap.get(targetOrgId);
        List<Long> sceneSubIdList = null;
        if (dy != null) {
            context.setBeforeOrgId(dy.getLong("adminorg.id"));
            context.setAfterOrgId(dy.getLong("afterbaseinfoid"));
            Map<Long, List<Long>> sceneSubMap = context.getSceneSubMap();
            if (sceneSubMap != null) {
                sceneSubIdList = sceneSubMap.get(dy.getLong("id"));
            }
        } else {
            context.setBeforeOrgId(targetOrgId);
            context.setAfterOrgId(targetOrgId);
        }
        return sceneSubIdList;
    }

    private void buildIdBoIdMap(ChangeTransactionContext context) {
        this.idBoIdMap = Arrays.stream(context.getMergeSplitDys()).collect(Collectors.toMap(dy -> dy.getLong("adminorg.id"), dy -> dy.getLong("adminorg.boid"), (key1, key2) -> key2));
    }

    private List<Long> getBoIdById(List<Long> idList) {
        if (CollectionUtils.isEmpty(idList)) {
            return idList;
        }
        return idList.stream().map(id -> this.idBoIdMap.getOrDefault(id, (Long)id)).collect(Collectors.toList());
    }

    @Override
    public List<ChangeTransactionBaseModel> build(ChangeTransactionContext context, int dataIndex) {
        this.buildIdBoIdMap(context);
        ArrayList result = Lists.newArrayListWithExpectedSize((int)16);
        for (MergeSplitDetail detail : this.mergeSplitDetailList) {
            Long sceneSubId = ChangeTransactionConstants.CHANGE_TYPE_SPLIT.equals(detail.getChangeTypeId()) ? ChangeTransactionConstants.SCENE_SUB_OUT : ChangeTransactionConstants.SCENE_SUB_INTO;
            ChangeTransactionSum changeTransactionSum = this.buildChangeTransactionSum(context, detail, detail.getOrgId(), sceneSubId);
            changeTransactionSum.setSourceOrgIds(this.getBoIdById(detail.getSourceOrgIdList()));
            result.add(changeTransactionSum);
            List<Long> targetOrgIdList = Collections.singletonList(this.idBoIdMap.getOrDefault(detail.getOrgId(), detail.getOrgId()));
            for (Long sourceOrgId : detail.getSourceOrgIdList()) {
                Long sourceSceneSubId = sceneSubId.equals(ChangeTransactionConstants.SCENE_SUB_INTO) ? ChangeTransactionConstants.SCENE_SUB_OUT : ChangeTransactionConstants.SCENE_SUB_INTO;
                changeTransactionSum = this.buildChangeTransactionSum(context, detail, sourceOrgId, sourceSceneSubId);
                changeTransactionSum.setSourceOrgIds(targetOrgIdList);
                result.add(changeTransactionSum);
                ChangeTransactionDetail changeTransactionDetail = this.buildChangeTransactionDetail(context, detail, detail.getOrgId(), sceneSubId);
                changeTransactionDetail.setSourceOrgId(this.idBoIdMap.getOrDefault(sourceOrgId, sourceOrgId));
                result.add(changeTransactionDetail);
                changeTransactionDetail = this.buildChangeTransactionDetail(context, detail, sourceOrgId, sourceSceneSubId);
                changeTransactionDetail.setSourceOrgId(this.idBoIdMap.getOrDefault(detail.getOrgId(), detail.getOrgId()));
                result.add(changeTransactionDetail);
            }
        }
        for (DynamicObject dy : this.mergeSplitDetailMap.values()) {
            long boId = dy.getLong("adminorg.boid");
            long changeType = dy.getLong("changetype.id");
            context.setChangeDate(changeType == ChangeTransactionConstants.ADD ? dy.getDate("establishmentdate") : dy.getDate("bsed"));
            context.setBeforeOrgId(dy.getLong("adminorg.id"));
            context.setAfterOrgId(dy.getLong("afterbaseinfoid"));
            ChangeOperateDetail changeOperateDetail = new ChangeOperateDetail();
            context.setModelCommonField(changeOperateDetail);
            changeOperateDetail.setOrgId(boId);
            changeOperateDetail.setChangeOperateId(changeType);
            changeOperateDetail.setStructChange(changeType == ChangeTransactionConstants.ADD || changeType == ChangeTransactionConstants.PARENT);
            changeOperateDetail.setInfoChange(changeType != ChangeTransactionConstants.DISABLE);
            result.add(changeOperateDetail);
        }
        return result;
    }
}

