/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.business.service.orgchangetransaction.service.change;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.haos.business.service.orgchangetransaction.service.change.AddChangeOperatHandler;
import kd.hr.haos.business.service.orgchangetransaction.service.change.AdjustChangeOperatHandler;
import kd.hr.haos.business.service.orgchangetransaction.service.change.CommonChangeOperatHandler;
import kd.hr.haos.business.service.orgchangetransaction.service.change.DisableChangeOperatHandler;
import kd.hr.haos.business.service.orgchangetransaction.service.change.IChangeOperatHandler;
import kd.hr.haos.business.service.orgchangetransaction.service.change.IChangeSceneSubService;
import kd.hr.haos.business.service.orgchangetransaction.service.change.ModifyChangeOperatHandler;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;

public class ChangeSceneSubService
implements IChangeSceneSubService {
    private static final String ORG_ID = "adminorg.boid";
    private final Map<Long, IChangeOperatHandler> map = new HashMap<Long, IChangeOperatHandler>(10);

    public ChangeSceneSubService() {
        this.map.put(1010L, new AddChangeOperatHandler());
        this.map.put(1020L, new AdjustChangeOperatHandler());
        this.map.put(1030L, new ModifyChangeOperatHandler());
        this.map.put(1040L, new DisableChangeOperatHandler());
    }

    @Override
    public Map<Long, List<Long>> getSceneSubId(List<DynamicObject> dObjectList) {
        HashMap<Long, List<Long>> map = new HashMap<Long, List<Long>>();
        if (CollectionUtils.isEmpty(dObjectList)) {
            return map;
        }
        List<Long> idList = dObjectList.stream().filter(this::isCommonChange).map(dy -> dy.getLong(ORG_ID)).collect(Collectors.toList());
        Map<Long, List<DynamicObject>> relMap = this.getCoopRelDynList(idList);
        Map<Long, Map<String, DynamicObject>> orgInfoMap = this.getOrgInfo(idList);
        for (DynamicObject dObject : dObjectList) {
            IChangeOperatHandler handler = this.buildChangeOperateHandler(dObject, relMap.get(dObject.getLong(ORG_ID)), orgInfoMap.get(dObject.getLong(ORG_ID)));
            if (handler == null) continue;
            map.put(dObject.getLong("id"), handler.getSceneSubId(dObject));
        }
        return map;
    }

    private boolean isCommonChange(DynamicObject dObject) {
        Long changeOperateId = this.getChangeOperateId(dObject);
        return changeOperateId.equals(1020L) || changeOperateId.equals(1030L);
    }

    private Long getChangeOperateId(DynamicObject dObject) {
        Long id = 0L;
        long changeTypeId = dObject.getLong("changetype.id");
        if (changeTypeId == 0L || changeTypeId == 1060L) {
            return id;
        }
        return changeTypeId;
    }

    private IChangeOperatHandler buildChangeOperateHandler(DynamicObject dObject, List<DynamicObject> coopRelDynList, Map<String, DynamicObject> orgInfoMap) {
        IChangeOperatHandler handler = this.map.get(this.getChangeOperateId(dObject));
        if (handler instanceof CommonChangeOperatHandler) {
            CommonChangeOperatHandler commonHandler = (CommonChangeOperatHandler)handler;
            commonHandler.setCoopRelDynList(coopRelDynList);
            commonHandler.setOrgInfoMap(orgInfoMap);
        }
        return handler;
    }

    private Map<Long, List<DynamicObject>> getCoopRelDynList(List<Long> orgIdList) {
        HashMap<Long, List<DynamicObject>> map = new HashMap<Long, List<DynamicObject>>(orgIdList.size());
        if (CollectionUtils.isEmpty(orgIdList)) {
            return map;
        }
        HRBaseServiceHelper coopRelHelper = new HRBaseServiceHelper("haos_orgteamcooprel");
        QFilter filter = new QFilter("org", "in", orgIdList).and(new QFilter("iscurrentversion", "=", (Object)"1")).and(new QFilter("enable", "=", (Object)"1")).and(new QFilter("datastatus", "=", (Object)"1")).and(new QFilter("coopreltype", "<>", (Object)1010L));
        DynamicObjectCollection cooperRelDys = coopRelHelper.queryOriginalCollection("id,org.id,coopreltype.id,cooporgteam.id", new QFilter[]{filter});
        for (DynamicObject dObject : cooperRelDys) {
            List list = map.computeIfAbsent(dObject.getLong("org.id"), k -> new ArrayList(10));
            list.add(dObject);
        }
        return map;
    }

    private Map<Long, Map<String, DynamicObject>> getOrgInfo(List<Long> orgIdList) {
        Map map;
        DynamicObject[] dys;
        HashMap<Long, Map<String, DynamicObject>> orgMap = new HashMap<Long, Map<String, DynamicObject>>(orgIdList.size());
        if (CollectionUtils.isEmpty(orgIdList)) {
            return orgMap;
        }
        HRBaseServiceHelper helper = new HRBaseServiceHelper("haos_adminorgdetail");
        QFilter commonFilter = new QFilter("iscurrentversion", "=", (Object)"1");
        for (DynamicObject dy : dys = helper.query("id,number,name,simplename,adminorgtype,corporateorg,adminorglayer,adminorgfunction,tobedisableflag,companyarea,city,workplace,detailaddress,description,positioning,mainduty,safelevel,safetype,safedescription,index,belongcompany,enable, org.id", new QFilter[]{new QFilter("id", "in", orgIdList), commonFilter})) {
            map = orgMap.computeIfAbsent(dy.getLong("id"), k -> new HashMap(5));
            map.put("org", dy);
        }
        commonFilter.and(new QFilter("enable", "=", (Object)"1"));
        commonFilter.and(new QFilter("adminorg", "in", orgIdList));
        helper = new HRBaseServiceHelper("haos_adminorgdepartment");
        DynamicObjectCollection dyCollection = helper.queryOriginalCollection("adminorg.id,departmenttype.id", new QFilter[]{commonFilter});
        for (DynamicObject dy : dyCollection) {
            map = (Map)orgMap.get(dy.getLong("adminorg.id"));
            if (map == null) continue;
            map.put("dept", dy);
        }
        helper = new HRBaseServiceHelper("haos_adminorgcompany");
        dyCollection = helper.queryOriginalCollection("adminorg.id,companytype.id,industrytype.id", new QFilter[]{commonFilter});
        for (DynamicObject dy : dyCollection) {
            map = (Map)orgMap.get(dy.getLong("adminorg.id"));
            if (map == null) continue;
            map.put("company", dy);
        }
        helper = new HRBaseServiceHelper("haos_adminorggroup");
        for (DynamicObject dy : dys = helper.query("adminorg.id,groupvision,groupmission", new QFilter[]{commonFilter})) {
            map = (Map)orgMap.get(dy.getLong("adminorg.id"));
            if (map == null) continue;
            map.put("group", dy);
        }
        return orgMap;
    }
}

