/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.business.service.orgchangetransaction.service.change;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.haos.business.service.orgchangetransaction.service.change.IChangeOperatHandler;
import kd.hr.haos.common.constants.changetransaction.ChangeTransactionConstants;
import kd.hr.hbp.common.util.HRStringUtils;

public abstract class CommonChangeOperatHandler
implements IChangeOperatHandler {
    private static final Log logger = LogFactory.getLog(CommonChangeOperatHandler.class);
    private static final Set<String> OTHER_INFO = Sets.newHashSet((Object[])new String[]{"number", "simplename", "adminorgtype.id", "index", "adminorglayer.id", "adminorgfunction.id", "companyarea.id", "city.id", "workplace.id", "detailaddress", "description", "positioning", "mainduty", "safelevel.id", "safetype.id", "safedescription"});
    private List<DynamicObject> coopRelDynList;
    private Map<String, DynamicObject> orgInfoMap;

    public void setOrgInfoMap(Map<String, DynamicObject> orgInfoMap) {
        this.orgInfoMap = orgInfoMap;
    }

    public void setCoopRelDynList(List<DynamicObject> coopRelDynList) {
        this.coopRelDynList = coopRelDynList;
    }

    @Override
    public List<Long> getSceneSubId(DynamicObject dObject) {
        String billEnable;
        String oldEnable;
        ArrayList<Long> list = new ArrayList<Long>(10);
        if (CollectionUtils.isEmpty(this.orgInfoMap)) {
            return list;
        }
        DynamicObject orgDy = this.orgInfoMap.get("org");
        if (this.isLocaleStringChanged(orgDy.getLocaleString("name"), dObject.getLocaleString("name"))) {
            list.add(1050L);
        }
        if (this.isLocaleStringChanged(orgDy.getLocaleString("mainduty"), dObject.getLocaleString("mainduty"))) {
            list.add(1070L);
        }
        if (orgDy.getLong("corporateorg.id") != dObject.getLong("corporateorg.id")) {
            list.add(1060L);
        }
        if (orgDy.getBoolean("tobedisableflag") != dObject.getBoolean("tobedisableflag")) {
            list.add(1110L);
        }
        if (dObject.getLong("changescene.id") == 1070L) {
            list.add(1140L);
            return list;
        }
        if (this.isRelChange(dObject.getDynamicObjectCollection("cooprelentryentity"))) {
            list.add(1080L);
        }
        if (this.isBelongCompanyChange(orgDy, dObject)) {
            list.add(1130L);
        }
        if (orgDy.getLong("org.id") != dObject.getLong("org.id")) {
            list.add(ChangeTransactionConstants.SCENE_SUB_ORG);
        }
        if (this.isOtherChange(orgDy, dObject)) {
            list.add(1030L);
        }
        if (dObject.getDynamicObjectType().getProperties().containsKey((Object)"billenable") && !HRStringUtils.equals((String)(oldEnable = orgDy.getString("enable")), (String)(billEnable = dObject.getString("billenable")))) {
            list.add(1140L);
            if (HRStringUtils.equals((String)billEnable, (String)"0")) {
                list.add(1040L);
            }
        }
        return list;
    }

    private boolean isBelongCompanyChange(DynamicObject orgDy, DynamicObject dObject) {
        long typestd = dObject.getLong("adminorgtype.adminorgtypestd.id");
        long belongCompanyId = 0L;
        if (typestd == 1010L || typestd == 1020L) {
            belongCompanyId = dObject.getLong("adminorg.boid");
        } else if (typestd == 1030L || typestd == 1040L) {
            belongCompanyId = dObject.getLong("parentorg.belongcompany.id");
        }
        return orgDy.getLong("belongcompany.boid") != belongCompanyId;
    }

    private boolean isOtherChange(DynamicObject orgDy, DynamicObject dObject) {
        for (String key : OTHER_INFO) {
            if (!this.isValueChanged(orgDy, dObject, key)) continue;
            logger.info("CommonChangeOperatHandler.isOtherChange is changed attribute:" + key);
            return true;
        }
        if (this.isValuesChanged(this.orgInfoMap.get("company"), dObject, "companytype.id,industrytype.id")) {
            return true;
        }
        if (this.isValuesChanged(this.orgInfoMap.get("dept"), dObject, "departmenttype.id")) {
            return true;
        }
        return this.isValuesChanged(this.orgInfoMap.get("group"), dObject, "groupvision,groupmission");
    }

    private boolean isValuesChanged(DynamicObject oldDy, DynamicObject newDy, String keys) {
        String[] keyArray = keys.split(",");
        if (oldDy == null) {
            for (String key : keyArray) {
                if (HRStringUtils.isEmpty((String)newDy.getString(key))) continue;
                logger.info("CommonChangeOperatHandler.isValuesChanged oldDy is null, attribute:" + key);
                return true;
            }
            return false;
        }
        for (String key : keyArray) {
            if (!this.isValueChanged(oldDy, newDy, key)) continue;
            logger.info("CommonChangeOperatHandler.isValuesChanged is changed attribute:" + key);
            return true;
        }
        return false;
    }

    private boolean isValueChanged(DynamicObject oldDy, DynamicObject newDy, String key) {
        Object value = oldDy.get(key);
        boolean flag = value instanceof ILocaleString ? this.isLocaleStringChanged((ILocaleString)value, newDy.getLocaleString(key)) : (value instanceof Long ? oldDy.getLong(key) != newDy.getLong(key) : !HRStringUtils.equals((String)oldDy.getString(key), (String)newDy.getString(key)));
        return flag;
    }

    private boolean isLocaleStringChanged(ILocaleString oldValue, ILocaleString newValue) {
        ILocaleString minSizeString;
        ILocaleString maxSizeString;
        if (CollectionUtils.isEmpty((Map)oldValue) && CollectionUtils.isEmpty((Map)newValue)) {
            return false;
        }
        if (CollectionUtils.isEmpty((Map)oldValue) || CollectionUtils.isEmpty((Map)newValue)) {
            return true;
        }
        if (oldValue.size() > newValue.size()) {
            maxSizeString = oldValue;
            minSizeString = newValue;
        } else {
            maxSizeString = newValue;
            minSizeString = oldValue;
        }
        for (Map.Entry entry : maxSizeString.entrySet()) {
            if (HRStringUtils.equals((String)((String)entry.getValue()), (String)((String)minSizeString.get(entry.getKey())))) continue;
            logger.info("CommonChangeOperatHandler is changed attribute local:" + (String)entry.getKey());
            return true;
        }
        return false;
    }

    private boolean isRelChange(DynamicObjectCollection newRelList) {
        if (CollectionUtils.isEmpty((Collection)newRelList) && CollectionUtils.isEmpty(this.coopRelDynList)) {
            return false;
        }
        if (CollectionUtils.isEmpty((Collection)newRelList) || CollectionUtils.isEmpty(this.coopRelDynList)) {
            return true;
        }
        if (newRelList.size() != this.coopRelDynList.size()) {
            return true;
        }
        int length = 0;
        block0: for (DynamicObject coopRel : this.coopRelDynList) {
            for (DynamicObject newRel : newRelList) {
                if (coopRel.getLong("id") != newRel.getLong("cooprelid")) continue;
                if (coopRel.getLong("coopreltype.id") != newRel.getLong("coopreltyp.id") || coopRel.getLong("cooporgteam.id") != newRel.getLong("cooporgteam.boid")) {
                    return true;
                }
                ++length;
                continue block0;
            }
        }
        return this.coopRelDynList.size() != length;
    }
}

