/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.business.service.orgteam;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.hr.haos.business.domain.repository.orgteam.CustomOTStructRepository;
import kd.hr.haos.business.domain.repository.orgteam.OTStructRepository;
import kd.hr.haos.business.domain.repository.structproject.StructProjectRepository;
import kd.hr.haos.business.service.adminorg.AdminOrgHisServiceHelper;
import kd.hr.haos.business.service.orgteam.OrgTeamEnablingService;
import kd.hr.haos.business.service.orgteam.OtherTeamStructService;
import kd.hr.haos.business.service.orgteam.model.OtCascadeBo;
import kd.hr.haos.business.service.orgteam.model.OtStructBo;
import kd.hr.haos.business.util.IdCreator;
import kd.hr.haos.business.util.LocalDateRangeUtils;
import kd.hr.haos.business.util.LogUtil;
import kd.hr.haos.business.util.cascade.MultiVersionTree;
import kd.hr.haos.common.constants.masterdata.AdminOrgConstants;
import kd.hr.haos.common.model.ChangeRootData;
import kd.hr.haos.common.model.cascade.CascadeResult;
import kd.hr.haos.common.model.cascade.PartBo;
import kd.hr.haos.common.model.orgteam.BatchSynModel;
import kd.hr.haos.common.util.DyCollectors;
import kd.hr.haos.common.util.LocalDateRange;
import kd.hr.hbp.business.application.impl.newhismodel.HisModelController;
import kd.hr.hbp.business.domain.model.newhismodel.BatchVersionChangeRespData;
import kd.hr.hbp.business.domain.model.newhismodel.HisResponse;
import kd.hr.hbp.business.domain.model.newhismodel.HisVersionParamBo;
import kd.hr.hbp.business.domain.model.newhismodel.HisVersionParamListBo;
import kd.hr.hbp.business.domain.service.impl.newhismodel.HisEffDateCommonService;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;

public class OrgTeamBatchSynService {
    private static final LogUtil LOGGER = new LogUtil(LogFactory.getLog(OrgTeamBatchSynService.class));
    private Date date2999 = HisEffDateCommonService.getInstance().getDate2999(null);
    private Map<Long, Long> otBoVsStructBo = new HashMap<Long, Long>();
    private List<Map<String, Object>> customizedFiledValue;
    private BatchSynModel batchSynModel;
    private boolean notSynOt = false;
    private DynamicObject structProjectDy;

    HisResponse<BatchVersionChangeRespData> synOnlyStruct() {
        this.notSynOt = true;
        return this.synWithoutEnabling();
    }

    public HisResponse<BatchVersionChangeRespData> syn() {
        HisResponse<BatchVersionChangeRespData> respDataHisResponse = this.synWithoutEnabling();
        if (this.batchSynModel.getStrucrProjectId() == 1010L || this.batchSynModel.getStrucrProjectId() == 1020L) {
            return respDataHisResponse;
        }
        Set parentChangeBoSet = (Set)this.getChgParentList().stream().collect(DyCollectors.toBoIdSet());
        new OrgTeamEnablingService().synByParentChange(parentChangeBoSet, this.batchSynModel.getStrucrProjectId());
        return respDataHisResponse;
    }

    HisResponse<BatchVersionChangeRespData> synWithoutEnabling() {
        this.initEffectDate();
        this.synOtBoVsStructBo();
        boolean newEmpty = CollectionUtils.isEmpty((Collection)this.batchSynModel.getNewList());
        boolean parentChgEmpty = CollectionUtils.isEmpty((Collection)this.batchSynModel.getChgParentList());
        boolean infoChgEmpty = CollectionUtils.isEmpty((Collection)this.batchSynModel.getChgInfoList());
        boolean statusChgEmpty = CollectionUtils.isEmpty((Collection)this.batchSynModel.getStatusChgList());
        LOGGER.infoIfEnabled(() -> String.format("syn start with newEmpty:%s, parentChgEmpty:%s, infoChgEmpty:%s, statusChgEmpty:%s", newEmpty, parentChgEmpty, infoChgEmpty, statusChgEmpty));
        CascadeResult cascadeResult = this.calculateCascadeField();
        ArrayList<DynamicObject> structList = new ArrayList<DynamicObject>();
        if (this.batchSynModel.getChangeRootData() != null) {
            structList.add(this.buildRootStructDy());
        } else {
            structList.addAll(this.createNewStructList(cascadeResult));
            structList.addAll(this.createNoParentNewStructList());
        }
        structList.addAll(this.overlapValue2DbDy(cascadeResult));
        this.calculateLevel(structList);
        this.setStructProject(structList);
        DynamicObject[] ots = this.batchSynModel.getSaveList().toArray(new DynamicObject[0]);
        DynamicObject[] structs = structList.toArray(new DynamicObject[0]);
        List<Long> newBoIds = this.batchSynModel.getNewList().stream().map(dyn -> dyn.getLong("boid")).collect(Collectors.toList());
        List<Long> otBaseInfoBoIdsForStruct = this.getExcludeOtIds(structList, ots, newBoIds);
        List<DynamicObject> structLists = this.getStructList(ots, otBaseInfoBoIdsForStruct);
        List<DynamicObject> allOtStructList = Arrays.stream(structs).collect(Collectors.toList());
        allOtStructList.addAll(structLists);
        Map<Long, Long> orgTeamIdToStructBoId = Arrays.stream(structs).filter(dyn -> newBoIds.contains(dyn.getLong("orgteam.id")) && HisEffDateCommonService.getInstance().getDate2999(null).equals(dyn.getDate("bsled"))).collect(Collectors.toMap(dyn -> dyn.getLong("orgteam.id"), dyn -> dyn.getLong("id"), (key1, key2) -> key2));
        structs = this.beforeCreateVersion(allOtStructList.toArray(new DynamicObject[0]), ots, orgTeamIdToStructBoId).toArray(new DynamicObject[0]);
        structs = Arrays.stream(structs).filter(struct -> struct.getLong("orgteamhisid") != 0L).collect(Collectors.toList()).toArray(new DynamicObject[0]);
        List<DynamicObject> otherStructList = Collections.emptyList();
        if (this.batchSynModel.getStrucrProjectId() == AdminOrgConstants.ADMINORG_STRUCT.longValue()) {
            OtherTeamStructService otherTeamStructService = new OtherTeamStructService();
            List<DynamicObject> list = this.batchSynModel.getSaveList().stream().filter(dy -> !newBoIds.contains(dy.getLong("boid"))).collect(Collectors.toList());
            otherStructList = otherTeamStructService.getOtherStructByOt(list);
        }
        VersionModel version = this.createVersion(structs, ots, otherStructList);
        this.setDefaultValue(version);
        this.removeOt4Modify(version);
        HisResponse<BatchVersionChangeRespData> respDataHisResponse = null;
        if (version.validVersion.size() != 0) {
            respDataHisResponse = this.getBatchVersionChangeRespDataHisResponse(version.validVersion);
        }
        if (version.invalidVersion.size() != 0) {
            HisResponse<BatchVersionChangeRespData> invalidHisResponse = this.getBatchVersionChangeRespDataHisResponse(version.invalidVersion);
            if (respDataHisResponse == null) {
                respDataHisResponse = invalidHisResponse;
            } else {
                ((BatchVersionChangeRespData)respDataHisResponse.getData()).getVersionChangeRespDataList().addAll(((BatchVersionChangeRespData)invalidHisResponse.getData()).getVersionChangeRespDataList());
            }
        }
        return respDataHisResponse;
    }

    private void setStructProject(List<DynamicObject> structList) {
        structList.stream().filter(struct -> struct.get("structproject") == null).forEach(struct -> struct.set("structproject", (Object)this.getStructProject()));
    }

    private void removeOt4Modify(VersionModel version) {
        String structEntityName = HRStringUtils.equals((String)"1", (String)this.batchSynModel.getCustomOrgStructFlag()) ? "haos_customotstruct" : "haos_adminorgstructure";
        if (this.isNotSynOt()) {
            if (version.validVersion.size() != 0) {
                version.validVersion.removeIf(dy -> !dy.getEntityNumber().equals(structEntityName));
            }
            if (version.invalidVersion.size() != 0) {
                version.invalidVersion.removeIf(dy -> !dy.getEntityNumber().equals(structEntityName));
            }
        }
    }

    private List<Long> getExcludeOtIds(List<DynamicObject> structList, DynamicObject[] ots, List<Long> newBoIds) {
        List otBaseInfoBoIds = Arrays.stream(ots).filter(dyn -> dyn.getLong("boid") != 0L).map(dyn -> dyn.getLong("boid")).collect(Collectors.toList());
        List otStructBoIds = structList.stream().map(dyn -> dyn.getLong("orgteam.id")).collect(Collectors.toList());
        ArrayList<Long> otBaseInfoBoIdsForStruct = new ArrayList<Long>(otBaseInfoBoIds);
        ArrayList otStructBoIdsForStruct = new ArrayList(otStructBoIds);
        otBaseInfoBoIdsForStruct.addAll(newBoIds);
        otBaseInfoBoIdsForStruct.removeAll(otStructBoIdsForStruct);
        return otBaseInfoBoIdsForStruct;
    }

    private List<DynamicObject> getStructList(DynamicObject[] ots, List<Long> otBaseInfoBoIdsForStruct) {
        DynamicObject[] otStructHis = HRStringUtils.equals((String)"1", (String)this.batchSynModel.getCustomOrgStructFlag()) ? CustomOTStructRepository.getInstance().loadHisByOTBo(new HashSet<Long>(otBaseInfoBoIdsForStruct), this.getStructProjectIdList4Query()) : OTStructRepository.getInstance().loadHisByOTBo(new HashSet<Long>(otBaseInfoBoIdsForStruct), this.getStructProjectIdList4Query());
        Map<Long, List<DynamicObject>> otMap = Arrays.stream(ots).collect(Collectors.groupingBy(ot -> ot.getLong("boid")));
        Map<Long, List<DynamicObject>> structMap = Arrays.stream(otStructHis).collect(Collectors.groupingBy(struct -> struct.getLong("orgteam.id")));
        ArrayList<DynamicObject> structLists = new ArrayList<DynamicObject>(10);
        otMap.forEach((key, value) -> {
            List dynamicObjects;
            if (otBaseInfoBoIdsForStruct.contains(key) && (dynamicObjects = (List)structMap.get(key)) != null && dynamicObjects.size() != 0 && value != null && value.size() != 0) {
                Date date = ((DynamicObject)value.get(0)).getDate("bsed");
                for (int i = 1; i < value.size(); ++i) {
                    Date bsed = ((DynamicObject)value.get(i)).getDate("bsed");
                    if (bsed == null || !bsed.before(date)) continue;
                    date = bsed;
                }
                for (DynamicObject otStruct : dynamicObjects) {
                    if (!date.before(otStruct.getDate("bsled"))) continue;
                    DynamicObject newDyn = new DynamicObject(otStruct.getDynamicObjectType());
                    HRDynamicObjectUtils.copy((DynamicObject)otStruct, (DynamicObject)newDyn);
                    newDyn.set("orgteamhisid", (Object)0L);
                    structLists.add(newDyn);
                }
            }
        });
        return structLists;
    }

    private List<DynamicObject> beforeCreateVersion(DynamicObject[] structs, DynamicObject[] ots, Map<Long, Long> orgTeamIdToStructBoId) {
        Map<Long, List<DynamicObject>> structMap = Arrays.stream(structs).collect(Collectors.groupingBy(struct -> struct.getLong("orgteam.id")));
        for (DynamicObject orgTeamDy : ots) {
            List<DynamicObject> list = structMap.get(orgTeamDy.getLong("boid"));
            if (CollectionUtils.isEmpty(list)) continue;
            this.splitStructAndSetHisId(orgTeamDy, list, orgTeamIdToStructBoId);
        }
        return structMap.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
    }

    private List<LocalDateRange> splitEffectRange(LocalDateRange effectRange, LocalDateRange structEffectRange) {
        ArrayList<LocalDateRange> list = new ArrayList<LocalDateRange>(2);
        if (structEffectRange.getStart().compareTo(effectRange.getStart()) < 0) {
            list.add(LocalDateRange.of((LocalDate)structEffectRange.getStart(), (LocalDate)effectRange.getStart()));
        }
        if (structEffectRange.getEnd().compareTo(effectRange.getEnd()) > 0) {
            list.add(LocalDateRange.of((LocalDate)effectRange.getEnd(), (LocalDate)structEffectRange.getEnd()));
        }
        return list;
    }

    private void splitStructData(ListIterator<DynamicObject> it, DynamicObject structDy, LocalDateRange effectRange, LocalDateRange structEffectRange, Map<Long, Long> orgTeamIdToStructBoId) {
        List<LocalDateRange> list = this.splitEffectRange(effectRange, structEffectRange);
        for (LocalDateRange dateRange : list) {
            DynamicObject newDy = new DynamicObject(structDy.getDynamicObjectType());
            HRDynamicObjectUtils.copy((DynamicObject)structDy, (DynamicObject)newDy);
            Long aLong = orgTeamIdToStructBoId.get(structDy.getLong("orgteam.id"));
            if (newDy.getLong("boid") == 0L && aLong != null) {
                newDy.set("boid", (Object)aLong);
            }
            LocalDateRangeUtils.setEffectRange(newDy, dateRange);
            it.add(newDy);
        }
    }

    private void splitStructAndSetHisId(DynamicObject orgTeamDy, List<DynamicObject> structDyList, Map<Long, Long> orgTeamIdToStructBoId) {
        LocalDateRange effectRange = LocalDateRangeUtils.getEffectRange(orgTeamDy);
        ListIterator<DynamicObject> it = structDyList.listIterator();
        while (it.hasNext()) {
            DynamicObject structDy = it.next();
            LocalDateRange structEffectRange = LocalDateRangeUtils.getEffectRange(structDy);
            if (!structEffectRange.overlaps(effectRange)) continue;
            if (effectRange.encloses(structEffectRange)) {
                if (this.date2999.equals(LocalDateRangeUtils.getDate(effectRange.getEnd().minusDays(1L))) && this.batchSynModel.getFirstVersionMap() != null && this.batchSynModel.getFirstVersionMap().get(orgTeamDy.getLong("id")) != null) {
                    structDy.set("orgteamhisid", this.batchSynModel.getFirstVersionMap().get(orgTeamDy.getLong("id")));
                } else {
                    structDy.set("orgteamhisid", (Object)orgTeamDy.getLong("id"));
                }
                structDy.set("otclassify", orgTeamDy.get("otclassify"));
                continue;
            }
            this.splitStructData(it, structDy, effectRange, structEffectRange, orgTeamIdToStructBoId);
            structDy.set("orgteamhisid", (Object)orgTeamDy.getLong("id"));
            structDy.set("otclassify", orgTeamDy.get("otclassify"));
            if (structEffectRange.encloses(effectRange)) {
                LocalDateRangeUtils.setEffectRange(structDy, effectRange);
                return;
            }
            LocalDateRangeUtils.setEffectRange(structDy, structEffectRange.intersection(effectRange));
        }
    }

    protected void beforeCreateValidVersion(List<DynamicObject> otList, List<DynamicObject> structList) {
        if (this.batchSynModel.getFirstVersionMap() != null) {
            Map boIdToVid = this.batchSynModel.getFirstVersionMap();
            DynamicObject[] ots = otList.toArray(new DynamicObject[0]);
            long[] firstVersionIds = new long[ots.length];
            Map[] customizedFiledValue = new Map[structList.size()];
            for (Map.Entry entry : boIdToVid.entrySet()) {
                int idx;
                Long boId = (Long)entry.getKey();
                Long vid = (Long)entry.getValue();
                for (idx = 0; idx < ots.length; ++idx) {
                    if (!boId.equals(ots[idx].getLong("id"))) continue;
                    firstVersionIds[idx] = vid;
                }
                for (idx = 0; idx < structList.size(); ++idx) {
                    if (!boId.equals(structList.get(idx).getLong("orgteam.id"))) continue;
                    HashMap<String, Long> map = new HashMap<String, Long>();
                    map.put("orgteamhisid", vid);
                    structList.get(idx).set("orgteamhisid", (Object)boId);
                    customizedFiledValue[idx] = map;
                }
            }
            AdminOrgHisServiceHelper.FIRST_VERSION_IDS.set(firstVersionIds);
            this.customizedFiledValue = Arrays.stream(customizedFiledValue).collect(Collectors.toList());
        }
    }

    private HisResponse<BatchVersionChangeRespData> getBatchVersionChangeRespDataHisResponse(List<HisVersionParamBo> validVersion) {
        HisVersionParamListBo validHisVersionParamListBo = new HisVersionParamListBo();
        validHisVersionParamListBo.setAtomicTrans(false);
        validHisVersionParamListBo.setEventId(Long.valueOf(this.batchSynModel.getEventId()));
        validHisVersionParamListBo.setListHisVersionParamBo(validVersion);
        HisResponse validHisResponse = HisModelController.getInstance().batchHisVersionChange(validHisVersionParamListBo);
        LOGGER.infoIfEnabled(() -> String.format("syn end with his response code:%s, errorMessage:%s", validHisResponse.getCode(), validHisResponse.getErrorMessage()));
        return validHisResponse;
    }

    private void synOtBoVsStructBo() {
        this.getNewOtBoVsStructBo().forEach((key, value) -> this.otBoVsStructBo.put((Long)key, (Long)value));
        IdCreator idCreator = new IdCreator();
        this.getNewList().forEach(ot -> this.otBoVsStructBo.putIfAbsent(ot.getLong("id"), idCreator.getId()));
    }

    private VersionModel createVersion(DynamicObject[] structs, DynamicObject[] ots, List<DynamicObject> otherStructList) {
        Function<DynamicObject[], Map> groupFunction = dyArr -> {
            if (((DynamicObject[])dyArr).length == 0) {
                return Collections.emptyMap();
            }
            return Arrays.stream(dyArr).collect(Collectors.groupingBy(dy -> this.date2999.equals(dy.getDate("bsled")), Collectors.toList()));
        };
        Map isValidVsOtList = groupFunction.apply(ots);
        Map isValidVsOtStructList = groupFunction.apply(structs);
        BiFunction<Map, Boolean, DynamicObject[]> getAndToArray = (isValidVsDyList, isValid) -> isValidVsDyList.getOrDefault(isValid, Collections.emptyList()).toArray(new DynamicObject[0]);
        VersionModel versionModel = new VersionModel();
        List<DynamicObject> effectingOTs = Arrays.stream((Object[])getAndToArray.apply(isValidVsOtList, true)).collect(Collectors.toList());
        List<DynamicObject> effectStructs = Arrays.stream((Object[])getAndToArray.apply(isValidVsOtStructList, true)).collect(Collectors.toList());
        this.beforeCreateValidVersion(effectingOTs, effectStructs);
        if (!CollectionUtils.isEmpty(otherStructList)) {
            effectStructs.addAll(otherStructList);
        }
        versionModel.validVersion.addAll(this.getListHisVersionParamBo(effectingOTs.toArray(new DynamicObject[0]), effectStructs.toArray(new DynamicObject[0]), this.customizedFiledValue));
        List<DynamicObject> invalidOTs = Arrays.stream((Object[])getAndToArray.apply(isValidVsOtList, false)).collect(Collectors.toList());
        List<DynamicObject> invalidStructs = Arrays.stream((Object[])getAndToArray.apply(isValidVsOtStructList, false)).collect(Collectors.toList());
        versionModel.invalidVersion.addAll(this.getListHisVersionParamBo(invalidOTs.toArray(new DynamicObject[0]), invalidStructs.toArray(new DynamicObject[0])));
        return versionModel;
    }

    private void calculateLevel(List<DynamicObject> structList) {
        int structNumberWithSeparatorLen = 13;
        for (DynamicObject struct : structList) {
            struct.set("level", (Object)((struct.getString("structlongnumber").length() + 1) / structNumberWithSeparatorLen));
        }
    }

    private void setDefaultValue(VersionModel versionModel) {
        Date now = new Date();
        versionModel.validVersion.forEach(hisVersionParamBo -> this.setDefaultValue(Arrays.asList(hisVersionParamBo.getHisDyns()), now));
        versionModel.invalidVersion.forEach(hisVersionParamBo -> this.setDefaultValue(Arrays.asList(hisVersionParamBo.getHisDyns()), now));
    }

    private void setDefaultValue(List<DynamicObject> dynamicObjectList, Date now) {
        dynamicObjectList.forEach(dy -> dy.set("createtime", (Object)now));
    }

    private List<HisVersionParamBo> getListHisVersionParamBo(DynamicObject[] ots, DynamicObject[] structs) {
        HisVersionParamBo structHisVersionParam;
        HisVersionParamBo otHisVersionParam;
        ArrayList<HisVersionParamBo> result = new ArrayList<HisVersionParamBo>();
        if (HRStringUtils.equals((String)"1", (String)this.batchSynModel.getCustomOrgStructFlag())) {
            otHisVersionParam = AdminOrgHisServiceHelper.getHisVersionParam(ots, "haos_cusadminorgteam", false);
            structHisVersionParam = AdminOrgHisServiceHelper.getHisVersionParam(structs, "haos_customotstruct", false);
        } else {
            otHisVersionParam = AdminOrgHisServiceHelper.getHisVersionParam(ots, "haos_adminorgteam", false);
            structHisVersionParam = AdminOrgHisServiceHelper.getHisVersionParam(structs, "haos_adminorgstructure", false);
        }
        structHisVersionParam.setNeedProcessAttachment(false);
        otHisVersionParam.setNeedProcessAttachment(false);
        Consumer<HisVersionParamBo> changeEntityConsumer = hisVersionParamBo -> hisVersionParamBo.setEntityNumber(hisVersionParamBo.getHisDyns()[0].getDataEntityType().getName());
        if (structHisVersionParam.getHisDyns().length != 0) {
            changeEntityConsumer.accept(structHisVersionParam);
            result.add(structHisVersionParam);
        }
        if (otHisVersionParam.getHisDyns().length != 0) {
            changeEntityConsumer.accept(otHisVersionParam);
            result.add(otHisVersionParam);
        }
        return result;
    }

    private List<HisVersionParamBo> getListHisVersionParamBo(DynamicObject[] ots, DynamicObject[] structs, List<Map<String, Object>> customizedFiledValue) {
        HisVersionParamBo structHisVersionParam;
        HisVersionParamBo otHisVersionParam;
        ArrayList<HisVersionParamBo> result = new ArrayList<HisVersionParamBo>();
        if (HRStringUtils.equals((String)"1", (String)this.batchSynModel.getCustomOrgStructFlag())) {
            otHisVersionParam = AdminOrgHisServiceHelper.getHisVersionParam(ots, "haos_cusadminorgteam", false);
            structHisVersionParam = AdminOrgHisServiceHelper.getHisVersionParam(structs, "haos_customotstruct", false, customizedFiledValue);
        } else {
            otHisVersionParam = AdminOrgHisServiceHelper.getHisVersionParam(ots, "haos_adminorgteam", false);
            structHisVersionParam = AdminOrgHisServiceHelper.getHisVersionParam(structs, "haos_adminorgstructure", false, customizedFiledValue);
        }
        structHisVersionParam.setNeedProcessAttachment(false);
        otHisVersionParam.setNeedProcessAttachment(false);
        Consumer<HisVersionParamBo> changeEntityConsumer = hisVersionParamBo -> hisVersionParamBo.setEntityNumber(hisVersionParamBo.getHisDyns()[0].getDataEntityType().getName());
        if (structHisVersionParam.getHisDyns().length != 0) {
            changeEntityConsumer.accept(structHisVersionParam);
            result.add(structHisVersionParam);
        }
        if (otHisVersionParam.getHisDyns().length != 0) {
            changeEntityConsumer.accept(otHisVersionParam);
            result.add(otHisVersionParam);
        }
        return result;
    }

    private CascadeResult calculateCascadeField() {
        List<OtCascadeBo> otCascadeBoList = this.getOtCascadeBoList();
        if (this.needCascade()) {
            MultiVersionTree multiVersionTree = MultiVersionTree.create(otCascadeBoList);
            multiVersionTree.traverse();
            return multiVersionTree.getResult();
        }
        return new CascadeResult();
    }

    private void initEffectDate() {
        for (List otList : Arrays.asList(this.getNewList(), this.getChgInfoList(), this.getChgParentList(), this.getStatusChgList())) {
            for (DynamicObject ot : otList) {
                if (ot.getDate("bsled") != null) continue;
                ot.set("bsled", (Object)this.date2999);
            }
        }
    }

    private List<OtCascadeBo> getOtCascadeBoList() {
        List<DynamicObject> hisStructList = this.getCascadeHisStruct();
        return hisStructList.stream().map(struct -> {
            String SLN = struct.getString("structlongnumber");
            OtCascadeBo otCascadeBo = new OtCascadeBo();
            otCascadeBo.setBo(struct.getLong("orgteam.id"));
            otCascadeBo.setParentBo(struct.getLong("parentorgteam.id"));
            otCascadeBo.setEffectRange(LocalDateRangeUtils.getEffectRange(struct));
            int i = SLN.lastIndexOf("!");
            otCascadeBo.setStructNumber(i != -1 ? SLN.substring(i + 1) : SLN);
            OtStructBo otStructBo = new OtStructBo();
            otStructBo.setVid(struct.getLong("id"));
            otStructBo.setEffectRange(LocalDateRangeUtils.getEffectRange(struct));
            otStructBo.setSLN(SLN);
            ArrayList<OtStructBo> otStructBoList = new ArrayList<OtStructBo>();
            otStructBoList.add(otStructBo);
            otCascadeBo.setOtStructBoList(otStructBoList);
            return otCascadeBo;
        }).collect(Collectors.toList());
    }

    private SceneVsCascadeResult groupCascadeResult(CascadeResult cascadeResult) {
        Set statusChgBoSet = this.getStatusChgList().stream().map(ot -> ot.getLong("boid")).collect(Collectors.toSet());
        Set infoChgBoSet = this.getChgInfoList().stream().map(ot -> ot.getLong("boid")).collect(Collectors.toSet());
        Set parentChgBoSet = this.getChgParentList().stream().map(ot -> ot.getLong("boid")).collect(Collectors.toSet());
        Set newBoSet = this.getNewList().stream().map(ot -> ot.getLong("boid")).collect(Collectors.toSet());
        SceneVsCascadeResult sceneVsCascadeResult = new SceneVsCascadeResult();
        cascadeResult.foreach((otBo, partBoList) -> {
            if (statusChgBoSet.contains(otBo)) {
                sceneVsCascadeResult.statusChgResult.put(otBo.longValue(), partBoList);
            } else if (infoChgBoSet.contains(otBo)) {
                sceneVsCascadeResult.infoChgResult.put(otBo.longValue(), partBoList);
            } else if (parentChgBoSet.contains(otBo)) {
                sceneVsCascadeResult.parentChgResult.put(otBo.longValue(), partBoList);
            } else if (newBoSet.contains(otBo)) {
                sceneVsCascadeResult.newResult.put(otBo.longValue(), partBoList);
            } else {
                sceneVsCascadeResult.cascadeResult.put(otBo.longValue(), partBoList);
            }
        });
        return sceneVsCascadeResult;
    }

    protected void setIsRootValue(DynamicObject structDy) {
        ChangeRootData changeRootData = this.batchSynModel.getChangeRootData();
        if (changeRootData == null) {
            return;
        }
        if (structDy.getLong("orgteam.id") == changeRootData.getOldRootId().longValue()) {
            structDy.set("isroot", (Object)Boolean.FALSE);
        }
    }

    private List<DynamicObject> overlapValue2DbDy(CascadeResult cascadeResult) {
        SceneVsCascadeResult sceneVsCascadeResult = this.groupCascadeResult(cascadeResult);
        Set<Long> structIdSet = cascadeResult.getBoVsPartCascadeBo().values().stream().flatMap(Collection::stream).map(PartBo::getVid).collect(Collectors.toSet());
        Map<Long, DynamicObject> idVsStruct = HRStringUtils.equals((String)"1", (String)this.batchSynModel.getCustomOrgStructFlag()) ? Arrays.stream(CustomOTStructRepository.getInstance().loadByIds(structIdSet)).collect(Collectors.toMap(struct -> struct.getLong("id"), obj -> obj)) : Arrays.stream(OTStructRepository.getInstance().loadByIds(structIdSet)).collect(Collectors.toMap(struct -> struct.getLong("id"), obj -> obj));
        ArrayList<DynamicObject> resultList = new ArrayList<DynamicObject>(idVsStruct.size());
        IdCreator idCreator = new IdCreator();
        for (CascadeResult subCascadeResult : Arrays.asList(sceneVsCascadeResult.cascadeResult, sceneVsCascadeResult.infoChgResult)) {
            for (List partBoList : subCascadeResult.getBoVsPartCascadeBo().values()) {
                for (PartBo partBo : partBoList) {
                    DynamicObject dbStruct = idVsStruct.get(partBo.getVid());
                    DynamicObject copy = OrgTeamBatchSynService.copy(dbStruct);
                    this.setDyFromStructBo(partBo, copy);
                    copy.set("sourcevid", (Object)partBo.getVid());
                    copy.set("id", (Object)idCreator.getId());
                    resultList.add(copy);
                }
            }
        }
        for (DynamicObject ot2 : this.getChgParentList()) {
            for (PartBo partBo : sceneVsCascadeResult.parentChgResult.get(ot2.getLong("boid"))) {
                DynamicObject sourceStruct;
                if (idVsStruct.containsKey(partBo.getVid())) {
                    sourceStruct = idVsStruct.get(partBo.getVid());
                    sourceStruct.set("parentorgteam", (Object)OrgTeamBatchSynService.genOt(ot2.getLong("parentid")));
                } else {
                    sourceStruct = this.createHisStruct4Save(Collections.singletonList(ot2)).get(0);
                }
                DynamicObject newStruct = OrgTeamBatchSynService.copy(sourceStruct);
                this.setDyFromStructBo(partBo, newStruct);
                newStruct.set("sourcevid", (Object)partBo.getVid());
                newStruct.set("id", (Object)idCreator.getId());
                String billEnable = ot2.getString("billenable");
                if (billEnable != null) {
                    newStruct.set("enable", (Object)billEnable);
                }
                this.setIsRootValue(newStruct);
                resultList.add(newStruct);
            }
        }
        for (DynamicObject ot2 : this.getChgInfoList()) {
            LocalDateRange newEffectRange;
            LocalDateRange dbStructEffectRange;
            DynamicObject dbStruct;
            String billEnable = ot2.getString("billenable");
            if (billEnable == null || HRStringUtils.equals((String)(dbStruct = HRStringUtils.equals((String)"1", (String)this.batchSynModel.getCustomOrgStructFlag()) ? CustomOTStructRepository.getInstance().loadCurrentHisVersionByOTBo(ot2.getLong("boid"), this.getStructProjectIdList4Query()) : OTStructRepository.getInstance().loadCurrentHisVersionByOTBo(ot2.getLong("boid"), this.getStructProjectIdList4Query())).getString("enable"), (String)billEnable)) continue;
            DynamicObject newStruct = OrgTeamBatchSynService.copy(dbStruct);
            LocalDateRange chgEffectRange = LocalDateRangeUtils.getEffectRange(ot2);
            if (chgEffectRange.encloses(dbStructEffectRange = LocalDateRangeUtils.getEffectRange(dbStruct))) {
                newEffectRange = dbStructEffectRange;
            } else {
                if (!chgEffectRange.overlaps(dbStructEffectRange)) continue;
                newEffectRange = dbStructEffectRange.intersection(chgEffectRange);
            }
            LocalDateRangeUtils.setEffectRange(newStruct, newEffectRange);
            newStruct.set("sourcevid", (Object)dbStruct.getString("id"));
            newStruct.set("id", (Object)idCreator.getId());
            newStruct.set("enable", (Object)billEnable);
            resultList.add(newStruct);
        }
        if (!this.isStatusChgEmpty()) {
            Optional<Date> earliestBsedOpt = this.getStatusChgList().stream().map(dy -> dy.getDate("bsed")).reduce((bsed, bsed2) -> bsed.before((Date)bsed2) ? bsed : bsed2);
            Date earliestBsed = earliestBsedOpt.get();
            DynamicObject[] structs4StatusChg = HRStringUtils.equals((String)"1", (String)this.batchSynModel.getCustomOrgStructFlag()) ? CustomOTStructRepository.getInstance().loadCurrentByOTBo(this.getStatusChgList().stream().map(ot -> ot.getLong("boid")).collect(Collectors.toSet()), earliestBsed, this.getStructProjectIdList4Query()) : OTStructRepository.getInstance().loadCurrentByOTBo(this.getStatusChgList().stream().map(ot -> ot.getLong("boid")).collect(Collectors.toSet()), earliestBsed, this.getStructProjectIdList4Query());
            Map<Long, List<DynamicObject>> otBoVsStruct = Arrays.stream(structs4StatusChg).collect(Collectors.groupingBy(struct -> struct.getLong("orgteam.id")));
            for (DynamicObject ot3 : this.getStatusChgList()) {
                DynamicObject dbStruct;
                ArrayList<DynamicObject> result = new ArrayList<DynamicObject>();
                long otBo = ot3.getLong("boid");
                List partBoList = sceneVsCascadeResult.statusChgResult.get(otBo);
                LocalDateRange chgEffectRange = LocalDateRangeUtils.getEffectRange(ot3);
                if (partBoList.size() == 0) {
                    List<DynamicObject> dbStructList = otBoVsStruct.get(otBo);
                    Iterator iterator = dbStructList.iterator();
                    while (iterator.hasNext()) {
                        LocalDateRange newEffectRange;
                        dbStruct = (DynamicObject)iterator.next();
                        LocalDateRange dbStructEffectRange = LocalDateRangeUtils.getEffectRange(dbStruct);
                        if (chgEffectRange.encloses(dbStructEffectRange)) {
                            newEffectRange = dbStructEffectRange;
                        } else {
                            if (!chgEffectRange.overlaps(dbStructEffectRange)) continue;
                            newEffectRange = dbStructEffectRange.intersection(chgEffectRange);
                        }
                        DynamicObject copy = OrgTeamBatchSynService.copy(dbStruct);
                        copy.set("id", (Object)idCreator.getId());
                        copy.set("enable", ot3.get("enable"));
                        LocalDateRangeUtils.setEffectRange(copy, newEffectRange);
                        result.add(copy);
                    }
                } else {
                    for (PartBo partBo : partBoList) {
                        dbStruct = idVsStruct.get(partBo.getVid());
                        DynamicObject copy = OrgTeamBatchSynService.copy(dbStruct);
                        copy.set("id", (Object)idCreator.getId());
                        if (chgEffectRange.encloses(partBo.getEffectRange())) {
                            copy.set("enable", ot3.get("enable"));
                            this.setDyFromStructBo(partBo, copy);
                        } else if (chgEffectRange.overlaps(partBo.getEffectRange())) {
                            DynamicObject copy2 = OrgTeamBatchSynService.copy(dbStruct);
                            copy2.set("id", (Object)idCreator.getId());
                            this.setDyFromStructBo(partBo, copy2);
                            LocalDateRangeUtils.setEffectRange(copy, LocalDateRange.of((LocalDate)partBo.getEffectRange().getStart(), (LocalDate)chgEffectRange.getStart()));
                            LocalDateRangeUtils.setEffectRange(copy2, chgEffectRange.intersection(partBo.getEffectRange()));
                            result.add(copy2);
                        }
                        result.add(copy);
                    }
                    List uncoverDateRangeList = chgEffectRange.subtract(partBoList.stream().map(PartBo::getEffectRange).collect(Collectors.toList()));
                    List<DynamicObject> dbStructList = otBoVsStruct.get(otBo);
                    for (DynamicObject dbStruct2 : dbStructList) {
                        LocalDateRange dbStructEffectRange = LocalDateRangeUtils.getEffectRange(dbStruct2);
                        for (LocalDateRange uncoverDateRange : uncoverDateRangeList) {
                            if (!uncoverDateRange.overlaps(dbStructEffectRange)) continue;
                            DynamicObject copy = OrgTeamBatchSynService.copy(dbStruct2);
                            copy.set("id", (Object)idCreator.getId());
                            copy.set("enable", ot3.get("enable"));
                            LocalDateRangeUtils.setEffectRange(copy, uncoverDateRange.intersection(dbStructEffectRange));
                            result.add(copy);
                        }
                    }
                }
                resultList.addAll(result);
            }
        }
        return resultList;
    }

    private List<DynamicObject> createNewStructList(CascadeResult cascadeResult) {
        IdCreator idCreator = new IdCreator();
        return this.getNewList().stream().filter(struct -> this.date2999.equals(struct.getDate("bsled"))).flatMap(ot -> {
            long otBo = ot.getLong("boid");
            List partBoList = cascadeResult.get(otBo);
            return partBoList.stream().map(partBo -> {
                DynamicObject newStruct = HRStringUtils.equals((String)"1", (String)this.batchSynModel.getCustomOrgStructFlag()) ? CustomOTStructRepository.getInstance().genEmptyDy() : OTStructRepository.getInstance().genEmptyDy();
                OrgTeamBatchSynService.synStructFromOt(ot, newStruct);
                this.setDyFromStructBo((PartBo)partBo, newStruct);
                if (this.date2999.equals(newStruct.getDate("bsled"))) {
                    newStruct.set("id", (Object)this.otBoVsStructBo.get(otBo));
                } else {
                    newStruct.set("id", (Object)idCreator.getId());
                    newStruct.set("boid", (Object)this.otBoVsStructBo.get(otBo));
                }
                return newStruct;
            });
        }).collect(Collectors.toList());
    }

    private DynamicObject buildRootStructDy() {
        DynamicObject ot = this.getNewList().get(0);
        long otBo = ot.getLong("boid");
        DynamicObject newStruct = HRStringUtils.equals((String)"1", (String)this.batchSynModel.getCustomOrgStructFlag()) ? CustomOTStructRepository.getInstance().genEmptyDy() : OTStructRepository.getInstance().genEmptyDy();
        OrgTeamBatchSynService.synStructFromOt(ot, newStruct);
        LocalDateRangeUtils.synEffectRange(ot, newStruct);
        newStruct.set("structlongnumber", ot.get("structnumber"));
        newStruct.set("boid", (Object)this.otBoVsStructBo.get(otBo));
        newStruct.set("id", (Object)this.otBoVsStructBo.get(otBo));
        newStruct.set("iscurrentversion", (Object)Boolean.TRUE);
        newStruct.set("isroot", (Object)Boolean.TRUE);
        return newStruct;
    }

    private List<DynamicObject> createNoParentNewStructList() {
        IdCreator idCreator = new IdCreator();
        return this.getNewList().stream().filter(ot -> ot.getLong("parentid") == 0L).map(ot -> {
            long otBo = ot.getLong("boid");
            DynamicObject newStruct = HRStringUtils.equals((String)"1", (String)this.batchSynModel.getCustomOrgStructFlag()) ? CustomOTStructRepository.getInstance().genEmptyDy() : OTStructRepository.getInstance().genEmptyDy();
            OrgTeamBatchSynService.synStructFromOt(ot, newStruct);
            LocalDateRangeUtils.synEffectRange(ot, newStruct);
            newStruct.set("structlongnumber", ot.get("structnumber"));
            newStruct.set("boid", (Object)this.otBoVsStructBo.get(otBo));
            newStruct.set("id", (Object)idCreator.getId());
            return newStruct;
        }).collect(Collectors.toList());
    }

    private void setDyFromStructBo(PartBo partBo, DynamicObject newStruct) {
        newStruct.set("bsed", (Object)LocalDateRangeUtils.getStartDate(partBo.getEffectRange()));
        newStruct.set("bsled", (Object)LocalDateRangeUtils.getEndInclusiveDate(partBo.getEffectRange()));
        newStruct.set("structlongnumber", (Object)((OtStructBo)partBo).getSLN());
    }

    private List<DynamicObject> removeVersion(List<DynamicObject> hisStructList) {
        ArrayList<DynamicObject> result = new ArrayList<DynamicObject>(hisStructList.size());
        Map<Long, List<DynamicObject>> otBoVsStructList = hisStructList.stream().collect(Collectors.groupingBy(dy -> dy.getLong("orgteam.id")));
        Map<Long, DynamicObject> chgParentOtBosVsOt = this.getChgParentList().stream().collect(Collectors.toMap(ot -> ot.getLong("boid"), obj -> obj));
        otBoVsStructList.forEach((otBo, structList) -> {
            if (chgParentOtBosVsOt.containsKey(otBo)) {
                DynamicObject ot = (DynamicObject)chgParentOtBosVsOt.get(otBo);
                if (structList.size() == 1) {
                    DynamicObject struct2 = (DynamicObject)structList.get(0);
                    LocalDateRange structRange = LocalDateRangeUtils.getEffectRange(struct2);
                    LocalDateRange otRange = LocalDateRangeUtils.getEffectRange(ot);
                    if (!otRange.encloses(structRange)) {
                        struct2.set("bsled", (Object)LocalDateRangeUtils.getDate(otRange.getStart().minusDays(1L)));
                        result.add(struct2);
                    }
                } else {
                    Collection<DynamicObject> duplicateDyCol = structList.stream().collect(Collectors.toMap(struct -> struct.getLong("id"), struct -> struct, (dy, dy2) -> dy)).values();
                    LocalDateRange effectRange = LocalDateRangeUtils.getEffectRange(ot);
                    for (DynamicObject struct3 : duplicateDyCol) {
                        LocalDateRange structEffectRange = LocalDateRangeUtils.getEffectRange(struct3);
                        if (effectRange.encloses(structEffectRange)) continue;
                        if (effectRange.overlaps(structEffectRange)) {
                            struct3.set("bsled", (Object)HRDateTimeUtils.addDay((Date)ot.getDate("bsed"), (long)-1L));
                            result.add(struct3);
                            continue;
                        }
                        result.add(struct3);
                    }
                }
            } else {
                result.addAll((Collection<DynamicObject>)structList);
            }
        });
        return result;
    }

    private List<DynamicObject> getCascadeHisStruct() {
        ArrayList<DynamicObject> structList = new ArrayList<DynamicObject>();
        DynamicObject[] hisStruct4Cascade = this.queryStruct4Cascade();
        this.recordOtBoVsStructBoMap(hisStruct4Cascade);
        structList.addAll(this.removeVersion(Arrays.asList(hisStruct4Cascade)));
        List<DynamicObject> newHisStruct4Cascade = this.createHisStruct4Cascade(this.getNewList());
        structList.addAll(newHisStruct4Cascade);
        structList.addAll(this.createHisStruct4Cascade(this.getChgParentList()));
        return structList;
    }

    private void recordOtBoVsStructBoMap(DynamicObject[] hisStruct4Cascade) {
        for (DynamicObject struct : hisStruct4Cascade) {
            this.otBoVsStructBo.put(struct.getLong("orgteam.id"), struct.getLong("boid"));
        }
    }

    private List<DynamicObject> createHisStruct4Cascade(List<DynamicObject> otList) {
        List<Object> result = Collections.emptyList();
        DynamicObjectType subDataEntityType = HRStringUtils.equals((String)"1", (String)this.batchSynModel.getCustomOrgStructFlag()) ? EntityMetadataCache.getSubDataEntityType((String)"haos_customotstruct", Arrays.asList("id", "orgteam", "parentorgteam", "structlongnumber", "bsed", "bsled")) : EntityMetadataCache.getSubDataEntityType((String)"haos_adminorgstructure", Arrays.asList("id", "orgteam", "parentorgteam", "structlongnumber", "bsed", "bsled"));
        IdCreator idCreator = new IdCreator();
        if (!CollectionUtils.isEmpty(otList)) {
            result = otList.stream().map(ot -> {
                DynamicObject struct = new DynamicObject(subDataEntityType);
                struct.set("id", (Object)idCreator.getId());
                struct.set("orgteam", (Object)OrgTeamBatchSynService.genOt(ot.getLong("boid")));
                struct.set("parentorgteam", (Object)OrgTeamBatchSynService.genOt(ot.getLong("parentid")));
                struct.set("bsed", ot.get("bsed"));
                struct.set("bsled", ot.get("bsled"));
                struct.set("structlongnumber", ot.get("structnumber"));
                return struct;
            }).collect(Collectors.toList());
        }
        return result;
    }

    private List<DynamicObject> createHisStruct4Save(List<DynamicObject> otList) {
        List<Object> result = Collections.emptyList();
        MainEntityType dataEntityType = HRStringUtils.equals((String)"1", (String)this.batchSynModel.getCustomOrgStructFlag()) ? MetadataServiceHelper.getDataEntityType((String)"haos_customotstruct") : MetadataServiceHelper.getDataEntityType((String)"haos_adminorgstructure");
        if (!CollectionUtils.isEmpty(otList)) {
            result = otList.stream().map(arg_0 -> this.lambda$createHisStruct4Save$58((DynamicObjectType)dataEntityType, arg_0)).collect(Collectors.toList());
        }
        return result;
    }

    private DynamicObject[] queryStruct4Cascade() {
        List<DynamicObject> otList;
        ArrayList<DynamicObject> resultList = new ArrayList<DynamicObject>();
        if (!this.isParentChgEmpty()) {
            otList = this.getChgParentList();
            Set otBoCascadeSet = otList.stream().map(dy -> dy.getLong("boid")).collect(Collectors.toSet());
            Set otPboCascadeSet = otList.stream().map(dy -> dy.getLong("parentid")).filter(bo -> bo != 0L).collect(Collectors.toSet());
            Optional<Date> earliestBsedOpt = otList.stream().map(dy -> dy.getDate("bsed")).reduce((bsed, bsed2) -> bsed.before((Date)bsed2) ? bsed : bsed2);
            Date earliestBsed = earliestBsedOpt.get();
            DynamicObject[] hisStruct4Cascade = HRStringUtils.equals((String)"1", (String)this.batchSynModel.getCustomOrgStructFlag()) ? CustomOTStructRepository.getInstance().queryOriginalHis4CascadeByOtBoAndStructProject(Stream.of(otBoCascadeSet, otPboCascadeSet).flatMap(Collection::stream).collect(Collectors.toSet()), earliestBsed, this.getStructProjectIdList4Query()) : OTStructRepository.getInstance().queryOriginalHis4CascadeByOtBoAndStructProject(Stream.of(otBoCascadeSet, otPboCascadeSet).flatMap(Collection::stream).collect(Collectors.toSet()), earliestBsed, this.getStructProjectIdList4Query());
            Map isParentVsSLN = Arrays.stream(hisStruct4Cascade).collect(Collectors.groupingBy(struct -> otPboCascadeSet.contains(struct.getLong("orgteam.id")), Collectors.mapping(struct -> struct.getString("structlongnumber"), Collectors.toSet())));
            if (HRStringUtils.equals((String)"1", (String)this.batchSynModel.getCustomOrgStructFlag())) {
                resultList.addAll(Arrays.asList(CustomOTStructRepository.getInstance().queryOriginalHisBySLNByStructProject(isParentVsSLN.getOrDefault(false, Collections.emptySet()), isParentVsSLN.getOrDefault(true, Collections.emptySet()), earliestBsed, this.getStructProjectIdList4Query())));
            } else {
                resultList.addAll(Arrays.asList(OTStructRepository.getInstance().queryOriginalHisBySLNByStructProject(isParentVsSLN.getOrDefault(false, Collections.emptySet()), isParentVsSLN.getOrDefault(true, Collections.emptySet()), earliestBsed, this.getStructProjectIdList4Query())));
            }
        }
        if (!this.isNewEmpty()) {
            otList = this.getNewList();
            Set<Long> otPboCascadeSet = otList.stream().map(dy -> dy.getLong("parentid")).filter(bo -> bo != 0L).collect(Collectors.toSet());
            Optional<Date> earliestBsedOpt = otList.stream().map(dy -> dy.getDate("bsed")).reduce((bsed, bsed2) -> bsed.before((Date)bsed2) ? bsed : bsed2);
            Date earliestBsed = earliestBsedOpt.get();
            if (HRStringUtils.equals((String)"1", (String)this.batchSynModel.getCustomOrgStructFlag())) {
                resultList.addAll(Arrays.asList(CustomOTStructRepository.getInstance().queryOriginalHisByOtBo(otPboCascadeSet, earliestBsed, this.getStructProjectIdList4Query())));
            } else {
                resultList.addAll(Arrays.asList(OTStructRepository.getInstance().queryOriginalHisByOtBo(otPboCascadeSet, earliestBsed, this.getStructProjectIdList4Query())));
            }
        }
        return resultList.stream().collect(Collectors.toMap(dy -> dy.getLong("id"), obj -> obj, (obj, obj2) -> obj)).values().toArray(new DynamicObject[0]);
    }

    private static void synStructFromOt(DynamicObject ot, DynamicObject struct) {
        String billEnable;
        struct.set("orgteam", (Object)OrgTeamBatchSynService.genOt(ot.getLong("boid")));
        struct.set("parentorgteam", (Object)OrgTeamBatchSynService.genOt(ot.getLong("parentid")));
        if (ot.getString("enable") != null) {
            struct.set("enable", ot.get("enable"));
        } else {
            struct.set("enable", (Object)"1");
        }
        if (ot.getDynamicObjectType().getProperty("billenable") != null && (billEnable = ot.getString("billenable")) != null) {
            struct.set("enable", (Object)billEnable);
        }
        struct.set("status", (Object)"C");
        struct.set("initstatus", (Object)"2");
        struct.set("initbatch", (Object)0L);
        struct.set("initdatasource", (Object)"0");
    }

    private static DynamicObject genOt(long bo) {
        DynamicObjectType subDataEntityType = EntityMetadataCache.getSubDataEntityType((String)"haos_cusadminorgteam", Arrays.asList("id", "boid"));
        DynamicObject ot = new DynamicObject(subDataEntityType);
        ot.set("id", (Object)bo);
        ot.set("boid", (Object)bo);
        return ot;
    }

    private static DynamicObject copy(DynamicObject from) {
        DynamicObject to = new DynamicObject(from.getDynamicObjectType());
        HRDynamicObjectUtils.copy((DynamicObject)from, (DynamicObject)to);
        return to;
    }

    public void setBatchSynModel(BatchSynModel batchSynModel) {
        this.batchSynModel = batchSynModel;
    }

    private boolean needCascade() {
        return !this.isParentChgEmpty() || !this.isNewEmpty();
    }

    private boolean isParentChgEmpty() {
        return CollectionUtils.isEmpty((Collection)this.batchSynModel.getChgParentList());
    }

    private boolean isInfoChgEmpty() {
        return CollectionUtils.isEmpty((Collection)this.batchSynModel.getChgInfoList());
    }

    private boolean isNewEmpty() {
        return CollectionUtils.isEmpty((Collection)this.batchSynModel.getNewList());
    }

    private boolean isStatusChgEmpty() {
        return CollectionUtils.isEmpty((Collection)this.batchSynModel.getStatusChgList());
    }

    private Map<Long, Long> getNewOtBoVsStructBo() {
        return this.batchSynModel.getNewOtBoVsStructBo() != null ? this.batchSynModel.getNewOtBoVsStructBo() : Collections.emptyMap();
    }

    private List<DynamicObject> getNewList() {
        return this.getNonNullOrEmptyList(this.batchSynModel.getNewList());
    }

    private List<DynamicObject> getChgParentList() {
        return this.getNonNullOrEmptyList(this.batchSynModel.getChgParentList());
    }

    private List<DynamicObject> getChgInfoList() {
        return this.getNonNullOrEmptyList(this.batchSynModel.getChgInfoList());
    }

    private List<DynamicObject> getStatusChgList() {
        return this.getNonNullOrEmptyList(this.batchSynModel.getStatusChgList());
    }

    private List<DynamicObject> getSaveList() {
        return this.getNonNullOrEmptyList(this.batchSynModel.getSaveList());
    }

    private List<DynamicObject> getNonNullOrEmptyList(List<DynamicObject> dynamicObjectList) {
        return dynamicObjectList == null ? Collections.emptyList() : dynamicObjectList;
    }

    private boolean isNotSynOt() {
        return this.notSynOt;
    }

    private DynamicObject getStructProject() {
        if (this.structProjectDy == null) {
            this.structProjectDy = StructProjectRepository.getInstance().loadByIds(Collections.singletonList(this.batchSynModel.getStrucrProjectId()))[0];
        }
        return this.structProjectDy;
    }

    private List<Long> getStructProjectIdList4Query() {
        long id = this.getStructProject().getLong("id");
        long relyOnStructProjectId = this.getStructProject().getLong("relyonstructproject.id");
        if (id == 1010L) {
            return Arrays.asList(1010L, 1020L, 1030L);
        }
        return Arrays.asList(id, relyOnStructProjectId);
    }

    private /* synthetic */ DynamicObject lambda$createHisStruct4Save$58(DynamicObjectType dataEntityType, DynamicObject ot) {
        long otBo = ot.getLong("boid");
        DynamicObject struct = new DynamicObject(dataEntityType);
        struct.set("boid", (Object)this.otBoVsStructBo.get(otBo));
        OrgTeamBatchSynService.synStructFromOt(ot, struct);
        return struct;
    }

    static class VersionModel {
        List<HisVersionParamBo> validVersion = new ArrayList<HisVersionParamBo>();
        List<HisVersionParamBo> invalidVersion = new ArrayList<HisVersionParamBo>();

        VersionModel() {
        }
    }

    static class SceneVsCascadeResult {
        CascadeResult newResult = new CascadeResult();
        CascadeResult parentChgResult = new CascadeResult();
        CascadeResult infoChgResult = new CascadeResult();
        CascadeResult statusChgResult = new CascadeResult();
        CascadeResult cascadeResult = new CascadeResult();

        SceneVsCascadeResult() {
        }
    }
}

