/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.business.service.otherstruct;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.orm.ORM;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.hr.haos.business.domain.repository.adorg.AdOrgRepository;
import kd.hr.haos.business.domain.repository.adorg.AdminOrgStructRepository;
import kd.hr.haos.business.domain.repository.adorg.OrgBusinessFileRepository;
import kd.hr.haos.business.domain.repository.orgteam.OTQueryRepository;
import kd.hr.haos.business.service.adminorg.AdminOrgHisDynKey;
import kd.hr.haos.business.service.adminorg.AdminOrgHisServiceHelper;
import kd.hr.haos.business.service.adminorg.bean.OrgTeamBasicInfoBO;
import kd.hr.haos.business.service.adminorg.businessfile.AdminOrgBusinessFileService;
import kd.hr.haos.business.service.orgteam.OrgTeamSynService;
import kd.hr.haos.business.service.orgteam.OtherTeamStructService;
import kd.hr.haos.business.service.orgteam.model.OtCascadeBo;
import kd.hr.haos.business.service.orgteam.model.OtStructBo;
import kd.hr.haos.business.service.otherstruct.model.OtherStructEntity;
import kd.hr.haos.business.service.otherstruct.model.OtherStructVO;
import kd.hr.haos.business.util.HAOSDynamicObjectUtil;
import kd.hr.haos.business.util.IdCreator;
import kd.hr.haos.business.util.LocalDateRangeUtils;
import kd.hr.haos.business.util.OtherStructSplitUtil;
import kd.hr.haos.business.util.cascade.MultiVersionTree;
import kd.hr.haos.common.constants.changetransaction.ChangeTransactionConstants;
import kd.hr.haos.common.model.cascade.CascadeResult;
import kd.hr.haos.common.model.cascade.PartBo;
import kd.hr.haos.common.util.OrgDateTimeUtil;
import kd.hr.hbp.business.application.impl.newhismodel.HisModelController;
import kd.hr.hbp.business.domain.model.newhismodel.HisVersionParamBo;
import kd.hr.hbp.business.domain.model.newhismodel.HisVersionParamListBo;
import kd.hr.hbp.common.constants.newhismodel.EnumHisDataVersionStatus;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;

public class OtherStructService {
    private IdCreator idCreator;
    private final OtherStructEntity otherStructEntity;
    private Set<Long> deleteOrgSet;
    private Map<Long, Long> firstIdMap;

    public OtherStructService() {
        this(null);
    }

    public OtherStructService(OtherStructEntity otherStructEntity) {
        this.otherStructEntity = otherStructEntity;
    }

    public void saveOtherStruct() {
        if (this.otherStructEntity.getDeleteAll().booleanValue()) {
            this.deleteByFilter();
        } else {
            this.buildEnablingOtherStructVO();
        }
        this.idCreator = new IdCreator();
        this.otherStructEntity.setEventId(this.idCreator.getId());
        Map<Boolean, List<DynamicObject>> virtualMap = this.buildVirtualData();
        List<DynamicObject> enablingList = null;
        if (this.otherStructEntity.getDeleteFlag().booleanValue()) {
            enablingList = virtualMap.remove(Boolean.FALSE);
            this.modifyBusinessFile(enablingList);
        }
        Map<Long, DynamicObject> orgMap = this.getAddAndParentChangeOrgMap();
        if (!CollectionUtils.isEmpty((Collection)virtualMap.get(Boolean.TRUE))) {
            virtualMap.get(Boolean.TRUE).forEach(dy -> orgMap.put(dy.getLong("id"), (DynamicObject)dy));
        }
        List<DynamicObject> structList = this.buildData(orgMap);
        Map<Boolean, List<DynamicObject>> map = this.buildMap(structList, this.otherStructEntity.getStructProjectId());
        Map<Boolean, List<DynamicObject>> businessFileMap = this.buildBusinessFileMap(virtualMap);
        this.batchHisVersionChange(this.buildParamBoList(map.get(Boolean.TRUE), virtualMap.get(Boolean.TRUE), businessFileMap.get(Boolean.TRUE), true));
        this.batchHisVersionChange(this.buildParamBoList(map.get(Boolean.FALSE), virtualMap.get(Boolean.FALSE), businessFileMap.get(Boolean.FALSE), false));
        Map<Long, Date> esDateBoIdMap = orgMap.values().stream().collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy.getDate("establishmentdate")));
        OtherTeamStructService otherTeamStructService = new OtherTeamStructService(this.otherStructEntity, esDateBoIdMap);
        this.setOtServiceValues(otherTeamStructService, virtualMap, enablingList);
        otherTeamStructService.saveOtherTeamStruct();
    }

    private void buildEnablingOtherStructVO() {
        if (!this.otherStructEntity.getDeleteFlag().booleanValue()) {
            return;
        }
        List<OtherStructVO> otherStructList = this.otherStructEntity.getOtherStructList();
        if (CollectionUtils.isEmpty(otherStructList)) {
            return;
        }
        Long structProjectId = this.otherStructEntity.getStructProjectId();
        Date effectDate = HRDateTimeUtils.getNowDate();
        Set<Long> parentChangeSet = otherStructList.stream().filter(vo -> ChangeTransactionConstants.PARENT.equals(vo.getChangeTypeId())).map(OtherStructVO::getOrgId).collect(Collectors.toSet());
        DynamicObjectCollection structLongNumberCol = AdminOrgStructRepository.getInstance().queryHisColByBoDate(parentChangeSet, effectDate, OrgDateTimeUtil.BSLED, structProjectId);
        Set<String> likeSet = structLongNumberCol.stream().map(struct -> struct.getString("structlongnumber")).collect(Collectors.toSet());
        DynamicObjectCollection structCol = AdminOrgStructRepository.getInstance().queryHisColBySLN(likeSet, Collections.emptySet(), effectDate, OrgDateTimeUtil.BSLED, structProjectId);
        Map<Long, Long> map = structCol.stream().collect(Collectors.toMap(dy -> dy.getLong("adminorg.id"), dy -> dy.getLong("parentorg.id")));
        ArrayList<OtherStructVO> list = new ArrayList<OtherStructVO>(otherStructList.size());
        HashSet<Long> deleteOrgSet = new HashSet<Long>(otherStructList.size());
        HashSet structOrgSet = Sets.newHashSet(map.keySet());
        for (OtherStructVO vo2 : otherStructList) {
            map.remove(vo2.getOrgId());
            if (ChangeTransactionConstants.DISABLE.equals(vo2.getChangeTypeId())) {
                deleteOrgSet.add(vo2.getOrgId());
                continue;
            }
            list.add(new OtherStructVO(vo2.getOrgId(), ChangeTransactionConstants.ADD, vo2.getParentId()));
        }
        map.forEach((key, value) -> list.add(new OtherStructVO((Long)key, ChangeTransactionConstants.ADD, (Long)value)));
        structOrgSet.addAll(deleteOrgSet);
        if (!CollectionUtils.isEmpty((Collection)structOrgSet)) {
            List<DynamicObject> dyList = this.otherStructEntity.getDyList();
            if (!CollectionUtils.isEmpty(dyList)) {
                dyList.removeIf(dy -> deleteOrgSet.contains(dy.getLong("orgid")));
            }
            OrgBusinessFileRepository.getInstance().deleteVirtualByOrgSet(deleteOrgSet);
            AdOrgRepository.getInstance().deleteVirtualOrgByOrgSet(deleteOrgSet);
            AdminOrgStructRepository.getInstance().deleteByStructProjectOrg(structProjectId, structOrgSet);
            new OtherTeamStructService().deleteByOrgSet(structProjectId, deleteOrgSet, structOrgSet);
        }
        this.otherStructEntity.setOtherStructList(list);
    }

    public void enabledByStructProject(Set<Long> structProjectSet) {
        this.enabledByStructProjectAndOrg(structProjectSet, null);
    }

    public void enabledByStructProjectAndOrg(Set<Long> structProjectSet, Set<Long> orgSet) {
        DynamicObject[] array;
        if (CollectionUtils.isEmpty(structProjectSet)) {
            return;
        }
        for (DynamicObject dy : array = AdminOrgStructRepository.getInstance().queryByStructProjectAndOrg("id,enable", structProjectSet, orgSet)) {
            dy.set("enable", (Object)"1");
        }
        AdminOrgStructRepository.getInstance().save(array);
        new OtherTeamStructService().enabledByStructProjectAndOrg(structProjectSet, orgSet);
    }

    public void deleteByStructProject(Set<Long> structProjectSet) {
        if (CollectionUtils.isEmpty(structProjectSet)) {
            return;
        }
        this.deleteVirtualOrgSet(structProjectSet, null);
        AdminOrgStructRepository.getInstance().deleteByStructProjectNotOrg(structProjectSet, null);
        OtherTeamStructService service = new OtherTeamStructService();
        service.setRelateOrgSet(this.deleteOrgSet);
        service.deleteByStructProject(structProjectSet);
    }

    private Map<Boolean, List<DynamicObject>> buildMap(List<DynamicObject> structList, Long structProjectId) {
        DynamicObject structProject = HAOSDynamicObjectUtil.newDy("haos_structure", structProjectId);
        DynamicObject creatorDy = BusinessDataServiceHelper.newDynamicObject((String)"bos_user");
        creatorDy.set("id", (Object)RequestContext.get().getCurrUserId());
        Date date = new Date();
        return structList.stream().peek(dy -> {
            HAOSDynamicObjectUtil.setInitFields(dy);
            if (dy.getDate("bsled").compareTo(OrgDateTimeUtil.BSLED) != 0) {
                dy.set("iscurrentversion", (Object)Boolean.FALSE);
            }
            if (dy.getBoolean("iscurrentversion")) {
                dy.set("id", (Object)dy.getLong("boid"));
            } else {
                dy.set("id", (Object)this.idCreator.getId());
            }
            dy.set("structproject", (Object)structProject);
            dy.set("createtime", (Object)date);
            dy.set("creator", (Object)creatorDy);
        }).collect(Collectors.groupingBy(dy -> dy.getBoolean("iscurrentversion")));
    }

    private List<DynamicObject> buildData(Map<Long, DynamicObject> orgMap) {
        Map<Long, Long> parentChangeMap = this.otherStructEntity.getOtherStructByType(ChangeTransactionConstants.PARENT).stream().collect(Collectors.toMap(OtherStructVO::getOrgId, OtherStructVO::getParentId));
        Set<Long> parentChangeOrgSet = parentChangeMap.keySet();
        Date effectDate = this.otherStructEntity.getEffectDate();
        Long structProjectId = this.otherStructEntity.getStructProjectId();
        DynamicObjectCollection structLongNumberCol = AdminOrgStructRepository.getInstance().queryHisColByBoDate(orgMap.keySet(), effectDate, OrgDateTimeUtil.BSLED, structProjectId);
        Map booleanMap = structLongNumberCol.stream().collect(Collectors.groupingBy(struct -> parentChangeOrgSet.contains(struct.getLong("adminorg.id")), Collectors.mapping(struct -> struct.getString("structlongnumber"), Collectors.toSet())));
        DynamicObjectCollection structCol = AdminOrgStructRepository.getInstance().queryHisColBySLN(booleanMap.get(Boolean.TRUE), booleanMap.get(Boolean.FALSE), effectDate, OrgDateTimeUtil.BSLED, structProjectId);
        if (!CollectionUtils.isEmpty(parentChangeOrgSet)) {
            this.setParentChangeValue(structCol, parentChangeMap, orgMap);
        }
        List<DynamicObject> addStructList = this.buildAddStruct(orgMap);
        CascadeResult cascadeResult = this.getCascadeResult(Stream.of(addStructList, structCol).flatMap(Collection::stream).collect(Collectors.toList()));
        List<DynamicObject> structList = this.buildStructChangeData(parentChangeMap, cascadeResult, addStructList);
        OtherStructSplitUtil.addStatusChangeList(this.otherStructEntity, structList, false);
        addStructList.stream().filter(dy -> dy.get("parentorg") == null).forEach(structList::add);
        return structList;
    }

    private Map<Long, DynamicObject> getAddAndParentChangeOrgMap() {
        List<OtherStructVO> voList = this.otherStructEntity.getOtherStructList();
        HashSet<Long> orgSet = new HashSet<Long>(16);
        voList.forEach(vo -> {
            if (ChangeTransactionConstants.ADD.equals(vo.getChangeTypeId()) || ChangeTransactionConstants.PARENT.equals(vo.getChangeTypeId())) {
                orgSet.add(vo.getOrgId());
                if (vo.getParentId() != null) {
                    orgSet.add(vo.getParentId());
                }
            }
        });
        Map<Long, DynamicObject> orgMap = AdOrgRepository.getInstance().queryOriginalColByPks("id,boid,establishmentdate,structnumber", orgSet).stream().collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy));
        if (this.otherStructEntity.getDeleteFlag().booleanValue() && this.otherStructEntity.getDeleteAll().booleanValue()) {
            return orgMap;
        }
        DynamicObjectCollection col = AdminOrgStructRepository.getInstance().queryColByOrgAndStructProject("adminorg.id,firstbsed", orgSet, this.otherStructEntity.getStructProjectId());
        col.forEach(structDy -> {
            DynamicObject orgDy = (DynamicObject)orgMap.get(structDy.getLong("adminorg.id"));
            if (orgDy != null) {
                orgDy.set("establishmentdate", (Object)structDy.getDate("firstbsed"));
            }
        });
        return orgMap;
    }

    private List<DynamicObject> buildStructChangeData(Map<Long, Long> parentIdMap, CascadeResult cascadeResult, List<DynamicObject> addStructList) {
        Set<Long> idSet = cascadeResult.getBoVsPartCascadeBo().values().stream().flatMap(Collection::stream).map(PartBo::getVid).collect(Collectors.toSet());
        DynamicObject[] structArray = AdminOrgStructRepository.getInstance().loadByIds(idSet);
        Map<Long, DynamicObject> map = Stream.concat(Arrays.stream(structArray), addStructList.stream()).collect(Collectors.toMap(struct -> struct.getLong("id"), obj -> obj));
        return cascadeResult.getBoVsPartCascadeBo().values().stream().flatMap(Collection::stream).map(partBo -> {
            OtStructBo structBo = (OtStructBo)((Object)partBo);
            DynamicObject hisDy = (DynamicObject)map.get(structBo.getVid());
            DynamicObject newDy = new DynamicObject(hisDy.getDynamicObjectType());
            HRDynamicObjectUtils.copy((DynamicObject)hisDy, (DynamicObject)newDy);
            LocalDateRangeUtils.setEffectRange(newDy, partBo.getEffectRange());
            newDy.set("id", (Object)structBo.getVid());
            newDy.set("structlongnumber", (Object)structBo.getSLN());
            Long parentId = (Long)parentIdMap.get(hisDy.getLong("adminorg.id"));
            if (parentId != null) {
                newDy.set("parentorg", (Object)HAOSDynamicObjectUtil.newDy(AdminOrgHisDynKey.ADMIN_ORG_KEY.getDynKey(), parentId));
                newDy.set("enable", (Object)this.otherStructEntity.getEnable());
            }
            newDy.set("level", (Object)structBo.getSLN().split("!").length);
            return newDy;
        }).collect(Collectors.toList());
    }

    private CascadeResult getCascadeResult(List<DynamicObject> allStructList) {
        List cascadeBoList = allStructList.stream().map(structDy -> {
            String structLongNumber = structDy.getString("structlongnumber");
            OtCascadeBo cascadeBo = new OtCascadeBo();
            cascadeBo.setBo(structDy.getLong("adminorg.id"));
            cascadeBo.setParentBo(structDy.getLong("parentorg.id"));
            cascadeBo.setEffectRange(LocalDateRangeUtils.getEffectRange(structDy));
            int index = structLongNumber.lastIndexOf("!");
            cascadeBo.setStructNumber(index != -1 ? structLongNumber.substring(index + 1) : structLongNumber);
            OtStructBo structBo = new OtStructBo();
            structBo.setVid(structDy.getLong("id"));
            structBo.setEffectRange(cascadeBo.getEffectRange());
            structBo.setSLN(structLongNumber);
            ArrayList<OtStructBo> structBoList = new ArrayList<OtStructBo>();
            structBoList.add(structBo);
            cascadeBo.setOtStructBoList(structBoList);
            return cascadeBo;
        }).collect(Collectors.toList());
        MultiVersionTree multiVersionTree = MultiVersionTree.create(cascadeBoList);
        multiVersionTree.traverse();
        return multiVersionTree.getResult();
    }

    private void setParentChangeValue(DynamicObjectCollection structCol, Map<Long, Long> parentChangeMap, Map<Long, DynamicObject> orgMap) {
        Set<Long> parentChangeOrgSet = parentChangeMap.keySet();
        Date effectDate = this.otherStructEntity.getEffectDate();
        structCol.stream().filter(dy -> parentChangeOrgSet.contains(dy.getLong("adminorg.id"))).forEach(dy -> {
            Long parentId = (Long)parentChangeMap.get(dy.getLong("adminorg.id"));
            dy.set("parentorg.id", (Object)parentId);
            Date date = this.getTruncateDate(effectDate, ((DynamicObject)orgMap.get(parentId)).getDate("establishmentdate"));
            if (dy.getDate("bsed").compareTo(date) < 0) {
                dy.set("bsed", (Object)date);
            }
        });
    }

    private List<DynamicObject> buildAddStruct(Map<Long, DynamicObject> orgMap) {
        List<OtherStructVO> addList = this.otherStructEntity.getOtherStructByType(ChangeTransactionConstants.ADD);
        Date effectDate = this.otherStructEntity.getEffectDate();
        String enable = this.otherStructEntity.getEnable();
        ArrayList<DynamicObject> addStructList = new ArrayList<DynamicObject>(addList.size());
        addList.forEach(addVO -> {
            DynamicObject parentOrgDy = (DynamicObject)orgMap.get(addVO.getParentId());
            DynamicObject orgDy = (DynamicObject)orgMap.get(addVO.getOrgId());
            DynamicObject structDy = HAOSDynamicObjectUtil.newDy(AdminOrgHisDynKey.ADMIN_STRUCT_KEY.getDynKey(), this.idCreator.getId());
            structDy.set("boid", (Object)structDy.getLong("id"));
            Date startDate = this.getTruncateDate(effectDate, orgDy.getDate("establishmentdate"));
            structDy.set("enable", (Object)enable);
            structDy.set("adminorg", (Object)HAOSDynamicObjectUtil.newDy(AdminOrgHisDynKey.ADMIN_ORG_KEY.getDynKey(), addVO.getOrgId()));
            structDy.set("iscurrentversion", (Object)Boolean.TRUE);
            structDy.set("bsed", (Object)startDate);
            structDy.set("bsled", (Object)OrgDateTimeUtil.BSLED);
            structDy.set("parentorg", (Object)HAOSDynamicObjectUtil.newDy(AdminOrgHisDynKey.ADMIN_ORG_KEY.getDynKey(), addVO.getParentId()));
            structDy.set("structlongnumber", (Object)orgDy.getString("structnumber"));
            structDy.set("level", (Object)1);
            structDy.set("isroot", (Object)"0");
            addStructList.add(structDy);
            if (parentOrgDy != null) {
                Date parentDate = this.getTruncateDate(effectDate, parentOrgDy.getDate("establishmentdate"));
                if (startDate.compareTo(parentDate) < 0) {
                    DynamicObject newDy = new DynamicObject(structDy.getDynamicObjectType());
                    HRDynamicObjectUtils.copy((DynamicObject)structDy, (DynamicObject)newDy);
                    newDy.set("parentorg", null);
                    newDy.set("id", (Object)this.idCreator.getId());
                    newDy.set("bsled", (Object)HRDateTimeUtils.addDay((Date)parentDate, (long)-1L));
                    structDy.set("bsed", (Object)parentDate);
                    addStructList.add(newDy);
                }
            } else {
                structDy.set("isroot", (Object)"1");
            }
        });
        return addStructList;
    }

    private void deleteByFilter() {
        if (!this.otherStructEntity.getDeleteFlag().booleanValue()) {
            return;
        }
        HashSet set = Sets.newHashSet((Object[])new Long[]{this.otherStructEntity.getStructProjectId()});
        Long rootOrgId = this.otherStructEntity.getRootOrgId();
        if (this.otherStructEntity.isIncludeVirtual()) {
            Set<Long> orgSet = this.otherStructEntity.getOtherStructList().stream().map(OtherStructVO::getOrgId).collect(Collectors.toSet());
            if (rootOrgId != null) {
                orgSet.add(rootOrgId);
            }
            this.deleteVirtualOrgSet(set, orgSet);
        }
        AdminOrgStructRepository.getInstance().deleteByStructProjectNotOrg(set, rootOrgId);
    }

    private void deleteVirtualOrgSet(Set<Long> structProjectSet, Set<Long> orgSet) {
        DynamicObjectCollection col = AdminOrgStructRepository.getInstance().queryOrgByStructProjectNotOrg("adminorg", structProjectSet, orgSet);
        this.deleteOrgSet = col.stream().map(dy -> dy.getLong("adminorg")).collect(Collectors.toSet());
        if (!CollectionUtils.isEmpty(this.deleteOrgSet)) {
            OrgBusinessFileRepository.getInstance().deleteVirtualByOrgSet(this.deleteOrgSet);
            AdOrgRepository.getInstance().deleteVirtualOrgByOrgSet(this.deleteOrgSet);
        }
    }

    private void setOtServiceValues(OtherTeamStructService service, Map<Boolean, List<DynamicObject>> virtualMap, List<DynamicObject> enablingList) {
        List<DynamicObject> orgList = virtualMap.get(Boolean.FALSE);
        HashMap<Boolean, List<DynamicObject>> otMap = new HashMap<Boolean, List<DynamicObject>>(2);
        String orgTeamNumberPrefix = OrgTeamSynService.getOrgTeamNumberPrefix(1010L);
        if (!CollectionUtils.isEmpty(orgList)) {
            otMap.put(Boolean.FALSE, this.buildChangedOtData(orgList, orgTeamNumberPrefix));
        }
        if (!CollectionUtils.isEmpty(orgList = virtualMap.get(Boolean.TRUE))) {
            OrgTeamBasicInfoBO orgTeamBasicInfoBO = new OrgTeamBasicInfoBO(1010L, 1010L, 1010L, 1010L, "adminorg.id", "parentorg");
            List otList = orgList.stream().map(orgDy -> {
                DynamicObject otDy = OrgTeamSynService.getInstance().createAddNewOrgTeam((DynamicObject)orgDy, orgTeamBasicInfoBO, orgTeamNumberPrefix);
                otDy.set("boid", orgDy.get("boid"));
                return otDy;
            }).collect(Collectors.toList());
            otMap.put(Boolean.TRUE, otList);
        }
        service.setOtMap(otMap);
        service.setFirstIdMap(this.firstIdMap);
        service.setRelateOrgSet(this.deleteOrgSet);
        if (!CollectionUtils.isEmpty(enablingList)) {
            service.setEnablingOtList(this.buildEnablingOtData(enablingList, orgTeamNumberPrefix));
        }
    }

    private Collection<DynamicObject> buildEnablingOtData(List<DynamicObject> orgList, String orgTeamNumberPrefix) {
        List<Long> idList = orgList.stream().map(orgDy -> orgDy.getLong("id")).collect(Collectors.toList());
        Map<Long, DynamicObject> orgTeamMap = Arrays.stream(OTQueryRepository.getInstance().loadByIds(idList)).collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy));
        orgList.forEach(orgDy -> {
            DynamicObject orgTeam = (DynamicObject)orgTeamMap.get(orgDy.getLong("id"));
            if (orgTeam == null) {
                throw new KDBizException("no find orgTeam data---orgTeamId=" + orgDy.getLong("boid"));
            }
            orgTeam.set("createtime", (Object)orgDy.getDate("createtime"));
            orgTeam.set("firstbsed", orgDy.get("firstbsed"));
            OrgTeamSynService.getInstance().synOrgTeamBizFields(orgTeam, (DynamicObject)orgDy, orgTeamNumberPrefix);
        });
        return orgTeamMap.values();
    }

    private List<DynamicObject> buildChangedOtData(List<DynamicObject> orgList, String orgTeamNumberPrefix) {
        List<Long> orgIdList = orgList.stream().map(orgDy -> orgDy.getLong("boid")).collect(Collectors.toList());
        Map<Long, DynamicObject> orgTeamMap = Arrays.stream(OTQueryRepository.getInstance().loadByIds(orgIdList)).collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy));
        MainEntityType dynamicObjectType = EntityMetadataCache.getDataEntityType((String)"haos_adminorgteam");
        return orgList.stream().map(arg_0 -> OtherStructService.lambda$buildChangedOtData$34(orgTeamMap, (DynamicObjectType)dynamicObjectType, orgTeamNumberPrefix, arg_0)).collect(Collectors.toList());
    }

    private Map<Boolean, List<DynamicObject>> buildVirtualData() {
        HashMap<Long, DynamicObject> dyMap;
        List<DynamicObject> dyList = this.otherStructEntity.getDyList();
        Map<Long, DynamicObject> map = dyMap = dyList == null ? new HashMap<Long, DynamicObject>() : dyList.stream().collect(Collectors.toMap(dy -> dy.getLong("orgid"), dy -> dy));
        if (this.otherStructEntity.getDeleteFlag().booleanValue()) {
            if (CollectionUtils.isEmpty(dyList)) {
                return new HashMap<Boolean, List<DynamicObject>>();
            }
            return this.buildEnablingData(dyMap);
        }
        return this.buildEnabledData(dyMap);
    }

    private void modifyBusinessFile(List<DynamicObject> orgDyList) {
        DynamicObject[] businessFileDys;
        if (CollectionUtils.isEmpty(orgDyList)) {
            return;
        }
        Map<Long, DynamicObject> orgMap = orgDyList.stream().collect(Collectors.toMap(dy -> dy.getLong("boid"), dy -> dy, (key1, key2) -> key1));
        for (DynamicObject businessFileDy : businessFileDys = OrgBusinessFileRepository.getInstance().queryDysByOrg("id,adminorg.id,bsed,org,enable", orgMap.keySet())) {
            DynamicObject orgDy = orgMap.get(businessFileDy.getLong("adminorg.id"));
            if (orgDy == null) continue;
            businessFileDy.set("org", orgDy.get("org"));
            businessFileDy.set("bsed", orgDy.get("bsed"));
            businessFileDy.set("enable", orgDy.get("enable"));
        }
        OrgBusinessFileRepository.getInstance().save(businessFileDys);
    }

    private Map<Boolean, List<DynamicObject>> buildBusinessFileMap(Map<Boolean, List<DynamicObject>> virtualMap) {
        ArrayList<DynamicObject> businessFileList;
        HashMap<Boolean, List<DynamicObject>> buildMap = new HashMap<Boolean, List<DynamicObject>>(2);
        List<DynamicObject> orgDyList = virtualMap.get(Boolean.TRUE);
        if (!CollectionUtils.isEmpty(orgDyList)) {
            businessFileList = new ArrayList<DynamicObject>(orgDyList.size());
            buildMap.put(Boolean.TRUE, businessFileList);
            for (DynamicObject orgDy : orgDyList) {
                DynamicObject businessFileDy = AdminOrgBusinessFileService.createAddNewBusinessFile(orgDy);
                businessFileDy.set("iscurrentversion", (Object)Boolean.TRUE);
                businessFileDy.set("id", (Object)this.idCreator.getId());
                businessFileDy.set("boid", (Object)businessFileDy.getLong("id"));
                businessFileList.add(businessFileDy);
            }
        }
        orgDyList = virtualMap.get(Boolean.FALSE);
        Date effDate = this.otherStructEntity.getEffectDate();
        if (!CollectionUtils.isEmpty(orgDyList)) {
            Map<Long, DynamicObject> orgMap = orgDyList.stream().collect(Collectors.toMap(dy -> dy.getLong("boid"), dy -> dy, (key1, key2) -> key1));
            DynamicObject[] businessFileDys = OrgBusinessFileRepository.getInstance().loadColByOrg(orgMap.keySet(), effDate);
            businessFileList = new ArrayList(orgDyList.size());
            for (DynamicObject dy2 : businessFileDys) {
                DynamicObject orgDy = orgMap.get(dy2.getLong("adminorg.id"));
                if (orgDy == null || dy2.getLong("org.id") == orgDy.getLong("org.id") && dy2.getString("enable").equals(orgDy.getString("enable"))) continue;
                DynamicObject newDy = new DynamicObject(dy2.getDynamicObjectType());
                HRDynamicObjectUtils.copy((DynamicObject)dy2, (DynamicObject)newDy);
                newDy.set("org", orgDy.get("org"));
                newDy.set("id", (Object)this.idCreator.getId());
                newDy.set("enable", orgDy.get("enable"));
                if (newDy.getDate("bsed").compareTo(effDate) < 0) {
                    newDy.set("bsed", (Object)effDate);
                }
                businessFileList.add(newDy);
            }
            buildMap.put(Boolean.FALSE, businessFileList);
        }
        return buildMap;
    }

    private Map<Boolean, List<DynamicObject>> buildEnabledData(Map<Long, DynamicObject> dyMap) {
        Set disabledSet = this.otherStructEntity.getOtherStructByType(ChangeTransactionConstants.DISABLE).stream().map(OtherStructVO::getOrgId).collect(Collectors.toSet());
        HashSet allSet = Sets.newHashSetWithExpectedSize((int)(disabledSet.size() + dyMap.size()));
        allSet.addAll(disabledSet);
        allSet.addAll(dyMap.keySet());
        AdOrgRepository adOrgRepository = AdOrgRepository.getInstance();
        Date effDate = this.otherStructEntity.getEffectDate();
        DynamicObject[] list = adOrgRepository.loadVirtualColByBo(allSet, effDate);
        List orgDyList = Arrays.stream(list).filter(dy -> !dy.getBoolean("iscurrentversion") || EnumHisDataVersionStatus.TEMP.getStatus().equals(dy.getString("datastatus")) && dy.getBoolean("iscurrentversion")).collect(Collectors.toList());
        ArrayList<DynamicObject> newList = new ArrayList<DynamicObject>(dyMap.size());
        HashSet boIdSet = Sets.newHashSetWithExpectedSize((int)orgDyList.size());
        for (DynamicObject orgDy : orgDyList) {
            DynamicObject newDy;
            if (orgDy.getBoolean("iscurrentversion")) {
                newDy = orgDy;
                this.setEsDate(newDy);
            } else {
                newDy = adOrgRepository.genEmptyDy();
                HRDynamicObjectUtils.copy((DynamicObject)orgDy, (DynamicObject)newDy);
                newDy.set("id", (Object)this.idCreator.getId());
                if (newDy.getDate("bsed").compareTo(this.otherStructEntity.getEffectDate()) < 0) {
                    newDy.set("bsed", (Object)this.otherStructEntity.getEffectDate());
                }
            }
            Long boId = newDy.getLong("boid");
            boIdSet.add(boId);
            DynamicObject modifyDy = dyMap.get(boId);
            if (disabledSet.contains(boId)) {
                newDy.set("enable", (Object)"0");
            } else {
                this.setVirtualValue(newDy, modifyDy);
            }
            newList.add(newDy);
        }
        dyMap.keySet().removeAll(boIdSet);
        this.addNewDy(newList, dyMap, adOrgRepository);
        return newList.stream().collect(Collectors.groupingBy(dy -> dy.getBoolean("iscurrentversion")));
    }

    private void addNewDy(List<DynamicObject> list, Map<Long, DynamicObject> dyMap, AdOrgRepository adOrgRepository) {
        String[] structNumbers = ORM.create().genStringIds("haos_adminorgdetail", dyMap.size());
        int index = 0;
        for (DynamicObject dy : dyMap.values()) {
            DynamicObject orgDy = adOrgRepository.genEmptyDy();
            this.setEmptyDyValue(orgDy, dy, structNumbers[index++]);
            list.add(orgDy);
        }
    }

    private Map<Boolean, List<DynamicObject>> buildEnablingData(Map<Long, DynamicObject> dyMap) {
        AdOrgRepository adOrgRepository = AdOrgRepository.getInstance();
        DynamicObject[] list = adOrgRepository.loadVirtualColByBo(dyMap.keySet(), null);
        Map<Boolean, List<DynamicObject>> booleanMap = Arrays.stream(list).collect(Collectors.groupingBy(dy -> dy.getString("datastatus").equals(EnumHisDataVersionStatus.TEMP.getStatus())));
        this.buildDyList(booleanMap.get(Boolean.FALSE), dyMap, t -> adOrgRepository.save(t.toArray(new DynamicObject[0])));
        List<DynamicObject> tempList = booleanMap.get(Boolean.TRUE);
        this.buildDyList(tempList, dyMap, null);
        if (CollectionUtils.isEmpty(dyMap)) {
            return booleanMap;
        }
        if (CollectionUtils.isEmpty(tempList)) {
            tempList = new ArrayList<DynamicObject>(dyMap.size());
            booleanMap.put(Boolean.TRUE, tempList);
        }
        this.addNewDy(tempList, dyMap, adOrgRepository);
        return booleanMap;
    }

    private void buildDyList(List<DynamicObject> list, Map<Long, DynamicObject> dyMap, Consumer<List<DynamicObject>> consumer) {
        if (!CollectionUtils.isEmpty(list)) {
            HashSet boIdSet = Sets.newHashSetWithExpectedSize((int)list.size());
            for (DynamicObject orgDy : list) {
                Long boId = orgDy.getLong("boid");
                boIdSet.add(boId);
                DynamicObject modifyDy = dyMap.get(boId);
                this.setVirtualValue(orgDy, modifyDy);
                this.setEsDate(orgDy);
            }
            dyMap.keySet().removeAll(boIdSet);
            if (consumer != null) {
                consumer.accept(list);
            }
        }
    }

    private void setEmptyDyValue(DynamicObject orgDy, DynamicObject dy, String structNumber) {
        long id = dy.getLong("orgid");
        this.setVirtualValue(orgDy, dy);
        this.setEsDate(orgDy);
        orgDy.set("bsled", (Object)OrgDateTimeUtil.BSLED);
        orgDy.set("status", (Object)"C");
        orgDy.set("iscurrentversion", (Object)Boolean.TRUE);
        orgDy.set("id", (Object)id);
        orgDy.set("boid", (Object)id);
        orgDy.set("structnumber", (Object)structNumber);
        orgDy.set("isvirtualorg", (Object)Boolean.TRUE);
        orgDy.set("enable", (Object)"1");
        HAOSDynamicObjectUtil.setInitFields(orgDy);
    }

    private void setEsDate(DynamicObject orgDy) {
        orgDy.set("establishmentdate", (Object)this.otherStructEntity.getEffectDate());
        orgDy.set("firstbsed", (Object)this.otherStructEntity.getEffectDate());
        orgDy.set("bsed", (Object)this.otherStructEntity.getEffectDate());
    }

    private void setVirtualValue(DynamicObject orgDy, DynamicObject dy) {
        if (dy == null) {
            return;
        }
        orgDy.set("number", dy.get("number"));
        orgDy.set("name", dy.get("name"));
        orgDy.set("org", dy.get("org"));
        orgDy.set("parentorg", null);
        orgDy.set("description", dy.get("description"));
    }

    private List<HisVersionParamBo> buildParamBoList(List<DynamicObject> structDyList, List<DynamicObject> virtualList, List<DynamicObject> businessFileList, boolean isFirst) {
        HisVersionParamBo paramBo;
        ArrayList<HisVersionParamBo> hisBoList = new ArrayList<HisVersionParamBo>(4);
        if (!CollectionUtils.isEmpty(structDyList)) {
            paramBo = AdminOrgHisServiceHelper.getHisVersionParam(structDyList.toArray(new DynamicObject[0]), AdminOrgHisDynKey.ADMIN_STRUCT_KEY.getDynKey(), false);
            paramBo.setNeedProcessAttachment(false);
            hisBoList.add(paramBo);
        }
        if (!CollectionUtils.isEmpty(virtualList)) {
            DynamicObject[] virtualArray = virtualList.toArray(new DynamicObject[0]);
            long[] firstVersionIds = null;
            if (isFirst) {
                this.firstIdMap = new HashMap<Long, Long>(virtualList.size());
                firstVersionIds = new long[virtualArray.length];
                int index = 0;
                for (DynamicObject virtual : virtualArray) {
                    firstVersionIds[index] = this.idCreator.getId();
                    this.firstIdMap.put(virtual.getLong("id"), firstVersionIds[index]);
                    ++index;
                }
            }
            HisVersionParamBo paramBo2 = AdminOrgHisServiceHelper.getHisVersionParam(virtualArray, AdminOrgHisDynKey.ADMIN_ORG_KEY.getDynKey(), false);
            paramBo2.setFirstVersionIds(firstVersionIds);
            paramBo2.setNeedProcessAttachment(false);
            hisBoList.add(paramBo2);
        }
        if (!CollectionUtils.isEmpty(businessFileList)) {
            paramBo = AdminOrgHisServiceHelper.getHisVersionParam(businessFileList.toArray(new DynamicObject[0]), "haos_orgbusinessfile", false);
            paramBo.setNeedProcessAttachment(false);
            hisBoList.add(paramBo);
        }
        return hisBoList;
    }

    private void batchHisVersionChange(List<HisVersionParamBo> hisBoList) {
        HisVersionParamListBo hisVersionParamListBo = new HisVersionParamListBo();
        hisVersionParamListBo.setAtomicTrans(false);
        hisVersionParamListBo.setEventId(this.otherStructEntity.getEventId());
        hisVersionParamListBo.setListHisVersionParamBo(hisBoList);
        HisModelController.getInstance().batchHisVersionChange(hisVersionParamListBo);
    }

    private Date getTruncateDate(Date effectDate, Date estDate) {
        return HRDateTimeUtils.truncateDate((Date)(effectDate.compareTo(estDate) < 0 ? estDate : effectDate));
    }

    private static /* synthetic */ DynamicObject lambda$buildChangedOtData$34(Map orgTeamMap, DynamicObjectType dynamicObjectType, String orgTeamNumberPrefix, DynamicObject orgDy) {
        DynamicObject orgTeam = (DynamicObject)orgTeamMap.get(orgDy.getLong("boid"));
        if (orgTeam == null) {
            throw new KDBizException("no find orgTeam data---orgTeamId=" + orgDy.getLong("boid"));
        }
        DynamicObject newOrgTeam = new DynamicObject(dynamicObjectType);
        HRDynamicObjectUtils.copy((DynamicObject)orgTeam, (DynamicObject)newOrgTeam);
        newOrgTeam.set("id", (Object)orgDy.getLong("id"));
        newOrgTeam.set("iscurrentversion", (Object)Boolean.FALSE);
        newOrgTeam.set("createtime", (Object)orgDy.getDate("createtime"));
        newOrgTeam.set("enable", (Object)orgDy.getString("enable"));
        OrgTeamSynService.getInstance().synOrgTeamBizFields(newOrgTeam, orgDy, orgTeamNumberPrefix);
        return newOrgTeam;
    }
}

