/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.business.service.otherstruct.model;

import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.hr.haos.business.service.otherstruct.model.OtherStructVO;
import kd.hr.haos.common.constants.changetransaction.ChangeTransactionConstants;

public class OtherStructEntity {
    private List<OtherStructVO> otherStructList;
    private Date effectDate;
    private Long structProjectId;
    private String enable;
    private Long rootOrgId;
    private Long eventId;
    private Boolean deleteFlag = Boolean.TRUE;
    private Boolean deleteAll = Boolean.TRUE;
    private Map<Long, List<OtherStructVO>> otherStructMap;
    private boolean isIncludeVirtual;
    private List<DynamicObject> dyList;

    public OtherStructEntity() {
        this(Collections.emptyList());
    }

    public OtherStructEntity(OtherStructVO otherStructVO) {
        this(Collections.singletonList(otherStructVO));
    }

    public OtherStructEntity(List<OtherStructVO> otherStructList) {
        this.otherStructList = otherStructList;
    }

    public Boolean getDeleteFlag() {
        return this.deleteFlag;
    }

    public void setDeleteFlag(Boolean deleteFlag) {
        this.deleteFlag = deleteFlag;
    }

    public void setEffectDate(Date effectDate) {
        this.effectDate = effectDate;
    }

    public void setStructProjectId(Long structProjectId) {
        this.structProjectId = structProjectId;
    }

    public void setEnable(String enable) {
        this.enable = enable;
    }

    public void setRootOrgId(Long rootOrgId) {
        this.rootOrgId = rootOrgId;
    }

    public void setEventId(Long eventId) {
        this.eventId = eventId;
    }

    public Long getEventId() {
        return this.eventId;
    }

    public List<OtherStructVO> getOtherStructList() {
        return this.otherStructList;
    }

    public void setOtherStructList(List<OtherStructVO> otherStructList) {
        this.otherStructList = otherStructList;
    }

    public Date getEffectDate() {
        return this.effectDate;
    }

    public Long getStructProjectId() {
        return this.structProjectId;
    }

    public List<OtherStructVO> getOtherStructByType(Long changeTypeId) {
        if (this.otherStructMap == null) {
            this.otherStructMap = this.otherStructList.stream().collect(Collectors.groupingBy(OtherStructVO::getChangeTypeId));
        }
        return this.otherStructMap.getOrDefault(changeTypeId, Collections.emptyList());
    }

    public Set<Long> getStatusChangeOrg() {
        return Stream.of(this.getOtherStructByType(ChangeTransactionConstants.INFO), this.getOtherStructByType(ChangeTransactionConstants.DISABLE)).flatMap(Collection::stream).map(OtherStructVO::getOrgId).collect(Collectors.toSet());
    }

    public String getEnable() {
        return this.enable;
    }

    public Long getRootOrgId() {
        return this.rootOrgId;
    }

    public List<DynamicObject> getDyList() {
        return this.dyList;
    }

    public void setDyList(List<DynamicObject> dyList) {
        this.dyList = dyList;
    }

    public boolean isIncludeVirtual() {
        return this.isIncludeVirtual;
    }

    public void setIncludeVirtual(boolean includeVirtual) {
        this.isIncludeVirtual = includeVirtual;
    }

    public Boolean getDeleteAll() {
        return this.deleteAll;
    }

    public void setDeleteAll(Boolean deleteAll) {
        this.deleteAll = deleteAll;
    }
}

