/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.business.service.performanceopt;

import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.haos.business.domain.repository.HAOSBaseRepository;

public abstract class PerformanceOptimization0804DataHelper {
    private static final Log LOGGER = LogFactory.getLog(PerformanceOptimization0804DataHelper.class);
    Set<Long> updateStructAdminOrgIdSet;
    Set<Long> updateSortCodeAdminOrgIdSet;
    private static final String SORT_CODE = "sortcode";
    private static final String STRUCT_LONG_NUMBER = "structlongnumber";
    private static final String LEVEL = "level";

    public void update() {
        boolean check = this.check();
        if (!check) {
            return;
        }
        DynamicObject[] masterData = this.queryMaster(this.getUpdateStructAdminOrgIdSet(), this.getUpdateSortCodeAdminOrgIdSet());
        DynamicObject[] structData = new DynamicObject[]{};
        DynamicObject[] sortCodeData = new DynamicObject[]{};
        if (!CollectionUtils.isEmpty(this.getUpdateStructAdminOrgIdSet())) {
            structData = this.queryStruct(this.getUpdateStructAdminOrgIdSet());
        }
        if (!CollectionUtils.isEmpty(this.getUpdateSortCodeAdminOrgIdSet())) {
            sortCodeData = this.querySortCode(this.getUpdateSortCodeAdminOrgIdSet());
        }
        this.writeStructFields(masterData, structData);
        this.writeSortCodeFields(masterData, sortCodeData);
        this.updateMasterData(masterData);
    }

    private void updateMasterData(DynamicObject[] masterData) {
        this.getMasterRepository().update(masterData);
    }

    private void writeSortCodeFields(DynamicObject[] masterData, DynamicObject[] sortCodeData) {
        if (masterData.length != 0 && sortCodeData.length != 0) {
            Map<Long, DynamicObject> foreignIdVsSortCode = Arrays.stream(sortCodeData).collect(Collectors.toMap(sortCode -> sortCode.getLong(this.getSortCodeForeignKey()), sortCode -> sortCode));
            Arrays.stream(masterData).forEach(master -> {
                long boid = master.getLong("boid");
                DynamicObject sortCode = (DynamicObject)foreignIdVsSortCode.get(boid);
                if (sortCode != null) {
                    master.set(SORT_CODE, (Object)sortCode.getString(SORT_CODE));
                }
            });
        }
    }

    private void writeStructFields(DynamicObject[] masterData, DynamicObject[] structData) {
        if (masterData.length != 0 && structData.length != 0) {
            Map<Long, DynamicObject> foreignIdVsStruct = Arrays.stream(structData).collect(Collectors.toMap(struct -> struct.getLong(this.getStructForeignKey()), struct -> struct));
            Arrays.stream(masterData).forEach(master -> {
                long boid = master.getLong("boid");
                DynamicObject struct = (DynamicObject)foreignIdVsStruct.get(boid);
                if (struct != null) {
                    master.set(STRUCT_LONG_NUMBER, (Object)struct.getString(STRUCT_LONG_NUMBER));
                    master.set(LEVEL, (Object)struct.getInt(LEVEL));
                }
            });
        }
    }

    protected DynamicObject[] querySortCode(Set<Long> updateSortCodeAdminOrgIdSet) {
        return this.getSortCodeRepository().queryPerformanceUpdateFields(updateSortCodeAdminOrgIdSet);
    }

    protected DynamicObject[] queryStruct(Set<Long> updateStructAdminOrgIdSet) {
        return this.getStructRepository().queryPerformanceUpdateFields(updateStructAdminOrgIdSet);
    }

    protected DynamicObject[] queryMaster(Set<Long> updateStructIdSet, Set<Long> updateSortCodeIdSet) {
        Set<Long> updatedAdminOrgIdSet = Stream.of(updateStructIdSet, updateSortCodeIdSet).filter(Objects::nonNull).flatMap(Collection::stream).collect(Collectors.toSet());
        return this.getMasterRepository().queryPerformanceUpdateFields(updatedAdminOrgIdSet);
    }

    private boolean check() {
        this.infoIfInfoEnabled(() -> String.format("UpdateSortCodeAdminOrgIdSet:%s", SerializationUtils.toJsonString(this.getUpdateSortCodeAdminOrgIdSet())));
        this.infoIfInfoEnabled(() -> String.format("UpdateStructAdminOrgIdSet:%s", SerializationUtils.toJsonString(this.getUpdateStructAdminOrgIdSet())));
        return !CollectionUtils.isEmpty(this.getUpdateSortCodeAdminOrgIdSet()) || !CollectionUtils.isEmpty(this.getUpdateStructAdminOrgIdSet());
    }

    private void infoIfInfoEnabled(Supplier<String> msgSupplier) {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info(msgSupplier.get());
        }
    }

    protected abstract String getSortCodeForeignKey();

    protected abstract String getStructForeignKey();

    protected abstract HAOSBaseRepository getMasterRepository();

    protected abstract HAOSBaseRepository getStructRepository();

    protected abstract HAOSBaseRepository getSortCodeRepository();

    private Set<Long> getUpdateStructAdminOrgIdSet() {
        return this.updateStructAdminOrgIdSet;
    }

    public void setUpdateStructAdminOrgIdSet(Set<Long> updateStructAdminOrgIdSet) {
        this.updateStructAdminOrgIdSet = updateStructAdminOrgIdSet;
    }

    private Set<Long> getUpdateSortCodeAdminOrgIdSet() {
        return this.updateSortCodeAdminOrgIdSet;
    }

    public void setUpdateSortCodeAdminOrgIdSet(Set<Long> updateSortCodeAdminOrgIdSet) {
        this.updateSortCodeAdminOrgIdSet = updateSortCodeAdminOrgIdSet;
    }
}

