/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.business.service.projectgroup.cascade;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDBizException;
import kd.hr.haos.business.domain.repository.adorg.AdOrgRepository;
import kd.hr.haos.business.domain.repository.prjorg.PRJOrgRepository;
import kd.hr.haos.business.service.projectgroup.bean.cascade.PRJCascadeBo;
import kd.hr.haos.business.service.projectgroup.cascade.ProjectGroupCascadeService;

public class AddCascadeService
extends ProjectGroupCascadeService {
    private List<DynamicObject> pjtOrgList;

    public AddCascadeService(List<DynamicObject> pjtOrgList) {
        this.pjtOrgList = pjtOrgList;
        this.check();
    }

    @Override
    protected List<PRJCascadeBo> getHisData() {
        Set<Long> parentOrgSet = this.pjtOrgList.stream().map(dy -> dy.getLong("parentorg.id")).collect(Collectors.toSet());
        Date earliestDate = this.pjtOrgList.stream().map(dy -> dy.getDate("establishmentdate")).min(Date::compareTo).get();
        DynamicObject[] pjtOrgs = PRJOrgRepository.getInstance().queryOriginalByBoAndEffectData("id, boid, parentorg.id, org.id, belongadminorg.id, rootprojectteam.id, bsed, bsled", parentOrgSet, earliestDate);
        DynamicObject[] adOrgs = AdOrgRepository.getInstance().queryOriginalByBoAndEffectData("id, boid, org.id, bsed, bsled", parentOrgSet, earliestDate);
        ArrayList<PRJCascadeBo> result = new ArrayList<PRJCascadeBo>();
        Arrays.stream(adOrgs).map(this::buildPrjCascadeBo4AdOt).forEach(result::add);
        Arrays.stream(pjtOrgs).map(this::buildPrjCascadeBo).forEach(result::add);
        return result;
    }

    @Override
    protected List<PRJCascadeBo> getNewData() {
        return this.pjtOrgList.stream().map(this::buildPrjCascadeBo).collect(Collectors.toList());
    }

    private void check() {
        for (DynamicObject dynamicObject : this.pjtOrgList) {
            long id = dynamicObject.getLong("id");
            long boId = dynamicObject.getLong("boid");
            if (id == 0L || boId == 0L) {
                throw new KDBizException("AddCascadeService create check error: id or boid is empty");
            }
            if (id != boId) continue;
            throw new KDBizException("AddCascadeService create check error: id is equals boid");
        }
    }
}

