/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.business.service.projectgroup.service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.haos.business.domain.repository.prjorg.PRJOrgRepository;
import kd.hr.haos.business.util.IdCreator;
import kd.hr.hbp.business.domain.model.newhismodel.BatchVersionChangeRespData;
import kd.hr.hbp.business.domain.model.newhismodel.HisResponse;
import kd.hr.hbp.business.domain.model.newhismodel.VersionChangeRespData;
import kd.hr.hbp.business.servicehelper.HRProducerServiceHelper;

public class ProTeamMsgService {
    private static int MAX_TITLE_LENGTH = 50;
    private static final Log LOGGER = LogFactory.getLog(ProTeamMsgService.class);
    private final IdCreator idCreator = new IdCreator();
    private DynamicObject emptyPjt;

    public static ProTeamMsgService getInstance() {
        return ProTeamMsgInstance.INSTANCE;
    }

    public void sendProTeamChgMsg(HisResponse<BatchVersionChangeRespData> hisResponse) {
        if (hisResponse == null) {
            return;
        }
        List versionChangeRespDataList = ((BatchVersionChangeRespData)hisResponse.getData()).getVersionChangeRespDataList();
        VersionChangeRespData versionChangeRespData = versionChangeRespDataList.stream().filter(v -> v.getEntityNumber().equals("haos_projteambaseinfo")).findFirst().orElse(null);
        if (versionChangeRespData == null) {
            return;
        }
        Object[] hisData = (DynamicObject[])Arrays.stream(versionChangeRespData.getNewDynamicObjects()).filter(dyn -> !dyn.getBoolean("iscurrentversion")).toArray(DynamicObject[]::new);
        if (ObjectUtils.isEmpty((Object[])hisData)) {
            return;
        }
        LOGGER.info("ProjectGroupChangeOp.sendProTeamUpMsg is start,hisData.length={}", (Object)hisData.length);
        Map<Long, List<DynamicObject>> boVsPjtList = Arrays.stream(hisData).collect(Collectors.groupingBy(dy -> dy.getLong("boid")));
        Map<Long, DynamicObject> idVsPjt = this.getIdVsPjtByQuery((DynamicObject[])hisData);
        LOGGER.info("ProjectGroupChangeOp.sendProTeamUpMsg is start,boVsPjtList.size={}", (Object)boVsPjtList.size());
        try {
            boVsPjtList.forEach((bo, pjt) -> HRProducerServiceHelper.publishAction(this.buildChangePublishInfo((long)bo, idVsPjt.getOrDefault(bo, this.getEmptyPjt()).getString("name"), (List<DynamicObject>)pjt)));
        }
        catch (Exception exception) {
            LOGGER.error("ProjectGroupChangeOp.sendProTeamUpMsg sendProTeamChgMsg is Exception", (Throwable)exception);
        }
        LOGGER.info("ProjectGroupChangeOp.sendProTeamUpMsg is end");
    }

    private Map<Long, DynamicObject> getIdVsPjtByQuery(DynamicObject[] hisData) {
        DynamicObject[] pjts = PRJOrgRepository.getInstance().queryOriginalByPks("id, name", Arrays.stream(hisData).map(dy -> dy.getLong("boid")).collect(Collectors.toSet()));
        return Arrays.stream(pjts).collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy));
    }

    private Map<String, Object> buildChangePublishInfo(long bo, String currentPjtName, List<DynamicObject> sameBoPjtList) {
        String msgTag = ResManager.loadKDString((String)"\u9879\u76ee\u56e2\u961f\u53d8\u66f4", (String)"ProTeamMsgService_0", (String)"hrmp-haos-business", (Object[])new Object[0]);
        StringBuilder msgTitle = new StringBuilder();
        String title = String.format(ResManager.loadKDString((String)"\u9879\u76ee\u56e2\u961f\u201c%1$s\u201d\u53d8\u66f4\u5df2\u751f\u6548\u3002", (String)"ProTeamMsgService_1", (String)"hrmp-haos-business", (Object[])new Object[0]), currentPjtName);
        if (title.length() > MAX_TITLE_LENGTH) {
            title = title.substring(0, MAX_TITLE_LENGTH);
        }
        msgTitle.append(title);
        HashMap<String, Object> actionInfo = new HashMap<String, Object>();
        actionInfo.put("msgNumber", String.valueOf(this.idCreator.getId()));
        actionInfo.put("senderId", 1L);
        actionInfo.put("sendTime", new Date());
        actionInfo.put("actionId", 1032102L);
        actionInfo.put("msgPubNo", "MP20221230001024");
        actionInfo.put("params", SerializationUtils.serializeToBase64(this.buildProTeamChgMsgParam(bo, sameBoPjtList)));
        actionInfo.put("msgTitle", msgTitle.toString());
        actionInfo.put("msgDesc", ResManager.loadKDString((String)"\u9879\u76ee\u56e2\u961f\u53d8\u66f4\u901a\u77e5", (String)"ProTeamMsgService_2", (String)"hrmp-haos-business", (Object[])new Object[0]));
        actionInfo.put("msgTag", msgTag);
        LOGGER.info("ProTeamMsgService.actionInfo,project.team.name={},actionInfo={}", (Object)currentPjtName, (Object)SerializationUtils.toJsonString(actionInfo));
        return actionInfo;
    }

    private Map<String, Object> buildProTeamChgMsgParam(long bo, List<DynamicObject> sameBoPjtList) {
        HashMap<String, Object> msg = new HashMap<String, Object>();
        msg.put("boId", bo);
        ArrayList list = new ArrayList();
        msg.put("dataList", list);
        sameBoPjtList.forEach(pjt -> {
            HashMap<String, Long> map = new HashMap<String, Long>();
            map.put("id", pjt.getLong("id"));
            list.add(map);
        });
        LOGGER.info("ProTeamMsgService.buildProTeamChgMsgParam,msg={}", msg);
        return msg;
    }

    private DynamicObject getEmptyPjt() {
        if (this.emptyPjt == null) {
            this.emptyPjt = PRJOrgRepository.getInstance().genEmptyDy();
        }
        return this.emptyPjt;
    }

    private static class ProTeamMsgInstance {
        private static ProTeamMsgService INSTANCE = new ProTeamMsgService();

        private ProTeamMsgInstance() {
        }
    }
}

