/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.business.service.projectgroup.service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.CollectionUtils;
import kd.hr.haos.business.domain.repository.orgteam.OTQueryRepository;
import kd.hr.haos.business.service.adminorg.AdminOrgHisServiceHelper;
import kd.hr.haos.business.service.adminorg.bean.OrgTeamBasicInfoBO;
import kd.hr.haos.business.service.adminorg.bean.TeamCoopRelBO;
import kd.hr.haos.business.service.adminorg.teamcoop.OrgTeamCoopRelService;
import kd.hr.haos.business.service.orgteam.OrgTeamBatchSynService;
import kd.hr.haos.business.service.orgteam.OrgTeamSynService;
import kd.hr.haos.business.service.projectgroup.bean.cascade.PRJMasterBo;
import kd.hr.haos.business.service.projectgroup.cascade.AddCascadeService;
import kd.hr.haos.business.service.projectgroup.service.AbstractProjectGroupDataService;
import kd.hr.haos.business.service.projectgroup.service.ProjChangeEventService;
import kd.hr.haos.business.service.projectgroup.service.ProjectGroupBaseService;
import kd.hr.haos.business.util.LocalDateRangeUtils;
import kd.hr.haos.common.model.cascade.CascadeResult;
import kd.hr.haos.common.model.cascade.PartBo;
import kd.hr.haos.common.model.orgteam.BatchSynModel;
import kd.hr.haos.common.util.LocalDateRange;
import kd.hr.hbp.business.application.impl.newhismodel.HisModelController;
import kd.hr.hbp.business.domain.model.newhismodel.BatchVersionChangeRespData;
import kd.hr.hbp.business.domain.model.newhismodel.HisResponse;
import kd.hr.hbp.business.domain.model.newhismodel.HisVersionParamBo;
import kd.hr.hbp.business.domain.model.newhismodel.HisVersionParamListBo;
import kd.hr.hbp.business.domain.model.newhismodel.VersionChangeRespData;
import kd.hr.hbp.business.domain.service.impl.newhismodel.HisEffDateCommonService;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;

public class ProjectGroupAddService
extends AbstractProjectGroupDataService {
    private static final Log LOGGER = LogFactory.getLog(ProjectGroupAddService.class);
    private List<DynamicObject> pjtOrgList;
    private List<DynamicObject> toSavePjtOrgList;
    private static final OrgTeamBasicInfoBO PRJ_ORG_TEAM_BASIC_INFO_BO = OrgTeamSynService.PRJ_ORG_TEAM_BASIC_INFO_BO;
    private String prjOtNumberPrefix;
    private long eventId;
    private Date date2999;
    private Map<Long, Long> boIdVsId;
    private List<DynamicObject> newPjtDataAfterCallHisInterface;

    public void save() {
        this.init();
        this.cascadeCalculate();
        this.savePjt();
        this.synOT();
        this.saveCoopRel();
        this.saveChangeTransaction();
    }

    private void cascadeCalculate() {
        AddCascadeService addCascadeService = new AddCascadeService(this.pjtOrgList);
        CascadeResult cascadeResult = addCascadeService.getResult();
        List<DynamicObject> newPrjOrgByCascadeResultList = this.createVersionByCascade(cascadeResult);
        this.beforeSaveProjectOrg(newPrjOrgByCascadeResultList);
        this.toSavePjtOrgList = newPrjOrgByCascadeResultList;
    }

    private void saveChangeTransaction() {
        if (!kd.bos.orm.util.CollectionUtils.isEmpty(this.newPjtDataAfterCallHisInterface)) {
            ProjChangeEventService.handleChangeEventHis(false, this.newPjtDataAfterCallHisInterface.toArray(new DynamicObject[0]));
        }
    }

    @Override
    void init() {
        super.init();
        this.prjOtNumberPrefix = OrgTeamSynService.getNumberByPrefixId(1020L);
        this.date2999 = new HisEffDateCommonService().getDate2999(null);
        this.pjtOrgList.forEach(dy -> {
            dy.set("bsled", (Object)this.date2999);
            dy.set("id", (Object)this.idCreator.getId());
        });
        this.initBoVsId();
    }

    private void savePjt() {
        List<DynamicObject> invalidDys;
        List<DynamicObject> effectingDys = this.toSavePjtOrgList.stream().filter(dy -> this.date2999.equals(dy.getDate("bsled"))).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(effectingDys)) {
            HisVersionParamListBo hisVersionParamListBo = new HisVersionParamListBo();
            HisVersionParamBo effectingVersionParam = AdminOrgHisServiceHelper.getHisVersionParam(effectingDys.toArray(new DynamicObject[0]), "haos_projteambaseinfo", false);
            long[] firstIdArr = effectingDys.stream().mapToLong(dy -> this.boIdVsId.get(dy.getLong("id"))).toArray();
            effectingVersionParam.setFirstVersionIds(firstIdArr);
            hisVersionParamListBo.setListHisVersionParamBo(Collections.singletonList(effectingVersionParam));
            hisVersionParamListBo.setEventId(Long.valueOf(this.getEventId()));
            HisResponse respDataHisResponse = HisModelController.getInstance().batchHisVersionChange(hisVersionParamListBo);
            this.newPjtDataAfterCallHisInterface = ((BatchVersionChangeRespData)respDataHisResponse.getData()).getVersionChangeRespDataList().stream().map(VersionChangeRespData::getNewDynamicObjects).flatMap(Arrays::stream).collect(Collectors.toList());
        }
        if (CollectionUtils.isNotEmpty(invalidDys = this.toSavePjtOrgList.stream().filter(dy -> !this.date2999.equals(dy.getDate("bsled"))).collect(Collectors.toList()))) {
            HisVersionParamListBo hisVersionParamListBo2 = new HisVersionParamListBo();
            HisVersionParamBo invalidVersionParam = AdminOrgHisServiceHelper.getHisVersionParam(invalidDys.toArray(new DynamicObject[0]), "haos_projteambaseinfo", false);
            hisVersionParamListBo2.setListHisVersionParamBo(Collections.singletonList(invalidVersionParam));
            hisVersionParamListBo2.setEventId(Long.valueOf(this.getEventId()));
            HisModelController.getInstance().batchHisVersionChange(hisVersionParamListBo2);
        }
    }

    private void saveCoopRel() {
        ProjectGroupBaseService projectGroupBaseService = new ProjectGroupBaseService();
        Map<Long, List<TeamCoopRelBO>> orgCoopRelBOMap = projectGroupBaseService.getBatchOrgCoopRelBOMapByBo(this.pjtOrgList.toArray(new DynamicObject[0]));
        HisVersionParamBo teamCoopRelHisParam = OrgTeamCoopRelService.getInstance().buildAddNewHisParam(orgCoopRelBOMap);
        HisVersionParamListBo hisVersionParamListBo = new HisVersionParamListBo();
        hisVersionParamListBo.setListHisVersionParamBo(Collections.singletonList(teamCoopRelHisParam));
        hisVersionParamListBo.setEventId(Long.valueOf(this.getEventId()));
        HisModelController.getInstance().batchHisVersionChange(hisVersionParamListBo);
    }

    private void beforeSaveProjectOrg(List<DynamicObject> newPrjOrgByCascadeResultList) {
        newPrjOrgByCascadeResultList.stream().filter(dy -> this.date2999.equals(dy.getDate("bsled"))).forEach(dy -> {
            dy.set("id", dy.get("boid"));
            dy.set("boid", null);
        });
    }

    private void synOT() {
        HRBaseServiceHelper otClassifyHelper = new HRBaseServiceHelper("haos_otclassify");
        DynamicObject otClassifyDyn = otClassifyHelper.generateEmptyDynamicObject();
        otClassifyDyn.set("id", (Object)1020L);
        List saveOtList = this.toSavePjtOrgList.stream().map(prjOrg -> {
            DynamicObject newOt = OTQueryRepository.getInstance().genEmptyDy();
            HRDynamicObjectUtils.copy((DynamicObject)prjOrg, (DynamicObject)newOt);
            OrgTeamSynService.getInstance().setOtType(newOt);
            new OrgTeamSynService().synOrgTeamBizFields(newOt, (DynamicObject)prjOrg, this.prjOtNumberPrefix);
            newOt.set("parent", (Object)prjOrg.getDynamicObject("parentorg"));
            newOt.set("id", (Object)prjOrg.getLong("id"));
            newOt.set("otclassify", (Object)otClassifyDyn);
            return newOt;
        }).collect(Collectors.toList());
        OrgTeamBatchSynService orgTeamBatchSynService = new OrgTeamBatchSynService();
        BatchSynModel batchSynModel = new BatchSynModel();
        batchSynModel.setEventId(this.getEventId());
        orgTeamBatchSynService.setBatchSynModel(batchSynModel);
        batchSynModel.setNewList(this.createOrgTeam(this.pjtOrgList));
        batchSynModel.setNewOtBoVsStructBo(this.pjtOrgList.stream().collect(Collectors.toMap(dy -> dy.getLong("boid"), dy -> this.idCreator.getId())));
        batchSynModel.setSaveList(saveOtList);
        batchSynModel.setFirstVersionMap(this.createFirstVersionMap());
        batchSynModel.setStrucrProjectId(1020L);
        orgTeamBatchSynService.syn();
    }

    private List<DynamicObject> createVersionByCascade(CascadeResult cascadeResult) {
        Map<Long, DynamicObject> idVsDy = this.pjtOrgList.stream().collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy));
        return this.pjtOrgList.stream().map(prjOrg -> {
            ArrayList result = new ArrayList();
            List partBoList = cascadeResult.get(prjOrg.getLong("boid"));
            LocalDateRange effectRange = LocalDateRangeUtils.getEffectRange(prjOrg);
            List newPrjOrgListWithCascade = partBoList.stream().map(partBo -> (PRJMasterBo)((Object)((Object)partBo))).map(partBo -> this.createPrjOrgWithPrjMasterBo(idVsDy, (PRJMasterBo)((Object)((Object)partBo)))).collect(Collectors.toList());
            List cascadeDateRangeList = partBoList.stream().map(PartBo::getEffectRange).collect(Collectors.toList());
            List unCascadeDateRangeList = effectRange.subtract(cascadeDateRangeList);
            List newPrjOrgListWithOutCascade = unCascadeDateRangeList.stream().map(dateRange -> {
                DynamicObject original = (DynamicObject)idVsDy.get(prjOrg.getLong("id"));
                DynamicObject copy = new DynamicObject(original.getDynamicObjectType());
                HRDynamicObjectUtils.copy((DynamicObject)original, (DynamicObject)copy);
                copy.set("id", (Object)this.idCreator.getId());
                LocalDateRangeUtils.setEffectRange(copy, dateRange);
                return copy;
            }).collect(Collectors.toList());
            result.addAll(newPrjOrgListWithCascade);
            result.addAll(newPrjOrgListWithOutCascade);
            return result;
        }).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private List<DynamicObject> createOrgTeam(List<DynamicObject> pjtOrgList) {
        return pjtOrgList.stream().map(prjOrg -> {
            DynamicObject ot = OTQueryRepository.getInstance().genEmptyDy(Arrays.asList("id", "boid", "parentid", "bsed", "bsled", "structnumber", "status", "enable", "initbatch", "initdatasource", "initstatus"));
            ot.set("id", (Object)prjOrg.getLong("id"));
            ot.set("boid", (Object)prjOrg.getLong("boid"));
            ot.set("parentid", (Object)prjOrg.getLong("parentorg.id"));
            LocalDateRangeUtils.synEffectRange(prjOrg, ot);
            ot.set("structnumber", prjOrg.get("structnumber"));
            ot.set("status", prjOrg.get("status"));
            ot.set("enable", prjOrg.get("enable"));
            ot.set("initstatus", prjOrg.get("initstatus"));
            ot.set("initbatch", prjOrg.get("initbatch"));
            ot.set("initdatasource", prjOrg.get("initdatasource"));
            return ot;
        }).collect(Collectors.toList());
    }

    private void initBoVsId() {
        if (this.boIdVsId == null) {
            this.boIdVsId = new HashMap<Long, Long>();
        }
        this.pjtOrgList.forEach(dy -> this.boIdVsId.putIfAbsent(dy.getLong("boid"), this.idCreator.getId()));
    }

    private Map<Long, Long> createFirstVersionMap() {
        return this.boIdVsId;
    }

    public long getEventId() {
        return this.eventId;
    }

    public void setEventId(long eventId) {
        this.eventId = eventId;
    }

    public void setBoIdVsId(Map<Long, Long> boIdVsId) {
        this.boIdVsId = boIdVsId;
    }

    public void setPjtOrgList(List<DynamicObject> pjtOrgList) {
        this.pjtOrgList = pjtOrgList;
    }
}

