/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.business.service.projectgroup.service;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.cache.util.PermCommonUtil;
import kd.hr.haos.business.domain.service.impl.teamcoop.TeamCoopRelServiceImpl;
import kd.hr.haos.business.service.adminorg.AdminOrgHisDynamicUtils;
import kd.hr.haos.business.service.adminorg.AdminOrgHisServiceHelper;
import kd.hr.haos.business.service.adminorg.AdminOrgOpService;
import kd.hr.haos.business.service.adminorg.bean.OrgTeamBasicInfoBO;
import kd.hr.haos.business.service.adminorg.bean.TeamCoopRelBO;
import kd.hr.haos.business.service.adminorg.teamcoop.OrgTeamCoopRelService;
import kd.hr.haos.business.service.orgteam.OrgTeamSynService;
import kd.hr.haos.business.service.projectgroup.service.IOpService;
import kd.hr.haos.business.service.projectgroup.service.ProjectGroupChangeService;
import kd.hr.haos.business.service.projectgroup.service.ProjectGroupRoleService;
import kd.hr.haos.business.servicehelper.ProjectGroupServiceHelper;
import kd.hr.haos.common.constants.HAOSPageConstants;
import kd.hr.haos.common.constants.OrgTeamConstants;
import kd.hr.haos.common.constants.projectgroup.ProjectGroupMDConstants;
import kd.hr.haos.common.model.prj.OpParam;
import kd.hr.hbp.business.application.impl.newhismodel.HisModelController;
import kd.hr.hbp.business.domain.model.newhismodel.BatchVersionChangeRespData;
import kd.hr.hbp.business.domain.model.newhismodel.HisResponse;
import kd.hr.hbp.business.domain.model.newhismodel.HisVersionParamBo;
import kd.hr.hbp.business.domain.model.newhismodel.HisVersionParamListBo;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.model.AuthorizedOrgTeamResult;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;

public class ProjectGroupBaseService
implements IOpService,
ProjectGroupMDConstants,
HAOSPageConstants {
    private static ProjectGroupBaseService instance = new ProjectGroupBaseService();
    private static final Log logger = LogFactory.getLog(ProjectGroupBaseService.class);

    public static ProjectGroupBaseService getInstance() {
        return instance;
    }

    @Override
    public HisResponse<BatchVersionChangeRespData> saveNew(DynamicObject[] dysArrays, Long eventId) {
        HisVersionParamListBo hisVersionParamListBo = new HisVersionParamListBo();
        hisVersionParamListBo.setAtomicTrans(false);
        if (eventId != null && !eventId.equals(0L)) {
            hisVersionParamListBo.setEventId(eventId);
        }
        ArrayList<HisVersionParamBo> listHisVersionParamBo = new ArrayList<HisVersionParamBo>();
        long[] firstVersionIds = ORM.create().genLongIds("haos_projteambaseinfo", dysArrays.length);
        AdminOrgHisDynamicUtils.FIRST_VERSION_IDS.set(firstVersionIds);
        ArrayList<DynamicObject> orgTeamMainDynList = new ArrayList<DynamicObject>(dysArrays.length);
        listHisVersionParamBo.add(this.buildAddNewHisVersionParam(dysArrays, orgTeamMainDynList));
        hisVersionParamListBo.setListHisVersionParamBo(listHisVersionParamBo);
        Map<Long, List<TeamCoopRelBO>> orgCoopRelBOMap = ProjectGroupBaseService.getBatchOrgCoopRelBOMap(dysArrays);
        HisVersionParamBo teamCoopRelHisParam = OrgTeamCoopRelService.getInstance().buildAddNewHisParam(orgCoopRelBOMap);
        if (!ObjectUtils.isEmpty((Object[])teamCoopRelHisParam.getHisDyns())) {
            listHisVersionParamBo.add(teamCoopRelHisParam);
        }
        HisResponse batchVerChangeResp = HisModelController.getInstance().batchHisVersionChange(hisVersionParamListBo);
        HisVersionParamListBo hisVersionParamListBos = new HisVersionParamListBo();
        hisVersionParamListBos.setAtomicTrans(false);
        if (((BatchVersionChangeRespData)batchVerChangeResp.getData()).getEventId() != null && !((BatchVersionChangeRespData)batchVerChangeResp.getData()).getEventId().equals(0L)) {
            hisVersionParamListBos.setEventId(((BatchVersionChangeRespData)batchVerChangeResp.getData()).getEventId());
        }
        OrgTeamBasicInfoBO orgTeamBasicInfoBO = new OrgTeamBasicInfoBO(OrgTeamConstants.NUMBER_PREFIX_ORG_TEAM_TYPE_ID, OrgTeamConstants.NUMBER_PREFIX_ORG_TYPE_PRO_ID, OrgTeamConstants.NUMBER_PREFIX_OT_CLASSIFY_PRO_ID, OrgTeamConstants.NUMBER_PREFIX_PRO_FID, "projteam.id", "parent");
        orgTeamBasicInfoBO.setPrefixId(1020L);
        AdminOrgHisDynamicUtils.FIRST_VERSION_IDS.set(firstVersionIds);
        OrgTeamSynService.getInstance().syncNewOrgTeam(orgTeamMainDynList, ((BatchVersionChangeRespData)batchVerChangeResp.getData()).getEventId(), orgTeamBasicInfoBO);
        List<DynamicObject> projectRoleList = ProjectGroupRoleService.getInstance().buildAddNewHisParam(dysArrays);
        if (!CollectionUtils.isEmpty(projectRoleList)) {
            Object object = HRMServiceHelper.invokeHRMPService((String)"hbpm", (String)"IProjectRoleService", (String)"addProjectRole", (Object[])new Object[]{projectRoleList});
        }
        return batchVerChangeResp;
    }

    private HisVersionParamBo buildAddNewHisVersionParam(DynamicObject[] dysArrays, List<DynamicObject> orgTeamMainDynList) {
        HRBaseServiceHelper orgTeamQueryHelper = new HRBaseServiceHelper("haos_orgteamquery");
        HRBaseServiceHelper projectGroupServiceHelper = new HRBaseServiceHelper("haos_projteambaseinfo");
        ArrayList newDyList = Lists.newArrayListWithExpectedSize((int)dysArrays.length);
        long[] idArr = ORM.create().genLongIds("haos_projteambaseinfo", dysArrays.length);
        String[] structNumberArr = ORM.create().genStringIds("haos_projteambaseinfo", dysArrays.length);
        for (int i = 0; i < dysArrays.length; ++i) {
            DynamicObject dyn = dysArrays[i];
            long id = dyn.getLong("id");
            if (id == 0L) {
                id = idArr[i];
            }
            dyn.set("org", (Object)dyn.getDynamicObject("belongadminorg.org"));
            dyn.set("id", (Object)id);
            dyn.set("rootprojectteam", (Object)id);
            dyn.set("enable", (Object)"1");
            dyn.set("status", (Object)"C");
            dyn.set("bsled", (Object)AdminOrgHisDynamicUtils.getDefaultBsled());
            dyn.set("structnumber", (Object)structNumberArr[i]);
            String index = dyn.getString("index");
            if (HRStringUtils.isEmpty((String)index)) {
                index = AdminOrgHisServiceHelper.getCurOrgIndex(dyn);
                dyn.set("index", (Object)index);
            }
            DynamicObject newDy = projectGroupServiceHelper.generateEmptyDynamicObject();
            HRDynamicObjectUtils.copy((DynamicObject)dyn, (DynamicObject)newDy);
            newDy.set("id", (Object)id);
            Date establishmentDate = dyn.getDate("establishmentdate");
            newDy.set("bsed", (Object)establishmentDate);
            newDy.set("firstbsed", (Object)establishmentDate);
            DynamicObject orgTeamMainDyn = orgTeamQueryHelper.generateEmptyDynamicObject();
            HRDynamicObjectUtils.copy((DynamicObject)newDy, (DynamicObject)orgTeamMainDyn);
            DynamicObject parentDyn = orgTeamQueryHelper.generateEmptyDynamicObject();
            parentDyn.set("id", (Object)dyn.getLong("parentorg.id"));
            orgTeamMainDyn.set("parent", (Object)parentDyn);
            orgTeamMainDyn.set("id", (Object)id);
            orgTeamMainDynList.add(orgTeamMainDyn);
            newDyList.add(newDy);
        }
        return AdminOrgHisDynamicUtils.getInstance().getHisVersionParam(newDyList.toArray(new DynamicObject[0]), "haos_projteambaseinfo", false);
    }

    private HisVersionParamBo buildDisableHisVersionParam(DynamicObject[] projectBaseList, Date effectDate, long[] ids) {
        ArrayList newDyList = Lists.newArrayListWithExpectedSize((int)projectBaseList.length);
        HRBaseServiceHelper projectGroupServiceHelper = new HRBaseServiceHelper("haos_projteambaseinfo");
        int projIndex = 0;
        for (DynamicObject project : projectBaseList) {
            String index;
            long id = ids[projIndex++];
            project.set("enable", (Object)"0");
            if (effectDate != null) {
                project.set("bsed", (Object)effectDate);
            }
            if (HRStringUtils.isEmpty((String)(index = project.getString("index")))) {
                index = AdminOrgHisServiceHelper.getCurOrgIndex(project);
                project.set("index", (Object)index);
            }
            DynamicObject newDy = projectGroupServiceHelper.generateEmptyDynamicObject();
            HRDynamicObjectUtils.copy((DynamicObject)project, (DynamicObject)newDy);
            newDy.set("id", (Object)id);
            newDyList.add(newDy);
        }
        return AdminOrgHisDynamicUtils.getInstance().getHisVersionParam(newDyList.toArray(new DynamicObject[0]), "haos_projteambaseinfo", false);
    }

    public Map<Long, List<TeamCoopRelBO>> getBatchOrgCoopRelBOMapByBo(DynamicObject[] dysArrays) {
        Map<Long, List<TeamCoopRelBO>> batchOrgCoopRelBOMap = ProjectGroupBaseService.getBatchOrgCoopRelBOMap(dysArrays);
        Map<Long, Long> idVsBoId = Arrays.stream(dysArrays).collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy.getLong("boid")));
        return batchOrgCoopRelBOMap.entrySet().stream().peek(entry -> {
            Long hisOrgId = (Long)entry.getKey();
            List value = (List)entry.getValue();
            if (!CollectionUtils.isEmpty((Collection)value)) {
                value.forEach(teamCoopRelBO -> teamCoopRelBO.setOrgTeamId((Long)idVsBoId.get(hisOrgId)));
            }
        }).collect(Collectors.toMap(entry -> (Long)idVsBoId.get(entry.getKey()), Map.Entry::getValue));
    }

    public static Map<Long, List<TeamCoopRelBO>> getBatchOrgCoopRelBOMap(DynamicObject[] dysArrays) {
        HashMap orgTeamCoopRelMap = Maps.newHashMapWithExpectedSize((int)(2 * dysArrays.length));
        for (DynamicObject projectInfo : dysArrays) {
            Date effDate = projectInfo.getDate("bsed");
            long orgTeamId = projectInfo.getLong("id");
            DynamicObjectCollection coopRelInfoList = projectInfo.getDynamicObjectCollection("entryentity");
            ArrayList coopRelBOList = Lists.newArrayListWithExpectedSize((int)16);
            DynamicObject parent = projectInfo.getDynamicObject("parentorg");
            if (Objects.nonNull(parent)) {
                TeamCoopRelBO teamCoopRelBO = new TeamCoopRelBO(orgTeamId, 1010L, parent.getLong("id"), 0);
                teamCoopRelBO.setEffDate(effDate);
                coopRelBOList.add(teamCoopRelBO);
            }
            orgTeamCoopRelMap.put(orgTeamId, coopRelBOList);
            for (int i = 1; i <= coopRelInfoList.size(); ++i) {
                DynamicObject coopInfo = (DynamicObject)coopRelInfoList.get(i - 1);
                TeamCoopRelBO teamCoopRelBO = new TeamCoopRelBO(orgTeamId, coopInfo.getLong("coopreltype.id"), coopInfo.getLong("cooporgteam.id"), i);
                teamCoopRelBO.setEffDate(effDate);
                coopRelBOList.add(teamCoopRelBO);
            }
            orgTeamCoopRelMap.put(orgTeamId, coopRelBOList);
        }
        return orgTeamCoopRelMap;
    }

    @Override
    public HisResponse<BatchVersionChangeRespData> change(DynamicObject[] dysArrays, Long eventId, OpParam opParam) {
        ProjectGroupChangeService changeService = new ProjectGroupChangeService(opParam);
        changeService.setEventId(eventId);
        changeService.setPrjOrgs(dysArrays);
        changeService.init();
        return changeService.change();
    }

    @Override
    public HisResponse<BatchVersionChangeRespData> disable(DynamicObject[] projectBaseArray, Long eventId, Date effectDate) {
        HisVersionParamListBo hisParamList = new HisVersionParamListBo();
        if (eventId != null && !eventId.equals(0L)) {
            hisParamList.setEventId(eventId);
        }
        ArrayList<HisVersionParamBo> hisParamBo = new ArrayList<HisVersionParamBo>();
        long[] ids = ORM.create().genLongIds("haos_projteambaseinfo", projectBaseArray.length);
        HisVersionParamBo pjtHisVersionParamBo = this.buildDisableHisVersionParam(projectBaseArray, effectDate, ids);
        Map<Long, Long> boVsNewId = this.getBoVsNewIdMap(pjtHisVersionParamBo);
        hisParamBo.add(pjtHisVersionParamBo);
        hisParamList.setListHisVersionParamBo(hisParamBo);
        HisResponse hisResponse = HisModelController.getInstance().batchHisVersionChange(hisParamList);
        ArrayList<HisVersionParamBo> orgHisParamBo = new ArrayList<HisVersionParamBo>();
        Map<Long, Date> idBsedMap = Arrays.stream(projectBaseArray).collect(Collectors.toMap(k -> k.getLong("id"), v -> v.getDate("bsed")));
        orgHisParamBo.add(AdminOrgOpService.getInstance().disableOrgTransaction(idBsedMap, "id", "haos_adminorgteam", boVsNewId));
        orgHisParamBo.add(AdminOrgOpService.getInstance().disableOrgTransaction(idBsedMap, "org", "haos_orgteamcooprel", boVsNewId));
        orgHisParamBo.add(ProjectGroupServiceHelper.changeOrgTeamStructList(projectBaseArray, boVsNewId));
        HisVersionParamListBo orgTeamHisParamList = new HisVersionParamListBo();
        orgTeamHisParamList.setListHisVersionParamBo(orgHisParamBo);
        orgTeamHisParamList.setEventId(eventId);
        HisModelController.getInstance().batchHisVersionChange(orgTeamHisParamList);
        DynamicObject[] projectRoles = ProjectGroupServiceHelper.queryProjectRoleByProjectTeam(projectBaseArray);
        ProjectGroupServiceHelper.disableProjectRole(projectRoles, projectBaseArray[0].getDate("bsed"));
        return hisResponse;
    }

    @Override
    public void changeCoopRel(DynamicObject[] dataEntities, Long eventId) {
        Map<Long, List<TeamCoopRelBO>> orgTeamCoopRelMap = this.getOrgTeamCoopRelMap(dataEntities[0]);
        Date effDate = dataEntities[0].getDate("bsed");
        TeamCoopRelServiceImpl.getInstance().batchChangeAll(orgTeamCoopRelMap, effDate, null);
    }

    @Override
    public QFilter getOrgTeamTypeFilter(DynamicObject pjDyn, String reportCorelTypeEntity, String reportCorelTypeFilterPro, Long filterVal) {
        QFilter qFilter = new QFilter("org.id", "!=", (Object)-1L);
        HRBaseServiceHelper helper = new HRBaseServiceHelper(reportCorelTypeEntity);
        DynamicObject[] dynArr = helper.queryOriginalArray("id", new QFilter[]{new QFilter(reportCorelTypeFilterPro, "=", (Object)filterVal)});
        if (dynArr != null) {
            List idList = Arrays.stream(dynArr).map(dyn -> dyn.getLong("id")).collect(Collectors.toList());
            qFilter.and(new QFilter("id", "in", idList));
        }
        return qFilter;
    }

    @Override
    public QFilter getProTeamCoopOrgPermFilter(String appIdOrNum, String entityNumber, String filed) {
        AuthorizedOrgTeamResult authorizedOrgResult = (AuthorizedOrgTeamResult)HRMServiceHelper.invokeHRMPService((String)"hrcs", (String)"IHRCSBizDataPermissionService", (String)"getAuthorizedOrgTeamsF7", (Object[])new Object[]{RequestContext.get().getCurrUserId(), PermCommonUtil.getAppIdFromSuspectedAppNum((String)appIdOrNum), entityNumber, "47150e89000000ac", filed});
        if (!authorizedOrgResult.isHasAllOrgPerm()) {
            Map hasPermOrgTeamMap = authorizedOrgResult.getHasPermOrgTeamMap();
            HashSet boIdSet = new HashSet(16);
            hasPermOrgTeamMap.forEach((key, val) -> boIdSet.addAll(val));
            return new QFilter("boid", "in", boIdSet);
        }
        return new QFilter("boid", "!=", (Object)-1);
    }

    private Map<Long, List<TeamCoopRelBO>> getOrgTeamCoopRelMap(DynamicObject dataEntity) {
        long org = (Long)dataEntity.get("id");
        Date effDate = dataEntity.getDate("bsed");
        DynamicObjectCollection dynamicObjectCollection = dataEntity.getDynamicObjectCollection("entryentity");
        HashMap<Long, List<TeamCoopRelBO>> orgTeamCoopRelMap = new HashMap<Long, List<TeamCoopRelBO>>(dynamicObjectCollection.size());
        ArrayList<TeamCoopRelBO> coopRelBOList = new ArrayList<TeamCoopRelBO>(4);
        if (!ObjectUtils.isEmpty((Object)dynamicObjectCollection)) {
            int index = 1;
            for (DynamicObject ele : dynamicObjectCollection) {
                TeamCoopRelBO teamCoopRelBO = new TeamCoopRelBO(org, ele.getLong("coopreltype.id"), ele.getLong("cooporgteam.id"), index);
                teamCoopRelBO.setBoId(ele.getLong("cooprelboid"));
                teamCoopRelBO.setEffDate(effDate);
                teamCoopRelBO.setChangeDescription(dataEntity.getString("changedescription"));
                coopRelBOList.add(teamCoopRelBO);
                ++index;
            }
        }
        orgTeamCoopRelMap.put(org, coopRelBOList);
        return orgTeamCoopRelMap;
    }

    private Map<Long, Long> getBoVsNewIdMap(HisVersionParamBo hisParamBo) {
        return Arrays.stream(hisParamBo.getHisDyns()).collect(Collectors.toMap(dy -> dy.getLong("boid"), dy -> dy.getLong("id")));
    }
}

