/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.business.service.projectgroup.service;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.hr.haos.business.domain.repository.orgteam.OTStructRepository;
import kd.hr.haos.business.domain.repository.prjorg.PRJOrgRepository;
import kd.hr.haos.business.service.projectgroup.service.IProjectInfoService;
import kd.hr.haos.common.constants.projectgroup.ProjectGroupMDConstants;

public class ProjectInfoService
implements IProjectInfoService,
ProjectGroupMDConstants {
    @Override
    public long findRootProjectTeam(long projectTeamId) {
        DynamicObject projectTeamStructDy = OTStructRepository.getInstance().queryOriginalByOtBo("structlongnumber", projectTeamId);
        if (projectTeamStructDy != null) {
            String SLN = projectTeamStructDy.getString("structlongnumber");
            String[] split = SLN.split("!");
            DynamicObject[] prjOrgDys = PRJOrgRepository.getInstance().queryOriginalByStructNumbers("id, structnumber", new HashSet<String>(Arrays.asList(split)));
            Map<String, Long> structNumberVsBo = Arrays.stream(prjOrgDys).collect(Collectors.toMap(dy -> dy.getString("structnumber"), dy -> dy.getLong("id")));
            Optional<Long> rootProjectTeamOpt = Arrays.stream(split).map(structNumberVsBo::get).filter(Objects::nonNull).findFirst();
            if (rootProjectTeamOpt.isPresent()) {
                return rootProjectTeamOpt.get();
            }
            throw new RuntimeException(String.format("can not find root project team, project team id: %s", projectTeamId));
        }
        return 0L;
    }

    @Override
    public boolean isRootProjectTeam(DynamicObject projectTeamDy) {
        return projectTeamDy.getLong("parentorg.otclassify.id") == 1010L;
    }

    @Override
    public int getChangeType(DynamicObject beforeProjectTeamDy, DynamicObject afterProjectTeamDy) {
        boolean isBeforeRoot = this.isRootProjectTeam(beforeProjectTeamDy);
        boolean isAfterRoot = this.isRootProjectTeam(afterProjectTeamDy);
        if (isBeforeRoot && isAfterRoot) {
            return 4;
        }
        if (!isBeforeRoot && !isAfterRoot) {
            return 3;
        }
        if (isBeforeRoot) {
            return 2;
        }
        return 1;
    }
}

