/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.business.service.projectgroup.valid.calibrator;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.login.utils.DateUtils;
import kd.hr.haos.business.domain.repository.prjorg.PRJOrgRepository;
import kd.hr.haos.business.service.projectgroup.bean.CalibratorBean;
import kd.hr.haos.business.service.projectgroup.valid.core.ProjectGroupValidContext;
import kd.hr.haos.business.service.projectgroup.valid.core.ProjectGroupValidService;
import kd.hr.haos.business.servicehelper.ProjectGroupServiceHelper;

public class ProjectGroupCommonValidator
implements ProjectGroupValidService {
    @Override
    public List<CalibratorBean> valid(ProjectGroupValidContext context) {
        ArrayList<CalibratorBean> result = new ArrayList<CalibratorBean>();
        this.dateCheck(context, result);
        return result;
    }

    private void dateCheck(ProjectGroupValidContext context, List<CalibratorBean> result) {
        String message;
        DynamicObject targetObject = context.getTargetObject();
        Date startDate = ProjectGroupServiceHelper.formatDateYYYYMMDD(targetObject.getDate("startdate"));
        Date establishDate = ProjectGroupServiceHelper.formatDateYYYYMMDD(targetObject.getDate("establishmentdate"));
        Date parentFirstBSed = ProjectGroupServiceHelper.formatDateYYYYMMDD(targetObject.getDate("parentorg.firstbsed"));
        String proNumber = targetObject.getString("number");
        if (startDate != null && startDate.before(establishDate)) {
            message = String.format(Locale.ROOT, ResManager.loadKDString((String)"%1$s\uff1a\u751f\u6548\u65e5\u671f\u5e94\u665a\u4e8e\u6216\u7b49\u4e8e\u9879\u76ee\u56e2\u961f\u7684\u6210\u7acb\u65e5\u671f\u201c%2$s\u201d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"ProjectGroupCommonValidator_2", (String)"hrmp-haos-business", (Object[])new Object[0]), proNumber, DateUtils.formatDate((Date)establishDate, (Object[])new Object[]{"yyyy-MM-dd"}));
            result.add(new CalibratorBean(message, false));
        }
        if (!"donothing_save_rel".equals(context.getChangeType()) && startDate != null && parentFirstBSed != null && startDate.before(parentFirstBSed)) {
            message = String.format(Locale.ROOT, ResManager.loadKDString((String)"%1$s\uff1a\u751f\u6548\u65e5\u671f\u5e94\u665a\u4e8e\u6216\u7b49\u4e8e\u4e0a\u7ea7\u7ec4\u7ec7\u7684\u6700\u65e9\u751f\u6548\u65e5\u671f\u201c%2$s\u201d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"ProjectGroupCommonValidator_1", (String)"hrmp-haos-business", (Object[])new Object[0]), proNumber, DateUtils.formatDate((Date)parentFirstBSed, (Object[])new Object[]{"yyyy-MM-dd"}));
            result.add(new CalibratorBean(message, false));
        }
        if ("donothing_confirmchangeinfo".equals(context.getChangeType()) || "donothing_confirmchangeparent".equals(context.getChangeType())) {
            DynamicObject[] curHisProjectTeam = PRJOrgRepository.getInstance().queryOriginalByPks("id, bsed", Sets.newHashSet((Object[])new Long[]{targetObject.getLong("boid")}));
            Date curHisBsed = ProjectGroupServiceHelper.formatDateYYYYMMDD(curHisProjectTeam[0].getDate("bsed"));
            if (startDate != null && startDate.before(curHisBsed)) {
                String message2 = String.format(ResManager.loadKDString((String)"%1$s\uff1a\u751f\u6548\u65e5\u671f\u5e94\u665a\u4e8e\u6216\u7b49\u4e8e\u5f53\u524d\u751f\u6548\u65e5\u671f\u201c%2$s\u201d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"ProjectGroupCommonValidator_3", (String)"hrmp-haos-business", (Object[])new Object[0]), targetObject.getString("number"), DateUtils.formatDate((Date)curHisBsed, (Object[])new Object[]{"yyyy-MM-dd"}));
                result.add(new CalibratorBean(message2, false));
            }
        }
    }
}

