/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.business.service.projectgroup.valid.calibrator;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.login.utils.DateUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.haos.business.service.projectgroup.bean.CalibratorBean;
import kd.hr.haos.business.service.projectgroup.valid.core.ProjectGroupValidContext;
import kd.hr.haos.business.service.projectgroup.valid.core.ProjectGroupValidService;
import kd.hr.haos.business.servicehelper.ProjectGroupServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;

public class ProjectGroupCoopInfoValidator
implements ProjectGroupValidService {
    private static final String SYSTEM_TYPE = "hrmp-haos-business";

    @Override
    public List<CalibratorBean> valid(ProjectGroupValidContext context) {
        DynamicObject targetObject = context.getTargetObject();
        DynamicObjectCollection coopInfoList = targetObject.getDynamicObjectCollection("entryentity");
        ArrayList result = Lists.newArrayListWithExpectedSize((int)16);
        this.checkCoopRelType(coopInfoList, result);
        if (!CollectionUtils.isEmpty((Collection)result)) {
            return result;
        }
        String changeType = context.getChangeType();
        if ("donothing_save_rel".equals(changeType) || "donothing_save".equals(changeType) || "donothing_saveandnew".equals(changeType)) {
            this.checkCoopRelFirstBSed(context, coopInfoList, result);
        }
        this.checkOrgTeamStatus(coopInfoList, result);
        return result;
    }

    private void checkCoopRelType(DynamicObjectCollection coopInfoList, List<CalibratorBean> result) {
        if (CollectionUtils.isEmpty((Collection)coopInfoList)) {
            return;
        }
        Map<Long, List<DynamicObject>> coopTypeIdMap = coopInfoList.stream().collect(Collectors.groupingBy(coopInfo -> coopInfo.getLong("coopreltype.id")));
        coopTypeIdMap.forEach((changeTypeId, coopInfos) -> {
            if (coopInfos.size() > 1) {
                String message = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u201c%s\u201d\u534f\u4f5c\u5173\u7cfb\u91cd\u590d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"ProjectGroupCoopInfoValidator_1", (String)SYSTEM_TYPE, (Object[])new Object[0]), ((DynamicObject)coopInfos.get(0)).getString("coopreltype.name"));
                result.add(new CalibratorBean(message, false));
            }
        });
    }

    private void checkCoopRelFirstBSed(ProjectGroupValidContext context, DynamicObjectCollection coopInfoList, List<CalibratorBean> result) {
        Optional<DynamicObject> addNewCoop;
        DynamicObject targetObject = context.getTargetObject();
        ArrayList<DynamicObject> proTeamNewErrList = new ArrayList<DynamicObject>(16);
        ArrayList<DynamicObject> proTeamChgSaveErrList = new ArrayList<DynamicObject>(16);
        ArrayList<DynamicObject> proTeamDelErrList = new ArrayList<DynamicObject>(16);
        HashMap<Long, Date> coopRelChgLastDateMap = new HashMap<Long, Date>(16);
        Date establishmentDate = ProjectGroupServiceHelper.formatDateYYYYMMDD(targetObject.getDate("establishmentdate"));
        Date coopTeamStartDate = ProjectGroupServiceHelper.formatDateYYYYMMDD(targetObject.getDate("bsed"));
        long proTeamId = targetObject.getLong("id");
        HashMap<Long, DynamicObject> coopRelDynMap = new HashMap(16);
        if (proTeamId != 0L) {
            coopRelDynMap = ProjectGroupServiceHelper.getCoopRelDynMap(proTeamId);
        }
        if ((addNewCoop = coopInfoList.stream().filter(dyn -> 0L == dyn.getLong("id")).findAny()).isPresent() && coopTeamStartDate.before(establishmentDate)) {
            String message = String.format(Locale.ROOT, ResManager.loadKDString((String)"%1$s\uff1a\u751f\u6548\u65e5\u671f\u5e94\u665a\u4e8e\u6216\u7b49\u4e8e\u9879\u76ee\u56e2\u961f\u7684\u6210\u7acb\u65e5\u671f\u201c%2$s\u201d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"ProjectGroupCoopInfoValidator_2", (String)SYSTEM_TYPE, (Object[])new Object[0]), targetObject.getString("number"), DateUtils.formatDate((Date)establishmentDate, (Object[])new Object[]{"yyyy-MM-dd"}));
            result.add(new CalibratorBean(message, false));
        }
        if (ObjectUtils.isEmpty(coopRelDynMap) && ObjectUtils.isEmpty((Object)coopInfoList)) {
            return;
        }
        ProjectGroupServiceHelper.addCoopRelErrInfo(coopInfoList, targetObject, proTeamNewErrList, proTeamChgSaveErrList, coopRelChgLastDateMap, proTeamDelErrList, coopRelDynMap);
        proTeamNewErrList.stream().forEach(coopInfo -> {
            Date orgTeamFirstBSed = coopInfo.getDate("cooporgteam.firstbsed");
            String message = String.format(Locale.ROOT, ResManager.loadKDString((String)"%1$s\uff1a\u751f\u6548\u65e5\u671f\u5e94\u665a\u4e8e\u6216\u7b49\u4e8e\u534f\u4f5c\u7ec4\u7ec7\u201c%2$s\u201d\u7684\u6700\u65e9\u751f\u6548\u65e5\u671f\u201c%3$s\u201d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"ProjectGroupCoopInfoValidator_3", (String)SYSTEM_TYPE, (Object[])new Object[0]), targetObject.getString("number"), coopInfo.getString("cooporgteam.name"), DateUtils.formatDate((Date)orgTeamFirstBSed, (Object[])new Object[]{"yyyy-MM-dd"}));
            result.add(new CalibratorBean(message, false));
        });
        proTeamChgSaveErrList.stream().forEach(coopInfo -> {
            Date lastDate = (Date)coopRelChgLastDateMap.get(coopInfo.getLong("id"));
            String message = String.format(Locale.ROOT, ResManager.loadKDString((String)"%1$s\uff1a\u751f\u6548\u65e5\u671f\u5e94\u665a\u4e8e\u6216\u7b49\u4e8e\u5f53\u524d\u751f\u6548\u65e5\u671f\u201c%2$s\u201d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"ProjectGroupCoopInfoValidator_4", (String)SYSTEM_TYPE, (Object[])new Object[0]), targetObject.getString("number"), DateUtils.formatDate((Date)lastDate, (Object[])new Object[]{"yyyy-MM-dd"}));
            result.add(new CalibratorBean(message, false));
        });
        proTeamDelErrList.forEach(coopInfo -> {
            Date orgTeamFirstBSed = coopInfo.getDate("bsed");
            String message = String.format(Locale.ROOT, ResManager.loadKDString((String)"%1$s\uff1a\u751f\u6548\u65e5\u671f\u5e94\u665a\u4e8e\u6216\u7b49\u4e8e\u5f53\u524d\u751f\u6548\u65e5\u671f\u201c%2$s\u201d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"ProjectGroupCoopInfoValidator_4", (String)SYSTEM_TYPE, (Object[])new Object[0]), targetObject.getString("number"), DateUtils.formatDate((Date)orgTeamFirstBSed, (Object[])new Object[]{"yyyy-MM-dd"}));
            result.add(new CalibratorBean(message, false));
        });
    }

    private void checkOrgTeamStatus(DynamicObjectCollection coopInfoList, List<CalibratorBean> result) {
        Set orgTeamIdSet = coopInfoList.stream().map(coopInfo -> coopInfo.getLong("cooporgteam.id")).collect(Collectors.toSet());
        QFilter idFilter = new QFilter("id", "in", orgTeamIdSet);
        HRBaseServiceHelper orgTeamServiceHelper = new HRBaseServiceHelper("haos_adminorgteam");
        DynamicObject[] orgTeamArray = orgTeamServiceHelper.queryOriginalArray("id, name, enable", new QFilter[]{idFilter});
        Map<Long, DynamicObject> orgTeamMap = Arrays.stream(orgTeamArray).collect(Collectors.toMap(orgTeam -> orgTeam.getLong("id"), orgTeam -> orgTeam, (object1, object2) -> object1));
        for (DynamicObject coopInfo2 : coopInfoList) {
            String enable;
            long orgTeamId = coopInfo2.getLong("cooporgteam.id");
            DynamicObject orgTeamInfo = orgTeamMap.get(orgTeamId);
            if (orgTeamInfo == null || !"0".equals(enable = orgTeamInfo.getString("enable"))) continue;
            String message = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u201c%1$s\u201d\u5bf9\u5e94\u7684\u534f\u4f5c\u7ec4\u7ec7\u201c%2$s\u201d\u5df2\u7981\u7528\uff0c\u8bf7\u4fee\u6539\u3002", (String)"ProjectGroupCoopInfoValidator_5", (String)SYSTEM_TYPE, (Object[])new Object[0]), coopInfo2.getString("coopreltype.name"), orgTeamInfo.getString("name"));
            result.add(new CalibratorBean(message, false));
        }
    }
}

