/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.business.service.projectgroup.valid.calibrator;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.hr.haos.business.domain.repository.prjorg.PRJOrgRepository;
import kd.hr.haos.business.service.projectgroup.bean.CalibratorBean;
import kd.hr.haos.business.service.projectgroup.service.LocaleStringComparator;
import kd.hr.haos.business.service.projectgroup.valid.core.ProjectGroupValidContext;
import kd.hr.haos.business.service.projectgroup.valid.core.ProjectGroupValidService;
import kd.hr.hbp.common.util.HRStringUtils;

public class ProjectGroupProjectInfoValidator
implements ProjectGroupValidService {
    @Override
    public List<CalibratorBean> valid(ProjectGroupValidContext context) {
        DynamicObject targetObject = context.getTargetObject();
        if (!this.isRootProjectTeam(targetObject)) {
            return Collections.emptyList();
        }
        ILocaleString projectName = targetObject.getLocaleString("projectname");
        long bo = targetObject.getLong("boid");
        ArrayList<CalibratorBean> result = new ArrayList<CalibratorBean>();
        DynamicObject[] hisData = PRJOrgRepository.getInstance().queryRootProjectTeamWithSameAdOrg("boid, projectname, projectnumber", targetObject.getLong("belongadminorg.id"), targetObject.getDate("bsed"));
        LocaleStringComparator localeStringComparator = new LocaleStringComparator();
        Optional<DynamicObject> sameNameOpt = Arrays.stream(hisData).filter(dy -> dy.getLong("boid") != bo).filter(dy -> localeStringComparator.compareAnyMatch(projectName, dy.getLocaleString("projectname"))).findAny();
        sameNameOpt.ifPresent(hisDatum -> {
            String errorNumber = localeStringComparator.getErrorNumber();
            String message = String.format(ResManager.loadKDString((String)"\u5728\u201c%1$s\u201d\u4e0b\uff0c\u9879\u76ee\u540d\u79f0\u201c%2$s\u201d\u5df2\u5b58\u5728\uff0c\u8bf7\u4fee\u6539\u3002", (String)"ProjectGroupProjectInfoValidator_1", (String)"hrmp-haos-business", (Object[])new Object[0]), targetObject.getString("belongadminorg.name"), projectName.getItem(errorNumber));
            result.add(new CalibratorBean(message, false));
        });
        String projectNumber = targetObject.getString("projectnumber");
        if (HRStringUtils.isNotEmpty((String)projectNumber)) {
            Optional<DynamicObject> sameNumberOpt = Arrays.stream(hisData).filter(dy -> dy.getLong("boid") != bo).filter(dy -> HRStringUtils.equals((String)projectNumber, (String)dy.getString("projectnumber"))).findAny();
            sameNumberOpt.ifPresent(hisDatum -> {
                String message = String.format(ResManager.loadKDString((String)"\u5728\u201c%1$s\u201d\u4e0b\uff0c\u9879\u76ee\u7f16\u53f7\u201c%2$s\u201d\u5df2\u5b58\u5728\uff0c\u8bf7\u4fee\u6539\u3002", (String)"ProjectGroupProjectInfoValidator_2", (String)"hrmp-haos-business", (Object[])new Object[0]), targetObject.getString("belongadminorg.name"), projectNumber);
                result.add(new CalibratorBean(message, false));
            });
        }
        return result;
    }

    private boolean isRootProjectTeam(DynamicObject targetObject) {
        long otClassifyId = targetObject.getLong("parentorg.otclassify.id");
        return otClassifyId == 1010L;
    }
}

