/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.business.service.staff.bean;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.db.DBRoute;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.hr.haos.business.domain.repository.staff.StaffDimensionRepository;
import kd.hr.haos.business.service.staff.bean.DynamicStaffDimensionVO;
import kd.hr.haos.business.service.staff.bean.StaffDimensionPersonVO;
import kd.hr.haos.business.service.staff.bean.StaffSyncPersonInfoHelperBo;
import kd.hr.haos.common.constants.staff.DynamicDimensionEnum;
import kd.hr.haos.common.constants.staff.OrgStaffConstants;
import kd.hr.haos.common.util.OrgDateTimeUtil;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.api.HrApiResponse;
import kd.hr.hbp.common.util.HRDBUtil;
import kd.hr.hbp.common.util.HRStringUtils;

public class EmpposorgrelSplitBO
implements OrgStaffConstants {
    private static final Log LOGGER = LogFactory.getLog(EmpposorgrelSplitBO.class);
    private static MainEntityType orgPersonStaffInfoMainEntityType = MetadataServiceHelper.getDataEntityType((String)"haos_orgpersonstaffinfo");
    private StaffSyncPersonInfoHelperBo syncHelperBo;
    private List<Long> useOrgIdList;
    private List<DynamicStaffDimensionVO> needSplitDimensionList;
    private List<DynamicStaffDimensionVO> needNotSplitDimensionList;
    private Map<String, Map<String, Object>> splitDimensionInfo = new HashMap<String, Map<String, Object>>(16);
    private Map<String, Map<String, Object>> nosplitDimensionInfo = new HashMap<String, Map<String, Object>>(16);
    private List<Long> personIdForRevisi;
    private int pageCount = 0;
    private String staffAdminorgKye;

    public EmpposorgrelSplitBO(StaffSyncPersonInfoHelperBo syncHelperBo, List<Long> useOrgIdList, List<Long> personIdList) {
        this.syncHelperBo = syncHelperBo;
        this.useOrgIdList = useOrgIdList;
        this.personIdForRevisi = personIdList;
        this.initStaffAdminorgKye();
        this.initDynamicStaffDimensionInfo();
    }

    private void initStaffAdminorgKye() {
        this.staffAdminorgKye = "adminorg";
        String selectSql = "select fbusinessvalue from t_hpfs_devconfig where fbusinesskey = ?";
        String orgKey = (String)HRDBUtil.query((DBRoute)new DBRoute("hr"), (String)selectSql, (Object[])new Object[]{"staff_adminorg"}, rs -> rs.next() ? rs.getString("fbusinessvalue") : "");
        if (!HRStringUtils.isEmpty((String)orgKey)) {
            this.staffAdminorgKye = orgKey;
        }
    }

    private void initDynamicStaffDimensionInfo() {
        DynamicObject[] dimensionInfo = StaffDimensionRepository.getInstance().listAllDimension();
        Map<Boolean, List<DynamicStaffDimensionVO>> dimensionGroupByByposorgrestaff = Arrays.stream(dimensionInfo).map(temp -> new DynamicStaffDimensionVO((DynamicObject)temp)).collect(Collectors.groupingBy(temp -> temp.isByposorgrestaff()));
        this.needNotSplitDimensionList = dimensionGroupByByposorgrestaff.getOrDefault(Boolean.FALSE, Lists.newArrayList());
        this.needSplitDimensionList = dimensionGroupByByposorgrestaff.getOrDefault(Boolean.TRUE, Lists.newArrayList());
    }

    private Map<String, Object> buildInvokeParam() {
        HashMap<String, Object> paramMap = new HashMap<String, Object>(16);
        paramMap.put("orgId", this.useOrgIdList);
        paramMap.put("startdate", this.syncHelperBo.getStart());
        paramMap.put("enddate", this.syncHelperBo.getEnd());
        paramMap.put("maxPersonId", this.syncHelperBo.getLastId());
        paramMap.put("top", this.syncHelperBo.getPage());
        return paramMap;
    }

    private Set<Long> getPersonId() {
        Map<String, Object> paramMap = this.buildInvokeParam();
        LOGGER.info("start sync staff info getpersonId : {}", (Object)paramMap.toString());
        HrApiResponse result = null;
        try {
            result = (HrApiResponse)HRMServiceHelper.invokeHRMPService((String)"hrpi", (String)"IHRPIPersonService", (String)"getPersonIdByOrgIds", (Object[])new Object[]{paramMap});
            if (result == null) {
                LOGGER.info("end_getpersonId_result is null");
                throw new KDException(new ErrorCode("genStaffDimensionInfoError", "getpersonId_result empty"), new Object[0]);
            }
            if (!result.isSuccess()) {
                LOGGER.info("end getpersonId_result errmsg : {}", (Object)result.getErrorMessage());
                throw new KDException(new ErrorCode("genStaffDimensionInfoError", result.getErrorMessage()), new Object[0]);
            }
            this.pageCount = ((Set)result.getData()).size();
        }
        catch (Exception exception) {
            LOGGER.error("sync staff info getpersonId error", (Throwable)exception);
            throw new KDException(new ErrorCode("genStaffDimensionInfoError", exception.getMessage()), new Object[0]);
        }
        return (Set)result.getData();
    }

    private List<StaffDimensionPersonVO> genStaffDimensionInfo() {
        Set<Long> personIds = this.getPersonId();
        if (personIds.size() > 0) {
            Long maxPersonId = (Long)personIds.stream().max(Long::compareTo).get();
            this.syncHelperBo.setLastId(maxPersonId);
        }
        return this.genStaffDimensionInfo(personIds);
    }

    private List<StaffDimensionPersonVO> genStaffDimensionInfo(Set<Long> personIds) {
        ArrayList<StaffDimensionPersonVO> finalToSplitStaffDimensionList = new ArrayList<StaffDimensionPersonVO>(16);
        if (CollectionUtils.isEmpty(personIds)) {
            return finalToSplitStaffDimensionList;
        }
        Map<String, Object> param = this.buildInvokePersonInfoByPersonIdParam(personIds);
        try {
            LOGGER.info("start sync staff info genStaffDimensionInfo : {}", (Object)param.toString());
            HrApiResponse result = (HrApiResponse)HRMServiceHelper.invokeHRMPService((String)"hrpi", (String)"IHRPIPersonService", (String)"personInfoByPersonId", (Object[])new Object[]{param});
            if (result == null) {
                LOGGER.info("end genStaffDimensionInfo result is empty");
                throw new KDException(new ErrorCode("genStaffDimensionInfoError", ""), new Object[0]);
            }
            if (!result.isSuccess()) {
                LOGGER.info("end getpersonId result wrong : {}", (Object)result.getErrorMessage());
                throw new KDException(new ErrorCode("genStaffDimensionInfoError", ""), new Object[0]);
            }
            Map data = (Map)result.getData();
            data.forEach((personId, map) -> {
                LOGGER.info("split start personid_{}", personId);
                List<StaffDimensionPersonVO> staffDimensionToSplit = this.buildStaffDimensionEveryPerson((Long)personId, map);
                LOGGER.info("tosplitdata personid_{}, result {}", personId, staffDimensionToSplit.stream().map(StaffDimensionPersonVO::toString).collect(Collectors.toList()));
                List<StaffDimensionPersonVO> split = this.split(staffDimensionToSplit, (Map)map);
                finalToSplitStaffDimensionList.addAll(split);
                LOGGER.info("split end personid_{}, result {}", personId, split.stream().map(StaffDimensionPersonVO::toString).collect(Collectors.toList()));
            });
        }
        catch (Exception exp) {
            LOGGER.error("sync staff info genStaffDimensionInfo error", (Throwable)exp);
            throw new KDException((Throwable)exp, new ErrorCode("genStaffDimensionInfoError", exp.getMessage()), new Object[0]);
        }
        return finalToSplitStaffDimensionList;
    }

    public List<DynamicObject> genStaffDimensionDy() {
        List<Long> personIdForRevisi = this.getPersonIdForRevisi();
        List<StaffDimensionPersonVO> staffDimensionPersonVOS = personIdForRevisi == null ? this.genStaffDimensionInfo() : this.genStaffDimensionInfo(new HashSet<Long>(personIdForRevisi));
        ArrayList<DynamicObject> staffDimensionDys = new ArrayList<DynamicObject>(staffDimensionPersonVOS.size());
        long[] ids = ORM.create().genLongIds("haos_orgpersonstaffinfo", staffDimensionPersonVOS.size());
        int index = 0;
        for (StaffDimensionPersonVO temp : staffDimensionPersonVOS) {
            DynamicObject staffDimensionDy = new DynamicObject((DynamicObjectType)orgPersonStaffInfoMainEntityType);
            if (this.isLongEmpty(temp.getPersonId()) || this.isLongEmpty(temp.getOrgpersonId()) || this.isLongEmpty(temp.getOrgteamId())) continue;
            staffDimensionDy.set("id", (Object)ids[index++]);
            staffDimensionDy.set("person", (Object)temp.getPersonId());
            staffDimensionDy.set("orgperson", (Object)temp.getOrgpersonId());
            staffDimensionDy.set("orgteam", (Object)temp.getOrgteamId());
            staffDimensionDy.set("dutyworkrole", (Object)temp.getDutyworkroleId());
            staffDimensionDy.set("job", (Object)temp.getJobId());
            staffDimensionDy.set("laborreltype", (Object)temp.getLaborreltype());
            staffDimensionDy.set("effdt", (Object)temp.getStartdate());
            staffDimensionDy.set("leffdt", (Object)temp.getEnddate());
            staffDimensionDy.set("status", (Object)this.getStatusByLeffdt(temp.getEnddate()));
            this.setExtendDimensionValue(staffDimensionDy, DynamicDimensionEnum.basicData1.getDimenSionIdentity(), temp.getBasicdata1());
            this.setExtendDimensionValue(staffDimensionDy, DynamicDimensionEnum.basicData2.getDimenSionIdentity(), temp.getBasicdata2());
            this.setExtendDimensionValue(staffDimensionDy, DynamicDimensionEnum.basicData3.getDimenSionIdentity(), temp.getBasicdata3());
            this.setExtendDimensionValue(staffDimensionDy, DynamicDimensionEnum.basicData4.getDimenSionIdentity(), temp.getBasicdata4());
            this.setExtendDimensionValue(staffDimensionDy, DynamicDimensionEnum.basicData5.getDimenSionIdentity(), temp.getBasicdata5());
            staffDimensionDys.add(staffDimensionDy);
        }
        return staffDimensionDys;
    }

    private List<StaffDimensionPersonVO> split(List<StaffDimensionPersonVO> staffDimensionToSplit, Map<String, Object> datas) {
        HashSet staffDimensionPersonVOS = new HashSet(16);
        datas.forEach((entityname, map) -> {
            if (entityname.equals("hrpi_employee")) {
                return;
            }
            List<Object> tempList = new ArrayList(16);
            if (staffDimensionPersonVOS.isEmpty()) {
                tempList.addAll(staffDimensionToSplit);
            } else {
                tempList.addAll(staffDimensionPersonVOS.stream().filter(temp -> !temp.getStartdate().after(temp.getEnddate()) && !temp.isInvalid()).collect(Collectors.toList()));
            }
            staffDimensionPersonVOS.clear();
            Map<String, Object> splitInfo = this.splitDimensionInfo.get(entityname);
            List<Map<String, Object>> dimensionMaps = (List<Map<String, Object>>)map;
            if (splitInfo == null) {
                Map<String, Object> cacheInfo = this.nosplitDimensionInfo.get(entityname);
                if (cacheInfo == null) {
                    staffDimensionPersonVOS.addAll(tempList);
                    LOGGER.info("cacheinfo is null entityName:{}", entityname);
                    LOGGER.info("cacheinfo is null nosplitDimensionInfo:{}", (Object)this.nosplitDimensionInfo.toString());
                    LOGGER.info("cacheinfo is null splitDimensionInfo:{}", (Object)this.splitDimensionInfo.toString());
                    return;
                }
                String fields = (String)cacheInfo.get("fields");
                String staffdimension = (String)cacheInfo.get("staffdimension");
                Map dimensionMap = (Map)dimensionMaps.get(0);
                tempList.forEach(temp -> {
                    Map<String, Consumer<Long>> setDimensionMap = temp.getSetDimensionMap();
                    setDimensionMap.get(staffdimension).accept(this.getDynamicPkId(dimensionMap.get(fields)));
                });
                staffDimensionPersonVOS.addAll(tempList);
            } else {
                String dimensionStartDateIdentity = (String)splitInfo.get("startdate");
                String dimensionEndDateIdentity = (String)splitInfo.get("enddate");
                String fields = (String)splitInfo.get("fields");
                String staffdimension = (String)splitInfo.get("staffdimension");
                tempList = tempList.stream().sorted(Comparator.comparing(StaffDimensionPersonVO::getStartdate)).collect(Collectors.toList());
                EmpposorgrelSplitBO.removeRepeateData(dimensionMaps, dimensionStartDateIdentity, dimensionEndDateIdentity);
                dimensionMaps = dimensionMaps.stream().sorted(Comparator.comparing(o -> (Date)o.get(dimensionStartDateIdentity))).collect(Collectors.toList());
                this.logExtendTimeDimData(staffDimensionToSplit, dimensionMaps, dimensionStartDateIdentity, dimensionEndDateIdentity, fields, staffdimension);
                for (StaffDimensionPersonVO staffDimensionPersonVO : tempList) {
                    for (Map<String, Object> dimensionMap : dimensionMaps) {
                        StaffDimensionPersonVO second;
                        StaffDimensionPersonVO first;
                        Date startdate = staffDimensionPersonVO.getStartdate();
                        Date enddate = staffDimensionPersonVO.getEnddate();
                        Date dimensionStartDate = (Date)dimensionMap.get(dimensionStartDateIdentity);
                        Date dimensionEndDate = (Date)dimensionMap.get(dimensionEndDateIdentity);
                        boolean finishFlag = (Boolean)dimensionMap.getOrDefault("finishFlag", false);
                        if (finishFlag || dimensionEndDate.before(startdate)) continue;
                        if (startdate.compareTo(dimensionStartDate) <= 0 && enddate.compareTo(dimensionEndDate) >= 0) {
                            first = staffDimensionPersonVO.copy(startdate, this.getTragetDate(dimensionStartDate, -1));
                            second = staffDimensionPersonVO.copy(dimensionStartDate, dimensionEndDate, staffdimension, this.getDynamicPkId(dimensionMap.get(fields)));
                            staffDimensionPersonVO.setStartdate(this.getTragetDate(dimensionEndDate, 1));
                            staffDimensionPersonVOS.add(first);
                            staffDimensionPersonVOS.add(second);
                            dimensionMap.put("finishFlag", true);
                            continue;
                        }
                        if (startdate.compareTo(dimensionStartDate) >= 0 && enddate.compareTo(dimensionEndDate) >= 0 && dimensionEndDate.compareTo(startdate) >= 0) {
                            first = staffDimensionPersonVO.copy(startdate, dimensionEndDate, staffdimension, this.getDynamicPkId(dimensionMap.get(fields)));
                            staffDimensionPersonVO.setStartdate(this.getTragetDate(dimensionEndDate, 1));
                            staffDimensionPersonVOS.add(first);
                            dimensionMap.put("finishFlag", true);
                            continue;
                        }
                        if (startdate.compareTo(dimensionStartDate) <= 0 && enddate.compareTo(dimensionEndDate) <= 0 && enddate.compareTo(dimensionStartDate) >= 0) {
                            first = staffDimensionPersonVO.copy(startdate, this.getTragetDate(dimensionStartDate, -1));
                            second = staffDimensionPersonVO.copy(dimensionStartDate, enddate, staffdimension, this.getDynamicPkId(dimensionMap.get(fields)));
                            staffDimensionPersonVOS.add(first);
                            staffDimensionPersonVOS.add(second);
                            dimensionMap.put(dimensionStartDateIdentity, this.getTragetDate(enddate, 1));
                            staffDimensionPersonVO.setInvalid(true);
                            break;
                        }
                        if (startdate.compareTo(dimensionStartDate) >= 0 && enddate.compareTo(dimensionEndDate) <= 0) {
                            first = staffDimensionPersonVO.copy(startdate, enddate, staffdimension, this.getDynamicPkId(dimensionMap.get(fields)));
                            staffDimensionPersonVOS.add(first);
                            dimensionMap.put(dimensionStartDateIdentity, this.getTragetDate(enddate, 1));
                            staffDimensionPersonVO.setInvalid(true);
                            break;
                        }
                        staffDimensionPersonVOS.add(staffDimensionPersonVO);
                    }
                    staffDimensionPersonVOS.add(staffDimensionPersonVO);
                }
            }
        });
        return staffDimensionPersonVOS.stream().filter(temp -> !temp.getStartdate().after(temp.getEnddate()) && !temp.isInvalid()).collect(Collectors.toList());
    }

    private List<StaffDimensionPersonVO> buildStaffDimensionEveryPerson(Long personId, Object map) {
        ArrayList<StaffDimensionPersonVO> tempList = new ArrayList<StaffDimensionPersonVO>(16);
        HashMap employeeIdKeyMap = new HashMap(16);
        Map entityNameKeyMap = (Map)map;
        List empposorgrel = (List)entityNameKeyMap.get("hrpi_empposorgrel");
        if (empposorgrel == null) {
            return tempList;
        }
        EmpposorgrelSplitBO.removeRepeateData(empposorgrel, "startdate", "enddate");
        empposorgrel.forEach(temp -> this.buildStaffDimensionByEmpposorgrel((List<StaffDimensionPersonVO>)tempList, personId, (Map<String, Object>)temp, employeeIdKeyMap));
        List employee = (List)entityNameKeyMap.get("hrpi_employee");
        if (employee == null) {
            return tempList;
        }
        employee.forEach(temp -> {
            String employeeid = String.valueOf(temp.get("id"));
            List employeeDy = (List)employeeIdKeyMap.get(employeeid);
            if (employeeDy == null) {
                return;
            }
            this.buildStaffDimensionByEmployee(employeeDy, (Map<String, Object>)temp);
        });
        return tempList;
    }

    private static void removeRepeateData(List<Map<String, Object>> list, String startKey, String endKey) {
        Map<Date, List<Map>> dateMap = list.stream().collect(Collectors.groupingBy(map -> (Date)map.get(startKey)));
        list.clear();
        dateMap.forEach((startdate, dataList) -> {
            if (dataList.size() > 1) {
                dataList = dataList.stream().sorted(Comparator.comparing(map -> (Date)map.get(endKey))).collect(Collectors.toList());
                Map data = (Map)dataList.get(dataList.size() - 1);
                dataList.clear();
                dataList.add(data);
            }
            list.addAll((Collection<Map<String, Object>>)dataList);
        });
    }

    private void buildStaffDimensionByEmpposorgrel(List<StaffDimensionPersonVO> staffdimensionInfo, Long personId, Map<String, Object> dimensionInfo, Map<String, List<StaffDimensionPersonVO>> employeeIdKeyMap) {
        StaffDimensionPersonVO staffDimensionPersonVO = new StaffDimensionPersonVO(personId, this.getDynamicPkId(dimensionInfo.get("depemp")), this.getStaffAdminorgValue(dimensionInfo), this.getDynamicPkId(dimensionInfo.get("position")), this.getDynamicPkId(dimensionInfo.get("job")), (Date)dimensionInfo.get("startdate"), (Date)dimensionInfo.get("enddate"), this.getDynamicPkId(dimensionInfo.get("employee")), 0L);
        String employeeId = String.valueOf(this.getDynamicPkId(dimensionInfo.get("employee")));
        List<StaffDimensionPersonVO> employeeDimensionVOList = employeeIdKeyMap.get(employeeId);
        if (employeeDimensionVOList == null) {
            employeeDimensionVOList = new ArrayList<StaffDimensionPersonVO>();
        }
        employeeDimensionVOList.add(staffDimensionPersonVO);
        employeeIdKeyMap.putIfAbsent(employeeId, employeeDimensionVOList);
        staffdimensionInfo.add(staffDimensionPersonVO);
    }

    private long getStaffAdminorgValue(Map<String, Object> dimensionInfo) {
        long id = this.getDynamicPkId(dimensionInfo.get(this.staffAdminorgKye));
        if (!HRStringUtils.equals((String)this.staffAdminorgKye, (String)"adminorg") && id == 0L) {
            return this.getDynamicPkId(dimensionInfo.get("adminorg"));
        }
        return id;
    }

    private void buildStaffDimensionByEmployee(List<StaffDimensionPersonVO> staffdimensionInfo, Map<String, Object> dimensionInfo) {
        staffdimensionInfo.forEach(info -> info.setLaborreltype(this.getDynamicPkId(dimensionInfo.get("laborreltype"))));
    }

    private Map<String, Object> buildInvokePersonInfoByPersonIdParam(Set<Long> personId) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>(32);
        paramMap.put("startdate", this.syncHelperBo.getStart());
        paramMap.put("enddate", this.syncHelperBo.getEnd());
        paramMap.put("person_id", new ArrayList<Long>(personId));
        ArrayList<Map<String, Object>> entityNameAndFields = new ArrayList<Map<String, Object>>(16);
        this.needSplitDimensionList.forEach(dynamicStaffDimensionVO -> entityNameAndFields.add(this.buildSplitDimensinoMetaInfo((DynamicStaffDimensionVO)dynamicStaffDimensionVO)));
        this.needNotSplitDimensionList.forEach(dynamicStaffDimensionVO -> entityNameAndFields.add(this.buildNoSplitDimensinoMetaInfo((DynamicStaffDimensionVO)dynamicStaffDimensionVO)));
        Map<String, Object> defaultEmpposorgrelParam = this.buildDefaultEmpposorgrelParam();
        Map<String, Object> defaultEmployeeParam = this.buildDefaultEmployeeParam();
        entityNameAndFields.add(defaultEmployeeParam);
        entityNameAndFields.add(defaultEmpposorgrelParam);
        paramMap.put("entitynameAndFields", entityNameAndFields);
        return paramMap;
    }

    private Map<String, Object> buildSplitDimensinoMetaInfo(DynamicStaffDimensionVO dynamicStaffDimensionVO) {
        HashMap<String, Object> param = new HashMap<String, Object>(16);
        param.put("entityname", dynamicStaffDimensionVO.getMappersoninfo());
        param.put("fields", dynamicStaffDimensionVO.getMapfieldflag());
        param.put("startdate", dynamicStaffDimensionVO.getStaffstartflag());
        param.put("enddate", dynamicStaffDimensionVO.getStaffendflag());
        param.put("datefilter", true);
        param.put("staffdimension", dynamicStaffDimensionVO.getStaffDimension());
        this.splitDimensionInfo.put(dynamicStaffDimensionVO.getMappersoninfo(), param);
        return param;
    }

    private Map<String, Object> buildNoSplitDimensinoMetaInfo(DynamicStaffDimensionVO dynamicStaffDimensionVO) {
        HashMap<String, Object> param = new HashMap<String, Object>(8);
        param.put("entityname", dynamicStaffDimensionVO.getMappersoninfo());
        param.put("fields", dynamicStaffDimensionVO.getMapfieldflag());
        param.put("datefilter", false);
        this.execEmpposorgrelDate(param);
        this.nosplitDimensionInfo.put(dynamicStaffDimensionVO.getMappersoninfo(), param);
        param.put("staffdimension", dynamicStaffDimensionVO.getStaffDimension());
        return param;
    }

    private Map<String, Object> buildDefaultEmpposorgrelParam() {
        HashMap<String, Object> param = new HashMap<String, Object>(16);
        param.put("entityname", "hrpi_empposorgrel");
        String selectFields = "id,person,adminorg,postype,employee,enddate,startdate,depemp,job,position";
        if (!HRStringUtils.equals((String)this.staffAdminorgKye, (String)"adminorg")) {
            selectFields = selectFields + "," + this.staffAdminorgKye;
        }
        param.put("fields", selectFields);
        param.put("startdate", "startdate");
        param.put("enddate", "enddate");
        param.put("datefilter", true);
        return param;
    }

    private Map<String, Object> buildDefaultEmployeeParam() {
        HashMap<String, Object> param = new HashMap<String, Object>(8);
        param.put("entityname", "hrpi_employee");
        param.put("fields", "id,laborreltype");
        param.put("datefilter", false);
        return param;
    }

    private void execEmpposorgrelDate(Map<String, Object> param) {
        String entityname = (String)param.getOrDefault("entityname", "");
        if (entityname.equals("hrpi_empposorgrel")) {
            param.put("startdate", "startdate");
            param.put("enddate", "enddate");
            param.put("datefilter", true);
        }
    }

    public String getStatusByLeffdt(Date leffdt) {
        Date leffdtTemp = Objects.isNull(leffdt) ? OrgDateTimeUtil.BSLED : leffdt;
        return new Date().before(leffdtTemp) ? "1" : "2";
    }

    public List<Long> getPersonIdForRevisi() {
        return this.personIdForRevisi;
    }

    private Long getDynamicPkId(Object value) {
        if (value == null) {
            return 0L;
        }
        if (value instanceof DynamicObject) {
            return ((DynamicObject)value).getLong("id");
        }
        if (value instanceof Integer) {
            return (long)((Integer)value);
        }
        if (value instanceof Long) {
            return (Long)value;
        }
        if (value instanceof String) {
            return Long.parseLong((String)value);
        }
        return 0L;
    }

    private void setExtendDimensionValue(DynamicObject staffDimensionDy, String key, Object value) {
        if (staffDimensionDy.containsProperty(key)) {
            staffDimensionDy.set(key, value);
        }
    }

    public int getPageCount() {
        return this.pageCount;
    }

    private boolean isLongEmpty(Long value) {
        return value == null || value == 0L;
    }

    private Date getTragetDate(Date date, int dayNums) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(5, dayNums);
        return calendar.getTime();
    }

    private void logExtendTimeDimData(List<StaffDimensionPersonVO> staffDimensionToSplit, List<Map<String, Object>> dimensionMaps, String dimensionStartDateIdentity, String dimensionEndDateIdentity, String fields, String staffdimension) {
        if (CollectionUtils.isEmpty(staffDimensionToSplit)) {
            return;
        }
        long personId = staffDimensionToSplit.get(0).getPersonId();
        StringBuilder logmsg = new StringBuilder();
        logmsg.append("dimdata_personid_").append(personId);
        for (Map<String, Object> map : dimensionMaps) {
            logmsg.append("startdate:").append(map.get(dimensionStartDateIdentity));
            logmsg.append("enddate:").append(map.get(dimensionEndDateIdentity));
            logmsg.append(staffdimension).append(":").append(this.getDynamicPkId(map.get(fields)));
        }
        LOGGER.info(logmsg.toString());
    }
}

