/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.business.service.staff.bean;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.MainEntityType;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.hr.haos.business.service.staff.bean.AbstractStaffPerson;
import kd.hr.haos.business.service.staff.bean.ChangeEventBo;
import kd.hr.haos.business.service.staff.bean.MulDimDetailBo;
import kd.hr.haos.business.service.staff.bean.MulDimUseStaffBo;
import kd.hr.haos.business.service.staff.bean.StaffContext;
import kd.hr.haos.business.service.staff.bean.StaffPersonBo;

public class OrgUseStaffBo
extends AbstractStaffPerson {
    private static final Log LOG = LogFactory.getLog(OrgUseStaffBo.class);
    private static MainEntityType orgUseStaffDetailEntityType = MetadataServiceHelper.getDataEntityType((String)"haos_orgusestaffdetail");
    private StaffPersonBo staffPersonBo;
    private ChangeEventBo changeEvent;
    private List<MulDimUseStaffBo> mulDimUseStaffBoList = Lists.newArrayList();
    private Long useOrgDetailId;
    private Long useOrgBoId;
    private String status;
    private String type;
    private Long depempId;
    private StaffContext staffContext;
    private DynamicObject dynamicObject;
    private Long id;
    private Long bo;

    public OrgUseStaffBo(DynamicObject dynamicObject, String type, StaffContext staffContext) {
        this.dynamicObject = dynamicObject;
        this.staffContext = staffContext;
        this.type = type;
        this.setEffdt(dynamicObject.getDate("effdt"));
        this.setLeffdt(dynamicObject.getDate("leffdt"));
        this.status = this.getStatusByLeffdt();
        this.useOrgBoId = dynamicObject.getLong("orgteam_id");
        this.useOrgDetailId = staffContext.getUseOrgDetailMapping().get(this.useOrgBoId);
        this.depempId = dynamicObject.getLong("orgperson_id");
        this.id = ID.genLongId();
        this.bo = staffContext.getUseOrgBOMapping().get(this.useOrgDetailId);
        if (0L == this.useOrgBoId || 0L == this.depempId) {
            LOG.warn("orgteamid is zero or depempId is zero, useOrgId = {}, depempId = {}", (Object)this.useOrgBoId, (Object)this.depempId);
        }
        this.staffPersonBo = new StaffPersonBo(dynamicObject, this);
        this.staffPersonBo.init();
        this.initMulDim();
        if (this.useOrgDetailId == null || this.useOrgDetailId == 0L) {
            this.id = 0L;
        }
    }

    private void initMulDim() {
        List<MulDimDetailBo> mulDimDetailBoList = this.staffContext.getMulDimMapping().get(this.useOrgBoId);
        if (Objects.isNull(mulDimDetailBoList)) {
            return;
        }
        for (MulDimDetailBo mulDimDetailBo : mulDimDetailBoList) {
            Long id = mulDimDetailBo.mapping(this.dynamicObject);
            if (Objects.isNull(id)) continue;
            Long bo = this.staffContext.getMulDimBOMapping().get(id);
            MulDimUseStaffBo mulDimUseStaffBo = new MulDimUseStaffBo(id, bo, this.staffPersonBo, this);
            this.mulDimUseStaffBoList.add(mulDimUseStaffBo);
        }
    }

    public DynamicObject convertToDynamicObject() {
        DynamicObject dy = new DynamicObject((DynamicObjectType)orgUseStaffDetailEntityType);
        dy.set("id", (Object)this.id);
        dy.set("personstaffinfo", (Object)this.staffPersonBo.getId());
        dy.set("useorgdetail", (Object)this.useOrgDetailId);
        dy.set("useorg", (Object)this.useOrgBoId);
        dy.set("status", (Object)this.status);
        dy.set("stafftype", (Object)this.type);
        dy.set("effdt", (Object)this.getEffdt());
        dy.set("leffdt", (Object)this.getLeffdt());
        dy.set("orgperson", (Object)this.depempId);
        dy.set("bo", (Object)this.bo);
        this.addDefaultInfo(dy);
        return dy;
    }

    public StaffPersonBo getStaffPersonBo() {
        return this.staffPersonBo;
    }

    public ChangeEventBo getChangeEvent() {
        return this.changeEvent;
    }

    public List<MulDimUseStaffBo> getMulDimUseStaffBoList() {
        return this.mulDimUseStaffBoList;
    }

    public String getStatus() {
        return this.status;
    }

    public String getType() {
        return this.type;
    }

    public Long getId() {
        return this.id;
    }

    public StaffContext getStaffContext() {
        return this.staffContext;
    }
}

