/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.business.service.staff.bean;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.hr.haos.business.domain.repository.staff.OrgPersonStaffInfoRepository;
import kd.hr.haos.common.constants.staff.OrgStaffConstants;
import org.apache.curator.shaded.com.google.common.collect.Maps;

public class StaffCallRuleEngineParamBo
implements OrgStaffConstants {
    private static OrgPersonStaffInfoRepository orgPersonStaffInfoRepository = OrgPersonStaffInfoRepository.getInstance();
    private String buNumber;
    private List<Long> executePolicyIds;
    private Map<String, Object> inputParams;
    private String serialNumber;
    private long orgId;

    public StaffCallRuleEngineParamBo(Long positionId, Long jobId, Long laborreltypeId, Long adminorgId, String serialNumber, long orgId) {
        this.initInputParams(positionId, jobId, laborreltypeId, adminorgId);
        this.serialNumber = serialNumber;
        this.orgId = orgId;
    }

    public StaffCallRuleEngineParamBo(Long positionId, Long jobId, Long laborreltypeId, Long adminorgId, Long policyId, String orgNumber, String serialNumber) {
        this.initInputParams(positionId, jobId, laborreltypeId, adminorgId);
        this.executePolicyIds = Collections.singletonList(policyId);
        this.buNumber = orgNumber;
        this.serialNumber = serialNumber;
    }

    public Map<String, Object> toParamMap() {
        HashMap params = Maps.newHashMapWithExpectedSize((int)8);
        params.put("bizApp", "homs");
        params.put("sceneNumber", "UncontrolledHeadcount");
        params.put("buNumber", this.buNumber);
        params.put("executePolicyIds", this.executePolicyIds);
        params.put("serialNumber", this.serialNumber);
        params.put("inputParams", this.inputParams);
        return params;
    }

    private void initInputParams(Long positionId, Long jobId, Long laborreltypeId, Long adminorgId) {
        this.inputParams = Maps.newHashMapWithExpectedSize((int)8);
        this.inputParams.put("orgteam", orgPersonStaffInfoRepository.getEmptyDynWithId("haos_adminorghr", adminorgId));
        if (positionId != null && positionId != 0L) {
            this.inputParams.put("position", orgPersonStaffInfoRepository.getEmptyDynWithId("hbpm_positionhr", positionId));
        }
        if (jobId != null && jobId != 0L) {
            this.inputParams.put("job", orgPersonStaffInfoRepository.getEmptyDynWithId("hbjm_jobhr", jobId));
        }
        if (laborreltypeId != null && laborreltypeId != 0L) {
            this.inputParams.put("laborreltype", orgPersonStaffInfoRepository.getEmptyDynWithId("hbss_laborreltype", laborreltypeId));
        }
    }

    public void setBuNumber(String buNumber) {
        this.buNumber = buNumber;
    }

    public void setExecutePolicyIds(List<Long> executePolicyIds) {
        this.executePolicyIds = executePolicyIds;
    }

    public String getSerialNumber() {
        return this.serialNumber;
    }

    public long getOrgId() {
        return this.orgId;
    }
}

