/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.business.service.staff.helper;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.datamodel.events.BeforeImportEntryEventArgs;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.entity.property.ComboProp;
import kd.bos.form.IFormView;
import kd.bos.form.plugin.importentry.resolving.ImportEntryData;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.haos.business.domain.repository.staff.StaffDimensionRepository;
import kd.hr.haos.business.service.staff.helper.IStaffEntryImportStrategy;
import kd.hr.haos.business.service.staff.helper.StaffEntryTempHelperEnum;
import kd.hr.haos.business.service.staff.service.StaffCommonService;
import kd.hr.haos.business.service.staff.service.StaffExtEntryHelper;
import kd.hr.haos.common.constants.staff.OrgStaffConstants;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;

public abstract class AbStractStaffEntryImport
implements IStaffEntryImportStrategy,
OrgStaffConstants {
    protected BeforeImportEntryEventArgs event;
    protected Map<String, List<ImportEntryData>> source;
    protected IFormView formView;
    protected static final Pattern COUNT_PATTERN = Pattern.compile("[0-9]*");
    protected String prefix;
    protected String entryKeyField;
    protected String importEntryName;
    protected String keyFieldEntityName;
    protected String entryStaffDimension;
    protected String entryControlStrategy;
    protected String entryElasticControl;
    protected String entryElasticCount;
    protected String entryYearStaff;
    protected String entryStaffYearNumWithSub;
    protected List<String> entryMonthStaffList = Lists.newArrayListWithExpectedSize((int)16);
    protected final Integer YEAR_STAFF_NUM = 13;
    protected List<String> useOrgNumberList = Lists.newArrayListWithExpectedSize((int)16);
    protected Map<String, Long> staffDimensionNameVsIdMap;
    protected Map<String, Long> staffDimensionNumberVsIdMap;
    protected Map<String, String> controlStrategyMap;
    protected Map<String, String> elasticControlMap;
    protected Map<String, Map<String, Object>> useOrgNumberVsPropValueMap = Maps.newHashMapWithExpectedSize((int)16);
    protected Map<String, Map<String, Object>> useOrgNameVsPropValueMap = Maps.newHashMapWithExpectedSize((int)16);
    protected List<String> hasSubUseOrgNumberList = Lists.newArrayListWithExpectedSize((int)16);
    Map<String, Map<String, Map<Integer, Integer>>> prefixVsStaffNumMap = Maps.newHashMapWithExpectedSize((int)16);
    private StaffExtEntryHelper staffExtEntryHelper = new StaffExtEntryHelper();

    public AbStractStaffEntryImport() {
    }

    public AbStractStaffEntryImport(BeforeImportEntryEventArgs event, Map<String, List<ImportEntryData>> source, IFormView formView) {
        this.event = event;
        this.source = source;
        this.formView = formView;
    }

    @Override
    public void init() {
        DynamicObjectCollection useOrgEntryEntityCol = this.formView.getModel().getEntryEntity("bentryentity");
        this.useOrgNumberList = useOrgEntryEntityCol.stream().map(entryEntity -> entryEntity.getString("buseorg.number")).collect(Collectors.toList());
        QFilter qfilter = new QFilter("1", "=", (Object)1);
        DynamicObject[] staffDimensionDyn = StaffDimensionRepository.getInstance().loadDynamicObjectArray(qfilter);
        this.staffDimensionNameVsIdMap = Arrays.stream(staffDimensionDyn).collect(Collectors.toMap(dyn -> dyn.getString("name"), dyn -> dyn.getLong("id")));
        this.staffDimensionNumberVsIdMap = Arrays.stream(staffDimensionDyn).collect(Collectors.toMap(dyn -> dyn.getString("number"), dyn -> dyn.getLong("id")));
        List controlStrategyComboItems = ((ComboProp)this.formView.getModel().getProperty("staffcontrolstrategy")).getComboItems();
        this.controlStrategyMap = controlStrategyComboItems.stream().collect(Collectors.toMap(valueMapItem -> valueMapItem.getName().getLocaleValue(), ValueMapItem::getValue));
        for (DynamicObject useOrgEntryEntity : useOrgEntryEntityCol) {
            boolean haveSubEntry = useOrgEntryEntity.getBoolean("bhavesubentry");
            if (!haveSubEntry) continue;
            this.hasSubUseOrgNumberList.add(useOrgEntryEntity.getString("buseorg.number"));
        }
        List elasticControlComboItems = ((ComboProp)this.formView.getModel().getProperty("staffelasticcontrol")).getComboItems();
        this.elasticControlMap = elasticControlComboItems.stream().collect(Collectors.toMap(valueMapItem -> valueMapItem.getName().getLocaleValue(), ValueMapItem::getValue));
        List<String> multiPrefixList = StaffEntryTempHelperEnum.getMultiPrefixList();
        for (DynamicObject useOrgEntryEntity : useOrgEntryEntityCol) {
            long useOrgId = useOrgEntryEntity.getLong("buseorg.id");
            String useOrgNumber = useOrgEntryEntity.getString("buseorg.number");
            String useOrgName = useOrgEntryEntity.getString("buseorg.name");
            this.buildPrefixVsStaffNumMap("b", useOrgEntryEntity, useOrgNumber);
            HashMap propValueMap = Maps.newHashMapWithExpectedSize((int)2);
            propValueMap.put("importprop", "id");
            propValueMap.put("id", useOrgId);
            this.useOrgNumberVsPropValueMap.put(useOrgNumber, propValueMap);
            this.useOrgNameVsPropValueMap.put(useOrgName, propValueMap);
            for (String multiPrefix : multiPrefixList) {
                DynamicObjectCollection multiEntryCol = useOrgEntryEntity.getDynamicObjectCollection(multiPrefix + "entryentity");
                String keyField = StaffEntryTempHelperEnum.getKeyFieldByPrefix(multiPrefix);
                String entryKeyField = StaffCommonService.addPrefix(multiPrefix, keyField);
                for (DynamicObject multiEntry : multiEntryCol) {
                    String multiNumber = multiEntry.getString(entryKeyField + ".number");
                    this.buildPrefixVsStaffNumMap(multiPrefix, multiEntry, useOrgNumber + multiNumber);
                }
            }
        }
    }

    @Override
    public void validAndTreatExcelDisplay() {
        Set<String> importEntryNameSet = this.source.keySet();
        ArrayList<String> importEntryNamePrefixList = new ArrayList<String>(8);
        for (String string : importEntryNameSet) {
            importEntryNamePrefixList.add(string.substring(0, 1));
        }
        boolean errorTemplateFlag = false;
        for (String mulPrefix : this.staffExtEntryHelper.getAllMulPrefix()) {
            if (!importEntryNamePrefixList.contains("b") || !importEntryNamePrefixList.contains(mulPrefix)) continue;
            errorTemplateFlag = true;
            break;
        }
        Set<Map.Entry<String, List<ImportEntryData>>> set = this.source.entrySet();
        for (Map.Entry<String, List<ImportEntryData>> entry : set) {
            this.initFieldName(entry.getKey());
            List<ImportEntryData> entryEntityImportDataList = entry.getValue();
            if (CollectionUtils.isEmpty(entryEntityImportDataList)) continue;
            Map<Integer, String> indexVsMsgMap = this.proposeValidateEntry(entryEntityImportDataList, errorTemplateFlag);
            this.treatExcelDisplay(this.event, entryEntityImportDataList, indexVsMsgMap);
            if (indexVsMsgMap.size() > 0) continue;
            this.initFieldName(entry.getKey());
            indexVsMsgMap = this.validate(entryEntityImportDataList);
            this.treatExcelDisplay(this.event, entryEntityImportDataList, indexVsMsgMap);
        }
    }

    protected abstract Map<Integer, String> validate(List<ImportEntryData> var1);

    protected abstract Boolean requiredFieldValidate(ImportEntryData var1, StringBuilder var2);

    protected void intValidator(StringBuilder errorMsg, JSONObject data) {
        Object staffNumWithSub;
        Object yearStaff;
        Object elastaicCount = data.get((Object)this.entryElasticCount);
        if (Objects.nonNull(elastaicCount) && !COUNT_PATTERN.matcher(elastaicCount.toString()).matches()) {
            errorMsg.append(ResManager.loadKDString((String)"\u5f39\u6027\u989d\u5ea6\u53ea\u80fd\u586b\u5199\u6b63\u6574\u6570\uff0c\u8bf7\u4fee\u6539;", (String)"AbStractStaffEntryImport_00", (String)"hrmp-haos-business", (Object[])new Object[0]));
        }
        if (Objects.nonNull(yearStaff = data.get((Object)this.entryYearStaff)) && !COUNT_PATTERN.matcher(yearStaff.toString()).matches()) {
            errorMsg.append(ResManager.loadKDString((String)"\u5e74\u5ea6\u7f16\u5236\u53ea\u80fd\u586b\u5199\u6b63\u6574\u6570\uff0c\u8bf7\u4fee\u6539;", (String)"AbStractStaffEntryImport_01", (String)"hrmp-haos-business", (Object[])new Object[0]));
        }
        if (Objects.nonNull(staffNumWithSub = data.get((Object)this.entryStaffYearNumWithSub)) && !COUNT_PATTERN.matcher(staffNumWithSub.toString()).matches()) {
            errorMsg.append(ResManager.loadKDString((String)"\u542b\u4e0b\u7ea7\u7f16\u5236\u53ea\u80fd\u586b\u5199\u6b63\u6574\u6570\uff0c\u8bf7\u4fee\u6539;", (String)"AbStractStaffEntryImport_02", (String)"hrmp-haos-business", (Object[])new Object[0]));
        }
        StringBuilder monthStaffMsg = new StringBuilder();
        for (String entryMonthStaff : this.entryMonthStaffList) {
            Object monthStaff = data.get((Object)entryMonthStaff);
            if (!Objects.nonNull(monthStaff) || COUNT_PATTERN.matcher(monthStaff.toString()).matches()) continue;
            int underLineIndex = entryMonthStaff.indexOf("_");
            String month = entryMonthStaff.substring(11, underLineIndex);
            monthStaffMsg.append(String.format(ResManager.loadKDString((String)"%s\u6708\u3001", (String)"AbStractStaffEntryImport_03", (String)"hrmp-haos-business", (Object[])new Object[0]), month));
        }
        if (HRStringUtils.isNotEmpty((String)monthStaffMsg.toString())) {
            errorMsg.append(String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u7f16\u5236\u53ea\u80fd\u586b\u5199\u6b63\u6574\u6570\uff0c\u8bf7\u4fee\u6539\uff1b", (String)"AbStractStaffEntryImport_04", (String)"hrmp-haos-business", (Object[])new Object[0]), monthStaffMsg.toString().substring(0, monthStaffMsg.length())));
        }
    }

    protected void validatePastYearAndMonth(DynamicObject dataEntity, StringBuilder errorMsg, JSONObject data) {
        Map<Integer, Integer> staffMap;
        Long staffCycleId = dataEntity.getLong("staffcycle.id");
        String useOrgNumber = data.getJSONObject(StaffCommonService.addPrefixAndPostfix(this.prefix, "useorg")).getString("number");
        Date now = new Date();
        Date year = dataEntity.getDate("year");
        int curYearInt = HRDateTimeUtils.getYear((Date)now);
        int yearInt = HRDateTimeUtils.getYear((Date)year);
        Map<String, Map<Integer, Integer>> numberVsStaffMap = this.prefixVsStaffNumMap.get(this.prefix);
        if ("b".equals(this.prefix)) {
            staffMap = numberVsStaffMap.get(useOrgNumber);
        } else {
            if (Objects.isNull(numberVsStaffMap)) {
                boolean monthJude;
                boolean yearJudge = STAFF_CYCLE_YEAR.equals(staffCycleId) && curYearInt > yearInt;
                boolean bl = monthJude = STAFF_CYCLE_MONTH.equals(staffCycleId) && (curYearInt > yearInt || curYearInt == yearInt && this.pastMonthStaffJudge(data, HRDateTimeUtils.getMonth((Date)now)));
                if (yearJudge || monthJude) {
                    errorMsg.append(String.format(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u65b0\u589e\u8fc7\u5f80\u5e74\u4efd\u7f16\u5236\u5206\u5f55\u6570\u636e\uff0c\u8bf7\u4fee\u6539;", (String)"AbStractStaffEntryImport_05", (String)"hrmp-haos-business", (Object[])new Object[0]), new Object[0]));
                    return;
                }
            }
            if (Objects.isNull(numberVsStaffMap)) {
                return;
            }
            String importprop = data.getJSONObject(StaffCommonService.addPrefixAndPostfix(this.prefix, StaffEntryTempHelperEnum.getKeyFieldByPrefix(this.prefix))).getString("importprop");
            if (!HRStringUtils.equals((String)"number", (String)importprop)) {
                return;
            }
            String keyFieldNumber = data.getJSONObject(StaffCommonService.addPrefixAndPostfix(this.prefix, StaffEntryTempHelperEnum.getKeyFieldByPrefix(this.prefix))).getString("number");
            staffMap = numberVsStaffMap.get(useOrgNumber + keyFieldNumber);
        }
        if (STAFF_CYCLE_YEAR.equals(staffCycleId) && curYearInt > yearInt) {
            Integer yearStaffNum;
            if (CollectionUtils.isEmpty(staffMap)) {
                errorMsg.append(String.format(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u65b0\u589e\u8fc7\u5f80\u5e74\u4efd\u7f16\u5236\u5206\u5f55\u6570\u636e\uff0c\u8bf7\u4fee\u6539;", (String)"AbStractStaffEntryImport_05", (String)"hrmp-haos-business", (Object[])new Object[0]), new Object[0]));
                return;
            }
            Integer yearStaffNumImport = data.getInteger(StaffCommonService.addPrefixAndPostfix(this.prefix, "yearstaff"));
            if (Objects.nonNull(yearStaffNumImport) && !yearStaffNumImport.equals(yearStaffNum = staffMap.get(this.YEAR_STAFF_NUM))) {
                errorMsg.append(String.format(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u4fee\u6539\u8fc7\u5f80\u5e74\u4efd\u7f16\u5236\uff0c\u8bf7\u4fee\u6539;", (String)"AbStractStaffEntryImport_06", (String)"hrmp-haos-business", (Object[])new Object[0]), new Object[0]));
            }
        } else if (STAFF_CYCLE_MONTH.equals(staffCycleId)) {
            if (curYearInt > yearInt) {
                if (CollectionUtils.isEmpty(staffMap)) {
                    errorMsg.append(String.format(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u65b0\u589e\u8fc7\u5f80\u5e74\u4efd\u7f16\u5236\u5206\u5f55\u6570\u636e\uff0c\u8bf7\u4fee\u6539;", (String)"AbStractStaffEntryImport_07", (String)"hrmp-haos-business", (Object[])new Object[0]), new Object[0]));
                    return;
                }
                this.validatePastMonth(errorMsg, data, staffMap, 12);
            } else if (curYearInt == yearInt) {
                int nowOfMonth = HRDateTimeUtils.getMonth((Date)now);
                this.validatePastMonth(errorMsg, data, staffMap, nowOfMonth - 1);
            }
        }
    }

    protected void unityStaffDimensionValidate(boolean unityStaffMension, List<Long> staffDimensionFromPageList, StringBuilder errorMsg, JSONObject data) {
        JSONObject jsonObject = data.getJSONObject(this.entryStaffDimension);
        ArrayList staffDimensionIdList = Lists.newArrayListWithExpectedSize((int)16);
        if (Objects.nonNull(jsonObject)) {
            String staffDimensionName = jsonObject.getString("name");
            if (Objects.isNull(staffDimensionName)) {
                String[] staffDimensionArr;
                String staffDimensionNumber = jsonObject.getString("number");
                for (String staffDimension : staffDimensionArr = staffDimensionNumber.split(",")) {
                    Long staffDimensionId = this.staffDimensionNumberVsIdMap.get(staffDimension);
                    staffDimensionIdList.add(staffDimensionId);
                }
            } else {
                String[] staffDimensionArr;
                for (String staffDimension : staffDimensionArr = staffDimensionName.split(",")) {
                    Long staffDimensionId = this.staffDimensionNameVsIdMap.get(staffDimension);
                    staffDimensionIdList.add(staffDimensionId);
                }
            }
        } else {
            return;
        }
        boolean isSame = true;
        if (unityStaffMension) {
            if (staffDimensionFromPageList.size() == staffDimensionIdList.size()) {
                for (Long staffDimensionFromPage : staffDimensionFromPageList) {
                    if (staffDimensionIdList.contains(staffDimensionFromPage)) continue;
                    isSame = false;
                }
            } else {
                isSame = false;
            }
        }
        if (!isSame) {
            errorMsg.append(ResManager.loadKDString((String)"\u7f16\u5236\u7ef4\u5ea6\u4e0d\u7edf\u4e00\uff0c\u8bf7\u4e0e\u63a7\u7f16\u89c4\u5219\u4fdd\u6301\u4e00\u81f4;", (String)"AbStractStaffEntryImport_08", (String)"hrmp-haos-business", (Object[])new Object[0]));
        }
    }

    private void validatePastMonth(StringBuilder errorMsg, JSONObject data, Map<Integer, Integer> staffMap, int month) {
        for (int i = 1; i <= month; ++i) {
            Integer monthStaffFromImport = data.getInteger(StaffCommonService.addPrefixAndPostfix(this.prefix, "monthstaff" + i));
            if (!Objects.nonNull(monthStaffFromImport)) continue;
            if (CollectionUtils.isEmpty(staffMap)) {
                errorMsg.append(String.format(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u65b0\u589e\u8fc7\u5f80\u6708\u4efd\u7f16\u5236\u5206\u5f55\u6570\u636e\uff0c\u8bf7\u4fee\u6539;", (String)"AbStractStaffEntryImport_09", (String)"hrmp-haos-business", (Object[])new Object[0]), new Object[0]));
                return;
            }
            Integer monthStaffFormPage = staffMap.get(i);
            if (monthStaffFromImport.equals(monthStaffFormPage)) continue;
            errorMsg.append(String.format(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u4fee\u6539\u8fc7\u5f80\u6708\u4efd\u7f16\u5236\uff0c\u8bf7\u4fee\u6539;", (String)"AbStractStaffEntryImport_10", (String)"hrmp-haos-business", (Object[])new Object[0]), new Object[0]));
        }
    }

    private boolean pastMonthStaffJudge(JSONObject data, int curMonth) {
        for (int i = 1; i < curMonth; ++i) {
            Integer monthStaffFromImport = data.getInteger(StaffCommonService.addPrefixAndPostfix(this.prefix, "monthstaff" + i));
            if (!Objects.nonNull(monthStaffFromImport)) continue;
            return true;
        }
        return false;
    }

    protected void notStringControlValidate(StringBuilder errorMsg, JSONObject data) {
        if (!HRStringUtils.equals((String)this.controlStrategyMap.get(data.getString(this.entryControlStrategy)), (String)"3")) {
            String elasticControl = data.getString(this.entryElasticControl);
            Integer elasticCount = data.getInteger(this.entryElasticCount);
            StringBuilder elasticEmptyField = new StringBuilder();
            if (HRStringUtils.isNotEmpty((String)elasticControl)) {
                elasticEmptyField.append(ResManager.loadKDString((String)"\u5f39\u6027\u65b9\u5f0f\u3001", (String)"AbStractStaffEntryImport_11", (String)"hrmp-haos-business", (Object[])new Object[0]));
            }
            if (Objects.nonNull(elasticCount)) {
                elasticEmptyField.append(ResManager.loadKDString((String)"\u5f39\u6027\u989d\u5ea6\u3001", (String)"AbStractStaffEntryImport_12", (String)"hrmp-haos-business", (Object[])new Object[0]));
            }
            if (HRStringUtils.isNotEmpty((String)elasticEmptyField.toString())) {
                errorMsg.append(String.format(ResManager.loadKDString((String)"\u63a7\u7f16\u65b9\u5f0f\u4e0d\u4e3a\u5f39\u6027\u63a7\u7f16\u65f6\uff0c%s\u5e94\u4e3a\u7a7a\uff0c\u8bf7\u4fee\u6539;", (String)"AbStractStaffEntryImport_13", (String)"hrmp-haos-business", (Object[])new Object[0]), elasticEmptyField.toString().substring(0, elasticEmptyField.length() - 1)));
            }
        }
    }

    protected void unityControlModeValidate(boolean unityControlMode, StringBuilder errorMsg, JSONObject data) {
        if (unityControlMode) {
            DynamicObject dataEntity = this.formView.getModel().getDataEntity();
            String staffControlStrategyFromPage = dataEntity.getString("staffcontrolstrategy");
            String staffElasticControlFromPage = dataEntity.getString("staffelasticcontrol");
            Integer staffElasticCountFromPage = dataEntity.getInt("staffelasticcount");
            String controlStrategy = data.getString(this.entryControlStrategy);
            if (HRStringUtils.isNotEmpty((String)controlStrategy) && !HRStringUtils.equals((String)this.controlStrategyMap.get(controlStrategy), (String)staffControlStrategyFromPage)) {
                errorMsg.append(ResManager.loadKDString((String)"\u63a7\u7f16\u65b9\u5f0f\u4e0d\u7edf\u4e00\uff0c\u8bf7\u4e0e\u63a7\u7f16\u89c4\u5219\u4fdd\u6301\u4e00\u81f4;", (String)"AbStractStaffEntryImport_14", (String)"hrmp-haos-business", (Object[])new Object[0]));
            }
            if (HRStringUtils.equals((String)staffControlStrategyFromPage, (String)"3")) {
                Integer elasticCount;
                String elasticControl = data.getString(this.entryElasticControl);
                if (HRStringUtils.isNotEmpty((String)elasticControl) && !HRStringUtils.equals((String)this.elasticControlMap.get(elasticControl), (String)staffElasticControlFromPage)) {
                    errorMsg.append(ResManager.loadKDString((String)"\u5f39\u6027\u65b9\u5f0f\u4e0d\u7edf\u4e00\uff0c\u8bf7\u4e0e\u63a7\u7f16\u89c4\u5219\u4fdd\u6301\u4e00\u81f4;", (String)"AbStractStaffEntryImport_15", (String)"hrmp-haos-business", (Object[])new Object[0]));
                }
                if (Objects.nonNull(elasticCount = data.getInteger(this.entryElasticCount)) && !elasticCount.equals(staffElasticCountFromPage)) {
                    errorMsg.append(ResManager.loadKDString((String)"\u5f39\u6027\u989d\u5ea6\u4e0d\u7edf\u4e00\uff0c\u8bf7\u4e0e\u63a7\u7f16\u89c4\u5219\u4fdd\u6301\u4e00\u81f4;", (String)"AbStractStaffEntryImport_16", (String)"hrmp-haos-business", (Object[])new Object[0]));
                }
            }
        }
    }

    @Override
    public void assembleImportPropValue() {
        Set<Map.Entry<String, List<ImportEntryData>>> entries = this.source.entrySet();
        for (Map.Entry<String, List<ImportEntryData>> entry : entries) {
            this.initFieldName(entry.getKey());
            List<ImportEntryData> entryEntityImportDataList = entry.getValue();
            this.entryNumberTransId(entryEntityImportDataList);
        }
    }

    protected Map<Integer, String> proposeValidateEntry(List<ImportEntryData> entryEntityImportDataList, boolean errorTemplateFlag) {
        boolean isRightTemplate;
        HashMap indexVsMsgMap = Maps.newHashMapWithExpectedSize((int)entryEntityImportDataList.size());
        if (errorTemplateFlag) {
            String prompt = ResManager.loadKDString((String)"\u6682\u4e0d\u652f\u6301\u540c\u65f6\u5bfc\u5165\u7ec4\u7ec7\u7f16\u5236\u4e0e\u591a\u7ef4\u7f16\u5236\uff0c\u8bf7\u9009\u7528\u9884\u7f6e\u6a21\u677f\u8fdb\u884c\u5bfc\u5165;", (String)"AbStractStaffEntryImport_20", (String)"hrmp-haos-business", (Object[])new Object[0]);
            this.onlyDisplayFirstLine(entryEntityImportDataList, indexVsMsgMap, prompt);
            return indexVsMsgMap;
        }
        Long staffCycleId = this.formView.getModel().getDataEntity().getLong("staffcycle.id");
        boolean containsYearStaff = entryEntityImportDataList.get(0).getEntryEntityMapping().getCols().containsKey(this.prefix + "yearstaff_import");
        boolean bl = isRightTemplate = STAFF_CYCLE_MONTH.equals(staffCycleId) && !containsYearStaff || STAFF_CYCLE_YEAR.equals(staffCycleId) && containsYearStaff;
        if (!isRightTemplate) {
            String prompt = ResManager.loadKDString((String)"\u5bfc\u5165\u6a21\u677f\u9009\u62e9\u4e0d\u6b63\u786e\uff0c\u8bf7\u9009\u62e9\u6b63\u786e\u7684\u5468\u671f\u6a21\u677f;", (String)"AbStractStaffEntryImport_17", (String)"hrmp-haos-business", (Object[])new Object[0]);
            this.onlyDisplayFirstLine(entryEntityImportDataList, indexVsMsgMap, prompt);
        }
        return indexVsMsgMap;
    }

    private void onlyDisplayFirstLine(List<ImportEntryData> entryEntityImportDataList, Map<Integer, String> indexVsMsgMap, String prompt) {
        for (int i = 0; i < entryEntityImportDataList.size(); ++i) {
            Integer rowNum = entryEntityImportDataList.get(i).getData().getInteger("rowNum");
            if (i == 0) {
                indexVsMsgMap.put(rowNum, prompt);
                continue;
            }
            indexVsMsgMap.put(rowNum, "");
        }
    }

    protected void treatExcelDisplay(BeforeImportEntryEventArgs event, List<ImportEntryData> entryEntityImportDataList, Map<Integer, String> indexVsMsgMap) {
        Set<Integer> indexSet = indexVsMsgMap.keySet();
        Map logMap = event.getEntryDataMap();
        ImportLogger importLogger = (ImportLogger)((List)logMap.get(this.importEntryName)).get(0);
        Set<Map.Entry<Integer, String>> indexVsMsgEntries = indexVsMsgMap.entrySet();
        for (Map.Entry<Integer, String> indexVsMsgEntry : indexVsMsgEntries) {
            Integer index = indexVsMsgEntry.getKey();
            importLogger.log(index, indexVsMsgEntry.getValue());
            importLogger.fail();
            importLogger.setTotal(importLogger.getTotal() + 1);
        }
        Iterator<ImportEntryData> iterator = entryEntityImportDataList.iterator();
        while (iterator.hasNext()) {
            ImportEntryData entryData = iterator.next();
            Integer rowNum = (Integer)entryData.getData().get((Object)"rowNum");
            if (!indexSet.contains(rowNum)) continue;
            iterator.remove();
        }
    }

    protected void initFieldName(String importEntryName) {
        this.importEntryName = importEntryName;
        this.prefix = importEntryName.substring(0, 1);
        String keyField = StaffEntryTempHelperEnum.getKeyFieldByPrefix(this.prefix);
        this.entryKeyField = StaffCommonService.addPrefixAndPostfix(this.prefix, keyField);
        this.keyFieldEntityName = this.staffExtEntryHelper.getKeyFieldEntityNameByPrefix(this.prefix);
        this.entryStaffDimension = StaffCommonService.addPrefixAndPostfix(this.prefix, "staffdimension");
        this.entryControlStrategy = StaffCommonService.addPrefixAndPostfix(this.prefix, "controlstrategy");
        this.entryElasticControl = StaffCommonService.addPrefixAndPostfix(this.prefix, "elasticcontrol");
        this.entryElasticCount = StaffCommonService.addPrefixAndPostfix(this.prefix, "elasticcount");
        this.entryYearStaff = StaffCommonService.addPrefixAndPostfix(this.prefix, "yearstaff");
        this.entryStaffYearNumWithSub = this.prefix + "yearstaffnumwithsub" + "_impo";
        for (int i = 1; i <= 12; ++i) {
            this.entryMonthStaffList.add(StaffCommonService.addPrefixAndPostfix(this.prefix, "monthstaff" + i));
        }
    }

    private void buildPrefixVsStaffNumMap(String prefix, DynamicObject useOrgEntryEntity, String useOrgNumber) {
        Map<String, Map<Integer, Integer>> useOrgNumberVsStaffNumMap = this.prefixVsStaffNumMap.getOrDefault(prefix, Maps.newHashMapWithExpectedSize((int)16));
        HashMap monthVsStaffNumMap = Maps.newHashMapWithExpectedSize((int)16);
        for (int i = 1; i <= 12; ++i) {
            Object monthStaffObject = useOrgEntryEntity.get(prefix + "monthstaff" + i);
            if (!Objects.nonNull(monthStaffObject)) continue;
            int monthStaff = useOrgEntryEntity.getInt(prefix + "monthstaff" + i);
            monthVsStaffNumMap.put(i, monthStaff);
        }
        Object yearStaffObject = useOrgEntryEntity.get(prefix + "yearstaff");
        if (Objects.nonNull(yearStaffObject)) {
            monthVsStaffNumMap.put(this.YEAR_STAFF_NUM, useOrgEntryEntity.getInt(prefix + "yearstaff"));
        }
        useOrgNumberVsStaffNumMap.put(useOrgNumber, monthVsStaffNumMap);
        this.prefixVsStaffNumMap.put(prefix, useOrgNumberVsStaffNumMap);
    }

    private void entryNumberTransId(List<ImportEntryData> entryEntityImportDataList) {
        if (entryEntityImportDataList == null) {
            return;
        }
        for (ImportEntryData importEntryData : entryEntityImportDataList) {
            Map<String, Object> importPropMap;
            String entryUseOrg;
            JSONObject data = importEntryData.getData();
            JSONObject useOrgJsonObject = data.getJSONObject(entryUseOrg = StaffCommonService.addPrefixAndPostfix(this.prefix, "useorg"));
            if (useOrgJsonObject == null) continue;
            String importProp = useOrgJsonObject.getString("importprop");
            if (HRStringUtils.equals((String)importProp, (String)"number")) {
                String number = useOrgJsonObject.getString(importProp);
                importPropMap = this.useOrgNumberVsPropValueMap.get(number);
            } else {
                String name = useOrgJsonObject.getString(importProp);
                importPropMap = this.useOrgNameVsPropValueMap.get(name);
            }
            data.put(entryUseOrg, importPropMap);
        }
    }
}

