/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.business.service.staff.helper;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.plugin.importentry.resolving.ImportEntryData;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.hr.haos.business.domain.repository.other.LaborRelTypeRepository;
import kd.hr.haos.business.service.ext.StaffExtDimFilterExtend;
import kd.hr.haos.business.service.staff.service.StaffExtEntryHelper;
import kd.hr.haos.common.constants.staff.OrgStaffConstants;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;

public class StaffEntryImportHelper
implements OrgStaffConstants {
    private Map<String, List<ImportEntryData>> source;
    private IDataModel dataModel;
    private Set<String> numberSet = new HashSet<String>();
    private Set<String> nameSet = new HashSet<String>();
    private StaffExtEntryHelper staffExtEntryHelper = new StaffExtEntryHelper();
    Map<String, Map<String, Object>>[] resultMap = new HashMap[2];

    public StaffEntryImportHelper(Map<String, List<ImportEntryData>> source, IDataModel dataModel) {
        this.resultMap[0] = Maps.newHashMapWithExpectedSize((int)16);
        this.resultMap[1] = Maps.newHashMapWithExpectedSize((int)16);
        this.source = source;
        this.dataModel = dataModel;
    }

    /*
     * WARNING - void declaration
     */
    public Map<String, Map<String, Object>>[] buildMultiVsPropValueMap(List<Long> orgIdList, List<Long> adminOrgIds) {
        if (CollectionUtils.isEmpty(adminOrgIds)) {
            return new HashMap[0];
        }
        Set<Map.Entry<String, List<ImportEntryData>>> entries = this.source.entrySet();
        for (Map.Entry<String, List<ImportEntryData>> entry : entries) {
            DynamicObject[] positionDataList;
            String prefix = entry.getKey().substring(0, 1);
            if (HRStringUtils.equals((String)prefix, (String)"c")) {
                Map positionMap = (Map)HRMServiceHelper.invokeHRMPService((String)"hbpm", (String)"IPositionService", (String)"queryPositionByOrgIds", (Object[])new Object[]{adminOrgIds});
                positionDataList = (DynamicObject[])positionMap.get("data");
                for (Map map : positionDataList) {
                    Long adminOrgBoId = (Long)map.get("adminorg");
                    long positionId = (Long)map.get("id");
                    if (positionId == 0L) continue;
                    this.putPropValueMap(adminOrgBoId, map, positionId, "c");
                }
                continue;
            }
            if (HRStringUtils.equals((String)prefix, (String)"d")) {
                void var10_13;
                DynamicObject[] jobDyns;
                positionDataList = jobDyns = (DynamicObject[])HRMServiceHelper.invokeHRMPService((String)"hbjm", (String)"IHBJMService", (String)"getJobInfoByOrgIds", (Object[])new Object[]{orgIdList});
                int n = positionDataList.length;
                int n2 = 0;
                while (var10_13 < n) {
                    DynamicObject jobDyn = positionDataList[var10_13];
                    long jobId = jobDyn.getLong("id");
                    this.putPropValueMap(jobDyn, jobId, "d");
                    ++var10_13;
                }
                continue;
            }
            if (HRStringUtils.equals((String)prefix, (String)"e")) {
                DynamicObject[] laborRelTypeDyns;
                QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
                for (DynamicObject laborRelTypeDyn : laborRelTypeDyns = LaborRelTypeRepository.getInstance().queryOriginalArray("id, name, number", new QFilter[]{enableFilter})) {
                    long laborRelTypeId = laborRelTypeDyn.getLong("id");
                    this.putPropValueMap(laborRelTypeDyn, laborRelTypeId, "e");
                }
                continue;
            }
            for (DynamicObject extDim : this.staffExtEntryHelper.getExtDim()) {
                DynamicObject[] extDyns;
                String extPrefix = this.staffExtEntryHelper.getExtDimPrefix(extDim.getString("staffdimension"));
                if (!HRStringUtils.equals((String)prefix, (String)extPrefix)) continue;
                String string = extDim.getDynamicObject("basedata").getString("number");
                HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper(string);
                for (DynamicObject extDyn : extDyns = hrBaseServiceHelper.queryOriginalArray("id,name,number", new QFilter[]{this.getExtDimQfilter(string)})) {
                    long extDynId = extDyn.getLong("id");
                    this.putPropValueMap(extDyn, extDynId, extPrefix);
                }
            }
        }
        return this.resultMap;
    }

    private QFilter getExtDimQfilter(String entity) {
        QFilter customExtDimQfilter = StaffExtDimFilterExtend.getInstance().getCustomExtDimQfilter(entity, this.dataModel);
        if (customExtDimQfilter != null) {
            return customExtDimQfilter;
        }
        if (HRStringUtils.equals((String)"hbjm_joblevelhr", (String)entity)) {
            return new QFilter("joblevelscm.iscurrentversion", "=", (Object)"1");
        }
        if (HRStringUtils.equals((String)"hbjm_jobgradehr", (String)entity)) {
            return new QFilter("jobgradescm.iscurrentversion", "=", (Object)"1");
        }
        MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)entity);
        if (entityType.getAllFields().containsKey("iscurrentversion")) {
            return new QFilter("iscurrentversion", "=", (Object)"1");
        }
        return new QFilter("1", "=", (Object)1);
    }

    private void putPropValueMap(Long adminOrgBoId, Object data, long keyFieldId, String prefix) {
        String number = this.getValueFromData(data, "number");
        String name = this.getValueFromData(data, "name");
        String numberKey = adminOrgBoId + prefix + number;
        String nameKey = adminOrgBoId + prefix + name;
        this.putMultiPropValueMap(keyFieldId, numberKey, nameKey);
    }

    private void putPropValueMap(Object data, long keyFieldId, String prefix) {
        String number = this.getValueFromData(data, "number");
        String name = this.getValueFromData(data, "name");
        String numberKey = prefix + number;
        String nameKey = prefix + name;
        this.putMultiPropValueMap(keyFieldId, numberKey, nameKey);
    }

    private String getValueFromData(Object data, String fieldName) {
        if (data instanceof Map) {
            return (String)((Map)data).get(fieldName);
        }
        if (data instanceof DynamicObject) {
            return ((DynamicObject)data).getString(fieldName);
        }
        return "";
    }

    private void putMultiPropValueMap(long keyFieldId, String numberKey, String nameKey) {
        HashMap multiPropValueMap = Maps.newHashMapWithExpectedSize((int)2);
        multiPropValueMap.put("importprop", "id");
        multiPropValueMap.put("id", keyFieldId);
        if (this.numberSet.add(numberKey)) {
            this.resultMap[0].put(numberKey, multiPropValueMap);
        } else {
            this.resultMap[0].remove(numberKey);
        }
        if (this.nameSet.add(nameKey)) {
            this.resultMap[1].put(nameKey, multiPropValueMap);
        } else {
            this.resultMap[1].remove(nameKey);
        }
    }

    public Map<String, List<String>> getMultiRepeatNameListMap(List<Long> adminOrgIds) {
        if (CollectionUtils.isEmpty(adminOrgIds)) {
            return Maps.newHashMapWithExpectedSize((int)0);
        }
        HashMap prefixVsRepeatNameListMap = Maps.newHashMapWithExpectedSize((int)16);
        Map positionMap = (Map)HRMServiceHelper.invokeHRMPService((String)"hbpm", (String)"IPositionService", (String)"queryPositionByOrgIds", (Object[])new Object[]{adminOrgIds});
        List positionDataList = (List)positionMap.get("data");
        ArrayList repeatPosNameList = Lists.newArrayListWithExpectedSize((int)16);
        HashSet posNameSet = Sets.newHashSetWithExpectedSize((int)16);
        for (Map positionData : positionDataList) {
            String positionName = (String)positionData.get("name");
            if (posNameSet.add(positionName)) continue;
            repeatPosNameList.add(positionName);
        }
        prefixVsRepeatNameListMap.put("c", repeatPosNameList);
        DynamicObject[] allJobDyns = (DynamicObject[])HRMServiceHelper.invokeHRMPService((String)"hbjm", (String)"IHBJMService", (String)"getAllJobInfo", (Object[])new Object[0]);
        List<DynamicObject> jobDynList = Arrays.stream(allJobDyns).filter(dyn -> HRStringUtils.equals((String)dyn.getString("enable"), (String)"1")).collect(Collectors.toList());
        this.putPreVsRepeatNameListMap(prefixVsRepeatNameListMap, jobDynList.toArray(new DynamicObject[0]), "d");
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        DynamicObject[] laborRelTypeDyns = LaborRelTypeRepository.getInstance().queryOriginalArray("id, name, number", new QFilter[]{enableFilter});
        this.putPreVsRepeatNameListMap(prefixVsRepeatNameListMap, laborRelTypeDyns, "e");
        return prefixVsRepeatNameListMap;
    }

    private void putPreVsRepeatNameListMap(Map<String, List<String>> prefixVsRepeatNameListMap, DynamicObject[] dyns, String prefix) {
        ArrayList repeatNameList = Lists.newArrayListWithExpectedSize((int)16);
        HashSet nameSet = Sets.newHashSetWithExpectedSize((int)16);
        for (DynamicObject jobDyn : dyns) {
            String jobName = jobDyn.getString("name");
            if (nameSet.add(jobName)) continue;
            repeatNameList.add(jobName);
        }
        prefixVsRepeatNameListMap.put(prefix, repeatNameList);
    }

    public Map<String, List<String>> getHasPermJobInfo(List<Long> orgIdList) {
        DynamicObject[] hasPermJobDyns = (DynamicObject[])HRMServiceHelper.invokeHRMPService((String)"hbjm", (String)"IHBJMService", (String)"getJobInfoByOrgIds", (Object[])new Object[]{orgIdList});
        HashMap importTypeVsValueListMap = Maps.newHashMapWithExpectedSize((int)16);
        ArrayList nameList = Lists.newArrayListWithExpectedSize((int)16);
        ArrayList numberList = Lists.newArrayListWithExpectedSize((int)16);
        for (DynamicObject jobDyn : hasPermJobDyns) {
            String number = jobDyn.getString("number");
            numberList.add(number);
            String name = jobDyn.getString("name");
            nameList.add(name);
        }
        importTypeVsValueListMap.put("number", numberList);
        importTypeVsValueListMap.put("name", nameList);
        return importTypeVsValueListMap;
    }

    public Map<String, Map<String, Map<String, List<String>>>> getMultiNumberAndNameList(List<Long> adminOrgIds) {
        Map positionMap = (Map)HRMServiceHelper.invokeHRMPService((String)"hbpm", (String)"IPositionService", (String)"queryPositionByOrgIds", (Object[])new Object[]{adminOrgIds});
        List positionDataList = (List)positionMap.get("data");
        HashMap prefixVsImportTypeVsValueList = Maps.newHashMapWithExpectedSize((int)16);
        HashMap importTypeVsValueListMap = Maps.newHashMapWithExpectedSize((int)16);
        ArrayList posNameList = Lists.newArrayListWithExpectedSize((int)16);
        ArrayList posNumberList = Lists.newArrayListWithExpectedSize((int)16);
        for (Map positionData : positionDataList) {
            String name = (String)positionData.get("name");
            String number = (String)positionData.get("number");
            posNameList.add(name);
            posNumberList.add(number);
        }
        HashMap nameMap = Maps.newHashMapWithExpectedSize((int)2);
        nameMap.put("allInfo", posNameList);
        importTypeVsValueListMap.put("name", nameMap);
        HashMap numberMap = Maps.newHashMapWithExpectedSize((int)2);
        numberMap.put("allInfo", posNumberList);
        importTypeVsValueListMap.put("number", numberMap);
        prefixVsImportTypeVsValueList.put("c", importTypeVsValueListMap);
        DynamicObject[] jobDyns = (DynamicObject[])HRMServiceHelper.invokeHRMPService((String)"hbjm", (String)"IHBJMService", (String)"getAllJobInfo", (Object[])new Object[0]);
        this.putPrefixVsValueListMap(prefixVsImportTypeVsValueList, jobDyns, "d");
        QFilter enableFilter = new QFilter("enable", "in", (Object)new String[]{"1", "0"});
        DynamicObject[] laborRelTypeDyns = LaborRelTypeRepository.getInstance().queryOriginalArray("id, enable, name, number", new QFilter[]{enableFilter});
        this.putPrefixVsValueListMap(prefixVsImportTypeVsValueList, laborRelTypeDyns, "e");
        return prefixVsImportTypeVsValueList;
    }

    private void putPrefixVsValueListMap(Map<String, Map<String, Map<String, List<String>>>> prefixVsImportTypeVsValueList, DynamicObject[] dyns, String prefix) {
        HashMap importTypeVsValueList = Maps.newHashMapWithExpectedSize((int)16);
        ArrayList nameList = Lists.newArrayListWithExpectedSize((int)16);
        ArrayList numberList = Lists.newArrayListWithExpectedSize((int)16);
        ArrayList enableNameList = Lists.newArrayListWithExpectedSize((int)16);
        ArrayList enableNumberList = Lists.newArrayListWithExpectedSize((int)16);
        for (DynamicObject dyn : dyns) {
            String name = dyn.getString("name");
            String number = dyn.getString("number");
            nameList.add(name);
            numberList.add(number);
            String enable = dyn.getString("enable");
            if (!HRStringUtils.equals((String)enable, (String)"1")) continue;
            enableNameList.add(name);
            enableNumberList.add(number);
        }
        Map<String, List<String>> nameMap = this.putMap(nameList, enableNameList);
        importTypeVsValueList.put("name", nameMap);
        Map<String, List<String>> numberMap = this.putMap(numberList, enableNumberList);
        importTypeVsValueList.put("number", numberMap);
        prefixVsImportTypeVsValueList.put(prefix, importTypeVsValueList);
    }

    private Map<String, List<String>> putMap(List<String> nameList, List<String> enableNameList) {
        HashMap nameMap = Maps.newHashMapWithExpectedSize((int)2);
        nameMap.put("allInfo", nameList);
        nameMap.put("enableInfo", enableNameList);
        return nameMap;
    }
}

