/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.business.service.staff.helper;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.BeforeImportEntryEventArgs;
import kd.bos.form.IFormView;
import kd.bos.form.plugin.importentry.resolving.ImportEntryData;
import kd.hr.haos.business.domain.repository.staff.StaffRepository;
import kd.hr.haos.business.service.staff.helper.AbStractStaffEntryImport;
import kd.hr.haos.business.service.staff.service.StaffCommonService;
import kd.hr.haos.business.servicehelper.SystemParamHelper;
import kd.hr.hbp.common.util.HRStringUtils;

public class UseOrgEntryImportStrategy
extends AbStractStaffEntryImport {
    public UseOrgEntryImportStrategy(Map<String, List<ImportEntryData>> source, IFormView formView, BeforeImportEntryEventArgs event) {
        super(event, source, formView);
    }

    @Override
    public void init() {
        super.init();
    }

    @Override
    public void validAndTreatExcelDisplay() {
        super.validAndTreatExcelDisplay();
    }

    @Override
    public void assembleImportPropValue() {
        super.assembleImportPropValue();
    }

    @Override
    protected Map<Integer, String> validate(List<ImportEntryData> entryEntityImportDataList) {
        HashMap indexVsMsgMap = Maps.newHashMapWithExpectedSize((int)entryEntityImportDataList.size());
        DynamicObject dataEntity = this.formView.getModel().getDataEntity();
        boolean unityStaffMension = dataEntity.getBoolean("staffproject.unitystaffdimension");
        boolean unityControlMode = dataEntity.getBoolean("staffproject.unitycontrolmode");
        DynamicObjectCollection staffDimensionDynCol = dataEntity.getDynamicObjectCollection("staffdimension");
        List<Long> staffDimensionFromPageList = staffDimensionDynCol.stream().map(dyn -> dyn.getLong("fbasedataid.id")).collect(Collectors.toList());
        for (ImportEntryData importEntryData : entryEntityImportDataList) {
            StringBuilder errorMsg = new StringBuilder();
            JSONObject data = importEntryData.getData();
            Integer rowNum = data.getInteger("rowNum");
            if (!this.requiredFieldValidate(importEntryData, errorMsg).booleanValue()) {
                indexVsMsgMap.put(rowNum, errorMsg.toString());
                continue;
            }
            String useOrgNumber = data.getJSONObject(StaffCommonService.addPrefixAndPostfix(this.prefix, "useorg")).getString("number");
            if (!this.useOrgNumberList.contains(useOrgNumber)) {
                errorMsg.append(ResManager.loadKDString((String)"\u4f7f\u7528\u7ec4\u7ec7\u7f16\u7801\u586b\u5199\u4e0d\u6b63\u786e\uff0c\u8bf7\u4fee\u6539;", (String)"UseOrgEntryImportStrategy_00", (String)"hrmp-haos-business", (Object[])new Object[0]));
                indexVsMsgMap.put(rowNum, errorMsg.toString());
                continue;
            }
            super.intValidator(errorMsg, data);
            if (HRStringUtils.isNotEmpty((String)errorMsg.toString())) {
                indexVsMsgMap.put(rowNum, errorMsg.toString());
                continue;
            }
            Object staffNumWithSub = data.get((Object)this.entryStaffYearNumWithSub);
            if (Objects.nonNull(staffNumWithSub) && !this.hasSubUseOrgNumberList.contains(useOrgNumber)) {
                errorMsg.append(ResManager.loadKDString((String)"\u7ec4\u7ec7\u4e3a\u6700\u672b\u7ea7\u8282\u70b9\uff0c\u4e0d\u53ef\u8bbe\u7f6e\u542b\u4e0b\u7ea7\u7f16\u5236\uff0c\u8bf7\u4fee\u6539;", (String)"AbStractStaffEntryImport_18", (String)"hrmp-haos-business", (Object[])new Object[0]));
            }
            boolean existEnableOrDisableDyn = StaffRepository.getInstance().isExistEnableOrDisableDynById(dataEntity.getLong("id"));
            long orgId = dataEntity.getLong("org.id");
            Boolean enableModify = SystemParamHelper.getStaffPastMonthModifyParameter(orgId);
            if (!enableModify.booleanValue() && existEnableOrDisableDyn) {
                this.validatePastYearAndMonth(dataEntity, errorMsg, data);
            }
            this.unityStaffDimensionValidate(unityStaffMension, staffDimensionFromPageList, errorMsg, data);
            this.unityControlModeValidate(unityControlMode, errorMsg, data);
            this.notStringControlValidate(errorMsg, data);
            if (!HRStringUtils.isNotEmpty((String)errorMsg.toString())) continue;
            indexVsMsgMap.put(rowNum, errorMsg.toString());
        }
        return indexVsMsgMap;
    }

    @Override
    protected Boolean requiredFieldValidate(ImportEntryData importEntryData, StringBuilder errorMsg) {
        StringBuilder emptyField = new StringBuilder();
        JSONObject data = importEntryData.getData();
        if (Objects.isNull(data.getJSONObject(StaffCommonService.addPrefixAndPostfix(this.prefix, "useorg")))) {
            emptyField.append(ResManager.loadKDString((String)"\u4f7f\u7528\u7ec4\u7ec7", (String)"UseOrgEntryImportStrategy_01", (String)"hrmp-haos-business", (Object[])new Object[0]));
        }
        if (HRStringUtils.isNotEmpty((String)emptyField.toString())) {
            errorMsg.append(String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c%s\u201d\u3002", (String)"UseOrgEntryImportStrategy_02", (String)"hrmp-haos-business", (Object[])new Object[0]), emptyField.toString()));
        }
        return HRStringUtils.isEmpty((String)errorMsg.toString());
    }
}

