/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.business.service.staff.occupy.core;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDBizException;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.haos.business.domain.repository.adorg.AdOrgRepository;
import kd.hr.haos.business.domain.repository.staff.MuldimUseStaffRepository;
import kd.hr.haos.business.domain.repository.staff.OrgUseStaffDetailRepository;
import kd.hr.haos.business.domain.repository.staff.PersonStaffInfoRepository;
import kd.hr.haos.business.domain.repository.staff.StaffCaseRepository;
import kd.hr.haos.business.domain.repository.staff.StaffDimensionRepository;
import kd.hr.haos.business.domain.service.impl.staff.StaffProjectServiceImpl;
import kd.hr.haos.business.domain.service.staff.IStaffProjectService;
import kd.hr.haos.business.service.staff.bean.StaffCallRuleEngineParamBo;
import kd.hr.haos.business.service.staff.occupy.core.AbstractMultiOccupyService;
import kd.hr.haos.business.service.staff.occupy.core.AbstractStaffOccupyService;
import kd.hr.haos.business.service.staff.occupy.core.DutyOrgOccupyChain;
import kd.hr.haos.business.service.staff.occupy.core.FifthDimensionChain;
import kd.hr.haos.business.service.staff.occupy.core.FirstDimensionChain;
import kd.hr.haos.business.service.staff.occupy.core.FourthDimensionChain;
import kd.hr.haos.business.service.staff.occupy.core.JobOccupyChain;
import kd.hr.haos.business.service.staff.occupy.core.LaborRelTypeOccupyChain;
import kd.hr.haos.business.service.staff.occupy.core.PositionOccupyChain;
import kd.hr.haos.business.service.staff.occupy.core.SecondDimensionChain;
import kd.hr.haos.business.service.staff.occupy.core.ThirdDimensionChain;
import kd.hr.haos.business.service.staff.occupy.core.UseOrgOccupyChain;
import kd.hr.haos.business.service.staff.service.StaffCommonService;
import kd.hr.haos.common.constants.staff.DynamicDimensionEnum;
import kd.hr.hbp.common.model.org.staff.StaffQueryInParam;
import kd.hr.hbp.common.util.HRStringUtils;

public class StaffOccupyServiceCreator {
    private static final Log logger = LogFactory.getLog(StaffOccupyServiceCreator.class);
    private List<StaffQueryInParam> staffQueryInParams;
    private PersonStaffInfoRepository personStaffInfoRepository = PersonStaffInfoRepository.getInstance();
    private OrgUseStaffDetailRepository useStaffInfoRepository = OrgUseStaffDetailRepository.getInstance();
    private MuldimUseStaffRepository muldimUseStaffRepository = MuldimUseStaffRepository.getInstance();
    private AdOrgRepository adOrgRepository = AdOrgRepository.getInstance();
    private IStaffProjectService projectService = new StaffProjectServiceImpl();
    private UseOrgOccupyChain useOrgOccupyChain;
    private DutyOrgOccupyChain dutyOrgOccupyChain;
    private PositionOccupyChain positionOccupyChain;
    private JobOccupyChain jobOccupyChain;
    private LaborRelTypeOccupyChain laborRelTypeOccupyChain;
    private FirstDimensionChain firstDimensionChain;
    private SecondDimensionChain secondDimensionChain;
    private ThirdDimensionChain thirdDimensionChain;
    private FourthDimensionChain fourthDimensionChain;
    private FifthDimensionChain fifthDimensionChain;
    private List<Long> candidateIds = Lists.newArrayListWithExpectedSize((int)16);
    private List<Long> depEmpIds = Lists.newArrayListWithExpectedSize((int)16);
    private Set<Long> orgTeamIds = Sets.newHashSetWithExpectedSize((int)16);
    private List<AbstractMultiOccupyService> multiOccupyServices = Lists.newArrayListWithExpectedSize((int)16);

    public StaffOccupyServiceCreator(List<StaffQueryInParam> staffQueryInParams) {
        this.staffQueryInParams = staffQueryInParams;
        this.useOrgOccupyChain = new UseOrgOccupyChain(staffQueryInParams);
        this.dutyOrgOccupyChain = new DutyOrgOccupyChain(this.useOrgOccupyChain, staffQueryInParams);
        this.positionOccupyChain = new PositionOccupyChain(staffQueryInParams);
        this.jobOccupyChain = new JobOccupyChain(staffQueryInParams);
        this.laborRelTypeOccupyChain = new LaborRelTypeOccupyChain(staffQueryInParams);
        this.initMultiOccupyServices(staffQueryInParams);
    }

    public static StaffOccupyServiceCreator getInstance(List<StaffQueryInParam> staffQueryInParams) {
        return new StaffOccupyServiceCreator(staffQueryInParams);
    }

    public AbstractStaffOccupyService getOccupyService() {
        this.useOrgOccupyChain.setNextOccupyService(this.dutyOrgOccupyChain);
        this.dutyOrgOccupyChain.setNextOccupyService(this.positionOccupyChain);
        this.positionOccupyChain.setNextOccupyService(this.jobOccupyChain);
        this.jobOccupyChain.setNextOccupyService(this.laborRelTypeOccupyChain);
        int dimensionNums = this.multiOccupyServices.size();
        if (dimensionNums == 1) {
            this.laborRelTypeOccupyChain.setNextOccupyService(this.multiOccupyServices.get(0));
        } else if (dimensionNums != 0) {
            for (int i = 0; i < dimensionNums - 1; ++i) {
                if (i == 0) {
                    this.laborRelTypeOccupyChain.setNextOccupyService(this.multiOccupyServices.get(i));
                }
                this.multiOccupyServices.get(i).setNextOccupyService(this.multiOccupyServices.get(i + 1));
            }
        }
        this.buildDepEmpIdStaffCaseMap();
        this.buildQueryParamGroupMap();
        this.buildBeforeGroupMap();
        this.rebuildOccupyResultMap();
        this.buildSpecialRule();
        this.querySystemParam();
        return this.useOrgOccupyChain;
    }

    private void buildDepEmpIdStaffCaseMap() {
        DynamicObject[] allStaffCaseDyns = StaffCaseRepository.getInstance().queryAllEnableAndAuditDyns();
        List<DynamicObject> staffCaseDynList = Arrays.stream(allStaffCaseDyns).collect(Collectors.toList());
        this.useOrgOccupyChain.setAllStaffCaseDynList(staffCaseDynList);
        this.positionOccupyChain.setAllStaffCaseDynList(staffCaseDynList);
        this.jobOccupyChain.setAllStaffCaseDynList(staffCaseDynList);
        this.laborRelTypeOccupyChain.setAllStaffCaseDynList(staffCaseDynList);
        this.multiOccupyServices.forEach(temp -> temp.setAllStaffCaseDynList(staffCaseDynList));
    }

    private void buildQueryParamGroupMap() {
        HashMap useOrgGroupMap = Maps.newHashMapWithExpectedSize((int)16);
        HashMap positionGroupMap = Maps.newHashMapWithExpectedSize((int)16);
        HashMap jobGroupMap = Maps.newHashMapWithExpectedSize((int)16);
        HashMap laborGroupMap = Maps.newHashMapWithExpectedSize((int)16);
        HashMap firstDimensionMap = Maps.newHashMapWithExpectedSize((int)16);
        HashMap secondDimensionMap = Maps.newHashMapWithExpectedSize((int)16);
        HashMap thirdDimensionMap = Maps.newHashMapWithExpectedSize((int)16);
        HashMap fourthDimensionMap = Maps.newHashMapWithExpectedSize((int)16);
        HashMap fifthDimensionMap = Maps.newHashMapWithExpectedSize((int)16);
        for (StaffQueryInParam staffQueryInParam : this.staffQueryInParams) {
            this.orgTeamIds.add(staffQueryInParam.getOrgTeamId());
            this.buildStaffGroupMap(staffQueryInParam, useOrgGroupMap, String.valueOf(staffQueryInParam.getOrgTeamId()));
            this.buildStaffGroupMap(staffQueryInParam, positionGroupMap, String.valueOf(staffQueryInParam.getDutyWorkRoleId()));
            this.buildDimensionGroupMap(staffQueryInParam, jobGroupMap, String.valueOf(staffQueryInParam.getJobId()));
            this.buildDimensionGroupMap(staffQueryInParam, laborGroupMap, String.valueOf(staffQueryInParam.getLaborRelTypeId()));
            Map other = staffQueryInParam.getOther();
            Long basicdata1 = (Long)other.get(DynamicDimensionEnum.basicData1.getDimenSionIdentity());
            Long basicdata2 = (Long)other.get(DynamicDimensionEnum.basicData2.getDimenSionIdentity());
            Long basicdata3 = (Long)other.get(DynamicDimensionEnum.basicData3.getDimenSionIdentity());
            Long basicdata4 = (Long)other.get(DynamicDimensionEnum.basicData4.getDimenSionIdentity());
            Long basicdata5 = (Long)other.get(DynamicDimensionEnum.basicData5.getDimenSionIdentity());
            this.buildDimensionGroupMap(staffQueryInParam, firstDimensionMap, String.valueOf(basicdata1));
            this.buildDimensionGroupMap(staffQueryInParam, secondDimensionMap, String.valueOf(basicdata2));
            this.buildDimensionGroupMap(staffQueryInParam, thirdDimensionMap, String.valueOf(basicdata3));
            this.buildDimensionGroupMap(staffQueryInParam, fourthDimensionMap, String.valueOf(basicdata4));
            this.buildDimensionGroupMap(staffQueryInParam, fifthDimensionMap, String.valueOf(basicdata5));
            if (staffQueryInParam.getCandidateId() != null) {
                this.candidateIds.add(staffQueryInParam.getCandidateId());
                continue;
            }
            this.depEmpIds.add(staffQueryInParam.getDepEmpId());
        }
        this.useOrgOccupyChain.setQueryParamGroupMap(useOrgGroupMap);
        this.positionOccupyChain.setQueryParamGroupMap(positionGroupMap);
        this.jobOccupyChain.setQueryParamGroupMap(jobGroupMap);
        this.laborRelTypeOccupyChain.setQueryParamGroupMap(laborGroupMap);
        if (this.firstDimensionChain != null) {
            this.firstDimensionChain.setQueryParamGroupMap(firstDimensionMap);
        }
        if (this.secondDimensionChain != null) {
            this.secondDimensionChain.setQueryParamGroupMap(secondDimensionMap);
        }
        if (this.thirdDimensionChain != null) {
            this.thirdDimensionChain.setQueryParamGroupMap(thirdDimensionMap);
        }
        if (this.fourthDimensionChain != null) {
            this.fourthDimensionChain.setQueryParamGroupMap(fourthDimensionMap);
        }
        if (this.fifthDimensionChain != null) {
            this.fifthDimensionChain.setQueryParamGroupMap(fifthDimensionMap);
        }
    }

    private void buildBeforeGroupMap() {
        DynamicObject[] dynamicObjectArray;
        logger.info("buildBeforeGroupMap.begin!");
        HashMap beforeUseOrgGroupMap = Maps.newHashMapWithExpectedSize((int)16);
        HashMap beforePositionGroupMap = Maps.newHashMapWithExpectedSize((int)16);
        HashMap beforeJobGroupMap = Maps.newHashMapWithExpectedSize((int)16);
        HashMap beforeLaborGroupMap = Maps.newHashMapWithExpectedSize((int)16);
        HashMap beforeBasicdata1GroupMap = Maps.newHashMapWithExpectedSize((int)16);
        HashMap beforeBasicdata2GroupMap = Maps.newHashMapWithExpectedSize((int)16);
        HashMap beforeBasicdata3GroupMap = Maps.newHashMapWithExpectedSize((int)16);
        HashMap beforeBasicdata4GroupMap = Maps.newHashMapWithExpectedSize((int)16);
        HashMap beforeBasicdata5GroupMap = Maps.newHashMapWithExpectedSize((int)16);
        DynamicObject[] useStaffInfoArr = null;
        if (!CollectionUtils.isEmpty(this.candidateIds)) {
            DynamicObject[] personInfoArr = this.personStaffInfoRepository.queryPersonStaffInfoCandidateIds(this.candidateIds);
            if (personInfoArr == null || personInfoArr.length == 0) {
                return;
            }
            List<Long> list = Arrays.stream(personInfoArr).map(dyn -> dyn.getLong("id")).collect(Collectors.toList());
            useStaffInfoArr = this.useStaffInfoRepository.queryEffStaffByStaffPersonId(list);
        } else if (!CollectionUtils.isEmpty(this.depEmpIds)) {
            useStaffInfoArr = this.useStaffInfoRepository.queryEffStaffInfoByDepId(this.depEmpIds);
        }
        if (useStaffInfoArr == null || useStaffInfoArr.length == 0) {
            return;
        }
        ArrayList useStaffIds = Lists.newArrayListWithExpectedSize((int)useStaffInfoArr.length);
        for (DynamicObject useStaffInfo : useStaffInfoArr) {
            long useStaffId = useStaffInfo.getLong("id");
            useStaffIds.add(useStaffId);
            long useOrgId = useStaffInfo.getLong("useorg.id");
            this.buildBeforeStaffGroupMap(useStaffInfo, beforeUseOrgGroupMap, String.valueOf(useOrgId));
        }
        for (DynamicObject multiDimensionInfo : dynamicObjectArray = this.muldimUseStaffRepository.queryByOrgUseStaffDetailIds(useStaffIds)) {
            if (multiDimensionInfo.getDynamicObject("muldimendetail.dutyworkrole") != null) {
                this.buildBeforeStaffGroupMap(multiDimensionInfo, beforePositionGroupMap, String.valueOf(multiDimensionInfo.getLong("muldimendetail.dutyworkrole.id")));
                continue;
            }
            if (multiDimensionInfo.getDynamicObject("muldimendetail.job") != null) {
                this.buildBeforeDimensionGroupMap(multiDimensionInfo, beforeJobGroupMap, String.valueOf(multiDimensionInfo.getLong("muldimendetail.job.id")));
                continue;
            }
            if (multiDimensionInfo.getDynamicObject("muldimendetail.laborreltype") != null) {
                this.buildBeforeDimensionGroupMap(multiDimensionInfo, beforeLaborGroupMap, String.valueOf(multiDimensionInfo.getLong("muldimendetail.laborreltype.id")));
                continue;
            }
            if (this.firstDimensionChain != null && multiDimensionInfo.getDynamicObject("muldimendetail.basicdata1") != null) {
                this.buildBeforeDimensionGroupMap(multiDimensionInfo, beforeBasicdata1GroupMap, String.valueOf(multiDimensionInfo.getLong("muldimendetail.basicdata1.id")));
                continue;
            }
            if (this.secondDimensionChain != null && multiDimensionInfo.getDynamicObject("muldimendetail.basicdata2") != null) {
                this.buildBeforeDimensionGroupMap(multiDimensionInfo, beforeBasicdata2GroupMap, String.valueOf(multiDimensionInfo.getLong("muldimendetail.basicdata2.id")));
                continue;
            }
            if (this.thirdDimensionChain != null && multiDimensionInfo.getDynamicObject("muldimendetail.basicdata3") != null) {
                this.buildBeforeDimensionGroupMap(multiDimensionInfo, beforeBasicdata3GroupMap, String.valueOf(multiDimensionInfo.getLong("muldimendetail.basicdata3.id")));
                continue;
            }
            if (this.fourthDimensionChain != null && multiDimensionInfo.getDynamicObject("muldimendetail.basicdata4") != null) {
                this.buildBeforeDimensionGroupMap(multiDimensionInfo, beforeBasicdata4GroupMap, String.valueOf(multiDimensionInfo.getLong("muldimendetail.basicdata4.id")));
                continue;
            }
            if (this.fifthDimensionChain == null || multiDimensionInfo.getDynamicObject("muldimendetail.basicdata5") == null) continue;
            this.buildBeforeDimensionGroupMap(multiDimensionInfo, beforeBasicdata5GroupMap, String.valueOf(multiDimensionInfo.getLong("muldimendetail.basicdata5.id")));
        }
        this.useOrgOccupyChain.setBeforeDynGroupMap(beforeUseOrgGroupMap);
        this.positionOccupyChain.setBeforeDynGroupMap(beforePositionGroupMap);
        this.jobOccupyChain.setBeforeDynGroupMap(beforeJobGroupMap);
        this.laborRelTypeOccupyChain.setBeforeDynGroupMap(beforeLaborGroupMap);
        if (this.firstDimensionChain != null) {
            this.firstDimensionChain.setBeforeDynGroupMap(beforeBasicdata1GroupMap);
        }
        if (this.secondDimensionChain != null) {
            this.secondDimensionChain.setBeforeDynGroupMap(beforeBasicdata2GroupMap);
        }
        if (this.thirdDimensionChain != null) {
            this.thirdDimensionChain.setBeforeDynGroupMap(beforeBasicdata3GroupMap);
        }
        if (this.fourthDimensionChain != null) {
            this.fourthDimensionChain.setBeforeDynGroupMap(beforeBasicdata4GroupMap);
        }
        if (this.fifthDimensionChain != null) {
            this.fifthDimensionChain.setBeforeDynGroupMap(beforeBasicdata5GroupMap);
        }
        logger.info("buildBeforeGroupMap.end!");
    }

    private void rebuildOccupyResultMap() {
        this.useOrgOccupyChain.rebuildOccupyResultMap();
        this.positionOccupyChain.rebuildOccupyResultMap();
        this.jobOccupyChain.rebuildOccupyResultMap();
        this.laborRelTypeOccupyChain.rebuildOccupyResultMap();
        this.multiOccupyServices.forEach(temp -> temp.rebuildOccupyResultMap());
    }

    private void buildBeforeStaffGroupMap(DynamicObject useStaffInfo, Map<String, List<DynamicObject>> groupMap, String groupKey) {
        if (!HRStringUtils.isEmpty((String)groupKey)) {
            ArrayList useOrgGroups = groupMap.get(groupKey);
            if (useOrgGroups == null) {
                useOrgGroups = Lists.newArrayListWithExpectedSize((int)16);
            }
            useOrgGroups.add(useStaffInfo);
            groupMap.put(groupKey, useOrgGroups);
        }
    }

    private void buildBeforeDimensionGroupMap(DynamicObject dimensionStaffInfo, Map<String, List<DynamicObject>> groupMap, String groupKey) {
        if (!HRStringUtils.isEmpty((String)groupKey)) {
            String buildKey = dimensionStaffInfo.getLong("orgusestaffdetail.useorg.id") + "-" + groupKey;
            ArrayList groupList = groupMap.get(buildKey);
            if (groupList == null) {
                groupList = Lists.newArrayListWithExpectedSize((int)16);
            }
            groupList.add(dimensionStaffInfo);
            groupMap.put(buildKey, groupList);
        }
    }

    private void buildStaffGroupMap(StaffQueryInParam staffQueryInParam, Map<String, List<StaffQueryInParam>> groupMap, String groupKey) {
        if (!HRStringUtils.isEmpty((String)groupKey)) {
            ArrayList useOrgGroups = groupMap.get(groupKey);
            if (useOrgGroups == null) {
                useOrgGroups = Lists.newArrayListWithExpectedSize((int)16);
            }
            useOrgGroups.add(staffQueryInParam);
            groupMap.put(groupKey, useOrgGroups);
        }
    }

    private void buildDimensionGroupMap(StaffQueryInParam staffQueryInParam, Map<String, List<StaffQueryInParam>> groupMap, String groupKey) {
        if (!HRStringUtils.isEmpty((String)groupKey)) {
            groupKey = staffQueryInParam.getOrgTeamId() + "-" + groupKey;
            ArrayList groupList = groupMap.get(groupKey);
            if (groupList == null) {
                groupList = Lists.newArrayListWithExpectedSize((int)16);
            }
            groupList.add(staffQueryInParam);
            groupMap.put(groupKey, groupList);
        }
    }

    private void buildSpecialRule() {
        if (CollectionUtils.isEmpty(this.orgTeamIds)) {
            return;
        }
        DynamicObject[] adminOrgInfoArr = this.adOrgRepository.queryOrgInfoByBoId("id, boid, org", new ArrayList<Long>(this.orgTeamIds));
        Map<Long, Long> orgIdMap = Arrays.stream(adminOrgInfoArr).collect(Collectors.toMap(adminOrgInfo -> adminOrgInfo.getLong("id"), adminOrgInfo -> adminOrgInfo.getLong("org.id")));
        ArrayList engineParamBos = Lists.newArrayListWithExpectedSize((int)this.staffQueryInParams.size());
        for (StaffQueryInParam staffQueryInParam : this.staffQueryInParams) {
            Long orgTeamId = staffQueryInParam.getOrgTeamId();
            Long orgId = orgIdMap.get(orgTeamId);
            if (orgId == null) continue;
            String serialNumber = ID.genStringId();
            StaffCallRuleEngineParamBo staffCallRuleEngineParamBo = new StaffCallRuleEngineParamBo(staffQueryInParam.getDutyWorkRoleId(), staffQueryInParam.getJobId(), staffQueryInParam.getLaborRelTypeId(), staffQueryInParam.getOrgTeamId(), serialNumber, orgId);
            engineParamBos.add(staffCallRuleEngineParamBo);
            staffQueryInParam.getOther().put("specialRuleSerialKey", serialNumber);
        }
        List<String> serialNumbers = this.projectService.batchCallRuleEngine(engineParamBos);
        this.useOrgOccupyChain.setSerialNumbers(serialNumbers);
    }

    private void querySystemParam() {
        HashSet orgIds = Sets.newHashSetWithExpectedSize((int)16);
        orgIds.addAll(this.useOrgOccupyChain.getOrgIds());
        orgIds.addAll(this.dutyOrgOccupyChain.getOrgIds());
        orgIds.addAll(this.positionOccupyChain.getOrgIds());
        orgIds.addAll(this.jobOccupyChain.getOrgIds());
        orgIds.addAll(this.laborRelTypeOccupyChain.getOrgIds());
        this.multiOccupyServices.forEach(temp -> orgIds.addAll(temp.getOrgIds()));
        Map<String, Map<String, Object>> systemParamAll = StaffCommonService.batchLoadSystemParam(new ArrayList<Long>(orgIds));
        HashMap systemParam = Maps.newHashMapWithExpectedSize((int)systemParamAll.size());
        Iterator<Map.Entry<String, Map<String, Object>>> iterator = systemParamAll.entrySet().iterator();
        while (iterator.hasNext()) {
            if (iterator.next().getValue() != null) continue;
            iterator.remove();
        }
        systemParamAll.forEach((orgId, paramKeyAndValueAll) -> paramKeyAndValueAll.forEach((paramKey, paramValue) -> {
            if (paramKey.equals("effectrelease") || paramKey.equals("elasticcountgroup")) {
                Map paramKeyAndValue = systemParam.getOrDefault(orgId, new HashMap());
                paramKeyAndValue.put(paramKey, paramValue);
                systemParam.put(orgId, paramKeyAndValue);
            }
        }));
        logger.info("StaffOccupyServiceCreator.systemParam:{}", (Object)JSONObject.toJSONString((Object)systemParam));
        this.useOrgOccupyChain.setSystemParam(systemParam);
        this.dutyOrgOccupyChain.setSystemParam(systemParam);
        this.positionOccupyChain.setSystemParam(systemParam);
        this.jobOccupyChain.setSystemParam(systemParam);
        this.laborRelTypeOccupyChain.setSystemParam(systemParam);
        this.multiOccupyServices.forEach(temp -> temp.setSystemParam(systemParam));
    }

    private void initMultiOccupyServices(List<StaffQueryInParam> staffQueryInParams) {
        DynamicObject[] dynamicObjects = StaffDimensionRepository.getInstance().listAllDimension();
        List<String> staffdimension = Arrays.asList(dynamicObjects).stream().map(temp -> temp.getString("staffdimension")).collect(Collectors.toList());
        staffdimension.forEach(temp -> {
            switch (temp) {
                case "basicdata1": {
                    FirstDimensionChain firstDimensionChain;
                    this.firstDimensionChain = firstDimensionChain = new FirstDimensionChain(staffQueryInParams);
                    this.multiOccupyServices.add(firstDimensionChain);
                    break;
                }
                case "basicdata2": {
                    SecondDimensionChain secondDimensionChain;
                    this.secondDimensionChain = secondDimensionChain = new SecondDimensionChain(staffQueryInParams);
                    this.multiOccupyServices.add(secondDimensionChain);
                    break;
                }
                case "basicdata3": {
                    ThirdDimensionChain thirdDimensionChain;
                    this.thirdDimensionChain = thirdDimensionChain = new ThirdDimensionChain(staffQueryInParams);
                    this.multiOccupyServices.add(thirdDimensionChain);
                    break;
                }
                case "basicdata4": {
                    FourthDimensionChain fourthDimensionChain;
                    this.fourthDimensionChain = fourthDimensionChain = new FourthDimensionChain(staffQueryInParams);
                    this.multiOccupyServices.add(fourthDimensionChain);
                    break;
                }
                case "basicdata5": {
                    FifthDimensionChain fifthDimensionChain;
                    this.fifthDimensionChain = fifthDimensionChain = new FifthDimensionChain(staffQueryInParams);
                    this.multiOccupyServices.add(fifthDimensionChain);
                    break;
                }
                default: {
                    throw new KDBizException("initMultiOccupyServices error not supported dimensionIdentify");
                }
            }
        });
    }
}

