/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.business.service.staff.occupy.core;

import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.hr.haos.business.domain.repository.staff.StaffDimensionRepository;
import kd.hr.haos.business.service.staff.occupy.core.AbstractMultiOccupyService;
import kd.hr.haos.common.constants.staff.DynamicDimensionEnum;
import kd.hr.hbp.common.model.org.staff.StaffQueryInParam;
import kd.hr.hbp.common.util.HRDateTimeUtils;

public class ThirdDimensionChain
extends AbstractMultiOccupyService {
    public ThirdDimensionChain(List<StaffQueryInParam> staffQueryInParams) {
        super(staffQueryInParams);
        this.staffOccupyResultMap = this.staffOccupyService.queryLaborThirdDimensionStaffInfo();
        logger.info("ThirdDimensionChain.init.staffOccupyResultMap:{}", (Object)this.staffOccupyResultMap.toString());
    }

    @Override
    protected String getOccupyKey(StaffQueryInParam staffQueryInParam) {
        Long orgTeamId = staffQueryInParam.getOrgTeamId();
        int year = HRDateTimeUtils.getYear((Date)staffQueryInParam.getEffDate());
        return year + "-" + orgTeamId + "-" + this.getDimensionId(staffQueryInParam);
    }

    @Override
    protected String getDimensionCombKey(StaffQueryInParam staffQueryInParam) {
        Long orgTeamId = staffQueryInParam.getOrgTeamId();
        return orgTeamId + "-" + this.getDimensionId(staffQueryInParam);
    }

    @Override
    protected String buildReasonMessage(int remainStaffNum, String name) {
        DynamicObject dimensionByIdentify = StaffDimensionRepository.getInstance().getDimensionByIdentify(DynamicDimensionEnum.basicData3.getDimenSionIdentity());
        String disPlayName = dimensionByIdentify == null ? ResManager.loadKDString((String)"\u7ef4\u5ea63", (String)"ThirdDimensionChain_1", (String)"hrmp-haos-business", (Object[])new Object[0]) : dimensionByIdentify.getString("name");
        return String.format(ResManager.loadKDString((String)"%1$s\uff08%2$s)\u7f16\u5236\u4e0d\u8db3\uff08\u7a7a\u4f59\u7f16\u5236\uff1a%3$s\u4eba\uff09\u3002", (String)"ThirdDimensionChain_0", (String)"hrmp-haos-business", (Object[])new Object[0]), disPlayName, name, remainStaffNum);
    }

    private Long getDimensionId(StaffQueryInParam staffQueryInParam) {
        Map other = staffQueryInParam.getOther();
        return other.getOrDefault("basicdata3", 0L);
    }
}

