/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.business.service.staff.occupy.core;

import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.haos.business.domain.repository.adorg.AdOrgRepository;
import kd.hr.haos.business.service.staff.occupy.bean.StaffDetailBO;
import kd.hr.haos.business.service.staff.occupy.core.AbstractStaffOccupyService;
import kd.hr.hbp.common.model.org.staff.StaffQueryInParam;
import kd.hr.hbp.common.model.org.staff.StaffQueryOutParam;
import kd.hr.hbp.common.util.HRDateTimeUtils;

public class UseOrgOccupyChain
extends AbstractStaffOccupyService {
    private List<String> serialNumbers;

    public UseOrgOccupyChain(List<StaffQueryInParam> staffQueryInParams) {
        super(staffQueryInParams);
        this.staffOccupyResultMap = this.staffOccupyService.queryUseStaffInfo();
        HashSet adminOrgBoIdSet = Sets.newHashSetWithExpectedSize((int)staffQueryInParams.size());
        for (StaffQueryInParam staffQueryInParam : staffQueryInParams) {
            Long orgTeamId = staffQueryInParam.getOrgTeamId();
            adminOrgBoIdSet.add(orgTeamId);
        }
        this.initKeyFieldIdVsNameMap(adminOrgBoIdSet);
        logger.info("UseOrgOccupyChain.init.staffOccupyResultMap:{}", (Object)this.staffOccupyResultMap.toString());
    }

    private void initKeyFieldIdVsNameMap(Set<Long> adminOrgBoIdSet) {
        QFilter idFilter = new QFilter("id", "in", adminOrgBoIdSet);
        DynamicObject[] adminOrgDyns = AdOrgRepository.getInstance().queryOriginalArray("id, name", new QFilter[]{idFilter});
        Map<Long, String> adminOrgBoIdVsNameMap = Arrays.stream(adminOrgDyns).collect(Collectors.toMap(dyn -> dyn.getLong("id"), dyn -> dyn.getString("name")));
        for (Long adminOrgBoId : adminOrgBoIdSet) {
            String name = adminOrgBoIdVsNameMap.get(adminOrgBoId);
            this.useOrgBoIdOrDutyOrgIdVsBoNameMap.put(adminOrgBoId, name);
        }
    }

    public void setSerialNumbers(List<String> serialNumbers) {
        this.serialNumbers = serialNumbers;
    }

    @Override
    protected boolean occupyCalc(StaffQueryInParam staffQueryInParam, StaffQueryOutParam staffQueryOutParam) {
        if (this.checkSpecialRule(staffQueryInParam)) {
            staffQueryOutParam.setSpecialRule(true);
            return false;
        }
        if (CollectionUtils.isEmpty((Map)this.staffOccupyResultMap)) {
            return false;
        }
        String occupyKey = this.getOccupyKey(staffQueryInParam);
        StaffDetailBO staffDetailBO = (StaffDetailBO)this.staffOccupyResultMap.get(occupyKey);
        if (staffDetailBO != null) {
            String controlStrategy = staffDetailBO.getControlStrategy();
            if ("4".equals(controlStrategy)) {
                return false;
            }
            return this.commonStaffNumValid(staffQueryInParam, staffQueryOutParam, staffDetailBO);
        }
        return false;
    }

    @Override
    protected String getOccupyKey(StaffQueryInParam staffQueryInParam) {
        Date effDate = staffQueryInParam.getEffDate();
        int year = HRDateTimeUtils.getYear((Date)effDate);
        return year + "-" + staffQueryInParam.getOrgTeamId();
    }

    @Override
    protected String getDimensionCombKey(StaffQueryInParam staffQueryInParam) {
        return String.valueOf(staffQueryInParam.getOrgTeamId());
    }

    @Override
    protected String getKeyFieldName(StaffDetailBO staffDetailBO) {
        long useOrgBoId = staffDetailBO.getUseOrgBOId();
        return (String)this.useOrgBoIdOrDutyOrgIdVsBoNameMap.get(useOrgBoId);
    }

    @Override
    protected String buildReasonMessage(int remainStaffNum, String name) {
        return String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u7f16\u5236\u4e0d\u8db3\uff08\u7a7a\u4f59\u76f4\u5c5e\u7f16\u5236\uff1a%2$s\uff09\u3002", (String)"UseOrgOccupyChain_0", (String)"hrmp-haos-business", (Object[])new Object[0]), name, remainStaffNum);
    }

    private boolean checkSpecialRule(StaffQueryInParam staffQueryInParam) {
        if (!CollectionUtils.isEmpty(this.serialNumbers)) {
            Map other = staffQueryInParam.getOther();
            String serialNumber = (String)other.get("specialRuleSerialKey");
            return this.serialNumbers.contains(serialNumber);
        }
        return false;
    }
}

