/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.business.service.staff.service;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.text.ParseException;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.hr.haos.business.service.staff.service.StaffCommonService;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.constants.newhismodel.EventOperateEnums;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;

public abstract class AbstractStaffHistoryService {
    private static final Log logger = LogFactory.getLog(AbstractStaffHistoryService.class);
    private static ThreadPool staffInfoSaveHandlerThreadPool = ThreadPools.newFixedThreadPool((String)"StaffInfoSaveHandler", (int)10);
    protected HRBaseServiceHelper serviceHelper;
    protected HRBaseServiceHelper hisServiceHelper;

    public AbstractStaffHistoryService(String entityName, String hisEntityName) {
        this.serviceHelper = new HRBaseServiceHelper(entityName);
        this.hisServiceHelper = new HRBaseServiceHelper(hisEntityName);
    }

    protected abstract String getHisJoinName();

    protected Map<Long, DynamicObject> getTempHisInfoMap(List<DynamicObject> dynList, boolean isHisData) {
        QFilter filter = new QFilter("datastatus", "=", (Object)EventOperateEnums.CHANGE_BEFORE_STATUS_TEMP.getValue());
        if (isHisData) {
            Set ids = dynList.stream().map(dyn -> dyn.getLong("id")).collect(Collectors.toSet());
            filter.and(this.getHisJoinName(), "in", ids);
            DynamicObject[] dbHisInfos = this.hisServiceHelper.loadDynamicObjectArray(new QFilter[]{filter});
            return Arrays.stream(dbHisInfos).collect(Collectors.toMap(dyn -> dyn.getLong(this.getHisJoinName() + ".id"), dyn -> dyn));
        }
        Set staffIds = dynList.stream().map(dyn -> dyn.getLong("staff.id")).collect(Collectors.toSet());
        filter.and("staff", "in", staffIds);
        String entityName = this.serviceHelper.getEntityName();
        QFilter orgPermQFilter = HRStringUtils.equals((String)entityName, (String)"haos_useorgdetail") ? StaffCommonService.getOrgPermQFilterForUseOrgEntry() : new QFilter("1", "=", (Object)1);
        DynamicObject[] dbInfos = this.serviceHelper.loadDynamicObjectArray(new QFilter[]{filter, orgPermQFilter});
        return Arrays.stream(dbInfos).collect(Collectors.toMap(dyn -> dyn.getLong("id"), dyn -> dyn));
    }

    public void batchSaveTempBoDataHis(List<DynamicObject> dynList) {
        this.beforeSaveTempBoDataHis(dynList);
        String errorInfoByMulDy = this.getErrorInfoByMulDy(dynList);
        if (!HRStringUtils.isEmpty((String)errorInfoByMulDy)) {
            throw new KDBizException(errorInfoByMulDy);
        }
        Date dateNow = new Date();
        int size = dynList.size();
        Map<Long, DynamicObject> dbInfoMap = this.getTempHisInfoMap(dynList, false);
        Map<Long, DynamicObject> dbHisInfoMap = this.getTempHisInfoMap(dynList, true);
        HashSet<Long> toDeleteIds = new HashSet<Long>(dbInfoMap.keySet());
        DynamicObject[] hisDynArr = new DynamicObject[size];
        for (int i = 0; i < size; ++i) {
            long vId;
            DynamicObject dyn = dynList.get(i);
            long id = dyn.getLong("id");
            dyn.set("enable", (Object)"10");
            this.setSystemField(dateNow, dyn);
            this.setHisCommonField(dateNow, dyn, EventOperateEnums.CHANGE_BEFORE_STATUS_TEMP.getValue());
            DynamicObject hisDyn = dbHisInfoMap.get(id);
            if (hisDyn != null) {
                vId = hisDyn.getLong("id");
                HRDynamicObjectUtils.copy((DynamicObject)dyn, (DynamicObject)hisDyn, this.saveTempIgnoreKey());
                hisDyn.set("id", (Object)vId);
            } else {
                hisDyn = this.hisServiceHelper.generateEmptyDynamicObject();
                vId = ID.genLongId();
                dyn.set("creator", (Object)RequestContext.get().getCurrUserId());
                dyn.set("createtime", (Object)dateNow);
                HRDynamicObjectUtils.copy((DynamicObject)dyn, (DynamicObject)hisDyn);
                dyn.set("id", (Object)id);
                dyn.set("vid", (Object)vId);
                hisDyn.set("id", (Object)vId);
                hisDyn.set(this.getHisJoinName(), (Object)id);
            }
            hisDynArr[i] = hisDyn;
            DynamicObject dynDB = dbInfoMap.get(id);
            if (dynDB != null) {
                HRDynamicObjectUtils.copy((DynamicObject)dyn, (DynamicObject)dynDB, this.saveTempIgnoreKey());
                dynDB.set("id", (Object)id);
                dynList.set(i, dynDB);
            }
            toDeleteIds.remove(id);
        }
        try {
            if (dynList.size() > 0) {
                int i;
                List dynListGroup = Lists.partition(dynList, (int)5000);
                List hisDynListGroup = Lists.partition(Arrays.asList(hisDynArr), (int)5000);
                int hisGroupSize = hisDynListGroup.size();
                int groupSize = dynListGroup.size();
                CountDownLatch countDownLatch = new CountDownLatch(groupSize + groupSize);
                for (i = 0; i < groupSize; ++i) {
                    List groupList = (List)dynListGroup.get(i);
                    staffInfoSaveHandlerThreadPool.execute(() -> {
                        this.serviceHelper.save(groupList.toArray(new DynamicObject[0]));
                        countDownLatch.countDown();
                    });
                }
                for (i = 0; i < hisGroupSize; ++i) {
                    List hisGroupList = (List)hisDynListGroup.get(i);
                    staffInfoSaveHandlerThreadPool.execute(() -> {
                        this.hisServiceHelper.save(hisGroupList.toArray(new DynamicObject[0]));
                        countDownLatch.countDown();
                    });
                }
                countDownLatch.await();
            }
        }
        catch (InterruptedException e) {
            logger.error((Throwable)e);
        }
        this.batchDeleteTempData(toDeleteIds.toArray());
        this.afterSaveTempBoDataHis(dynList);
    }

    private Set<String> saveTempIgnoreKey() {
        HashSet ignoreKeys = Sets.newHashSetWithExpectedSize((int)16);
        ignoreKeys.add("vid");
        ignoreKeys.add("vid_id");
        ignoreKeys.add("creator");
        ignoreKeys.add("creator_id");
        return ignoreKeys;
    }

    protected void setSystemField(Date dateNow, DynamicObject dyn) {
        dyn.set("modifytime", (Object)dateNow);
        dyn.set("modifier", (Object)RequestContext.get().getCurrUserId());
    }

    protected void setHisCommonField(Date dateNow, DynamicObject dyn, String dataStatus) {
        dyn.set("datastatus", (Object)dataStatus);
        try {
            dyn.set("effdt", (Object)HRDateTimeUtils.parseDate((String)HRDateTimeUtils.format((Date)dateNow, (String)"yyyy-MM-dd")));
            dyn.set("leffdt", (Object)HRDateTimeUtils.parseDate((String)"2999-12-31"));
        }
        catch (ParseException e) {
            logger.error("setHisCommonField parse date error" + e);
            throw new KDBizException("setHisCommonField parse date error!");
        }
    }

    protected void beforeSaveTempBoDataHis(List<DynamicObject> dynList) {
    }

    protected void afterSaveTempBoDataHis(List<DynamicObject> dynList) {
    }

    public void batchModifyBoDataHis(List<DynamicObject> dynList) {
        this.beforeBatchModifyBoDataHis(dynList);
        String errorInfoByMulDy = this.getErrorInfoByMulDy(dynList);
        if (!HRStringUtils.isEmpty((String)errorInfoByMulDy)) {
            throw new KDBizException(errorInfoByMulDy);
        }
        Date dateNow = new Date();
        int size = dynList.size();
        List vIdList = dynList.stream().map(dyn -> dyn.getLong("vid.id")).collect(Collectors.toList());
        QFilter vIdFilter = new QFilter("id", "in", vIdList);
        DynamicObject[] hisDynArr = this.hisServiceHelper.loadDynamicObjectArray(new QFilter[]{vIdFilter});
        Map<Long, DynamicObject> vIdVsHisDynMap = Arrays.stream(hisDynArr).collect(Collectors.toMap(dyn -> dyn.getLong("id"), dyn -> dyn));
        for (int i = 0; i < size; ++i) {
            DynamicObject dyn2 = dynList.get(i);
            this.setSystemField(dateNow, dyn2);
            dyn2.set("datastatus", (Object)EventOperateEnums.CHANGE_BEFORE_STATUS_EFFECTING.getValue());
            long vId = dyn2.getLong("vid.id");
            DynamicObject hisDyn = vIdVsHisDynMap.get(vId);
            HRDynamicObjectUtils.copy((DynamicObject)dyn2, (DynamicObject)hisDyn, this.saveTempIgnoreKey());
            hisDyn.set("id", (Object)vId);
            hisDyn.set("datastatus", (Object)EventOperateEnums.CHANGE_BEFORE_STATUS_EFFECTING.getValue());
        }
        this.serviceHelper.save(dynList.toArray(new DynamicObject[0]));
        this.hisServiceHelper.save(hisDynArr);
        this.afterBatchModifyBoDataHis(dynList);
    }

    public void batchSaveAndEnableBoDataHis(List<DynamicObject> dynList) {
        this.beforeSaveAndEnableTempBoDataHis(dynList);
        String errorInfoByMulDy = this.getErrorInfoByMulDy(dynList);
        if (!HRStringUtils.isEmpty((String)errorInfoByMulDy)) {
            throw new KDBizException(errorInfoByMulDy);
        }
        Date dateNow = new Date();
        int size = dynList.size();
        DynamicObject[] hisDynArr = new DynamicObject[size];
        for (int i = 0; i < size; ++i) {
            DynamicObject dyn = dynList.get(i);
            long id = dyn.getLong("id");
            if (id == 0L) {
                id = ID.genLongId();
            }
            dyn.set("enable", (Object)dyn.getString("staff.enable"));
            this.setSystemField(dateNow, dyn);
            this.setHisCommonField(dateNow, dyn, EventOperateEnums.CHANGE_BEFORE_STATUS_EFFECTING.getValue());
            DynamicObject hisDyn = this.hisServiceHelper.generateEmptyDynamicObject();
            long vId = ID.genLongId();
            dyn.set("creator", (Object)RequestContext.get().getCurrUserId());
            dyn.set("createtime", (Object)dateNow);
            HRDynamicObjectUtils.copy((DynamicObject)dyn, (DynamicObject)hisDyn);
            dyn.set("id", (Object)id);
            dyn.set("vid", (Object)vId);
            hisDyn.set("id", (Object)vId);
            hisDyn.set(this.getHisJoinName(), (Object)id);
            hisDynArr[i] = hisDyn;
        }
        this.serviceHelper.save(dynList.toArray(new DynamicObject[0]));
        this.hisServiceHelper.save(hisDynArr);
        this.afterSaveAndEnableTempBoDataHis(dynList);
    }

    protected void beforeSaveAndEnableTempBoDataHis(List<DynamicObject> dynList) {
    }

    protected void afterSaveAndEnableTempBoDataHis(List<DynamicObject> dynList) {
    }

    protected void beforeBatchModifyBoDataHis(List<DynamicObject> dynList) {
    }

    protected void afterBatchModifyBoDataHis(List<DynamicObject> dynList) {
    }

    public void batchEffectDataHis(List<Long> boIds) {
    }

    public void batchModifyAndEffectBoData(List<DynamicObject> dynList) {
        int i;
        DynamicObject[] hisDynArr;
        this.beforeModifyAndEffectBoDataHis(dynList);
        String errorInfoByMulDy = this.getErrorInfoByMulDy(dynList);
        if (!HRStringUtils.isEmpty((String)errorInfoByMulDy)) {
            throw new KDBizException(errorInfoByMulDy);
        }
        ArrayList tempDynList = Lists.newArrayListWithExpectedSize((int)dynList.size());
        ArrayList effectingDynList = Lists.newArrayListWithExpectedSize((int)dynList.size());
        ArrayList invalidList = Lists.newArrayListWithExpectedSize((int)dynList.size());
        dynList.forEach(dyn -> {
            String dataStatus = dyn.getString("datastatus");
            if (HRStringUtils.equals((String)dataStatus, (String)EventOperateEnums.CHANGE_BEFORE_STATUS_TEMP.getValue())) {
                tempDynList.add(dyn);
            } else if (HRStringUtils.equals((String)dataStatus, (String)EventOperateEnums.CHANGE_BEFORE_STATUS_EFFECTING.getValue())) {
                effectingDynList.add(dyn);
            } else {
                invalidList.add(dyn);
            }
        });
        List vidList = dynList.stream().map(dy -> dy.getLong("vid.id")).collect(Collectors.toList());
        QFilter hisDyFilter = new QFilter("id", "in", vidList);
        DynamicObject[] oldHisDyns = this.hisServiceHelper.loadDynamicObjectArray(new QFilter[]{hisDyFilter});
        Map<Long, DynamicObject> vid4OldHisDynMap = Arrays.stream(oldHisDyns).collect(Collectors.toMap(hisDyn -> hisDyn.getLong("id"), hisDyn -> hisDyn));
        Date dateNow = new Date();
        Date curDay = Date.from(ZonedDateTime.now().truncatedTo(ChronoUnit.DAYS).toInstant());
        if (!CollectionUtils.isEmpty((Collection)tempDynList)) {
            hisDynArr = new DynamicObject[tempDynList.size()];
            for (i = 0; i < tempDynList.size(); ++i) {
                DynamicObject dyn2 = (DynamicObject)tempDynList.get(i);
                this.setSystemField(dateNow, dyn2);
                this.setHisCommonField(dateNow, dyn2, EventOperateEnums.CHANGE_BEFORE_STATUS_EFFECTING.getValue());
                long vid = dyn2.getLong("vid.id");
                DynamicObject hisDyn2 = vid4OldHisDynMap.get(vid);
                HRDynamicObjectUtils.copy((DynamicObject)dyn2, (DynamicObject)hisDyn2);
                hisDyn2.set("id", (Object)vid);
                hisDynArr[i] = hisDyn2;
            }
            this.serviceHelper.save(dynList.toArray(new DynamicObject[0]));
            this.hisServiceHelper.save(hisDynArr);
        }
        if (!CollectionUtils.isEmpty((Collection)effectingDynList)) {
            hisDynArr = new DynamicObject[effectingDynList.size()];
            ArrayList oldHisDynList = Lists.newArrayListWithExpectedSize((int)effectingDynList.size());
            for (int i2 = 0; i2 < effectingDynList.size(); ++i2) {
                DynamicObject effectingDyn = (DynamicObject)effectingDynList.get(i2);
                long vid = effectingDyn.getLong("vid.id");
                DynamicObject oldHisDyn = vid4OldHisDynMap.get(vid);
                Date effdt = oldHisDyn.getDate("effdt");
                if (HRDateTimeUtils.dayEquals((Date)curDay, (Date)effdt)) {
                    oldHisDyn.set("datastatus", (Object)EventOperateEnums.CHANGE_BEFORE_STATUS_DELETED.getValue());
                } else {
                    oldHisDyn.set("datastatus", (Object)EventOperateEnums.CHANGE_BEFORE_STATUS_INVALIDED.getValue());
                    Date leffdt = HRDateTimeUtils.addDay((Date)dateNow, (long)-1L);
                    oldHisDyn.set("leffdt", (Object)leffdt);
                }
                oldHisDynList.add(oldHisDyn);
                this.setSystemField(dateNow, effectingDyn);
                this.setHisCommonField(dateNow, effectingDyn, EventOperateEnums.CHANGE_BEFORE_STATUS_EFFECTING.getValue());
                DynamicObject newHisDyn = this.hisServiceHelper.generateEmptyDynamicObject();
                long vId = ID.genLongId();
                HRDynamicObjectUtils.copy((DynamicObject)effectingDyn, (DynamicObject)newHisDyn);
                newHisDyn.set("id", (Object)vId);
                newHisDyn.set("createtime", (Object)dateNow);
                newHisDyn.set("creator", (Object)RequestContext.get().getCurrUserId());
                newHisDyn.set(this.getHisJoinName(), (Object)effectingDyn.getLong("id"));
                effectingDyn.set("vid", (Object)vId);
                hisDynArr[i2] = newHisDyn;
            }
            this.hisServiceHelper.update(oldHisDynList.toArray(new DynamicObject[0]));
            this.hisServiceHelper.save(hisDynArr);
            this.serviceHelper.save(dynList.toArray(new DynamicObject[0]));
        }
        if (!CollectionUtils.isEmpty((Collection)invalidList)) {
            hisDynArr = new DynamicObject[invalidList.size()];
            for (i = 0; i < invalidList.size(); ++i) {
                DynamicObject dyn3 = (DynamicObject)invalidList.get(i);
                DynamicObject hisDyn3 = this.hisServiceHelper.generateEmptyDynamicObject();
                long vId = ID.genLongId();
                this.setSystemField(dateNow, dyn3);
                this.setHisCommonField(dateNow, dyn3, EventOperateEnums.CHANGE_BEFORE_STATUS_EFFECTING.getValue());
                HRDynamicObjectUtils.copy((DynamicObject)dyn3, (DynamicObject)hisDyn3);
                dyn3.set("vid", (Object)vId);
                hisDyn3.set("id", (Object)vId);
                hisDyn3.set(this.getHisJoinName(), (Object)dyn3.getLong("id"));
                hisDynArr[i] = hisDyn3;
            }
        }
        this.afterModifyAndEffectBoDataHis(dynList);
    }

    protected void beforeModifyAndEffectBoDataHis(List<DynamicObject> dynList) {
    }

    protected void afterModifyAndEffectBoDataHis(List<DynamicObject> dynList) {
    }

    public void batchDeleteBoDataHis(List<DynamicObject> dynList) {
        this.beforeDeleteBoDataHis(dynList);
        String errorInfoByMulDy = this.getErrorInfoByMulDy(dynList);
        if (!HRStringUtils.isEmpty((String)errorInfoByMulDy)) {
            throw new KDBizException(errorInfoByMulDy);
        }
        List vidList = dynList.stream().map(dy -> dy.getLong("vid.id")).collect(Collectors.toList());
        QFilter hisDyFilter = new QFilter("id", "in", vidList);
        DynamicObject[] oldHisDyns = this.hisServiceHelper.loadDynamicObjectArray(new QFilter[]{hisDyFilter});
        Map<Long, DynamicObject> vid4OldHisDynMap = Arrays.stream(oldHisDyns).collect(Collectors.toMap(hisDyn -> hisDyn.getLong("id"), hisDyn -> hisDyn));
        Date dateNow = new Date();
        ArrayList oldHisDynList = Lists.newArrayListWithExpectedSize((int)dynList.size());
        this.hisServiceHelper.update(oldHisDyns);
        for (int i = 0; i < dynList.size(); ++i) {
            DynamicObject dyn = dynList.get(i);
            this.setSystemField(dateNow, dyn);
            dyn.set("datastatus", (Object)EventOperateEnums.CHANGE_BEFORE_STATUS_INVALIDED.getValue());
            Date leffdt = dateNow;
            try {
                leffdt = HRDateTimeUtils.parseDate((String)HRDateTimeUtils.format((Date)dateNow, (String)"yyyy-MM-dd"));
            }
            catch (ParseException e) {
                logger.error("date format error:", (Throwable)e);
                throw new KDBizException(e.getMessage());
            }
            dyn.set("leffdt", (Object)leffdt);
            long vid = dyn.getLong("vid.id");
            DynamicObject oldHisDyn = vid4OldHisDynMap.get(vid);
            oldHisDyn.set("datastatus", (Object)EventOperateEnums.CHANGE_BEFORE_STATUS_INVALIDED.getValue());
            oldHisDyn.set("leffdt", (Object)leffdt);
            oldHisDynList.add(oldHisDyn);
        }
        this.hisServiceHelper.save(oldHisDynList.toArray(new DynamicObject[dynList.size()]));
        this.serviceHelper.save(dynList.toArray(new DynamicObject[dynList.size()]));
        this.afterDeleteBoDataHis(dynList);
    }

    protected void beforeDeleteBoDataHis(List<DynamicObject> dynList) {
    }

    protected void afterDeleteBoDataHis(List<DynamicObject> dynList) {
    }

    public void batchDeleteTempData(Object[] pks) {
        this.serviceHelper.delete(pks);
        QFilter filter = new QFilter(this.getHisJoinName(), "in", (Object)pks);
        this.hisServiceHelper.deleteByFilter(new QFilter[]{filter});
    }

    protected String getErrorInfoByMulDy(List<DynamicObject> dynList) {
        ArrayList<String> errorInfos = new ArrayList<String>();
        if (dynList == null || dynList.size() == 0) {
            errorInfos.add(ResManager.loadKDString((String)"\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"OrgStaffHistoryService_0", (String)"hrmp-haos-business", (Object[])new Object[0]));
        } else {
            List repeatData = dynList.stream().map(dy -> dy.getDynamicObjectType().getName()).distinct().collect(Collectors.toList());
            if (repeatData.size() > 1) {
                errorInfos.add(ResManager.loadKDString((String)"\u6240\u6709\u5386\u53f2\u6570\u636e\u5fc5\u987b\u6765\u81ea\u540c\u4e00\u5b9e\u4f53\u3002", (String)"OrgStaffHistoryService_1", (String)"hrmp-haos-business", (Object[])new Object[0]));
            }
        }
        return CollectionUtils.isEmpty(errorInfos) ? null : ((Object)errorInfos).toString();
    }
}

