/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.business.service.staff.service;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.form.IFormView;
import kd.bos.form.container.Tab;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.haos.business.domain.repository.staff.StaffOrgEmpCountRepository;
import kd.hr.haos.business.service.staff.bean.StaffEntryParamBO;
import kd.hr.haos.business.service.staff.bean.StaffProjectBo;
import kd.hr.haos.business.service.staff.bean.UseOrgEntryParamBO;
import kd.hr.haos.business.service.staff.service.StaffCommonService;
import kd.hr.haos.business.service.staff.service.StaffExtEntryHelper;
import kd.hr.haos.business.util.TimeLogger;
import kd.hr.haos.common.constants.staff.OrgStaffConstants;

public class StaffEntryHelper
implements OrgStaffConstants {
    private static TimeLogger timeLogger = TimeLogger.create();
    private static final Log logger = LogFactory.getLog(StaffEntryHelper.class);

    public static void batchCreateNewEntryRow(AbstractFormDataModel model, IFormView view, List<? extends StaffEntryParamBO> entryParamBOs) {
        if (CollectionUtils.isEmpty(entryParamBOs)) {
            return;
        }
        String entryName = entryParamBOs.get(0).getEntryName();
        if (!entryParamBOs.get(0).isKeepOriginalData()) {
            model.deleteEntryData(entryName);
        }
        model.beginInit();
        TableValueSetter vs = new TableValueSetter(new String[0]);
        entryParamBOs.get(0).addField(vs);
        for (StaffEntryParamBO staffEntryParamBO : entryParamBOs) {
            if (staffEntryParamBO.getAdminOrgId() == 0L) {
                logger.info("StaffInitEntryDataService#batchCreateNewEntryRow adminOrgId is null");
                continue;
            }
            if (staffEntryParamBO.getDyn() != null) {
                staffEntryParamBO.addRowFromDyn(vs);
                continue;
            }
            staffEntryParamBO.addRow(vs);
        }
        timeLogger.checkForError("staffcosttime#before StaffEntryHelper#batchCreateNewEntryRow2222:");
        model.batchCreateNewEntryRow(entryName, vs);
        timeLogger.checkForError("staffcosttime#after StaffEntryHelper#batchCreateNewEntryRow2222:");
        model.endInit();
        timeLogger.checkForError("staffcosttime#before StaffEntryHelper#updateView:");
        view.updateView(entryName);
        timeLogger.checkForError("staffcosttime#after StaffEntryHelper#updateView:");
    }

    public static List<UseOrgEntryParamBO> buildUseOrgEntryParamBO(AbstractFormDataModel model, DynamicObject[] useOrgInfoArr, DynamicObject[] dutyOrgInfoArr) {
        HashSet adminOrgIds = Sets.newHashSetWithExpectedSize((int)16);
        HashSet adminOrgBOIds = Sets.newHashSetWithExpectedSize((int)16);
        for (DynamicObject dyn2 : useOrgInfoArr) {
            adminOrgIds.add(dyn2.getLong("useorg.id"));
            adminOrgBOIds.add(dyn2.getLong("useorg.boid"));
        }
        Date lastModifyTime = (Date)model.getValue("modifytime");
        Map<Long, String> orgLongNameMap = StaffCommonService.getOrgNameMap(adminOrgIds, lastModifyTime);
        DynamicObject[] staffOrgEmpCountArr = StaffOrgEmpCountRepository.getInstance().queryStaffEmpCountByOrgId(new ArrayList<Long>(adminOrgBOIds));
        Map<Long, DynamicObject> staffOrgEmpInfoMap = Arrays.stream(staffOrgEmpCountArr).collect(Collectors.toMap(dyn -> dyn.getLong("useorgbo.id"), dyn -> dyn, (v1, v2) -> v1));
        Map<Long, DynamicObject> structInfoMap = StaffCommonService.getStructInfoByOrgId(adminOrgBOIds, lastModifyTime);
        Map<Long, DynamicObject> dutyIdInfoMap = Arrays.stream(dutyOrgInfoArr).collect(Collectors.toMap(dyn -> dyn.getLong("dutyorg.id"), dyn -> dyn));
        ArrayList paramBOs = Lists.newArrayListWithExpectedSize((int)16);
        String roundType = (String)StaffCommonService.getSystemParam(((DynamicObject)model.getValue("org")).getLong("id"), "elasticcountgroup");
        DynamicObject staffCycle = (DynamicObject)model.getValue("staffcycle");
        for (DynamicObject dyn3 : useOrgInfoArr) {
            DynamicObject staffOrgEmpCount;
            DynamicObject structInfo;
            long adminOrgId = dyn3.getLong("useorg.id");
            long adminOrgBOId = dyn3.getLong("useorg.boid");
            UseOrgEntryParamBO useOrgEntry = new UseOrgEntryParamBO("bentryentity", "buseorg", adminOrgId);
            useOrgEntry.setId(dyn3.getLong("id"));
            useOrgEntry.setBoId(adminOrgBOId);
            useOrgEntry.setDyn(dyn3);
            useOrgEntry.setRoundType(roundType);
            useOrgEntry.setStaffCycleId(staffCycle == null ? 0L : staffCycle.getLong("id"));
            DynamicObject dutyOrgInfo = dutyIdInfoMap.get(adminOrgId);
            if (dutyOrgInfo != null) {
                useOrgEntry.setYearStaffNumWithSub(dutyOrgInfo.getInt("staffcount"));
            }
            if ((structInfo = structInfoMap.get(adminOrgBOId)) != null) {
                useOrgEntry.setStructLongNumber(structInfo.getString("structlongnumber"));
                useOrgEntry.setLevel(structInfo.getInt("level"));
            }
            if ((staffOrgEmpCount = staffOrgEmpInfoMap.get(adminOrgBOId)) != null) {
                useOrgEntry.setDirectNum(staffOrgEmpCount.getInt("count"));
            }
            useOrgEntry.setLongName(orgLongNameMap.get(adminOrgId));
            useOrgEntry.setParentOrgId(dyn3.getLong("useorg.parentorg.id"));
            useOrgEntry.setParentEntryId(dyn3.getLong("pid"));
            StaffProjectBo staffProjectBo = new StaffProjectBo(dyn3.get("controlstrategy"), dyn3.get("elasticcontrol"), dyn3.get("elasticcount"), dyn3.getDynamicObjectCollection("staffdimension"));
            useOrgEntry.setStaffProjectBo(staffProjectBo);
            paramBOs.add(useOrgEntry);
        }
        return paramBOs;
    }

    public static void buildChildEntryData(Set<Long> dimensionIds, HashSet<Long>[] positionAndJobIds, DynamicObjectCollection positionListAll, DynamicObjectCollection jobListAll, DynamicObjectCollection laborListAll, Set<Long> laborRelTypeIds, StaffProjectBo staffProjectBo, DynamicObject useOrgInfo) {
        if (CollectionUtils.isEmpty(dimensionIds)) {
            return;
        }
        DynamicObjectCollection positionInfoList = useOrgInfo.getDynamicObjectCollection("centryentity");
        DynamicObjectCollection jobInfoList = useOrgInfo.getDynamicObjectCollection("dentryentity");
        DynamicObjectCollection laborInfoList = useOrgInfo.getDynamicObjectCollection("eentryentity");
        if (positionAndJobIds != null && positionAndJobIds.length > 0) {
            if (dimensionIds.contains(1010L)) {
                StaffEntryHelper.buildDimensionInfo("c", positionAndJobIds[0], positionInfoList, staffProjectBo);
            }
            if (dimensionIds.contains(1020L)) {
                StaffEntryHelper.buildDimensionInfo("d", positionAndJobIds[1], jobInfoList, staffProjectBo);
            }
        }
        if (dimensionIds.contains(1050L) && !CollectionUtils.isEmpty(laborRelTypeIds)) {
            StaffEntryHelper.buildDimensionInfo("e", laborRelTypeIds, laborInfoList, staffProjectBo);
        }
        positionListAll.addAll((Collection)positionInfoList);
        jobListAll.addAll((Collection)jobInfoList);
        laborListAll.addAll((Collection)laborInfoList);
    }

    public static void buildDimensionInfo(String prefix, Set<Long> keyFieldIds, DynamicObjectCollection subEntries, StaffProjectBo staffProjectBo) {
        if (!CollectionUtils.isEmpty(keyFieldIds)) {
            DynamicObjectType objectType = subEntries.getDynamicObjectType();
            for (long keyFieldId : keyFieldIds) {
                DynamicObject dyn = new DynamicObject(objectType);
                if ("c".equals(prefix)) {
                    dyn.set("cdutyworkrole_id", (Object)keyFieldId);
                } else if ("d".equals(prefix)) {
                    dyn.set("djob_id", (Object)keyFieldId);
                } else {
                    dyn.set("elaborreltype_id", (Object)keyFieldId);
                }
                dyn.set(prefix + "controlstrategy", staffProjectBo.getControlStrategy());
                dyn.set(prefix + "elasticcontrol", staffProjectBo.getElasticControl());
                dyn.set(prefix + "elasticcount", staffProjectBo.getElasticCount());
                subEntries.add((Object)dyn);
            }
        }
    }

    public static void deleteEntryDataByName(AbstractFormDataModel model, String entryName) {
        model.beginInit();
        model.deleteEntryData(entryName);
        model.endInit();
    }

    public static void deleteEntryDataByPrefix(AbstractFormDataModel model, List<String> prefixList) {
        for (String prefix : prefixList) {
            model.beginInit();
            model.deleteEntryData(StaffCommonService.addPrefixAndPostfix(prefix, "entryentity"));
            model.endInit();
        }
    }

    public static void setActiveTab(Tab tabAp, Set<Long> dimensionIds) {
        if (dimensionIds.contains(1010L)) {
            tabAp.activeTab("tabpage_position");
        } else if (dimensionIds.contains(1020L)) {
            tabAp.activeTab("tabpage_job");
        } else if (dimensionIds.contains(1050L)) {
            tabAp.activeTab("tabpage_laborreltype");
        } else {
            StaffExtEntryHelper staffExtEntryHelper = new StaffExtEntryHelper();
            for (DynamicObject dimDyn : staffExtEntryHelper.getExtDim()) {
                if (!dimensionIds.contains(dimDyn.getLong("id"))) continue;
                tabAp.activeTab("tabpage_" + dimDyn.getString("staffdimension"));
            }
        }
    }

    public static boolean entryStaffCycleHasValue(long oldStaffCycleId, DynamicObjectCollection useOrgInfos) {
        if (CollectionUtils.isEmpty((Collection)useOrgInfos)) {
            return false;
        }
        StaffExtEntryHelper staffExtEntryHelper = new StaffExtEntryHelper();
        List<String> extPrefixList = staffExtEntryHelper.getExtDimPrefix();
        if (oldStaffCycleId == STAFF_CYCLE_MONTH) {
            List<String> bMonthStaff = StaffCommonService.getMonthStaff("b", null);
            List<String> cMonthStaff = StaffCommonService.getMonthStaff("c", null);
            List<String> dMonthStaff = StaffCommonService.getMonthStaff("d", null);
            List<String> eMonthStaff = StaffCommonService.getMonthStaff("e", null);
            HashMap<String, List<String>> extMonthStaffMap = new HashMap<String, List<String>>(8);
            for (String extPrefix : extPrefixList) {
                List<String> extMonthStaff = StaffCommonService.getMonthStaff(extPrefix, null);
                extMonthStaffMap.put(extPrefix, extMonthStaff);
            }
            for (DynamicObject useOrgInfo : useOrgInfos) {
                for (String property : bMonthStaff) {
                    if (useOrgInfo.get(property) == null || useOrgInfo.getInt(property) == 0) continue;
                    return true;
                }
                DynamicObjectCollection positionInfos = useOrgInfo.getDynamicObjectCollection("centryentity");
                boolean hasValue = StaffEntryHelper.monthStaffHasValue(positionInfos, cMonthStaff);
                if (hasValue) {
                    return true;
                }
                DynamicObjectCollection jobInfos = useOrgInfo.getDynamicObjectCollection("dentryentity");
                hasValue = StaffEntryHelper.monthStaffHasValue(jobInfos, dMonthStaff);
                if (hasValue) {
                    return true;
                }
                DynamicObjectCollection laborInfos = useOrgInfo.getDynamicObjectCollection("eentryentity");
                hasValue = StaffEntryHelper.monthStaffHasValue(laborInfos, eMonthStaff);
                if (hasValue) {
                    return true;
                }
                for (Map.Entry entry : extMonthStaffMap.entrySet()) {
                    DynamicObjectCollection extInfos = useOrgInfo.getDynamicObjectCollection((String)entry.getKey() + "entryentity");
                    boolean extHasValue = StaffEntryHelper.monthStaffHasValue(extInfos, (List)entry.getValue());
                    if (!extHasValue) continue;
                    return true;
                }
            }
        } else {
            for (DynamicObject useOrgInfo : useOrgInfos) {
                Object bYearStaffObj = useOrgInfo.get("byearstaff");
                if (bYearStaffObj != null && (Integer)bYearStaffObj != 0) {
                    return true;
                }
                DynamicObjectCollection positionInfos = useOrgInfo.getDynamicObjectCollection("centryentity");
                if (positionInfos.stream().anyMatch(dyn -> dyn.get("cyearstaff") != null && dyn.getInt("cyearstaff") != 0)) {
                    return true;
                }
                DynamicObjectCollection jobInfos = useOrgInfo.getDynamicObjectCollection("dentryentity");
                if (jobInfos.stream().anyMatch(dyn -> dyn.get("dyearstaff") != null && dyn.getInt("dyearstaff") != 0)) {
                    return true;
                }
                DynamicObjectCollection laborInfos = useOrgInfo.getDynamicObjectCollection("eentryentity");
                if (laborInfos.stream().anyMatch(dyn -> dyn.get("eyearstaff") != null && dyn.getInt("eyearstaff") != 0)) {
                    return true;
                }
                for (String extPrefix : extPrefixList) {
                    DynamicObjectCollection extInfos = useOrgInfo.getDynamicObjectCollection(extPrefix + "entryentity");
                    if (!extInfos.stream().anyMatch(dyn -> dyn.get(extPrefix + "yearstaff") != null && dyn.getInt(extPrefix + "yearstaff") != 0)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private static boolean monthStaffHasValue(DynamicObjectCollection data, List<String> monthStaff) {
        if (CollectionUtils.isEmpty((Collection)data)) {
            return false;
        }
        for (DynamicObject dyn : data) {
            for (String property : monthStaff) {
                if (dyn.get(property) == null || dyn.getInt(property) == 0) continue;
                return true;
            }
        }
        return false;
    }

    public static int getDimMaxValue(DynamicObject useOrgInfo, Long staffCycleId, String month) {
        HashMap<String, DynamicObjectCollection> colMap = new HashMap<String, DynamicObjectCollection>(8);
        ArrayList<String> prefixList = new ArrayList<String>(Arrays.asList("c", "d", "e"));
        StaffExtEntryHelper staffExtEntryHelper = new StaffExtEntryHelper();
        prefixList.addAll(staffExtEntryHelper.getExtDimPrefix());
        for (String extPrefix : prefixList) {
            colMap.put(extPrefix, useOrgInfo.getDynamicObjectCollection(extPrefix + "entryentity"));
        }
        ArrayList<Integer> countList = new ArrayList<Integer>(10);
        if (OrgStaffConstants.STAFF_CYCLE_YEAR.equals(staffCycleId)) {
            for (Map.Entry entry : colMap.entrySet()) {
                int extCount = ((DynamicObjectCollection)entry.getValue()).stream().filter(ext -> Objects.nonNull(ext.get((String)entry.getKey() + "yearstaff"))).mapToInt(ext -> ext.getInt((String)entry.getKey() + "yearstaff")).sum();
                countList.add(extCount);
            }
        } else if (OrgStaffConstants.STAFF_CYCLE_MONTH.equals(staffCycleId)) {
            colMap.forEach((prefix, entryCol) -> {
                HashMap<String, Integer> monthCountMap = new HashMap<String, Integer>(16);
                String monthKey = prefix + month;
                for (DynamicObject entryDyn : entryCol) {
                    Object monthStaffObject = entryDyn.get(monthKey);
                    if (Objects.nonNull(monthStaffObject)) {
                        monthCountMap.put(monthKey, monthCountMap.getOrDefault(monthKey, 0) + entryDyn.getInt(monthKey));
                        continue;
                    }
                    monthCountMap.put(monthKey, monthCountMap.getOrDefault(monthKey, 0));
                }
                countList.add(monthCountMap.getOrDefault(monthKey, 0));
            });
        }
        countList.sort((a, b) -> b - a);
        return (Integer)countList.get(0);
    }
}

