/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.business.service.staff.service;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.MainEntityType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.hr.haos.business.domain.repository.staff.StaffDimensionRepository;
import kd.hr.haos.business.service.staff.helper.StaffEntryHelperEnum;
import kd.hr.haos.common.constants.staff.OrgStaffConstants;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;

public class StaffExtEntryHelper
implements OrgStaffConstants {
    private static List<DynamicObject> extDimensionList = new ArrayList<DynamicObject>(8);
    private static boolean isInit;
    private Map<String, String> dimensionprefixMap = ImmutableMap.of((Object)"basicdata1", (Object)"f", (Object)"basicdata2", (Object)"g", (Object)"basicdata3", (Object)"h", (Object)"basicdata4", (Object)"i", (Object)"basicdata5", (Object)"j");
    private Map<String, String> perfixToEntityNameMap = new HashMap<String, String>(8);
    private Map<String, String> perfixToNameMap = new HashMap<String, String>(8);
    private Map<String, String> callBackIdToEntryMap = new HashMap<String, String>(8);
    private Map<String, String> callBackIdToPropNameMap = new HashMap<String, String>(8);
    private Map<String, String> callBackIdToPropIdMap = new HashMap<String, String>(8);
    private Map<String, String> callBackActionToEntryMap = new HashMap<String, String>(8);
    private Map<String, String> callBackActionToDimMap = new HashMap<String, String>(8);
    private Map<String, String> afterOpToCallBackIdMap = new HashMap<String, String>(8);
    private List<Long> extDimensionIdList = new ArrayList<Long>(8);

    public StaffExtEntryHelper() {
        this.initExtDimensionList();
        for (DynamicObject dynamicObject : extDimensionList) {
            String dimesion = dynamicObject.getString("staffdimension");
            DynamicObject basedata = dynamicObject.getDynamicObject("basedata");
            String prefix = this.dimensionprefixMap.get(dimesion);
            if (!HRStringUtils.isNotEmpty((String)prefix)) continue;
            this.perfixToEntityNameMap.put(prefix, basedata.getString("number"));
            this.perfixToNameMap.put(prefix, dynamicObject.getString("name"));
            this.extDimensionIdList.add(dynamicObject.getLong("id"));
            String callBackId = String.format("delete%sConfirmActionId", dimesion);
            this.callBackIdToEntryMap.put(callBackId, prefix + "entryentity");
            this.callBackIdToPropNameMap.put(callBackId, prefix + dimesion + ".name");
            this.callBackIdToPropIdMap.put(callBackId, prefix + dimesion + ".id");
            String callBackAction = String.format("new%sCloseActionId", dimesion);
            this.callBackActionToEntryMap.put(callBackAction, prefix + "entryentity");
            this.callBackActionToDimMap.put(callBackAction, prefix + dimesion);
            String afterOp = String.format("donothing_delete%s", dimesion);
            this.afterOpToCallBackIdMap.put(afterOp, callBackId);
        }
    }

    private void initExtDimensionList() {
        if (isInit) {
            return;
        }
        if (!this.isAutoHandleStaffPage()) {
            isInit = true;
            return;
        }
        DynamicObject[] dynamicObjects = StaffDimensionRepository.getInstance().listAllDimension();
        Map<String, DynamicObject> staffdimensionMap = Arrays.stream(dynamicObjects).collect(Collectors.toMap(dyn -> dyn.getString("staffdimension"), dyn -> dyn));
        Set staffdimension = Arrays.stream(dynamicObjects).map(temp -> temp.getString("staffdimension")).collect(Collectors.toSet());
        MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)"haos_staff");
        for (String dimension : staffdimension) {
            String prefix = this.dimensionprefixMap.get(dimension);
            if (HRStringUtils.isEmpty((String)prefix)) continue;
            String extEntryName = prefix + "entryentity";
            if (!entityType.getAllEntities().containsKey(extEntryName)) continue;
            extDimensionList.add(staffdimensionMap.get(dimension));
        }
        isInit = true;
    }

    public boolean isAutoHandleStaffPage() {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("haos_odcconfigparam");
        QFilter filter = new QFilter("number", "=", (Object)"isAutoHandleStaffPage");
        DynamicObject config = serviceHelper.queryOne("value", filter.toArray());
        return !HRObjectUtils.isEmpty((Object)config) && !HRStringUtils.equals((String)config.getString("value"), (String)"0");
    }

    public List<String> getExtDimPrefix() {
        Set staffdimensionSet = extDimensionList.stream().map(temp -> temp.getString("staffdimension")).collect(Collectors.toSet());
        ArrayList<String> list = new ArrayList<String>();
        for (String validDimension : staffdimensionSet) {
            String prefix = this.dimensionprefixMap.get(validDimension);
            if (!HRStringUtils.isNotEmpty((String)prefix)) continue;
            list.add(prefix);
        }
        return list;
    }

    public List<Long> getExtDimIds() {
        return this.extDimensionIdList;
    }

    public List<DynamicObject> getExtDim() {
        return extDimensionList;
    }

    public String getExtDimPrefix(String dim) {
        return this.dimensionprefixMap.getOrDefault(dim, "");
    }

    public String getExtDimPrefix(long dimId) {
        for (DynamicObject dimDyn : extDimensionList) {
            if (dimId != dimDyn.getLong("id")) continue;
            String dim = dimDyn.getString("staffdimension");
            return this.dimensionprefixMap.getOrDefault(dim, "");
        }
        return "";
    }

    public String getKeyFieldEntityNameByPrefix(String prefix) {
        StaffEntryHelperEnum[] entryEnums;
        for (StaffEntryHelperEnum entryEnum : entryEnums = StaffEntryHelperEnum.values()) {
            if (!entryEnum.getPrefix().equals(prefix)) continue;
            return entryEnum.getKeyFieldEntityName();
        }
        return this.perfixToEntityNameMap.get(prefix);
    }

    public String getKeyFieldLocaleByPrefix(String prefix) {
        StaffEntryHelperEnum[] entryEnums;
        for (StaffEntryHelperEnum entryEnum : entryEnums = StaffEntryHelperEnum.values()) {
            if (!HRStringUtils.equals((String)entryEnum.getPrefix(), (String)prefix)) continue;
            return entryEnum.getkeyFieldLocale();
        }
        return this.perfixToNameMap.get(prefix);
    }

    public Map<String, String> getExtCallBackIdToEntryMap() {
        return this.callBackIdToEntryMap;
    }

    public Map<String, String> getExtCallBackIdToPropNameMap() {
        return this.callBackIdToPropNameMap;
    }

    public Map<String, String> getExtCallBackIdToPropIdMap() {
        return this.callBackIdToPropIdMap;
    }

    public Map<String, String> getExtCallBackActionToEntryMap() {
        return this.callBackActionToEntryMap;
    }

    public Map<String, String> getExtCallBackActionToDimMap() {
        return this.callBackActionToDimMap;
    }

    public Map<String, String> getExtAfterOpToCallBackIdMap() {
        return this.afterOpToCallBackIdMap;
    }

    public List<String> getAllPrefix() {
        List<String> extPrefixList = this.getExtDimPrefix();
        extPrefixList.addAll(Arrays.asList("a", "b", "c", "d", "e"));
        return extPrefixList;
    }

    public List<String> getAllPrefixWithoutA() {
        List<String> extPrefixList = this.getExtDimPrefix();
        extPrefixList.addAll(Arrays.asList("b", "c", "d", "e"));
        return extPrefixList;
    }

    public List<String> getAllMulPrefix() {
        List<String> extPrefixList = this.getExtDimPrefix();
        extPrefixList.addAll(Arrays.asList("c", "d", "e"));
        return extPrefixList;
    }

    public List<String> getExtControlstrategy() {
        ArrayList<String> list = new ArrayList<String>(8);
        for (String prefix : this.getExtDimPrefix()) {
            list.add(prefix + "controlstrategy");
        }
        return list;
    }
}

