/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.business.service.staff.valid.calibrator;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.hr.haos.business.service.projectgroup.bean.CalibratorBean;
import kd.hr.haos.business.service.staff.valid.core.OrgStaffValidContext;
import kd.hr.haos.business.service.staff.valid.core.OrgStaffValidService;
import kd.hr.haos.business.util.TimeConvertUtil;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;

public class OrgUniqueValidator
implements OrgStaffValidService {
    @Override
    public List<CalibratorBean> valid(OrgStaffValidContext context) {
        ArrayList<CalibratorBean> result = new ArrayList<CalibratorBean>();
        DynamicObject targetObject = context.getTargetObject();
        if (!HRStringUtils.equals((String)targetObject.getString("enable"), (String)"1")) {
            return result;
        }
        Date date = targetObject.getDate("year");
        int year = TimeConvertUtil.getYear(date);
        Date minDate = TimeConvertUtil.getMinDate(date);
        Date maxDate = TimeConvertUtil.getMaxDate(date);
        DynamicObjectCollection useOrgInfos = targetObject.getDynamicObjectCollection("bentryentity");
        Set useOrgIds = useOrgInfos.stream().map(dyn -> dyn.getLong("buseorg.boid")).collect(Collectors.toSet());
        HRBaseServiceHelper useOrgHelper = new HRBaseServiceHelper("haos_useorgdetail");
        QFilter filter = new QFilter("useorgbo", "in", useOrgIds);
        filter.and("staff.year", ">=", (Object)minDate);
        filter.and("staff.year", "<=", (Object)maxDate);
        filter.and("enable", "=", (Object)"1");
        filter.and("datastatus", "=", (Object)"1");
        filter.and("staff", "!=", (Object)targetObject.getLong("id"));
        DynamicObject[] dynamicObjects = useOrgHelper.query("useorg", new QFilter[]{filter});
        if (dynamicObjects.length > 0) {
            String message = String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u5b58\u5728\u5df2\u542f\u7528\u7684\u4eba\u529b\u7f16\u5236\uff08\u5e74\u4efd\uff1a%2$s\uff09\uff0c\u65e0\u9700\u91cd\u590d\u8bbe\u7f6e\u3002", (String)"StaffProjectPlugin_1", (String)"hrmp-haos-business", (Object[])new Object[0]), dynamicObjects[0].getString("useorg.name"), year);
            result.add(new CalibratorBean(message, false));
        }
        return result;
    }
}

