/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.business.service.staff.valid.calibrator;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.haos.business.service.projectgroup.bean.CalibratorBean;
import kd.hr.haos.business.service.staff.helper.StaffEntryTempHelperEnum;
import kd.hr.haos.business.service.staff.service.StaffCommonService;
import kd.hr.haos.business.service.staff.service.StaffEntryHelper;
import kd.hr.haos.business.service.staff.service.StaffExtEntryHelper;
import kd.hr.haos.business.service.staff.valid.core.OrgStaffValidContext;
import kd.hr.haos.business.service.staff.valid.core.OrgStaffValidService;
import kd.hr.haos.common.constants.staff.OrgStaffConstants;
import kd.hr.hbp.common.model.AuthorizedOrgResult;
import kd.hr.hbp.common.util.HRDateTimeUtils;

public class StaffElasticCountValidator
implements OrgStaffValidService,
OrgStaffConstants {
    private static final String BYEARSTAFF = "byearstaff";
    private static final String BMONTHSTAFF = "bmonthstaff";
    private StaffExtEntryHelper staffExtEntryHelper = new StaffExtEntryHelper();

    @Override
    public List<CalibratorBean> valid(OrgStaffValidContext context) {
        DynamicObject targetObject = context.getTargetObject();
        long staffCycleId = targetObject.getLong("staffcycle.id");
        ArrayList<CalibratorBean> result = new ArrayList<CalibratorBean>();
        DynamicObjectCollection orgDetailCollection = targetObject.getDynamicObjectCollection("bentryentity");
        HashSet<Long> useOrgIds = new HashSet<Long>(orgDetailCollection.size());
        AuthorizedOrgResult permResult = StaffCommonService.getOrgAuth();
        ArrayList<String> prefixList = new ArrayList<String>(Arrays.asList("c", "d", "e"));
        prefixList.addAll(this.staffExtEntryHelper.getExtDimPrefix());
        for (DynamicObject orgDetail : orgDetailCollection) {
            DynamicObject useOrg = orgDetail.getDynamicObject("buseorg");
            if (this.validateUseOrg(result, useOrgIds, permResult, useOrg)) continue;
            this.validateStaffNumWithSub(result, orgDetail, staffCycleId);
            DynamicObject staffProject = targetObject.getDynamicObject("staffproject");
            if (staffProject != null && "3".equals(orgDetail.getString("bcontrolstrategy")) && (orgDetail.getInt("belasticcontrol") == 0 || orgDetail.get("belasticcount") == null)) {
                String message = ResManager.loadKDString((String)"\u201c%s\u201d\u7684\u63a7\u7f16\u65b9\u5f0f\u4e3a\u201c\u5f39\u6027\u63a7\u7f16\u201d\u65f6\uff0c\u5f39\u6027\u65b9\u5f0f\u3001\u5f39\u6027\u989d\u5ea6\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"StaffElasticCountValidator_1", (String)"hrmp-haos-business", (Object[])new Object[]{useOrg.getString("name")});
                result.add(new CalibratorBean(message, false));
            }
            this.validateCount(targetObject, result, orgDetail, prefixList);
            this.validateControlStrategySpring(orgDetail, useOrg, result, prefixList);
        }
        return result;
    }

    private void validateControlStrategySpring(DynamicObject orgDetail, DynamicObject useOrgDyn, List<CalibratorBean> result, List<String> prefixList) {
        for (String prefix : prefixList) {
            String dimensionName = this.staffExtEntryHelper.getKeyFieldLocaleByPrefix(prefix);
            DynamicObjectCollection collection = orgDetail.getDynamicObjectCollection(prefix + "entryentity");
            if (CollectionUtils.isEmpty((Collection)collection)) continue;
            this.validateEntryControlStrategy(useOrgDyn, result, prefix, collection, dimensionName);
        }
    }

    private void validateEntryControlStrategy(DynamicObject useOrgDyn, List<CalibratorBean> result, String prefix, DynamicObjectCollection dimCollection, String dimensionName) {
        for (DynamicObject dimDyn : dimCollection) {
            if (!"3".equals(dimDyn.getString(prefix + "controlstrategy")) || dimDyn.getInt(prefix + "elasticcontrol") != 0 && dimDyn.get(prefix + "elasticcount") != null) continue;
            String keyField = StaffEntryTempHelperEnum.getKeyFieldByPrefix(prefix);
            String message = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u201c%1$s\u201d\u4e0b\u7684\u201c%2$s\uff08%3$s\uff09\u201d\u7684\u63a7\u7f16\u65b9\u5f0f\u4e3a\u201c\u5f39\u6027\u63a7\u7f16\u201d\u65f6\uff0c\u201c\u5f39\u6027\u65b9\u5f0f\u201d\u201c\u5f39\u6027\u989d\u5ea6\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"StaffElasticCountValidator_16", (String)"hrmp-haos-business", (Object[])new Object[0]), useOrgDyn.getString("name"), dimensionName, dimDyn.getDynamicObject(prefix + keyField).getString("name"));
            result.add(new CalibratorBean(message, false));
        }
    }

    private void validateStaffNumWithSub(List<CalibratorBean> result, DynamicObject orgDetail, Long staffCycleId) {
        DynamicProperty yearStaffNumProp = orgDetail.getDynamicObjectType().getProperty("byearstaffnumwithsub");
        Object yearStaffNumValue = orgDetail.getDataStorage().getLocalValue((IDataEntityProperty)yearStaffNumProp);
        if (Objects.isNull(yearStaffNumValue)) {
            return;
        }
        int yearStaffNumWithSub = orgDetail.getInt("byearstaffnumwithsub");
        Integer staffNumWithSub = 0;
        Object staffNumWithSubObject = orgDetail.get("bstaffnumwithsub");
        if (Objects.nonNull(staffNumWithSubObject)) {
            staffNumWithSub = (Integer)staffNumWithSubObject;
        }
        int curStaff = 0;
        if (STAFF_CYCLE_MONTH.equals(staffCycleId)) {
            for (int i = 1; i <= 12; ++i) {
                Object monthStaffObject = orgDetail.get(BMONTHSTAFF + i);
                int monthStaff = Objects.isNull(monthStaffObject) ? StaffEntryHelper.getDimMaxValue(orgDetail, staffCycleId, "monthstaff" + i) : (Integer)monthStaffObject;
                if (monthStaff <= curStaff) continue;
                curStaff = monthStaff;
            }
        } else {
            Object yearStaffObject = orgDetail.get(BYEARSTAFF);
            curStaff = Objects.nonNull(yearStaffObject) ? orgDetail.getInt(BYEARSTAFF) : StaffEntryHelper.getDimMaxValue(orgDetail, staffCycleId, "");
        }
        if (staffNumWithSub + curStaff > yearStaffNumWithSub) {
            String useOrgName = orgDetail.getString("buseorg.name");
            String message = ResManager.loadKDString((String)"{0}\u542b\u4e0b\u7ea7\u7f16\u5236\uff08\u7f16\u5236\u6570\uff1a{1}\uff09\u5e94\u5927\u4e8e\u6216\u7b49\u4e8e\u4e0b\u7ea7\u7ec4\u7ec7\u7f16\u5236\u6570\u4e4b\u548c\uff08\u7f16\u5236\u6570\uff1a{2}\uff09\u3002", (String)"StaffElasticCountValidator_2", (String)"hrmp-haos-business", (Object[])new Object[]{useOrgName, yearStaffNumWithSub, staffNumWithSub + curStaff});
            result.add(new CalibratorBean(message, false));
        }
    }

    private boolean validateUseOrg(List<CalibratorBean> result, Set<Long> useOrgIds, AuthorizedOrgResult permResult, DynamicObject useOrg) {
        if (useOrg == null) {
            String message = ResManager.loadKDString((String)"\u201c\u4f7f\u7528\u7ec4\u7ec7\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"StaffElasticCountValidator_3", (String)"hrmp-haos-business", (Object[])new Object[0]);
            result.add(new CalibratorBean(message, false));
            return true;
        }
        if (permResult != null && !permResult.isHasAllOrgPerm() && !permResult.getHasPermOrgs().contains(useOrg.getLong("id"))) {
            String message = ResManager.loadKDString((String)"\u4f7f\u7528\u7ec4\u7ec7\u201c%s\u201d\u4e0d\u5728\u7528\u6237\u6743\u9650\u8303\u56f4\u5185\uff0c\u8bf7\u4fee\u6539\u3002", (String)"StaffElasticCountValidator_4", (String)"hrmp-haos-business", (Object[])new Object[]{useOrg.getString("name")});
            result.add(new CalibratorBean(message, false));
            return true;
        }
        if (!useOrgIds.add(useOrg.getLong("id"))) {
            String message = ResManager.loadKDString((String)"\u201c%s\u201d\u7684\u7ec4\u7ec7\u5728\u5206\u5f55\u4e2d\u5df2\u5b58\u5728\uff0c\u8bf7\u4fee\u6539\u3002", (String)"StaffElasticCountValidator_5", (String)"hrmp-haos-business", (Object[])new Object[]{useOrg.getString("name")});
            result.add(new CalibratorBean(message, false));
            return true;
        }
        if (!"1".equals(useOrg.getString("enable"))) {
            String message = ResManager.loadKDString((String)"\u201c%s\u201d\u7684\u7ec4\u7ec7\u5df2\u505c\u7528\uff0c\u8bf7\u4fee\u6539\u3002", (String)"StaffElasticCountValidator_6", (String)"hrmp-haos-business", (Object[])new Object[]{useOrg.getString("name")});
            result.add(new CalibratorBean(message, false));
            return true;
        }
        return false;
    }

    private void validateCount(DynamicObject targetObject, List<CalibratorBean> result, DynamicObject orgDetail, List<String> prefixList) {
        DynamicObject staffCycle = targetObject.getDynamicObject("staffcycle");
        Object yearStaffObject = orgDetail.get(BYEARSTAFF);
        for (String prefix : prefixList) {
            int i;
            DynamicObjectCollection collection = orgDetail.getDynamicObjectCollection(prefix + "entryentity");
            if (CollectionUtils.isEmpty((Collection)collection)) continue;
            String dimensionName = this.staffExtEntryHelper.getKeyFieldLocaleByPrefix(prefix);
            if (staffCycle != null && "1020_S".equals(staffCycle.get("number"))) {
                String message = ResManager.loadKDString((String)"\u201c{0}\u201d\u5728\u8be5\u5e74\u4efd\uff08\u5e74\u4efd\uff1a{1}\uff09\uff0c{2}\u591a\u7ef4\u7ec6\u5206\u7f16\u5236\u6570\u5e94\u5c0f\u4e8e\u6216\u7b49\u4e8e\u7ec4\u7ec7\u7f16\u5236\u6570\uff0c\u8bf7\u4fee\u6539\u3002", (String)"StaffElasticCountValidator_10", (String)"hrmp-haos-business", (Object[])new Object[]{orgDetail.getDynamicObject("buseorg").getString("name"), String.valueOf(HRDateTimeUtils.getYear((Date)targetObject.getDate("year"))), dimensionName});
                int count = collection.stream().filter(dim -> Objects.nonNull(dim.get(prefix + "yearstaff"))).mapToInt(dim -> dim.getInt(prefix + "yearstaff")).sum();
                boolean useOrgStaffNumNotNullFlag = Objects.nonNull(yearStaffObject) && orgDetail.getInt(BYEARSTAFF) < count;
                if (!useOrgStaffNumNotNullFlag) continue;
                result.add(new CalibratorBean(message, false));
                continue;
            }
            if (staffCycle == null || !"1010_S".equals(staffCycle.get("number"))) continue;
            HashMap<String, Integer> monthCountMap = new HashMap<String, Integer>(16);
            String monthStaffKey = prefix + "monthstaff";
            for (i = 1; i <= 12; ++i) {
                monthCountMap.put(monthStaffKey + i, 0);
            }
            for (DynamicObject dim2 : collection) {
                for (int i2 = 1; i2 <= 12; ++i2) {
                    String iStr = String.valueOf(i2);
                    Object monthStaffObject = dim2.get(monthStaffKey + iStr);
                    if (Objects.nonNull(monthStaffObject)) {
                        monthCountMap.put(monthStaffKey + iStr, (Integer)monthCountMap.get(monthStaffKey + iStr) + dim2.getInt(monthStaffKey + iStr));
                        continue;
                    }
                    monthCountMap.put(monthStaffKey + iStr, (Integer)monthCountMap.get(monthStaffKey + iStr));
                }
            }
            for (i = 1; i <= 12; ++i) {
                boolean useOrgMonthStaffNotNullFlag;
                String iStr = String.valueOf(i);
                Object bMonthStaffObject = orgDetail.get(BMONTHSTAFF + iStr);
                boolean bl = useOrgMonthStaffNotNullFlag = Objects.nonNull(bMonthStaffObject) && orgDetail.getInt(BMONTHSTAFF + iStr) < (Integer)monthCountMap.get(monthStaffKey + iStr);
                if (!useOrgMonthStaffNotNullFlag) continue;
                String message = ResManager.loadKDString((String)"\u201c{0}\u201d\u5728\u8be5\u6708\u4efd\uff08\u6708\u4efd\uff1a{1}\uff09\uff0c{2}\u591a\u7ef4\u7ec6\u5206\u7f16\u5236\u6570\u5e94\u5c0f\u4e8e\u6216\u7b49\u4e8e\u7ec4\u7ec7\u7f16\u5236\u6570\uff0c\u8bf7\u4fee\u6539\u3002", (String)"StaffElasticCountValidator_13", (String)"hrmp-haos-business", (Object[])new Object[]{orgDetail.getDynamicObject("buseorg").getString("name"), iStr, dimensionName});
                result.add(new CalibratorBean(message, false));
            }
        }
    }
}

