/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.business.servicehelper;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.hr.haos.business.domain.repository.adorg.AdOrgRepository;
import kd.hr.hbp.common.constants.newhismodel.EnumHisDataVersionStatus;
import kd.hr.hbp.common.util.HRStringUtils;

public class AdminOrgCodeRuleServiceHelper {
    private IFormView formView;
    private IDataModel dateModel;

    public static AdminOrgCodeRuleServiceHelper create(IFormView formView, IDataModel dateModel) {
        return new AdminOrgCodeRuleServiceHelper(formView, dateModel);
    }

    public AdminOrgCodeRuleServiceHelper(IFormView formView, IDataModel dateModel) {
        if (formView == null || dateModel == null) {
            throw new KDBizException("code rule service helper need formView and dataModel!");
        }
        this.formView = formView;
        this.dateModel = dateModel;
    }

    public void setOrgNumber(DynamicObject hrDy, String numberColumnName) {
        DynamicObject currentDy = this.dateModel.getDataEntity();
        if (!HRStringUtils.isEmpty((String)currentDy.getString(numberColumnName))) {
            return;
        }
        DynamicObject org = currentDy.getDynamicObject("org");
        if (org == null) {
            this.formView.setEnable(Boolean.FALSE, new String[]{numberColumnName});
            return;
        }
        String orgStr = org.getString("id");
        boolean flag = CodeRuleServiceHelper.isExist((String)"haos_adminorghr", (DynamicObject)hrDy, (String)orgStr);
        if (flag) {
            String orgNumber = CodeRuleServiceHelper.getNumber((String)"haos_adminorghr", (DynamicObject)hrDy, (String)orgStr);
            boolean modifyFlag = CodeRuleServiceHelper.isModifiable((String)"haos_adminorghr", (DynamicObject)hrDy, (String)orgStr);
            if (!modifyFlag) {
                this.formView.setEnable(Boolean.FALSE, new String[]{numberColumnName});
            }
            QFilter qFilter = new QFilter("number", "=", (Object)orgNumber);
            qFilter.and("datastatus", "=", (Object)EnumHisDataVersionStatus.EFFECTING.getStatus());
            DynamicObject[] array = AdOrgRepository.getInstance().queryOriginalArray("id", qFilter.toArray());
            if (array.length != 0) {
                this.setOrgNumber(hrDy, numberColumnName);
            }
            this.dateModel.setValue(numberColumnName, (Object)orgNumber);
        } else {
            this.formView.setEnable(Boolean.TRUE, new String[]{numberColumnName});
        }
    }
}

