/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.business.servicehelper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.haos.business.servicehelper.AdminOrgUpgradeHelper;
import kd.hr.haos.business.servicehelper.OrgTeamStructUpgradeService;
import kd.hr.haos.business.servicehelper.OrgTeamUpgradeService;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;

public class OrgTeamInfoUpgradeService {
    private static final Log LOGGER = LogFactory.getLog(OrgTeamInfoUpgradeService.class);
    private static final String SELECT_PROPERTIES = "id,name,number,enable,createtime,boid,bsed,bsled,iscurrentversion,firstbsed,datastatus,sourcevid,hisversion,modifytime,modifier,creator,initstatus,initbatch,org,initdatasource,status,structnumber,index,bred,simplename,description";
    private HRBaseServiceHelper ADMIN_ORG_HELPER = new HRBaseServiceHelper("haos_adminorgdetail");
    private HRBaseServiceHelper ORG_TEAM_HELPER = new HRBaseServiceHelper("haos_adminorgteam");
    private HRBaseServiceHelper PROJECT_TEAM_BASE = new HRBaseServiceHelper("haos_projteambaseinfo");
    private Map<Long, Long> teamAndOrgProjectIdMatchMap;
    private List<DynamicObject> upgradeOrgTeamInfoList;
    private Map<Long, List<DynamicObject>> orgTeamMap;
    private DynamicObject[] orgTeamInfoArr;
    private Map<Long, String> numberPrefixMap;

    private void initData() {
        QFilter filter = new QFilter("otclassify", "in", Arrays.asList(1010L, 1020L));
        this.orgTeamInfoArr = this.ORG_TEAM_HELPER.query("id,name,number,enable,createtime,boid,bsed,bsled,iscurrentversion,firstbsed,datastatus,sourcevid,hisversion,modifytime,modifier,creator,initstatus,initbatch,org,initdatasource,status,structnumber,index,bred,simplename,description,parent,otclassify", filter.toArray());
        this.upgradeOrgTeamInfoList = new ArrayList<DynamicObject>();
        this.orgTeamMap = Arrays.stream(this.orgTeamInfoArr).collect(Collectors.groupingBy(team -> team.getLong("boid"), Collectors.toList()));
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hbss_numberprefix");
        DynamicObject[] numberPrefixes = serviceHelper.query("id,numberprefix", new QFilter("id", "in", Arrays.asList(1010L, 1020L)).toArray());
        this.numberPrefixMap = Arrays.stream(numberPrefixes).collect(Collectors.toMap(obj -> obj.getLong("id"), obj -> obj.getString("numberprefix"), (v1, v2) -> v2));
    }

    public void upgrade() {
        new AdminOrgUpgradeHelper().upgradeOrg();
        this.initData();
        QFilter filter = new QFilter("1", "=", (Object)1);
        DynamicObject[] adminOrgInfo = this.ADMIN_ORG_HELPER.query("id,name,number,enable,createtime,boid,bsed,bsled,iscurrentversion,firstbsed,datastatus,sourcevid,hisversion,modifytime,modifier,creator,initstatus,initbatch,org,initdatasource,status,structnumber,index,bred,simplename,description,parentorg.id", filter.toArray());
        Map<Long, List<DynamicObject>> adminOrgMap = Arrays.stream(adminOrgInfo).collect(Collectors.groupingBy(org -> org.getLong("boid"), Collectors.toList()));
        DynamicObject[] projectTeamInfo = this.PROJECT_TEAM_BASE.query("id,name,number,enable,createtime,boid,bsed,bsled,iscurrentversion,firstbsed,datastatus,sourcevid,hisversion,modifytime,modifier,creator,initstatus,initbatch,org,initdatasource,status,structnumber,index,bred,simplename,description,parentorg.id", filter.toArray());
        Map<Long, List<DynamicObject>> projectTeamMap = Arrays.stream(projectTeamInfo).collect(Collectors.groupingBy(org -> org.getLong("boid"), Collectors.toList()));
        this.teamAndOrgProjectIdMatchMap = new HashMap<Long, Long>(adminOrgInfo.length + projectTeamInfo.length);
        this.upgradeByType(adminOrgMap, "0");
        this.upgradeByType(projectTeamMap, "1");
        this.dealSourceVid();
        this.ORG_TEAM_HELPER.updateDatas(this.orgTeamInfoArr);
        if (!this.upgradeOrgTeamInfoList.isEmpty()) {
            this.ORG_TEAM_HELPER.save(this.upgradeOrgTeamInfoList.toArray(new DynamicObject[0]));
        }
        new OrgTeamStructUpgradeService(this.teamAndOrgProjectIdMatchMap).updateStruct();
        new OrgTeamUpgradeService(this.teamAndOrgProjectIdMatchMap).upgrade();
    }

    private void dealSourceVid() {
        ArrayList<DynamicObject> allOrgTeamInfoList = new ArrayList<DynamicObject>(this.upgradeOrgTeamInfoList.size() + this.orgTeamInfoArr.length);
        allOrgTeamInfoList.addAll(this.upgradeOrgTeamInfoList);
        allOrgTeamInfoList.addAll(Arrays.asList(this.orgTeamInfoArr));
        Map orgTeamBoIdMap = allOrgTeamInfoList.stream().collect(Collectors.groupingBy(team -> team.getLong("boid"), Collectors.toList()));
        orgTeamBoIdMap.forEach((boId, list) -> {
            Optional<DynamicObject> currentVersionTeamOptional = list.stream().filter(team -> team.getBoolean("iscurrentversion")).findFirst();
            if (currentVersionTeamOptional.isPresent()) {
                DynamicObject currentVersionTeam = currentVersionTeamOptional.get();
                List hisVersionTeamList = list.stream().filter(team -> !team.getBoolean("iscurrentversion")).sorted(Comparator.comparing(team -> team.getString("hisversion"))).collect(Collectors.toList());
                long currentSourId = 0L;
                for (int index = 0; index < hisVersionTeamList.size(); ++index) {
                    DynamicObject hisDy = (DynamicObject)hisVersionTeamList.get(index);
                    if (index == 0) {
                        hisDy.set("sourcevid", (Object)0L);
                    } else {
                        hisDy.set("sourcevid", (Object)((DynamicObject)hisVersionTeamList.get(index - 1)).getLong("id"));
                    }
                    if (!"1".equals(hisDy.getString("datastatus"))) continue;
                    currentSourId = hisDy.getLong("id");
                }
                currentVersionTeam.set("sourcevid", (Object)currentSourId);
            }
        });
    }

    private void upgradeByType(Map<Long, List<DynamicObject>> map, String upgradeType) {
        map.forEach((boId, infoList) -> {
            if (this.orgTeamMap.containsKey(boId)) {
                List<DynamicObject> orgTeamList = this.orgTeamMap.get(boId);
                this.matchByBSed(orgTeamList, (List<DynamicObject>)infoList, upgradeType);
                this.upgradeEffectingData((List<DynamicObject>)infoList, orgTeamList);
            }
        });
    }

    private void matchByBSed(List<DynamicObject> orgTeamList, List<DynamicObject> infoList, String upgradeType) {
        Map bSedMap = infoList.stream().filter(info -> !HRStringUtils.equals((String)info.getString("datastatus"), (String)"1")).collect(Collectors.groupingBy(team -> team.getDate("bsed"), Collectors.toList()));
        Map orgTeamBSedMap = orgTeamList.stream().filter(team -> !HRStringUtils.equals((String)team.getString("datastatus"), (String)"1")).collect(Collectors.groupingBy(team -> team.getDate("bsed"), Collectors.toList()));
        bSedMap.forEach((bSed, bSedList) -> {
            if (orgTeamBSedMap.containsKey(bSed)) {
                Map<String, List<DynamicObject>> orgTeamDataStatusMap = ((List)orgTeamBSedMap.get(bSed)).stream().collect(Collectors.groupingBy(team -> team.getString("datastatus"), Collectors.toList()));
                Map<String, List<DynamicObject>> dataStatusMap = bSedList.stream().collect(Collectors.groupingBy(org -> org.getString("datastatus"), Collectors.toList()));
                this.matchByDataStatus(orgTeamDataStatusMap, dataStatusMap, upgradeType);
            } else {
                bSedList.forEach(info -> this.upgradeOrgTeamInfoList.add(this.createOrgTeam((DynamicObject)info, upgradeType)));
            }
        });
    }

    private void matchByDataStatus(Map<String, List<DynamicObject>> orgTeamDataStatusMap, Map<String, List<DynamicObject>> dataStatusMap, String upgradeType) {
        dataStatusMap.forEach((dataStatus, statusList) -> {
            if (orgTeamDataStatusMap.containsKey(dataStatus)) {
                HashSet<Integer> indexSet = new HashSet<Integer>(statusList.size());
                List teamStatusList = (List)orgTeamDataStatusMap.get(dataStatus);
                this.matchOrgTeamInfo((List<DynamicObject>)statusList, (Set<Integer>)indexSet, teamStatusList);
                Integer index = 0;
                for (DynamicObject info2 : statusList) {
                    if (!indexSet.contains(index)) {
                        this.upgradeOrgTeamInfoList.add(this.createOrgTeam(info2, upgradeType));
                    }
                    Integer n = index;
                    Integer n2 = index = Integer.valueOf(index + 1);
                }
            } else {
                statusList.forEach(info -> this.upgradeOrgTeamInfoList.add(this.createOrgTeam((DynamicObject)info, upgradeType)));
            }
        });
    }

    private void upgradeEffectingData(List<DynamicObject> infoList, List<DynamicObject> orgTeamList) {
        Map<String, DynamicObject> orgTeamEffectMap = orgTeamList.stream().filter(team -> HRStringUtils.equals((String)team.getString("datastatus"), (String)"1")).collect(Collectors.toMap(team -> team.getString("iscurrentversion"), team -> team));
        if (CollectionUtils.isEmpty(infoList = infoList.stream().filter(info -> HRStringUtils.equals((String)info.getString("datastatus"), (String)"1")).collect(Collectors.toList()))) {
            return;
        }
        infoList.forEach(info -> {
            String version = info.getString("iscurrentversion");
            DynamicObject team = (DynamicObject)orgTeamEffectMap.get(version);
            if (team != null) {
                team.set("parent", (Object)info.getLong("parentorg.id"));
                team.set("hisversion", (Object)info.getString("hisversion"));
                if (team.getDate("bsed").compareTo(info.getDate("bsed")) != 0) {
                    team.set("bsed", (Object)info.getDate("bsed"));
                }
                this.teamAndOrgProjectIdMatchMap.put(team.getLong("id"), info.getLong("id"));
            }
        });
    }

    private void matchOrgTeamInfo(List<DynamicObject> statusList, Set<Integer> orgIndexSet, List<DynamicObject> teamStatusList) {
        HashSet<Integer> teamIndexSet = new HashSet<Integer>(teamStatusList.size());
        Integer orgIndex = 0;
        statusList.sort(Comparator.comparing(info -> info.getDate("createtime")));
        teamStatusList.sort(Comparator.comparing(info -> info.getDate("createtime")));
        for (DynamicObject info2 : statusList) {
            Integer teamIndex = 0;
            for (DynamicObject team : teamStatusList) {
                if (teamIndexSet.contains(teamIndex)) {
                    Integer n = teamIndex;
                    Integer n2 = teamIndex = Integer.valueOf(teamIndex + 1);
                    continue;
                }
                String prefix = this.numberPrefixMap.get(team.getLong("otclassify.id"));
                String orgNumber = prefix + "_" + info2.getString("number");
                String teamNumber = team.getString("number");
                String orgName = info2.getString("name");
                String teamName = team.getString("name");
                String orgEnable = info2.getString("enable");
                String teamEnable = team.getString("enable");
                if (HRStringUtils.equals((String)orgNumber, (String)teamNumber) && HRStringUtils.equals((String)orgName, (String)teamName) && HRStringUtils.equals((String)orgEnable, (String)teamEnable)) {
                    team.set("parent", (Object)info2.getLong("parentorg.id"));
                    team.set("bsled", (Object)info2.getDate("bsled"));
                    team.set("hisversion", (Object)info2.getString("hisversion"));
                    this.teamAndOrgProjectIdMatchMap.put(team.getLong("id"), info2.getLong("id"));
                    teamIndexSet.add(teamIndex);
                    orgIndexSet.add(orgIndex);
                    break;
                }
                Integer n = teamIndex;
                Integer n3 = teamIndex = Integer.valueOf(teamIndex + 1);
            }
            Integer n = orgIndex;
            Integer n4 = orgIndex = Integer.valueOf(orgIndex + 1);
        }
    }

    private DynamicObject createOrgTeam(DynamicObject info, String upgradeType) {
        DynamicObject team = this.ORG_TEAM_HELPER.generateEmptyDynamicObject();
        HRDynamicObjectUtils.copy((DynamicObject)info, (DynamicObject)team);
        team.set("id", (Object)info.getLong("id"));
        team.set("teamtype", (Object)1010L);
        team.set("parent", (Object)info.getLong("parentorg.id"));
        if (HRStringUtils.equals((String)upgradeType, (String)"0")) {
            team.set("number", (Object)(this.numberPrefixMap.get(1010L) + "_" + info.getString("number")));
            team.set("orgtype", (Object)1010L);
            team.set("otclassify", (Object)1010L);
        } else {
            team.set("number", (Object)(this.numberPrefixMap.get(1020L) + "_" + info.getString("number")));
            team.set("orgtype", (Object)1020L);
            team.set("otclassify", (Object)1020L);
        }
        this.teamAndOrgProjectIdMatchMap.put(info.getLong("id"), info.getLong("id"));
        return team;
    }
}

