/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.business.servicehelper;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.api.ApiResult;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.service.operation.OperationServiceImpl;
import kd.hr.haos.business.service.adminorg.AdminOrgHisDynamicUtils;
import kd.hr.haos.business.service.adminorg.AdminOrgHisServiceHelper;
import kd.hr.hbp.business.application.impl.newhismodel.HisModelController;
import kd.hr.hbp.business.domain.model.newhismodel.HisVersionParamBo;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;

public class OrgTeamServiceHelper {
    private static final Log LOGGER = LogFactory.getLog(OrgTeamServiceHelper.class);
    private static final int ORG_TEAM_MAX = 2000;
    private static final String OTCLASSIFY_TEAMTYPE_ID = "teamtype.id";
    private static final String ADMIN_ORG_TYPE = "1010";
    private static final String DELIMITER = "\u3001";

    public static List<Map<String, Object>> batchGetSupOrgTeamInfo(List<Long> orgTeamIdList, Date date, Long coopType) {
        if (CollectionUtils.isEmpty(orgTeamIdList)) {
            LOGGER.error("batchGetSupOrgTeamInfo() param orgTeamIdList is empty");
            return Lists.newArrayListWithExpectedSize((int)0);
        }
        long startTime = System.currentTimeMillis();
        LOGGER.info(String.format(Locale.ROOT, "batchGetSupOrgTeamInfo() params orgTeamIdList: %s, date: %s, coopType: %s.", orgTeamIdList, date, coopType));
        Object[] dynamicObjects = AdminOrgHisServiceHelper.batchGetStructLongNumber(orgTeamIdList, date, "haos_adminorgstructure", "orgteam");
        if (ObjectUtils.isEmpty((Object[])dynamicObjects)) {
            return Lists.newArrayListWithExpectedSize((int)0);
        }
        Set structNumberSet = Stream.of(dynamicObjects).map(dy -> dy.getString("structlongnumber").split("!")).flatMap(Arrays::stream).collect(Collectors.toSet());
        QFilter structNumberFilter = new QFilter("structnumber", "in", structNumberSet);
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("haos_adminorgteam");
        QFilter dateFilter = AdminOrgHisServiceHelper.hisDateQueryFilter(date);
        dateFilter.and(new QFilter("initstatus", "=", (Object)"2"));
        Object[] orgTeamIdDyn = serviceHelper.query("boid", new QFilter[]{structNumberFilter, dateFilter});
        if (ObjectUtils.isEmpty((Object[])orgTeamIdDyn)) {
            return Lists.newArrayListWithExpectedSize((int)0);
        }
        List needSearchOrgTeamIdList = Stream.of(orgTeamIdDyn).map(dy -> dy.getLong("boid")).collect(Collectors.toList());
        HRBaseServiceHelper teamCoopRelServiceHelper = new HRBaseServiceHelper("haos_orgteamcooprel");
        QFilter orgFilter = new QFilter("org", "in", needSearchOrgTeamIdList);
        QFilter coopTypeFilter = new QFilter("coopreltype", "=", (Object)coopType);
        DynamicObject[] teamCoopRelInfos = teamCoopRelServiceHelper.loadDynamicObjectArray(new QFilter[]{orgFilter, coopTypeFilter, dateFilter});
        HashSet<Long> orgTeamIdSet = new HashSet<Long>(teamCoopRelInfos.length);
        for (DynamicObject dynamicObject : teamCoopRelInfos) {
            orgTeamIdSet.add(dynamicObject.getLong("org.id"));
            orgTeamIdSet.add(dynamicObject.getLong("cooporgteam.id"));
        }
        DynamicObject[] objects = serviceHelper.query("name,number,boid", new QFilter[]{dateFilter, new QFilter("boid", "in", orgTeamIdSet)});
        Map<Long, DynamicObject> objectMap = Stream.of(objects).collect(Collectors.toMap(dy -> dy.getLong("boid"), dy -> dy));
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>(teamCoopRelInfos.length);
        for (DynamicObject dynamicObject : teamCoopRelInfos) {
            HashMap<String, Object> map = new HashMap<String, Object>(8);
            long orgTeamId = dynamicObject.getLong("org.id");
            map.put("orgTeamId", orgTeamId);
            DynamicObject orgTeamDy = objectMap.get(orgTeamId);
            map.put("orgTeamNumber", orgTeamDy.getString("number"));
            map.put("orgTeamName", orgTeamDy.getString("name"));
            map.put("coopTypeId", dynamicObject.getLong("coopreltype.id"));
            long coopOrgTeamId = dynamicObject.getLong("cooporgteam.id");
            map.put("coopOrgTeamId", coopOrgTeamId);
            DynamicObject coopOrgTeamDy = objectMap.get(coopOrgTeamId);
            if (Objects.nonNull(coopOrgTeamDy)) {
                map.put("coopOrgTeamNumber", coopOrgTeamDy.getString("number"));
                map.put("coopOrgTeamName", coopOrgTeamDy.getString("name"));
            }
            map.put("businessStatus", dynamicObject.getString("enable"));
            result.add(map);
        }
        LOGGER.info(String.format(Locale.ROOT, "batchGetSupOrgTeamInfo() time cost is: %s", System.currentTimeMillis() - startTime));
        return result;
    }

    public static Map<String, Object> batchAddOrgTeam(DynamicObject[] orgTeamArr) {
        ApiResult apiResult = OrgTeamServiceHelper.batchAddValidate(orgTeamArr);
        return OrgTeamServiceHelper.callOp(apiResult, orgTeamArr, "save");
    }

    public static Map<String, Object> batchUpdateOrgTeamInfo(DynamicObject[] orgTeamArr) {
        ApiResult apiResult = OrgTeamServiceHelper.batchCommonValidate(orgTeamArr);
        if (!apiResult.getSuccess()) {
            return ApiResult.toMap((ApiResult)apiResult);
        }
        apiResult.setMessage("");
        Map<Long, DynamicObject> orgTeamMap = Arrays.stream(orgTeamArr).collect(Collectors.toMap(team -> team.getLong("id"), team -> team));
        Map<Long, DynamicObject> newOrgTeamMap = OrgTeamServiceHelper.getNewOrgTeamMap(orgTeamMap);
        ArrayList<String> orgTeamIdNotExistList = new ArrayList<String>();
        ArrayList<String> orgTeamTypeErrorList = new ArrayList<String>();
        ArrayList list = new ArrayList();
        orgTeamMap.forEach((orgTeamId, orgTeam) -> {
            DynamicObject newOrgTeam = (DynamicObject)newOrgTeamMap.get(orgTeamId);
            if (newOrgTeam != null) {
                String teamTypeId = newOrgTeam.getString(OTCLASSIFY_TEAMTYPE_ID);
                if (HRStringUtils.equals((String)teamTypeId, (String)ADMIN_ORG_TYPE)) {
                    orgTeamTypeErrorList.add(orgTeam.getString("name"));
                } else {
                    newOrgTeam.set("name", (Object)orgTeam.getString("name"));
                    newOrgTeam.set("number", (Object)orgTeam.getString("number"));
                    newOrgTeam.set("bsed", (Object)orgTeam.getDate("bsed"));
                    DynamicObject team = new DynamicObject(newOrgTeam.getDynamicObjectType());
                    HRDynamicObjectUtils.copy((DynamicObject)newOrgTeam, (DynamicObject)team);
                    list.add(team);
                }
            } else {
                orgTeamIdNotExistList.add(orgTeam.getString("name"));
            }
        });
        OrgTeamServiceHelper.orgTeamIdValidate(apiResult, orgTeamIdNotExistList);
        OrgTeamServiceHelper.orgTeamTypeValidate(apiResult, orgTeamTypeErrorList);
        return OrgTeamServiceHelper.callOp(apiResult, list.toArray(new DynamicObject[0]), "save");
    }

    private static Map<Long, DynamicObject> getNewOrgTeamMap(Map<Long, DynamicObject> orgTeamMap) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("haos_adminorgteam");
        QFilter filter = new QFilter("id", "in", orgTeamMap.keySet());
        DynamicObject[] newOrgTeamArr = serviceHelper.loadDynamicObjectArray(new QFilter[]{filter});
        return Arrays.stream(newOrgTeamArr).collect(Collectors.toMap(team -> team.getLong("id"), team -> team));
    }

    private static Map<String, Object> callOp(ApiResult apiResult, DynamicObject[] orgTeamArr, String operate) {
        OperateOption operateOption;
        OperationServiceImpl opImpl;
        OperationResult operationResult;
        if (apiResult.getSuccess() && !(operationResult = (opImpl = new OperationServiceImpl()).localInvokeOperation(operate, orgTeamArr, operateOption = OperateOption.create())).isSuccess()) {
            apiResult.setSuccess(false);
            apiResult.setMessage(operationResult.getAllErrorOrValidateInfo().toString());
            LOGGER.info("ot callOp fail" + operationResult.getAllErrorOrValidateInfo().toString());
        }
        return ApiResult.toMap((ApiResult)apiResult);
    }

    public static Map<String, Object> batchUpdateOrgTeamEnable(DynamicObject[] orgTeamArr) {
        ApiResult apiResult = OrgTeamServiceHelper.batchCommonValidate(orgTeamArr);
        if (!apiResult.getSuccess()) {
            return ApiResult.toMap((ApiResult)apiResult);
        }
        Map<Long, DynamicObject> orgTeamMap = Arrays.stream(orgTeamArr).collect(Collectors.toMap(team -> team.getLong("id"), team -> team));
        Map<Long, Date> effDateAndDynMap = Arrays.stream(orgTeamArr).collect(Collectors.toMap(dyn -> dyn.getLong("id"), dyn -> dyn.getDate("bsed")));
        Map<Long, DynamicObject> newOrgTeamMap = OrgTeamServiceHelper.getNewOrgTeamMap(orgTeamMap);
        ArrayList<String> orgTeamTypeErrorList = new ArrayList<String>();
        ArrayList<String> orgTeamIdNotExistList = new ArrayList<String>();
        ArrayList<String> orgTeamEffDateErrorList = new ArrayList<String>();
        ArrayList list = new ArrayList();
        long currUserId = RequestContext.get().getCurrUserId();
        orgTeamMap.forEach((orgTeamId, orgTeam) -> {
            DynamicObject newOrgTeam = (DynamicObject)newOrgTeamMap.get(orgTeamId);
            if (newOrgTeam != null) {
                String teamTypeId = newOrgTeam.getString(OTCLASSIFY_TEAMTYPE_ID);
                if (HRStringUtils.equals((String)teamTypeId, (String)ADMIN_ORG_TYPE)) {
                    orgTeamTypeErrorList.add(orgTeam.getString("name"));
                } else {
                    Date effDate = (Date)effDateAndDynMap.get(orgTeamId);
                    if (effDate == null) {
                        orgTeamEffDateErrorList.add(orgTeam.getString("name"));
                    } else {
                        OrgTeamServiceHelper.setNewOrgTeam(list, currUserId, newOrgTeam, effDate);
                    }
                }
            } else {
                orgTeamIdNotExistList.add(orgTeam.getString("name"));
            }
        });
        OrgTeamServiceHelper.orgTeamIdValidate(apiResult, orgTeamIdNotExistList);
        OrgTeamServiceHelper.orgTeamTypeValidate(apiResult, orgTeamTypeErrorList);
        OrgTeamServiceHelper.orgTeamEffDateValidate(apiResult, orgTeamEffDateErrorList);
        return OrgTeamServiceHelper.orgTeamBatchHisVersionChange(apiResult, list.toArray(new DynamicObject[0]));
    }

    private static void setNewOrgTeam(List<DynamicObject> list, long currUserId, DynamicObject newOrgTeam, Date effDate) {
        newOrgTeam.set("bsed", (Object)effDate);
        if (HRStringUtils.equals((String)"1", (String)newOrgTeam.getString("enable"))) {
            newOrgTeam.set("enable", (Object)"0");
            newOrgTeam.set("disabledate", (Object)effDate);
            newOrgTeam.set("disabler", (Object)currUserId);
        } else {
            newOrgTeam.set("enable", (Object)"1");
            newOrgTeam.set("disabledate", null);
            newOrgTeam.set("disabler", null);
        }
        DynamicObject team = new DynamicObject(newOrgTeam.getDynamicObjectType());
        HRDynamicObjectUtils.copy((DynamicObject)newOrgTeam, (DynamicObject)team);
        list.add(team);
    }

    private static void orgTeamTypeValidate(ApiResult apiResult, List<String> orgTeamTypeErrorList) {
        if (!orgTeamTypeErrorList.isEmpty()) {
            String orgTeamTypeErrorStr = orgTeamTypeErrorList.stream().collect(Collectors.joining(DELIMITER));
            apiResult.setSuccess(false);
            apiResult.setMessage(ResManager.loadKDString((String)"\u201c%1$s%2$s\u201d\u4e3a\u884c\u653f\u7c7b\u7ec4\u7ec7\u56e2\u961f\uff0c\u4e0d\u5141\u8bb8\u4fee\u6539\u3002", (String)"OrgTeamServiceHelper_0", (String)"hrmp-haos-business", (Object[])new Object[]{apiResult.getMessage(), orgTeamTypeErrorStr}));
        }
    }

    private static void orgTeamIdValidate(ApiResult apiResult, List<String> orgTeamIdNotExistList) {
        if (!orgTeamIdNotExistList.isEmpty()) {
            String orgTeamIdNotExistStr = orgTeamIdNotExistList.stream().collect(Collectors.joining(DELIMITER));
            apiResult.setSuccess(false);
            apiResult.setMessage(ResManager.loadKDString((String)"%1$s%2$s\u6240\u5c5e\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"OrgTeamServiceHelper_1", (String)"hrmp-haos-business", (Object[])new Object[]{apiResult.getMessage(), orgTeamIdNotExistStr}));
        }
    }

    private static void orgTeamEffDateValidate(ApiResult apiResult, List<String> orgTeamEffDateErrorList) {
        if (!orgTeamEffDateErrorList.isEmpty()) {
            String orgTeamEffDateErrorStr = orgTeamEffDateErrorList.stream().collect(Collectors.joining(DELIMITER));
            apiResult.setSuccess(false);
            apiResult.setMessage(ResManager.loadKDString((String)"%1$s%2$s\u751f\u6548\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"OrgTeamServiceHelper_2", (String)"hrmp-haos-business", (Object[])new Object[]{apiResult.getMessage(), orgTeamEffDateErrorStr}));
        }
    }

    private static Map<String, Object> orgTeamBatchHisVersionChange(ApiResult apiResult, DynamicObject[] newOrgTeamArr) {
        if (apiResult.getSuccess()) {
            try {
                HisVersionParamBo hisVersionParam = AdminOrgHisDynamicUtils.getInstance().getHisVersionParam(newOrgTeamArr, "haos_adminorgteam", false);
                HisModelController.getInstance().hisVersionChange(hisVersionParam);
            }
            catch (Exception e) {
                apiResult.setSuccess(false);
                apiResult.setMessage(e.getMessage());
            }
        }
        return ApiResult.toMap((ApiResult)apiResult);
    }

    private static ApiResult batchAddValidate(DynamicObject[] orgTeamArr) {
        ApiResult apiResult = OrgTeamServiceHelper.batchCommonValidate(orgTeamArr);
        if (!apiResult.getSuccess()) {
            return apiResult;
        }
        String orgTeamNameStr = Arrays.stream(orgTeamArr).filter(team -> HRStringUtils.equals((String)team.getString(OTCLASSIFY_TEAMTYPE_ID), (String)ADMIN_ORG_TYPE)).map(team -> team.getString("name")).collect(Collectors.joining(DELIMITER));
        if (HRStringUtils.isNotEmpty((String)orgTeamNameStr)) {
            apiResult.setSuccess(false);
            apiResult.setMessage(ResManager.loadKDString((String)"\u201c%s\u201d\u4e3a\u884c\u653f\u7c7b\u7ec4\u7ec7\u56e2\u961f\uff0c\u4e0d\u5141\u8bb8\u65b0\u589e\u3002", (String)"OrgTeamServiceHelper_3", (String)"hrmp-haos-business", (Object[])new Object[]{orgTeamNameStr}));
            return apiResult;
        }
        return apiResult;
    }

    private static ApiResult batchCommonValidate(DynamicObject[] orgTeamArr) {
        ApiResult apiResult = ApiResult.success(null);
        if (orgTeamArr == null || orgTeamArr.length == 0) {
            apiResult.setSuccess(false);
            apiResult.setMessage("orgTeamArr is null or empty!");
            return apiResult;
        }
        if (orgTeamArr.length > 2000) {
            apiResult.setSuccess(false);
            apiResult.setMessage(ResManager.loadKDString((String)"\u5355\u6b21\u64cd\u4f5c\u4e0d\u80fd\u8d85\u8fc72000\u6761\u6570\u636e\u3002", (String)"OrgTeamServiceHelper_4", (String)"hrmp-haos-business", (Object[])new Object[0]));
        }
        return apiResult;
    }
}

