/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.business.servicehelper;

import java.text.MessageFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.operate.interaction.InteractionContext;
import kd.bos.entity.operate.interaction.KDInteractionException;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.hr.haos.business.domain.service.impl.orgteam.OrgTeamServiceImpl;
import kd.hr.haos.business.service.adminorg.AdminOrgHisDynamicUtils;
import kd.hr.haos.common.constants.projectgroup.ProjectGroupMDConstants;
import kd.hr.haos.common.constants.structproject.StructProjectConstants;
import kd.hr.haos.common.util.StructLongNumberUtil;
import kd.hr.hbp.business.domain.model.newhismodel.HisVersionParamBo;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import org.apache.commons.collections4.CollectionUtils;

public class ProjectGroupServiceHelper
implements ProjectGroupMDConstants {
    private static final Log LOG = LogFactory.getLog(ProjectGroupServiceHelper.class);
    private static final String HRMP_HAOS_BUSINESS = "hrmp-haos-business";

    public static DynamicObject[] getProjectGroupByFilters(QFilter[] filters) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("haos_projteambaseinfo");
        return helper.loadDynamicObjectArray(filters);
    }

    public static List<DynamicObject> getAllProjectList(List<Long> selectIds, DynamicObject params) {
        DynamicObject[] proTeamArr = ProjectGroupServiceHelper.getEnableProTeamDynArrById(selectIds);
        String projNotExitTip = ResManager.loadKDString((String)"\u9009\u4e2d\u7684\u9879\u76ee\u56e2\u961f\u4e0d\u5b58\u5728\u3002", (String)"ProjectGroupServiceHelper_10", (String)HRMP_HAOS_BUSINESS, (Object[])new Object[0]);
        if (null == proTeamArr) {
            throw new KDBizException(projNotExitTip);
        }
        Date effectDate = ProjectGroupServiceHelper.formatDateYYYYMMDD(params.getDate("startdate"));
        Set<Long> idSet = Arrays.stream(proTeamArr).map(s -> s.getLong("id")).collect(Collectors.toSet());
        DynamicObject[] subProjectArray = ProjectGroupServiceHelper.getSubProjectArray(idSet);
        if (subProjectArray == null || subProjectArray.length < 1) {
            throw new KDBizException(projNotExitTip);
        }
        DynamicObject[] coopRelArr = ProjectGroupServiceHelper.getCurEnableProTeamCoopArr(selectIds);
        Map<Long, Date> proTeamCoopDateMap = ProjectGroupServiceHelper.getProTeamOrgIdEffDateMap(coopRelArr);
        for (DynamicObject project : subProjectArray) {
            Date coopRelLastEffDate;
            Date coopDate;
            Date startDate = ProjectGroupServiceHelper.formatDateYYYYMMDD(project.getDate("bsed"));
            if (startDate == null) continue;
            if (!ObjectUtils.isEmpty(proTeamCoopDateMap) && (coopDate = proTeamCoopDateMap.get(project.getLong("id"))) != null && startDate.before(coopRelLastEffDate = ProjectGroupServiceHelper.formatDateYYYYMMDD(proTeamCoopDateMap.get(project.getLong("id"))))) {
                startDate = coopRelLastEffDate;
            }
            if (effectDate.before(startDate)) {
                SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
                String s2 = MessageFormat.format(ResManager.loadKDString((String)"{0}\uff1a\u751f\u6548\u65e5\u671f\u5e94\u665a\u4e8e\u6216\u7b49\u4e8e\u5f53\u524d\u751f\u6548\u65e5\u671f\u201c{1}\u201d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"ProjectGroupServiceHelper_2", (String)HRMP_HAOS_BUSINESS, (Object[])new Object[0]), project.getString("number"), format.format(startDate));
                throw new KDBizException(s2);
            }
            project.set("bsed", (Object)effectDate);
        }
        return Arrays.stream(subProjectArray).collect(Collectors.toList());
    }

    public static Map<Long, Date> getProTeamOrgIdEffDateMap(DynamicObject[] coopRelArr) {
        HashMap<Long, Date> proTeamCoopDateMap = new HashMap<Long, Date>(coopRelArr.length);
        if (ObjectUtils.isEmpty((Object[])coopRelArr)) {
            return proTeamCoopDateMap;
        }
        for (DynamicObject dyn : coopRelArr) {
            Date effDate = dyn.getDate("bsed");
            Long sourceOrgId = dyn.getLong("org.id");
            proTeamCoopDateMap.putIfAbsent(sourceOrgId, effDate);
            Date tmpDate = (Date)proTeamCoopDateMap.get(sourceOrgId);
            if (!tmpDate.before(effDate)) continue;
            proTeamCoopDateMap.put(sourceOrgId, effDate);
        }
        return proTeamCoopDateMap;
    }

    public static DynamicObject[] getCurEnableProTeamCoopArr(List<Long> sourceOrgIdList) {
        HRBaseServiceHelper orgTeamCoopRelHelper = new HRBaseServiceHelper("haos_orgteamcooprel");
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        QFilter orgFilter = new QFilter("org", "in", sourceOrgIdList);
        QFilter isCurVersionFilter = new QFilter("iscurrentversion", "=", (Object)"1");
        QFilter coopRelTypeFilter = new QFilter("coopreltype", "!=", (Object)1010L);
        return orgTeamCoopRelHelper.queryOriginalArray("id,bsed,org.id,coopreltype.id", new QFilter[]{orgFilter, enableFilter, isCurVersionFilter, coopRelTypeFilter});
    }

    public static DynamicObject[] getEnableProTeamDynArrById(List<Long> selectIds) {
        QFilter idFilter = new QFilter("id", "in", (Object)selectIds.toArray());
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        QFilter isCurVersionFilter = new QFilter("iscurrentversion", "=", (Object)"1");
        HRBaseServiceHelper helper = new HRBaseServiceHelper("haos_projteambaseinfo");
        return helper.loadDynamicObjectArray(new QFilter[]{idFilter, enableFilter, isCurVersionFilter});
    }

    public static DynamicObject[] getEnableProTeamDynArrByNumber(List<String> numberList) {
        QFilter numberFilter = new QFilter("number", "in", (Object)numberList.toArray());
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        QFilter isCurVersionFilter = new QFilter("iscurrentversion", "=", (Object)"1");
        HRBaseServiceHelper helper = new HRBaseServiceHelper("haos_projteambaseinfo");
        return helper.loadDynamicObjectArray(new QFilter[]{numberFilter, enableFilter, isCurVersionFilter});
    }

    public static DynamicObject[] getSubProjectArray(Set<Long> prjTeamIds) {
        DynamicObject[] structList = ProjectGroupServiceHelper.getSubProjectStruct(prjTeamIds);
        if (structList == null || structList.length < 1) {
            return null;
        }
        HRBaseServiceHelper projTeamInfoDAO = new HRBaseServiceHelper("haos_projteambaseinfo");
        QFilter idFilter = new QFilter("id", "in", (Object)Arrays.stream(structList).map(x -> x.getLong("orgteam.id")).toArray());
        return projTeamInfoDAO.loadDynamicObjectArray(new QFilter[]{idFilter, FILTER_IS_CURRENT_VERSION});
    }

    public static DynamicObject[] getSubProjectStruct(Set<Long> prjTeamIds) {
        if (CollectionUtils.isEmpty(prjTeamIds)) {
            return null;
        }
        HRBaseServiceHelper projectStructDAO = new HRBaseServiceHelper("haos_adminorgstructure");
        DynamicObjectCollection projects = projectStructDAO.queryOriginalCollection("structlongnumber", new QFilter[]{new QFilter("orgteam.id", "in", prjTeamIds), FILTER_IS_CURRENT_VERSION, FILTER_ENABLE});
        List longNumberSet = projects.stream().map(s -> s.getString("structlongnumber")).collect(Collectors.toList());
        QFilter structFilter = null;
        for (String structNumber : StructLongNumberUtil.getPrefixStructLongNumber(longNumberSet)) {
            if (structFilter == null) {
                structFilter = new QFilter("structlongnumber", "like", (Object)(structNumber + "%"));
                continue;
            }
            structFilter.or(new QFilter("structlongnumber", "like", (Object)(structNumber + "%")));
        }
        return projectStructDAO.query("orgteam.id", new QFilter[]{structFilter, FILTER_IS_CURRENT_VERSION, FILTER_ENABLE});
    }

    public static HisVersionParamBo changeOrgTeamStructList(DynamicObject[] projectBaseList, Map<Long, Long> boVsNewId) {
        Set orgTeamSet = Arrays.stream(projectBaseList).map(s -> s.getLong("id")).collect(Collectors.toSet());
        HRBaseServiceHelper orgTeamStructHelper = new HRBaseServiceHelper("haos_adminorgstructure");
        QFilter orgTeamFilter = new QFilter("orgteam", "in", orgTeamSet);
        DynamicObject[] structS = orgTeamStructHelper.loadDynamicObjectArray(new QFilter[]{orgTeamFilter, FILTER_IS_CURRENT_VERSION, (QFilter)StructProjectConstants.ORG_STRUCTURE_FILTER.get()});
        List structList = Arrays.stream(structS).collect(Collectors.toList());
        ArrayList<DynamicObject> newStructList = new ArrayList<DynamicObject>(16);
        int i = 0;
        long[] idArr = ORM.create().genLongIds("haos_adminorgstructure", structList.size());
        Date nowDate = new Date();
        for (DynamicObject struct : structList) {
            DynamicObject newDy = orgTeamStructHelper.generateEmptyDynamicObject();
            HRDynamicObjectUtils.copy((DynamicObject)struct, (DynamicObject)newDy);
            newDy.set("id", (Object)idArr[i]);
            newDy.set("enable", (Object)"0");
            newDy.set("initstatus", (Object)"2");
            newDy.set("bsed", (Object)projectBaseList[0].getDate("bsed"));
            newDy.set("orgteamhisid", (Object)boVsNewId.get(newDy.getLong("orgteam.id")));
            newDy.set("createtime", (Object)nowDate);
            newStructList.add(newDy);
            ++i;
        }
        return AdminOrgHisDynamicUtils.getInstance().getHisVersionParam(newStructList.toArray(new DynamicObject[0]), "haos_adminorgstructure", false);
    }

    public static DynamicObject[] queryProjectRoleByProjectTeam(DynamicObject[] groups) {
        DynamicObject[] projectRoles = new DynamicObject[]{};
        if (groups == null || groups.length < 1) {
            return projectRoles;
        }
        List ids = Arrays.stream(groups).map(x -> x.getLong("id")).collect(Collectors.toList());
        Map result = (Map)HRMServiceHelper.invokeHRMPService((String)"hbpm", (String)"IProjectRoleService", (String)"queryProjectRoleByProjectTeam", (Object[])new Object[]{ids, new Date()});
        if (null == result) {
            return projectRoles;
        }
        boolean success = (Boolean)result.get("success");
        if (!success) {
            return projectRoles;
        }
        return (DynamicObject[])result.get("data");
    }

    public static DynamicObject[] queryProjectRoleByProjectTeam(List<Long> idList) {
        return ProjectGroupServiceHelper.queryProjectRoleByProjectTeam(idList, null);
    }

    public static DynamicObject[] queryProjectRoleByProjectTeam(List<Long> idList, Date queryDate) {
        Map result;
        DynamicObject[] projectRoles = new DynamicObject[]{};
        if (CollectionUtils.isEmpty(idList)) {
            return projectRoles;
        }
        if (queryDate == null) {
            queryDate = HRDateTimeUtils.truncateDate((Date)new Date());
        }
        if (null == (result = (Map)HRMServiceHelper.invokeHRMPService((String)"hbpm", (String)"IProjectRoleService", (String)"queryProjectRoleByProjectTeam", (Object[])new Object[]{idList, queryDate}))) {
            return projectRoles;
        }
        boolean success = (Boolean)result.get("success");
        if (!success) {
            return projectRoles;
        }
        return (DynamicObject[])result.get("data");
    }

    public static DynamicObject[] queryProjectRoleByProjectTeamId(List<Long> proTeamIdList) {
        DynamicObject[] projectRoles = new DynamicObject[]{};
        Map result = (Map)HRMServiceHelper.invokeHRMPService((String)"hbpm", (String)"IProjectRoleService", (String)"queryProjectRoleByProjectTeam", (Object[])new Object[]{proTeamIdList, new Date()});
        if (null == result) {
            return projectRoles;
        }
        boolean success = (Boolean)result.get("success");
        if (!success) {
            return projectRoles;
        }
        return (DynamicObject[])result.get("data");
    }

    public static Set<Long> checkProjectGroupMembersById(List<Long> idSet) {
        if (idSet == null || idSet.size() < 1) {
            return null;
        }
        OrgTeamServiceImpl orgTeamService = OrgTeamServiceImpl.getInstance();
        List<Long> allBoIdList = orgTeamService.getCurAndSubOrgTeamByBoIdSet(new HashSet<Long>(idSet));
        HashSet<Long> containPerson = new HashSet<Long>(16);
        List result = (List)HRMServiceHelper.invokeHRService((String)"ptmm", (String)"IPTMMQueryMemberService", (String)"getProjectGroupMembersById", (Object[])new Object[]{allBoIdList});
        result.forEach(map -> {
            if (!((Boolean)map.get("isHaveMembers")).booleanValue()) {
                return;
            }
            containPerson.add((Long)map.get("projectGroupId"));
        });
        return containPerson;
    }

    public static void disableProjectRole(DynamicObject[] roles, Date effectDate) {
        if (roles == null || roles.length < 1) {
            return;
        }
        List ids = Arrays.stream(roles).map(x -> x.getLong("id")).collect(Collectors.toList());
        HRMServiceHelper.invokeHRMPService((String)"hbpm", (String)"IProjectRoleService", (String)"changeProjectRoleStatus", (Object[])new Object[]{"0", ids, effectDate});
    }

    public static void updateNumberRule(String type, DynamicObject[] dyArray) {
        boolean exist = CodeRuleServiceHelper.isExist((String)"haos_projectgroupadd", (DynamicObject)dyArray[0], null);
        if (!exist) {
            return;
        }
        if ("opplugin".equals(type)) {
            CodeRuleServiceHelper.getNumbers((String)"haos_projectgroupadd", Arrays.asList(dyArray));
        } else if ("form".equals(type)) {
            try {
                CodeRuleServiceHelper.readNumber((String)"haos_projectgroupadd", (DynamicObject)dyArray[0], null);
            }
            catch (KDException e) {
                throw new KDBizException(e.getMessage());
            }
        }
    }

    public static Map<String, DynamicObject> getLatestOfFirstBsedCooDynMap(DynamicObjectCollection coopInfoList, String orgNumber, Date curOrgEffDate) {
        HashMap<String, DynamicObject> map = new HashMap<String, DynamicObject>(1);
        if (ObjectUtils.isEmpty((Object)coopInfoList) || curOrgEffDate == null || ObjectUtils.isEmpty((Object)orgNumber)) {
            return map;
        }
        Date lastCoopInfoDate = null;
        for (DynamicObject coopDyn : coopInfoList) {
            Date orgTeamFirstBSed = coopDyn.getDate("cooporgteam.firstbsed");
            if (!curOrgEffDate.before(orgTeamFirstBSed)) continue;
            lastCoopInfoDate = ProjectGroupServiceHelper.getLastCoopOrgDate(orgNumber, map, lastCoopInfoDate, coopDyn, orgTeamFirstBSed);
        }
        return map;
    }

    private static Date getLastCoopOrgDate(String orgNumber, Map<String, DynamicObject> map, Date lastCoopInfoDate, DynamicObject coopDyn, Date orgTeamFirstBSed) {
        if (lastCoopInfoDate == null) {
            lastCoopInfoDate = orgTeamFirstBSed;
            map.put(orgNumber, coopDyn);
            return lastCoopInfoDate;
        }
        if (lastCoopInfoDate.before(orgTeamFirstBSed)) {
            lastCoopInfoDate = orgTeamFirstBSed;
            map.put(orgNumber, coopDyn);
        }
        return lastCoopInfoDate;
    }

    public static Map<Long, DynamicObject> getCoopRelDynMap(long orgCoopId) {
        Map<Long, DynamicObject> coopRelDynMap = new HashMap<Long, DynamicObject>(16);
        if (orgCoopId != 0L) {
            HRBaseServiceHelper orgTeamCoopRelHelper = new HRBaseServiceHelper("haos_orgteamcooprel");
            QFilter qFilter = new QFilter("org", "=", (Object)orgCoopId);
            QFilter isCurVerFilter = new QFilter("iscurrentversion", "=", (Object)"1");
            QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
            QFilter coopRelFilter = new QFilter("coopreltype", "!=", (Object)1010L);
            Object[] coopRelDynArr = orgTeamCoopRelHelper.queryOriginalArray("id,boid,org.id,bsed,firstbsed", new QFilter[]{qFilter, isCurVerFilter, enableFilter, coopRelFilter});
            if (!ObjectUtils.isEmpty((Object[])coopRelDynArr)) {
                coopRelDynMap = Arrays.stream(coopRelDynArr).collect(Collectors.toMap(dyn -> dyn.getLong("id"), dyn -> dyn));
            }
        }
        return coopRelDynMap;
    }

    public static void addCoopRelErrInfo(DynamicObjectCollection coopInfoList, DynamicObject targetObject, List<DynamicObject> proTeamNewErrList, List<DynamicObject> proTeamChgSaveErrList, Map<Long, Date> coopRelChgLastDateMap, List<DynamicObject> proTeamDelErrList, Map<Long, DynamicObject> coopRelDynMap) {
        Date pageTeamFirstDate = ProjectGroupServiceHelper.formatDateYYYYMMDD(targetObject.getDate("firstbsed"));
        Date pageTeamEffDate = ProjectGroupServiceHelper.formatDateYYYYMMDD(targetObject.getDate("bsed"));
        if (!ObjectUtils.isEmpty((Object)coopInfoList)) {
            for (DynamicObject coopInfo : coopInfoList) {
                Date coopTeamFirstBSed = ProjectGroupServiceHelper.formatDateYYYYMMDD(coopInfo.getDate("cooporgteam.firstbsed"));
                if (pageTeamEffDate == null || coopTeamFirstBSed == null) continue;
                Long coopRelId = coopInfo.getLong("id");
                if (coopRelId == 0L || coopRelDynMap.get(coopRelId) == null) {
                    if (pageTeamEffDate == null || !pageTeamEffDate.before(coopTeamFirstBSed)) continue;
                    proTeamNewErrList.add(coopInfo);
                    continue;
                }
                Date lastEffDate = pageTeamFirstDate;
                DynamicObject coopRelDynDb = coopRelDynMap.get(coopRelId);
                if (coopRelDynDb != null) {
                    Date coopRelEffDate = ProjectGroupServiceHelper.formatDateYYYYMMDD(coopRelDynDb.getDate("bsed"));
                    if (lastEffDate.before(coopTeamFirstBSed)) {
                        lastEffDate = coopTeamFirstBSed;
                    }
                    if (lastEffDate.before(coopRelEffDate)) {
                        lastEffDate = coopRelEffDate;
                    }
                    if (pageTeamEffDate.before(lastEffDate)) {
                        proTeamChgSaveErrList.add(coopInfo);
                        coopRelChgLastDateMap.put(coopRelId, lastEffDate);
                    }
                }
                coopRelDynMap.remove(coopRelId);
            }
        }
        if (!ObjectUtils.isEmpty(coopRelDynMap)) {
            for (DynamicObject coopRelDel : coopRelDynMap.values()) {
                Date coopRelDelEffDate = ProjectGroupServiceHelper.formatDateYYYYMMDD(coopRelDel.getDate("bsed"));
                if (pageTeamEffDate == null || !pageTeamEffDate.before(coopRelDelEffDate)) continue;
                proTeamDelErrList.add(coopRelDel);
            }
        }
    }

    public static Date formatDateYYYYMMDD(Date date) {
        String curProCoopEffDateStr = HRDateTimeUtils.format((Date)date, (String)"yyyy-MM-dd");
        try {
            return HRDateTimeUtils.parseDate((String)curProCoopEffDateStr, (String)"yyyy-MM-dd");
        }
        catch (ParseException e) {
            LOG.error("parseDate ParseException", (Throwable)e);
            return new Date();
        }
    }

    public static boolean alterConfigWindow(OperateOption option, boolean isInteractionException, String interactionMsg) {
        String confirmResultString = option.getVariableValue("interactionconfirmresult", "");
        if (!StringUtils.isEmpty((CharSequence)confirmResultString)) {
            return true;
        }
        if (isInteractionException) {
            InteractionContext interactionContext = new InteractionContext();
            OperateErrorInfo errorInfo = new OperateErrorInfo();
            errorInfo.setMessage(interactionMsg);
            errorInfo.setLevel(ErrorLevel.Warning);
            interactionContext.addOperateInfo(errorInfo);
            throw new KDInteractionException("interactionconfirmresult", interactionContext);
        }
        return false;
    }
}

