/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.business.servicehelper;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.list.QueryBuilder;
import kd.bos.orm.query.QFilter;
import kd.hr.haos.business.domain.repository.QFilterHelper;
import kd.hr.haos.business.domain.repository.adorg.AdOrgRepository;
import kd.hr.haos.business.domain.repository.staff.RemainStaffRepository;
import kd.hr.haos.business.domain.repository.staff.UseOrgDetailRepository;
import kd.hr.haos.business.service.staff.bean.RemainStaffBO;
import kd.hr.haos.business.service.staff.bean.RemainStaffQueryBO;
import kd.hr.haos.business.service.staff.service.IRemainStaffQueryService;
import kd.hr.haos.business.service.staff.service.impl.RemainStaffCountService;
import kd.hr.haos.business.service.staff.service.impl.RemainStaffQueryDataService;
import kd.hr.hbp.common.util.HRStringUtils;

public class RemainStaffQueryFactory {
    private RemainStaffBO staffBO;
    private String realOrderByExp;
    private QFilter adOrgBoFilter;

    public IRemainStaffQueryService buildCountService(QueryBuilder queryBuilder) {
        RemainStaffQueryBO queryModel = new RemainStaffQueryBO();
        queryModel.setUseOrgFilter(this.convert4UseOrg(queryBuilder.getFilters()));
        queryModel.setDutyOrgFilter(this.convert4DutyOrg(queryBuilder.getFilters()));
        RemainStaffCountService remainStaffCountRepository = new RemainStaffCountService();
        remainStaffCountRepository.setQueryModel(queryModel);
        return remainStaffCountRepository;
    }

    public IRemainStaffQueryService buildQueryDataService(QueryBuilder queryBuilder) {
        DynamicObject[] useOrgDetails = UseOrgDetailRepository.getInstance().queryUseOrgDetailByStaffId("useorgbo", this.staffBO.getStaffId());
        List useOrgBoList = Arrays.stream(useOrgDetails).map(dy -> dy.getLong("useorgbo")).collect(Collectors.toList());
        RemainStaffQueryBO queryModel = new RemainStaffQueryBO();
        queryModel.setStart(queryBuilder.getStart());
        queryModel.setLimit(queryBuilder.getLimit());
        queryModel.setOrderBys(this.realOrderByExp);
        queryModel.setUseOrgFilter(this.convert4UseOrg(queryBuilder.getFilters()));
        queryModel.setDutyOrgFilter(this.convert4DutyOrg(queryBuilder.getFilters()));
        queryModel.setSortCodeFilter(Lists.newArrayList((Object[])new QFilter[]{new QFilter("adminorg.id", "in", useOrgBoList), QFilterHelper.createValidHisVersionFilterByOnePoint(this.staffBO.getModifyTime())}));
        queryModel.setStaffBO(this.staffBO);
        RemainStaffQueryDataService remainStaffQueryRepository = new RemainStaffQueryDataService();
        remainStaffQueryRepository.setQueryModel(queryModel);
        return remainStaffQueryRepository;
    }

    private List<QFilter> convert4DutyOrg(QFilter[] filters) {
        List<QFilter> qFilterList = this.convertStaffTypeOrgFilter(filters, "dutyorg");
        this.convertAdminOrgF7Filter(qFilterList);
        qFilterList.add(this.staffBO.getStaffCycle().getDutyOrgQFilter());
        return qFilterList;
    }

    private List<QFilter> convert4UseOrg(QFilter[] filters) {
        List<QFilter> qFilterList = this.convertStaffTypeOrgFilter(filters, "useorg");
        this.convertAdminOrgF7Filter(qFilterList);
        qFilterList.add(this.staffBO.getStaffCycle().getUseOrgQFilter());
        return qFilterList;
    }

    private List<QFilter> convertStaffTypeOrgFilter(QFilter[] filters, String staffType) {
        Map<Boolean, List<QFilter>> staffTypeVsFilterList = Arrays.stream(filters).collect(Collectors.groupingBy(filter -> HRStringUtils.equals((String)"stafftype", (String)filter.getProperty())));
        List<QFilter> generalFilterList = staffTypeVsFilterList.getOrDefault(false, Collections.emptyList());
        List<QFilter> staffTypeQFilterList = staffTypeVsFilterList.getOrDefault(true, Collections.emptyList());
        DynamicObject[] remainStaffDys = RemainStaffRepository.getInstance().load(staffTypeQFilterList);
        if (remainStaffDys.length == 0) {
            return generalFilterList;
        }
        Predicate<DynamicObject> matchPredicate = "dutyorg".equals(staffType) ? dy -> dy.getLong("id") == 1010L : dy -> dy.getLong("id") == 1020L;
        boolean shouldQueryDutyOrg = Arrays.stream(remainStaffDys).anyMatch(matchPredicate);
        if (shouldQueryDutyOrg) {
            return generalFilterList;
        }
        return Lists.newArrayList((Object[])new QFilter[]{QFilterHelper.create1NotEquals1Filter()});
    }

    private void convertAdminOrgF7Filter(List<QFilter> filterList) {
        ArrayList<QFilter> adminOrgIdFilterList = new ArrayList<QFilter>();
        for (int i = filterList.size() - 1; i >= 0; --i) {
            if (!filterList.get(i).getProperty().equals("adminorg.id")) continue;
            QFilter remove = filterList.remove(i);
            adminOrgIdFilterList.add(remove);
        }
        if (adminOrgIdFilterList.size() != 0) {
            filterList.add(this.getAdOrgBoFilter(adminOrgIdFilterList));
        }
    }

    private QFilter getAdOrgBoFilter(List<QFilter> adminOrgIdFilterList) {
        if (this.adOrgBoFilter == null) {
            QFilter[] idFilters = (QFilter[])adminOrgIdFilterList.stream().map(QFilter::copy).peek(filter -> filter.__setProperty("id")).toArray(QFilter[]::new);
            DynamicObject[] adOrgs = AdOrgRepository.getInstance().queryArrayOrderBy("boid", idFilters, null);
            Set adminOrgBoSet = Arrays.stream(adOrgs).map(dy -> dy.getLong("boid")).collect(Collectors.toSet());
            this.adOrgBoFilter = new QFilter("adminorg.boid", "in", adminOrgBoSet);
        }
        return this.adOrgBoFilter;
    }

    public void setStaffBO(RemainStaffBO staffBO) {
        this.staffBO = staffBO;
    }

    public void setRealOrderByExp(String realOrderByExp) {
        this.realOrderByExp = realOrderByExp;
    }
}

