/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.business.servicehelper;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DBRoute;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.param.ParameterWriter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.hr.haos.business.domain.repository.other.LaborRelTypeRepository;
import kd.hr.haos.business.domain.service.impl.staff.StaffProjectServiceImpl;
import kd.hr.haos.business.domain.service.staff.IStaffProjectService;
import kd.hr.hbp.common.util.HRDBUtil;
import kd.hr.hbp.common.util.HRStringUtils;

public class StaffSpecialRuleTranUpdateDataServiceHelper {
    private static Log LOG = LogFactory.getLog(StaffProjectServiceImpl.class);
    private Map<String, String> operatorMap;
    private Map<String, String> nameToIdMap;
    private String displayParam = "";
    private IStaffProjectService staffProjectService = new StaffProjectServiceImpl();

    public void upgrade() {
        LOG.info("ruleupdate_start");
        this.displayParam = ResManager.loadKDString((String)"\u7528\u5de5\u5173\u7cfb\u7c7b\u578b", (String)"StaffSpecialRuleTranUpdateDataServiceHelper_0", (String)"hrmp-haos-business", (Object[])new Object[0]);
        this.operatorMap = this.getOperatorMap();
        this.nameToIdMap = this.getNameToIdMap();
        Map<Long, Map<String, Object>> data = this.getNeedUpdateData();
        for (Map.Entry<Long, Map<String, Object>> d : data.entrySet()) {
            Map<String, Object> paramData = d.getValue();
            String specialRuleStr = (String)paramData.get("staffspecialrule");
            Map specialRuleMap = (Map)JSONObject.parseObject((String)specialRuleStr, Map.class);
            String oldRule = (String)specialRuleMap.get("rule");
            String newRule = this.transitNewRule(oldRule);
            specialRuleMap.put("rule", newRule);
            Long policyId = this.staffProjectService.addPolicy(specialRuleMap);
            if (policyId == null || policyId == 0L) {
                LOG.info("ruleupdate_add_policy_worng");
                throw new KDBizException("addPolicy_failed");
            }
            specialRuleMap.put("policyid", policyId);
            specialRuleStr = JSONObject.toJSONString((Object)specialRuleMap);
            paramData.put("staffspecialrule", specialRuleStr);
            String paramDataStr = JSONObject.toJSONString(paramData);
            LOG.info("ruleupdate_save_paramdata_start");
            this.save(paramDataStr, d.getKey());
            LOG.info("ruleupdate_save_paramdata_end");
        }
    }

    private void save(String json, long orgId) {
        ParameterWriter.saveSystemParameter(null, (String)"217WYC/L9U7E", (String)"21", (long)orgId, (long)0L, (String)json);
    }

    private String transitNewRule(String oldRuleStr) {
        LOG.info("ruleupdate_transitnewrule_start , oldrule{}", (Object)oldRuleStr);
        Map oldRuleMap = (Map)SerializationUtils.fromJsonString((String)oldRuleStr, Map.class);
        List oldRulelist = (List)oldRuleMap.get("filterRow");
        NewRule newRule = new NewRule();
        int i = 0;
        int length = oldRulelist.size();
        for (Map filterRow : oldRulelist) {
            OldRule oldRule = (OldRule)JSONObject.parseObject((String)JSONObject.toJSONString((Object)filterRow), OldRule.class);
            NewRuleCondition condition = new NewRuleCondition();
            condition.setIndex(i);
            condition.setDisplayParam(this.displayParam);
            String name = "T";
            name = ++i < 10 ? name + "0" + i : name + i;
            condition.setName(name);
            condition.setOperators(this.operatorMap.get(oldRule.getCompareType()));
            List<Map<String, Object>> valueList = oldRule.getValue();
            ArrayList<String> newValueList = new ArrayList<String>();
            ArrayList<String> displayValueList = new ArrayList<String>();
            for (Map<String, Object> valueMap : valueList) {
                String id;
                String value = valueMap.getOrDefault("value", "").toString();
                if ("".equals(value) || (id = this.nameToIdMap.get(value)) == null) continue;
                newValueList.add(id);
                displayValueList.add(value);
            }
            condition.setDisplayValue(displayValueList.size() > 0 ? String.join((CharSequence)",", displayValueList) : "");
            condition.setValue(newValueList.size() > 0 ? String.join((CharSequence)",", newValueList) : "");
            if (!"".equals(condition.getValue())) {
                condition.setValueType("2");
            }
            NewRuleConditionExpress conditionExpress = new NewRuleConditionExpress();
            conditionExpress.setName(name);
            if (i - 1 != length) {
                conditionExpress.setLogical("0".equals(oldRule.getLogic()) ? " and " : " or ");
            }
            conditionExpress.setLeftBracket("".equals(oldRule.getLeftBracket()) ? "" : " " + oldRule.getLeftBracket() + " ");
            conditionExpress.setRightBracket("".equals(oldRule.getRightBracket()) ? "" : " " + oldRule.getRightBracket() + " ");
            newRule.getConditionList().add(condition);
            newRule.getConditionExpressList().add(conditionExpress);
        }
        newRule.setConditionExpressStr(this.getConditionExpressStr(oldRuleStr));
        String newRuleStr = JSONObject.toJSONString((Object)newRule);
        LOG.info("ruleupdate_transitnewrule_end , newrule{}", (Object)newRuleStr);
        return newRuleStr;
    }

    private Map<Long, Map<String, Object>> getNeedUpdateData() {
        LOG.info("get_needupdatedata_start");
        String sql = "select forgid,fdata from t_bas_sysparameter where fviewtypeid ='21' ";
        HashMap dataMap = Maps.newHashMap();
        DataSet rs = HRDBUtil.queryDataSet((String)"t_bas_sysparameter", (DBRoute)new DBRoute("sys"), (String)sql, (Object[])new Object[0]);
        Object object = null;
        try {
            rs.forEach(data -> {
                long orgId = data.getLong("forgid");
                String paramData = data.getString("fdata");
                dataMap.put(orgId, paramData);
            });
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (rs != null) {
                if (object != null) {
                    try {
                        rs.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    rs.close();
                }
            }
        }
        LOG.info("get_needupdatedata_end");
        HashMap data2 = Maps.newHashMapWithExpectedSize((int)16);
        for (Map.Entry entry : dataMap.entrySet()) {
            long policyId;
            String rule;
            Map specialRule;
            String ruleOrg;
            String staffSpecialRuleStr;
            Long orgId = (Long)entry.getKey();
            Map paramData = (Map)SerializationUtils.fromJsonString((String)((String)entry.getValue()), Map.class);
            if (paramData == null || HRStringUtils.isEmpty((String)(staffSpecialRuleStr = (String)paramData.get("staffspecialrule"))) || !(ruleOrg = String.valueOf((specialRule = (Map)JSONObject.parseObject((String)staffSpecialRuleStr, Map.class)).getOrDefault("org", 0L))).equals(String.valueOf(orgId)) || HRStringUtils.isEmpty((String)(rule = (String)specialRule.get("rule"))) || (policyId = Long.parseLong(((Object)specialRule.getOrDefault("policyid", 0L)).toString())) != 0L) continue;
            data2.put(orgId, paramData);
        }
        LOG.info("handled_get_needupdatedata");
        return data2;
    }

    private Map<String, String> getOperatorMap() {
        HashMap<String, String> operatorMap = new HashMap<String, String>();
        operatorMap.put("17", "in");
        operatorMap.put("34", "not_in");
        operatorMap.put("67", "==");
        operatorMap.put("83", "!=");
        operatorMap.put("37", "is_null");
        operatorMap.put("9", "is_not_null");
        operatorMap.put("59", "==");
        operatorMap.put("58", "!=");
        operatorMap.put("60", "==");
        operatorMap.put("211", "==");
        operatorMap.put("21", "is_null");
        operatorMap.put("36", "is_null");
        operatorMap.put("19", "==");
        operatorMap.put("65", "==");
        return operatorMap;
    }

    private Map<String, String> getNameToIdMap() {
        DynamicObject[] labs = LaborRelTypeRepository.getInstance().queryOriginalArray("id,name", new QFilter[]{new QFilter("enable", "in", (Object)new String[]{"1", "0"})});
        return Arrays.stream(labs).collect(Collectors.toMap(dyn -> dyn.getString("name"), dyn -> dyn.getString("id"), (v1, v2) -> v1));
    }

    private String getConditionExpressStr(String rule) {
        FilterCondition condition = HRStringUtils.isEmpty((String)rule) ? null : (FilterCondition)SerializationUtils.fromJsonString((String)rule, FilterCondition.class);
        MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)"haos_orgpersonstaffinfo");
        FilterBuilder filterBuilder = new FilterBuilder(entityType, condition);
        filterBuilder.buildFilter();
        QFilter completeQFilter = filterBuilder.getQFilter();
        List qFilterList = filterBuilder.getQFilters();
        String completeQfilterStr = completeQFilter.toString();
        String conditionExpressStr = completeQfilterStr.trim();
        int j = 1;
        for (int i = qFilterList.size() - 1; i >= 0; --i) {
            String name = "T";
            name = i < 10 ? name + "0" + j : name + j;
            ++j;
            String express = ((QFilter)qFilterList.get(i)).toString();
            conditionExpressStr = conditionExpressStr.replace(express, name);
        }
        return conditionExpressStr.replace("OR", "or").replace("AND", "and");
    }

    static class NewRuleConditionExpress {
        private String name = "";
        private String logical = "";
        private String leftBracket = "";
        private String rightBracket = "";

        NewRuleConditionExpress() {
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getLogical() {
            return this.logical;
        }

        public void setLogical(String logical) {
            this.logical = logical;
        }

        public String getLeftBracket() {
            return this.leftBracket;
        }

        public void setLeftBracket(String leftBracket) {
            this.leftBracket = leftBracket;
        }

        public String getRightBracket() {
            return this.rightBracket;
        }

        public void setRightBracket(String rightBracket) {
            this.rightBracket = rightBracket;
        }
    }

    static class NewRuleCondition {
        private int index;
        private String name = "";
        private String displayParam = "";
        private String param = "laborreltype.hbss_laborreltype.id";
        private String paramType = "dynamicObject";
        private boolean target = false;
        private String operators = "";
        private String valueType = "";
        private String displayValue = "";
        private String value = "";
        private String objectId = "";
        private String objectNumber = "";

        NewRuleCondition() {
        }

        public int getIndex() {
            return this.index;
        }

        public void setIndex(int index) {
            this.index = index;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getDisplayParam() {
            return this.displayParam;
        }

        public void setDisplayParam(String displayParam) {
            this.displayParam = displayParam;
        }

        public String getParam() {
            return this.param;
        }

        public void setParam(String param) {
            this.param = param;
        }

        public String getParamType() {
            return this.paramType;
        }

        public void setParamType(String paramType) {
            this.paramType = paramType;
        }

        public boolean isTarget() {
            return this.target;
        }

        public void setTarget(boolean target) {
            this.target = target;
        }

        public String getOperators() {
            return this.operators;
        }

        public void setOperators(String operators) {
            this.operators = operators;
        }

        public String getValueType() {
            return this.valueType;
        }

        public void setValueType(String valueType) {
            this.valueType = valueType;
        }

        public String getDisplayValue() {
            return this.displayValue;
        }

        public void setDisplayValue(String displayValue) {
            this.displayValue = displayValue;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public String getObjectId() {
            return this.objectId;
        }

        public void setObjectId(String objectId) {
            this.objectId = objectId;
        }

        public String getObjectNumber() {
            return this.objectNumber;
        }

        public void setObjectNumber(String objectNumber) {
            this.objectNumber = objectNumber;
        }
    }

    static class NewRule {
        private List<NewRuleCondition> conditionList = new ArrayList<NewRuleCondition>();
        private int conditionExpressType = 2;
        private List<NewRuleConditionExpress> conditionExpressList = new ArrayList<NewRuleConditionExpress>();
        private String conditionExpressStr = "";

        NewRule() {
        }

        public List<NewRuleCondition> getConditionList() {
            return this.conditionList;
        }

        public void setConditionList(List<NewRuleCondition> conditionList) {
            this.conditionList = conditionList;
        }

        public int getConditionExpressType() {
            return this.conditionExpressType;
        }

        public void setConditionExpressType(int conditionExpressType) {
            this.conditionExpressType = conditionExpressType;
        }

        public List<NewRuleConditionExpress> getConditionExpressList() {
            return this.conditionExpressList;
        }

        public void setConditionExpressList(List<NewRuleConditionExpress> conditionExpressList) {
            this.conditionExpressList = conditionExpressList;
        }

        public String getConditionExpressStr() {
            return this.conditionExpressStr;
        }

        public void setConditionExpressStr(String conditionExpressStr) {
            this.conditionExpressStr = conditionExpressStr;
        }
    }

    static class OldRule {
        private String leftBracket = "";
        private String compareType = "";
        private String rightBracket = "";
        private String logic = "";
        private List<Map<String, Object>> value;

        OldRule() {
        }

        public String getLeftBracket() {
            return this.leftBracket;
        }

        public void setLeftBracket(String leftBracket) {
            this.leftBracket = leftBracket;
        }

        public String getCompareType() {
            return this.compareType;
        }

        public void setCompareType(String compareType) {
            this.compareType = compareType;
        }

        public String getRightBracket() {
            return this.rightBracket;
        }

        public void setRightBracket(String rightBracket) {
            this.rightBracket = rightBracket;
        }

        public String getLogic() {
            return this.logic;
        }

        public void setLogic(String logic) {
            this.logic = logic;
        }

        public List<Map<String, Object>> getValue() {
            return this.value;
        }

        public void setValue(List<Map<String, Object>> value) {
            this.value = value;
        }
    }
}

