/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.business.task;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.sql.ResultSet;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.schedule.api.ScheduleManager;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.schedule.ScheduleServiceHelper;

public abstract class AbstractCreateUseRegUpgradeTask
extends AbstractTask {
    private static final Log LOGGER = LogFactory.getLog(AbstractCreateUseRegUpgradeTask.class);
    private static final String CREATE_USE_REG_TABLE_SQL = "create table %s (  FUseOrgID        bigint          not null,  FDataID          bigint          not null,  FCreateOrgID     bigint          null,  FAdminOrgID      bigint          null,  FCtrlStrategy    varchar(10)     null,  FIsAssign        char(1)         null,  FAssignOrgID     bigint          null,  FMASTERID          bigint          null,  constraint %s primary key (FDataID, FUseOrgID) ) ";
    private static final String TABLE_IS_EXISTED_SQL = "SELECT * FROM KSQL_USERTABLES WHERE KSQL_TABNAME = '%s' ";
    private static final String CREATE_INDEX_SQL = "IF NOT EXISTS (SELECT 1 FROM KSQL_INDEXES WHERE KSQL_INDNAME = '%s') CREATE INDEX %s ON %s (%s)";

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        Object[] originalNames = this.originalTableNames();
        if (ArrayUtils.isEmpty((Object[])originalNames)) {
            this.disableTask();
            return;
        }
        for (Object originalName : originalNames) {
            Map<String, List<String>> colsOfIndexes;
            String pkName;
            String tableName;
            if (StringUtils.isBlank((CharSequence)originalName) || !(tableName = ((String)originalName).toUpperCase(Locale.ROOT) + "USEREG").startsWith("T_")) continue;
            String entityNameUp = tableName.substring(2);
            if (this.tableIsExisted(tableName) || !this.createTable(tableName, pkName = this.pkName(entityNameUp)) || CollectionUtils.isEmpty(colsOfIndexes = this.colsOfIndexes(entityNameUp))) continue;
            for (Map.Entry<String, List<String>> entry : colsOfIndexes.entrySet()) {
                String indexName = entry.getKey();
                List<String> value = entry.getValue();
                String columns = Joiner.on((char)',').join(value);
                this.createIndex(indexName, tableName, columns);
            }
        }
        this.disableTask();
    }

    private boolean tableIsExisted(String tableName) {
        String tableExistSql = String.format(TABLE_IS_EXISTED_SQL, tableName);
        return (Boolean)DB.query((DBRoute)DBRoute.of((String)this.dbRouteKey()), (String)tableExistSql, null, ResultSet::next);
    }

    private boolean createTable(String tableName, String pkName) {
        String createTableSql = String.format(CREATE_USE_REG_TABLE_SQL, tableName, pkName);
        try {
            DB.execute((DBRoute)DBRoute.of((String)this.dbRouteKey()), (String)createTableSql, null);
            return true;
        }
        catch (Exception ex) {
            LOGGER.error("Error when create table " + tableName, (Throwable)ex);
            return false;
        }
    }

    protected boolean createIndex(String indexName, String tableName, String columns) {
        String createIndexSql = String.format(CREATE_INDEX_SQL, indexName, indexName, tableName, columns);
        try {
            return DB.execute((DBRoute)DBRoute.of((String)this.dbRouteKey()), (String)createIndexSql, null);
        }
        catch (Exception ex) {
            LOGGER.error("Error when create table " + tableName, (Throwable)ex);
            return false;
        }
    }

    protected Map<String, List<String>> colsOfIndexes(String entityNameUp) {
        HashMap result = Maps.newHashMapWithExpectedSize((int)3);
        result.put("IDX_" + entityNameUp + "_1", Lists.newArrayList((Object[])new String[]{"FDataID ASC"}));
        result.put("IDX_" + entityNameUp + "_2", Lists.newArrayList((Object[])new String[]{"FCREATEORGID ASC"}));
        result.put("IDX_" + entityNameUp + "_3", Lists.newArrayList((Object[])new String[]{"FMASTERID ASC"}));
        return result;
    }

    protected String pkName(String entityNameUp) {
        return "PK_" + entityNameUp;
    }

    protected abstract String[] originalTableNames();

    protected abstract String dbRouteKey();

    private void disableTask() {
        ScheduleManager service = (ScheduleManager)ServiceFactory.getService(ScheduleManager.class);
        TaskInfo taskInfo = ScheduleServiceHelper.queryTask((String)this.taskId);
        service.disableJob(taskInfo.getJobId());
        service.disableSchedule(taskInfo.getScheduleId());
    }
}

