/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.haos.business.task;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.locks.Lock;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.schedule.executor.AbstractTask;
import kd.hr.haos.business.servicehelper.OrgChangeMsgServiceHelper;
import kd.hr.haos.common.constants.PublishConstants;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.business.servicehelper.HRProducerServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;

public class PublishTask
extends AbstractTask
implements Runnable {
    private static final Log logger = LogFactory.getLog(PublishTask.class);
    private List<DynamicObject> msgList;
    private Map<Long, List<Map<String, String>>> actionConsumerMap = Maps.newHashMapWithExpectedSize((int)8);
    private Lock lock;
    private String groupNumber;

    public PublishTask() {
    }

    public PublishTask(List<DynamicObject> msgList) {
        this.msgList = msgList;
    }

    public PublishTask(List<DynamicObject> msgList, Lock lock, String groupNumber) {
        this.msgList = msgList;
        this.lock = lock;
        this.groupNumber = groupNumber;
    }

    @Override
    public void run() {
        this.publish(this.msgList, this.groupNumber, false, Objects.nonNull(this.lock));
    }

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        DynamicObject[] msgList = OrgChangeMsgServiceHelper.querySyncData();
        this.syncRecStatus(msgList);
        DynamicObject[] sendstateSyncList = OrgChangeMsgServiceHelper.querySendstateSyncData();
        this.syncSendstate(sendstateSyncList);
    }

    private void syncRecStatus(DynamicObject[] msgList) {
        if (msgList == null) {
            return;
        }
        Map<String, Map<String, Object>> msgNoToDataMapMap = this.getMsgCenterData(msgList);
        for (DynamicObject msg : msgList) {
            Map<String, Object> dataMap;
            String msgNo = msg.getString("number");
            DynamicObjectCollection entry = msg.getDynamicObjectCollection("entryentity");
            if (CollectionUtils.isEmpty((Collection)entry) || (dataMap = msgNoToDataMapMap.get(msgNo)) == null) continue;
            List subList = (List)dataMap.get("dataList");
            for (Map sub : subList) {
                long subscribeBD = (Long)sub.get("subscribeBD");
                String recStatus = (String)sub.get("recStatus");
                for (DynamicObject entryDyn : entry) {
                    long entrySubscribebd = entryDyn.getLong("subscribebd.id");
                    if (entrySubscribebd != subscribeBD) continue;
                    entryDyn.set("recstatus", (Object)recStatus);
                }
            }
        }
        OrgChangeMsgServiceHelper.saveBatch(Arrays.asList(msgList));
    }

    private Map<String, Map<String, Object>> getMsgCenterData(DynamicObject[] msgList) {
        if (msgList == null || msgList.length == 0) {
            return new HashMap<String, Map<String, Object>>();
        }
        ArrayList paramsList = Lists.newArrayListWithExpectedSize((int)msgList.length);
        for (DynamicObject msg : msgList) {
            String msgNo = msg.getString("number");
            long actionId = msg.getLong("action");
            HashMap<String, Object> paramMap = new HashMap<String, Object>();
            paramMap.put("msgNumber", msgNo);
            paramMap.put("actionId", actionId);
            paramsList.add(paramMap);
        }
        if (paramsList.size() == 0) {
            return new HashMap<String, Map<String, Object>>();
        }
        List<Map<String, Object>> dataList = this.getSubRecStatus(paramsList);
        return dataList.stream().collect(Collectors.toMap(o -> o.get("msgNumber").toString(), o -> o, (o1, o2) -> o2));
    }

    private void syncSendstate(DynamicObject[] msgList) {
        Map<String, Map<String, Object>> msgNoToDataMapMap = this.getMsgCenterData(msgList);
        for (DynamicObject msg : msgList) {
            String msgNo = msg.getString("number");
            Map<String, Object> dataMap = msgNoToDataMapMap.get(msgNo);
            if (dataMap == null) continue;
            msg.set("sendstate", (Object)"1");
        }
        OrgChangeMsgServiceHelper.saveBatch(Arrays.asList(msgList));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void publish(List<DynamicObject> msgList, String groupNumber, boolean retry, boolean isUserLock) {
        if (CollectionUtils.isEmpty(msgList)) {
            return;
        }
        Date now = new Date();
        if (HRStringUtils.isEmpty((String)groupNumber)) {
            groupNumber = UUID.randomUUID().toString().replace("-", "");
        }
        ArrayList<DynamicObject> saveList = new ArrayList<DynamicObject>(msgList.size());
        for (DynamicObject msg : msgList) {
            if (retry) {
                msg.set("retrytimes", (Object)(msg.getInt("retrytimes") + 1));
            }
            int step = 0;
            long actionId = msg.getLong("action");
            this.lockIfNeed(isUserLock);
            try {
                Map<String, Object> actionInfo = this.getPublishInfoMap(msg, now, groupNumber);
                List<Map<String, String>> subInfoList = this.getSubinfo(actionId);
                ++step;
                HRProducerServiceHelper.publishAction(actionInfo);
                this.setConsumerEntry(msg, subInfoList);
                msg.set("sendstate", (Object)"1");
            }
            catch (KDBizException ex) {
                logger.error("kd.hr.haos.business.task.PublishTask.publish failed", (Throwable)ex);
                if (step > 0 && this.isSendSuccess(msg.getString("number"), actionId)) {
                    msg.set("sendstate", (Object)"1");
                } else {
                    String errorMsg = ex.getMessage();
                    msg.set("sendstate", (Object)"2");
                    logger.error(errorMsg);
                    logger.error("pubmsg-error");
                }
            }
            catch (Exception ex) {
                logger.error("kd.hr.haos.business.task.PublishTask.publish failed ex", (Throwable)ex);
            }
            finally {
                this.unLockIfNeed(isUserLock);
            }
            msg.set("lastsendtime", (Object)now);
            saveList.add(msg);
        }
        OrgChangeMsgServiceHelper.saveBatch(saveList);
    }

    private void unLockIfNeed(boolean isUserLock) {
        if (isUserLock) {
            this.lock.unlock();
        }
    }

    private void lockIfNeed(boolean isUserLock) {
        if (isUserLock) {
            this.lock.lock();
        }
    }

    private List<Map<String, String>> getSubinfo(long actionId) {
        List subInfoList = this.actionConsumerMap.get(actionId);
        if (subInfoList == null) {
            Map<String, Object> pubAndSubInfo = this.getSimplePubAndSubInfo((String)PublishConstants.msgPubNoMap.get(actionId));
            subInfoList = (List)pubAndSubInfo.get("subInfoList");
            if (subInfoList == null) {
                subInfoList = Lists.newArrayListWithExpectedSize((int)8);
            }
            this.actionConsumerMap.put(actionId, subInfoList);
            return subInfoList;
        }
        return subInfoList;
    }

    private void setConsumerEntry(DynamicObject msg, List<Map<String, String>> subInfoList) {
        if (CollectionUtils.isEmpty(subInfoList)) {
            return;
        }
        DynamicObjectCollection consumerEntry = msg.getDynamicObjectCollection("entryentity");
        for (Map<String, String> consumer : subInfoList) {
            DynamicObjectType entryType = consumerEntry.getDynamicObjectType();
            DynamicObject row = new DynamicObject(entryType);
            row.set("consumercloud", (Object)consumer.get("consumerCloudId"));
            row.set("consumerapp", (Object)consumer.get("consumerAppId"));
            row.set("subscribebd", (Object)consumer.get("businessTypeId"));
            row.set("recstatus", (Object)"C");
            consumerEntry.add((Object)row);
        }
    }

    private Map<String, Object> getSimplePubAndSubInfo(String msgPubNo) {
        return (Map)HRMServiceHelper.invokeBizService((String)"hrmp", (String)"hrcs", (String)"IHRCSMsgService", (String)"getSimplePubAndSubInfo", (Object[])new Object[]{msgPubNo});
    }

    private List<Map<String, Object>> getSubRecStatus(List<Map<String, Object>> paramsList) {
        List list = Lists.partition(paramsList, (int)500);
        ArrayList result = Lists.newArrayListWithExpectedSize((int)paramsList.size());
        for (List paramsSubList : list) {
            try {
                result.addAll((Collection)HRMServiceHelper.invokeBizService((String)"hrmp", (String)"hrcs", (String)"IHRCSMsgService", (String)"getMsgCenterListInfo", (Object[])new Object[]{paramsSubList}));
            }
            catch (Exception ex) {
                return Lists.newArrayListWithExpectedSize((int)8);
            }
        }
        return result;
    }

    private boolean isSendSuccess(String msgNumber, long actionId) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>(4);
        filters.add(new QFilter("number", "=", (Object)msgNumber));
        filters.add(new QFilter("action", "=", (Object)actionId));
        return (Boolean)HRMServiceHelper.invokeBizService((String)"hrmp", (String)"hrcs", (String)"IHRCSMsgService", (String)"validateMsgIsDuplicate", (Object[])new Object[]{filters.toArray(new QFilter[0])});
    }

    private Map<String, Object> getPublishInfoMap(DynamicObject msg, Date now, String groupNumber) {
        String msgNumber = msg.getString("number");
        long actionId = msg.getLong("action");
        String msgTitle = msg.getString("msgtitle");
        String msgTag = msg.getString("msgtag");
        String msgDesc = msg.getString("msgdesc");
        HashMap actionInfo = Maps.newHashMapWithExpectedSize((int)16);
        actionInfo.put("msgNumber", msgNumber);
        actionInfo.put("actionId", actionId);
        actionInfo.put("senderId", 1L);
        actionInfo.put("sendTime", now);
        actionInfo.put("msgPubNo", PublishConstants.msgPubNoMap.get(actionId));
        actionInfo.put("msgTitle", this.subString(msgTitle, 100));
        actionInfo.put("params", msg.getString("msgparams"));
        actionInfo.put("msgDesc", msgDesc);
        actionInfo.put("msgTag", this.subString(msgTag, 100));
        actionInfo.put("groupNumber", groupNumber);
        return actionInfo;
    }

    public String subString(String str, int length) {
        if (HRStringUtils.isEmpty((String)str)) {
            return str;
        }
        return str.length() > length ? str.substring(0, length) : str;
    }
}

